'use strict';
jQuery(document).ready(function () {
/*
     * Replace all SVG images with inline SVG
     */
        jQuery('.brands-list img[src$=".svg"]').each(function() {
        var $img = jQuery(this);
        var imgURL = $img.attr('src');
        var attributes = $img.prop("attributes");

        jQuery.get(imgURL, function(data) {
            /*Get the SVG tag, ignore the rest*/
            var $svg = jQuery(data).find('svg');

            /*Remove any invalid XML tags*/
            $svg = $svg.removeAttr('xmlns:a');

            /*Loop through IMG attributes and apply on SVG*/
            jQuery.each(attributes, function() {
                $svg.attr(this.name, this.value);
            });

            /*Replace IMG with SVG*/
            $img.replaceWith($svg);
        }, 'xml');
    });
});