<?php
/**
 * Single Product title
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/title.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author     WooThemes
 * @package    WooCommerce/Templates
 * @version    1.6.4
 */
global $product;
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$page_title = printcart_get_options('show_title_section');
$pd_title = printcart_get_options('nbcore_pd_details_title');

if($page_title) {
	if($pd_title) {
		the_title( '<h1 class="product_title entry-title">', '</h1>' );
	}
} else {
	the_title( '<h1 class="product_title entry-title">', '</h1>' );
}
$brands = get_the_terms( $product->get_id(), 'product_brand' );
$brand = '';
if(is_wp_error( $brands )){
    $brands = array();
}
if(count($brands) > 0) :
    $brand = esc_html__('Made by ' , 'woocommerce');
    foreach($brands as $key => $term){
        if($key == 0){
            $brand .= '<a href="' . get_term_link($term) . '">' . $term->name . '</a>';
        }else{
            $brand .= ' - ' . '<a href="' . get_term_link($term) . '">' . $term->name . '</a>';
        }
    }
?>
<p><?php echo $brand; ?></p>
<?php endif;
