<?php
/**
 * Plugin Name:       Multi vendor design
 * Plugin URI:        https://cmsmart.net
 * Description:       Multi vendor design
 * Version:           1.0.0
 * Requires at least: 5.2
 * Requires PHP:      7.1
 * Author:            The
 * Author URI:        https://cmsmart.net
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       background-for-nbdesigner-advanced
 * Domain Path:       /languages
 */

if ( !function_exists( 'add_action' ) ) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}

bg_nbd_define( 'MV_PLUGIN_DIR',             plugin_dir_path( __FILE__ ) );
bg_nbd_define( 'MV_PLUGIN_URL',             plugin_dir_url( __FILE__ ) );
bg_nbd_define( 'MV_PLUGIN_BASENAME',        plugin_basename( __FILE__ ) );
function bg_nbd_define( $name, $value ) {
    if ( ! defined( $name ) ) {
        define( $name, $value );
    }
}
// require_once( MV_PLUGIN_DIR . 'class-compatibility.php' );
// $compatibility = new Nbdesigner_Compatibility_WCFM();
// $compatibility->init();

add_action('nbd_js_config','muvp_nbd_js_config');
function muvp_nbd_js_config(){
 	echo 'var muvp_nbd_js_config = true;';
 	if(isset($_GET['create_thumb']) && $_GET['create_thumb'] != ''){
 		?>
 		NBDESIGNCONFIG['create_thumb'] = 1;
 		NBDESIGNCONFIG['id_realte'] = "<?php echo $_GET['create_thumb'] ?>";
 		NBDESIGNCONFIG['cpi'] = "<?php echo $_GET['cpi'] ?>";
 		<?php
 	}
 	$product_id     = ( isset( $_GET['product_id'] ) &&  $_GET['product_id'] != '' ) ? absint( $_GET['product_id'] ) : 0;
 	?>
 	NBDESIGNCONFIG['product_url'] = "<?php echo get_permalink( $product_id ); ?>";
 	<?php
 }

add_filter('nbod_task_save_design','muvp_nbod_task_save_design');
function muvp_nbod_task_save_design($task){
	if(isset($_POST['create_thumb']) && $_POST['create_thumb'] == 'yes'){
		$task = 'create_thumb';
	}
	return $task;
}

function muvp_get_design($folder){
	$path = NBDESIGNER_CUSTOMER_DIR . '/' . $folder;
	$content = file_exists($path . '/design.json') ? file_get_contents($path . '/design.json') : '';
    return json_decode($content , true) ;
}
add_action('nbd_object_option_focecolor','muvp_object_option_focecolor');
function muvp_object_option_focecolor(){
	?>
	nbOption.odOption.color.opValue = field.value;
	<?php
}
add_filter('nbod_variable_data_design_template','muvp_variable_data_design_template',10,2);
function muvp_variable_data_design_template($data,$template_id){
	if($template_id != ''){
		if(isset($_POST['value'])){
			$designs = (array) $data['design'];
			foreach($designs as $key => $design){
				if($key == 'frame_'.$_POST['value']){
					$designs['frame_0'] = $design;
				}
				else{
					unset($designs[$key]);
				}
			}
			$data['design'] = (object) $designs;
		}
	}
	return $data;
}
add_filter('filter_after_nbd_save_customer_design','muvp_result_nbd_save_customer_design');
function muvp_result_nbd_save_customer_design($result){
    if(isset($_POST['create_thumb']) && $_POST['create_thumb'] == 'yes'){
        if($result['flag'] == 'success'){
            $product_id = $result['product_id'];
            $result['rd'] = dokan_edit_product_url( $product_id );
        }
    }
    return $result;
}
add_action('after_nbd_save_customer_design','muvp_after_nbd_save_customer_design',10,4);
function muvp_after_nbd_save_customer_design($result, $nbd_item_key,$post,$th){
	if(isset($_POST['create_thumb']) && $_POST['create_thumb'] == 'yes'){
		if($result['flag'] == 'success'){
		    
		    $product_id = $result['product_id'];
            $result['rd'] = dokan_edit_product_url( $product_id );
		    if($_POST['id_realte'] != $product_id){
		        $path = NBDESIGNER_CUSTOMER_DIR . '/' . $result['folder'];
    		    $path_config    = NBDESIGNER_CUSTOMER_DIR . '/' . $result['folder'] . '/config.json';
                $config         = nbd_get_data_from_json( $path_config );
                update_post_meta($product_id, '_designer_setting', serialize(json_decode(json_encode($config->product),true)));
                $width = absint( nbdesigner_get_option( 'nbdesigner_template_width', 500 ) ) ? absint( nbdesigner_get_option( 'nbdesigner_template_width', 500 ) ) : 500;
                $product_config = unserialize( file_get_contents( $path . '/product.json' ) );
    			$file = "";
    			$_product_image_gallery = '';
    			foreach ($result['image'] as $key => $value) {
    				if($key == 'frame_0'){
    					$file = $value;
    					$att = nbd_add_attachment(Nbdesigner_IO::convert_url_to_path($file));
    					set_post_thumbnail( $product_id, $att );
    				}
    				else{
    				    $attachment_id = nbd_add_attachment(Nbdesigner_IO::convert_url_to_path($value));
    				    $_product_image_gallery .= $attachment_id . ",";
    				}
    			}
    			update_post_meta($product_id, '_product_image_gallery',  $_product_image_gallery);
    			$cpi = explode(',',$_POST['cpi']);
    			global $wpdb;
    			$arr = muvp_get_printing_option_by_product_id($_POST['id_realte'],false);
    			foreach ($arr['fields'] as $ak => $a) {
    				if($a['nbd_type'] == 'color' && $a['appearance']['change_image_product'] == 'y' && $arr['fields'][$ak]['general']['attributes']['bg_type'] == 'i'){
    					$i = 0;
    					$f_ops = $arr['fields'][$ak]['general']['attributes']['options'];
    					$fisrt = true;
    					$arr_remove = array();
    					foreach ($f_ops as $key => $value) {
    						if(in_array($key,$cpi)){
    						    if($fisrt){
    						        $arr['fields'][$ak]['general']['attributes']['options'][$key]['selected'] = 1;
    						        $fisrt = false;
    						    }
    				    		$bg = wp_get_attachment_url( $value['bg_image'][0] );
    		    				$product_config[0]['img_src'] = $bg;
    						    avdi_create_preview_design( $path, $path.'/preview', $product_config, $width, $width );
    						    $_images             = Nbdesigner_IO::get_list_images( $path.'/preview', 1 );
    							$file = $_images[0];
    							$image = nbd_add_attachment(Nbdesigner_IO::convert_url_to_path($file));
    							$arr['fields'][$ak]['general']['attributes']['options'][$key]['product_image'] = $image;
    							$i++;
    						}
    						else{
    				// 			array_splice($arr['fields'][$ak]['general']['attributes']['options'],$key,1);
    				            $arr_remove[] = $key;
    						}
    					}
    					foreach ($arr_remove as $krm => $rm) {
    					    array_splice($arr['fields'][$ak]['general']['attributes']['options'],$rm,1);
    					}
    				}
    				if($a['nbd_type'] == 'page3'){
    				    array_splice($arr['fields'], $ak, 1);
    				}
    			}
    			$fields = serialize($arr);
    			$option_id = NBD_FRONTEND_PRINTING_OPTIONS::get_product_option( $_POST['id_realte'] );
    			$_options = NBD_FRONTEND_PRINTING_OPTIONS::get_option($option_id);
    			unset($_options['id']);
    			$_options['fields'] = $fields;
    			$_options['product_ids'] = serialize(array($product_id));
    			$_options['product_cats'] = serialize(array());
    			$_options['apply_for'] = 'p';
    	        $date = new DateTime();  
    	        $_options['created']     = $date->format('Y-m-d H:i:s');
    	        $_options['created_by']  = wp_get_current_user()->ID;
    	        $op_id = NBD_FRONTEND_PRINTING_OPTIONS::get_product_option( $product_id );
    	        if(!$op_id){
    	        	$results = $wpdb->insert("{$wpdb->prefix}nbdesigner_options", $_options);
    	        }
    	        else{
    	        	$results = $wpdb->update("{$wpdb->prefix}nbdesigner_options", $_options, array( 'id' => $op_id) );
    	        }
    	        if($results){
    	        	$thumb_id = $_POST['id_realte'];
    		    	$product_thumb = wc_get_product($thumb_id);
    	            update_post_meta( $product_id, '_nbo_enable', 1 );
    	            update_post_meta( $product_id, '_user_design', get_current_user_id());
    	            update_post_meta( $product_id, 'dokan_design', 1);
    	            $product = wc_get_product($product_id);
    	            $categories = $product_thumb->get_category_ids();
    	            wp_set_object_terms( $product_id, $categories, 'product_cat' );
    	            if($_POST['price_relate'] > 0){
    	                update_post_meta( $product_id, '_regular_price', $_POST['price_relate']);
    	                update_post_meta( $product_id, '_price', $_POST['price_relate']);
    	                $product->set_price($_POST['price_relate']);
    	            }
    	            $product->set_props(
    			        array(
    			            'description'               =>     $product_thumb->get_description(),
    			        )
    			    );
    	            $product->save();
    	        }
		    }
		    else{
		        global $wpdb;
		        $thumb_id = $_POST['id_realte'];
    		    $product_thumb = wc_get_product($thumb_id);
    		    $product_status = dokan_get_new_post_status();
    		    $post_data = array(
                    'post_type'    => 'product',
                    'post_status'  => $product_status,
                    'post_title'   => $product_thumb->get_name(),
                    'post_content' => $product_thumb->get_name(),
                ) ;
                $product_id = wp_insert_post( $post_data );
                $product = wc_get_product($product_id);
                update_post_meta( $product_id, '_regular_price', $product_thumb->get_price());
                update_post_meta( $product_id, '_price', $product_thumb->get_price());
                $product->set_price($product_thumb->get_price());
                $op_id = NBD_FRONTEND_PRINTING_OPTIONS::get_product_option( $thumb_id );
                if($op_id){
                    $_options = NBD_FRONTEND_PRINTING_OPTIONS::get_option($op_id);
                    $ids = unserialize($_options['product_ids']);
                    $ids[] = $product_id;
                    $_options['product_ids'] = serialize($ids);
                    $results = $wpdb->update("{$wpdb->prefix}nbdesigner_options", $_options, array( 'id' => $op_id) );
                }
                $_nbo_enable = get_post_meta($thumb_id, '_nbo_enable', true);
                if($_nbo_enable) update_post_meta( $product_id, '_nbo_enable', 1 );
                update_post_meta( $product_id, '_product_dokan_admin', 1 );
                
                $product->set_category_ids($product_thumb->get_category_ids() );
                $product->set_props(
			        array(
			            'description'               =>     $product_thumb->get_description(),
			        )
			    );
			    $product->save();
		    }
		}
	}
}
add_action('wp_body_open','muvp__body_open');
function muvp__body_open(){
    $_pro_id = isset($_GET['product_id']) ? $_GET['product_id'] : '';
	if(dokan_is_seller_dashboard() && !$_pro_id):
	include 'popup.php';
	?>
	<div id="loader-wrapper" style="display: none">
	    <div id="loader"></div>
	    <div class="loader-section section-left"></div>
	    <div class="loader-section section-right"></div>
	</div>
	<?php
	endif;
}
function return_custom_price($price, $product) {
    if(!$product->is_on_sale()){
        $data = $product->get_data();
        if(isset($data['regular_price'])){
            $price = $data['regular_price'];
        }
    }
    return $price;
}
add_filter('woocommerce_get_price', 'return_custom_price', 10, 2);
add_filter('nbod_redirect_url_variable_editor','muvp_redirect_url_variable_editor',10,2);
function muvp_redirect_url_variable_editor($url,$product_id){
	if(isset($_GET['create_thumb']) && $_GET['create_thumb'] != ''){
		$url = dokan_edit_product_url( $product_id );
	}
	return $url;
}
add_filter('nbd_editor_process_action','muvp_vendor_editor_process_action');
function muvp_vendor_editor_process_action($process_action){
	if(isset($_GET['create_thumb']) && $_GET['create_thumb'] != ''){
        $process_action = 'saveData()';
    }
    return $process_action;
}

add_filter('nbd_product_info','muvp_nbd_product_info');
function muvp_nbd_product_info($data){
// 	$product_id     = ( isset( $_GET['create_thumb'] ) &&  $_GET['create_thumb'] != '' ) ? absint( $_GET['create_thumb'] ) : 0;
// 	$index_arr 		= explode(',',$_GET['cpi']);
// 	if($product_id && isset($_GET['create_thumb']) && $_GET['create_thumb'] != '' && count($index_arr) > 0){
// 		$options = muvp_get_printing_option_by_product_id($product_id);
// 		$fields = $options['fields'];
// 		if(count($fields) > 0 && count($index_arr)){
// 			$data_sample = $data['product'][0];
// 			$data['product'] = array();
// 			foreach ($fields as $k => $f) {
// 				if($f['nbd_type'] == 'color' && $f['appearance']['change_image_product'] == 'y'){
// 					$f_ops = $f['general']['attributes']['options'];
// 					?><?php
// 					foreach ($f_ops as $ok => $ov) {
// 						if(in_array($ok, $index_arr)){
// 							$data_sample['bg_type'] = 'image';
// 							$data_sample['img_src'] = $ov['full_src'] ? $ov['full_src'] : get_option('nbdesigner_default_background');
// 							$data['product'][] = $data_sample;
// 						}
// 					}
					
// 				}
// 			}
// 		}
// 		else{
// 			$img = get_the_post_thumbnail_url($product_id,'large');
// 			$data['product'][0]['bg_type'] = 'image';
// 			$data['product'][0]['img_src'] = $img ? $img : $data['product'][0]['img_src'];
// 		}
// 	}
	return $data;
}

function muvp_get_printing_option_by_product_id($product_id , $flag = true){
	$option_id = NBD_FRONTEND_PRINTING_OPTIONS::get_product_option( $product_id );
	if($option_id){
		$_options = NBD_FRONTEND_PRINTING_OPTIONS::get_option($option_id);
		$options = unserialize($_options['fields']);
		if($flag){
			if( !isset($options['fields']) ){
	            $options['fields'] = array();
	        }
	        $options['fields'] = NBD_FRONTEND_PRINTING_OPTIONS::recursive_stripslashes( $options['fields'] );
			foreach ($options['fields'] as $key => $field){
	            if( !isset($field['general']['attributes']) ){
	                $field['general']['attributes'] = array();
	                $field['general']['attributes']['options'] = array();
	                $options['fields'][$key]['general']['attributes'] = array();
	                $options['fields'][$key]['general']['attributes']['options'] = array();
	            }
	            if($field['appearance']['change_image_product'] == 'y'){
	                foreach ($field['general']['attributes']['options'] as $op_index => $option ){
	                    $option['product_image'] = isset($option['product_image']) ? $option['product_image'] : 0;
	                    $attachment_id = absint( $option['product_image'] );
	                    if( $attachment_id != 0 ){
	                        $image_link         = wp_get_attachment_url( $attachment_id );
	                        $attachment_object  = get_post( $attachment_id );
	                        $full_src           = wp_get_attachment_image_src( $attachment_id, 'large' );
	                        $image_title        = get_the_title( $attachment_id );
	                        $image_alt          = trim( strip_tags( get_post_meta( $attachment_id, '_wp_attachment_image_alt', TRUE ) ) );
	                        $image_srcset       = function_exists( 'wp_get_attachment_image_srcset' ) ? wp_get_attachment_image_srcset( $attachment_id, 'shop_single' ) : FALSE;
	                        $image_sizes        = function_exists( 'wp_get_attachment_image_sizes' ) ? wp_get_attachment_image_sizes( $attachment_id, 'shop_single' ) : FALSE;
	                        $image_caption      = $attachment_object->post_excerpt;
	                        $options['fields'][$key]['general']['attributes']['options'][$op_index] = array_replace_recursive($options['fields'][$key]['general']['attributes']['options'][$op_index], array(
	                            'imagep'        => 'y',
	                            'image_link'    => $image_link,
	                            'image_title'   => $image_title,
	                            'image_alt'     => $image_alt,
	                            'image_srcset'  => $image_srcset,
	                            'image_sizes'   => $image_sizes,
	                            'image_caption' => $image_caption,
	                            'full_src'      => $full_src[0],
	                            'full_src_w'    => $full_src[1],
	                            'full_src_h'    => $full_src[2]
	                        ));
	                    }else{
	                        $options['fields'][$key]['general']['attributes']['options'][$op_index]['imagep'] = 'n';
	                    }
	                }
	            }
	            if( isset($field['nbpb_type']) && $field['nbpb_type'] == 'nbpb_com' ){
	                if( isset($field['general']['pb_config']) ){
	                    foreach( $field['general']['pb_config'] as $a_index => $attr ){
	                        foreach( $attr as $s_index => $sattr ){
	                            foreach( $sattr['views'] as $v_index => $view ){
	                                $pb_image_obj = wp_get_attachment_url( absint($view['image']) );
	                                $options['fields'][$key]['general']['pb_config'][$a_index][$s_index]['views'][$v_index]['image_url'] =  $pb_image_obj ? $pb_image_obj : NBDESIGNER_ASSETS_URL . 'images/placeholder.png';
	                            }
	                        }
	                    }
	                }else{
	                    $field['general']['pb_config'] = array();
	                }
	                foreach ($field['general']['attributes']['options'] as $op_index => $option ){
	                    if( isset($option['enable_subattr']) && $option['enable_subattr'] == 'on' && isset($option['sub_attributes']) && count($option['sub_attributes']) > 0 ){
	                        foreach( $option['sub_attributes'] as $sa_index => $sattr ){
	                            $options['fields'][$key]['general']['attributes']['options'][$op_index]['sub_attributes'][$sa_index]['image_url'] = nbd_get_image_thumbnail( $sattr['image'] );
	                        }
	                    }else{
	                        $options['fields'][$key]['general']['attributes']['options'][$op_index]['image_url'] = nbd_get_image_thumbnail( $option['image'] );
	                    }
	                };
	                $options['fields'][$key]['general']['component_icon_url'] = nbd_get_image_thumbnail( $field['general']['component_icon'] );
	            }
	            if( isset($field['general']['attributes']['bg_type']) && $field['general']['attributes']['bg_type'] == 'i' ){
	                foreach ($field['general']['attributes']['options'] as $op_index => $option ){
	                    foreach( $option['bg_image'] as $bg_index => $bg ){
	                        $bg_obj = wp_get_attachment_url( absint($bg) );
	                        $options['fields'][$key]['general']['attributes']['options'][$op_index]['bg_image_url'][$bg_index] = $bg_obj ? $bg_obj : NBDESIGNER_ASSETS_URL . 'images/placeholder.png';
	                    }
	                };
	            }
	            if( isset($field['nbd_type']) && $field['nbd_type'] == 'overlay' ){
	                foreach ($field['general']['attributes']['options'] as $op_index => $option ){
	                    foreach( $option['overlay_image'] as $ov_index => $ov ){
	                        $ov_obj = wp_get_attachment_url( absint($ov) );
	                        $options['fields'][$key]['general']['attributes']['options'][$op_index]['overlay_image_url'][$ov_index] = $ov_obj ? $ov_obj : '';
	                    }
	                };
	            }
	            if( isset($field['nbe_type']) && $field['nbe_type'] == 'frame' ){
	                foreach ($field['general']['attributes']['options'] as $op_index => $option ){
	                    $fr_obj = wp_get_attachment_url( absint($option['image']) );
	                    $options['fields'][$key]['general']['attributes']['options'][$op_index]['image_url'] = $fr_obj ? $fr_obj : '';
	                };
	            }
	        }
		}
        
        return $options;
	}
	else{
		return array();
	}
}

// add_filter('nbod_section_nbd_design','muvp_section_nbd_design',10,2);
// function muvp_section_nbd_design($content,$position){
//     if($position != 4){
//         $content = '';
//     }
//     return $content;
// }

// add_filter('nbod_button_start_design_html','muvp_button_start_design_html',10,7);
// function muvp_button_start_design_html($html,$url,$quantity,$product,$layout,$class,$label){
//     $html = '';
//     return $html;
// }
add_action('nbod_enqueue_dokan_extra','avdi_enqueue_dokan_extra');
function avdi_enqueue_dokan_extra(){
	wp_register_script('nbd-wcfm-product', MV_PLUGIN_URL . 'wcfm.js', array( 'nbd-dokan-product' ));
	wp_enqueue_script( 'nbd-wcfm-product' );
	wp_enqueue_style('nba-wc-product', MV_PLUGIN_URL . 'style.css');
	if(isset($_GET['addnew']) && $_GET['addnew'] == 'product' ){
	    ?>
	    <script>var add_new_product_action = true;</script>
	    <?php
	}
}
add_filter('nbod_attributes_in_product_dokan','avdi_attributes_in_product_dokan');
function avdi_attributes_in_product_dokan($atts){
	$atts['is_dokan_page'] = 1;
	return $atts;
}
add_action('dokan_new_product_added','avdi_dokan_new_product_added',10,2);
function avdi_dokan_new_product_added($post_id,$data){
    update_post_meta($post_id, '_nbo_enable', 1);
    update_post_meta($post_id, '_nbdesigner_enable', 1);
    $designer_setting       = array();
    $designer_setting[0]    = nbd_default_product_setting();
    $_option = nbd_get_default_product_option();
    update_post_meta($post_id, '_nbdesigner_option', serialize($_option));
    update_post_meta($post_id, '_designer_setting', serialize($designer_setting));
}
add_action('dokan_product_gallery_image_count','avdi_product_gallery_image_count');
function avdi_product_gallery_image_count(){
    global $post;
    $link_create_template = add_query_arg(array(
        'product_id'    => $post->ID,
        'task'          => 'create',
        'aid'           => get_current_user_id(),
        'rd'            => is_admin() ? 'admin_templates' : 'designer'
    ), getUrlPageNBD('create'));
	$link_create_template .= "&create_thumb=1";
	?>
	<a class="button nbd-admin-tem-link" id="toggle-popup-tem" href="<?php echo esc_url( $link_create_template ); ?>">
        <span class="dashicons dashicons-art"></span>
        <?php esc_html_e('Create Thumbnail', 'web-to-print-online-designer'); ?>
    </a>
	<?php
}
add_action('nbod_after_setting_dokan_product','avdi_after_setting_dokan_product');
function avdi_after_setting_dokan_product(){
	include 'popup.php';
}
add_filter('dokan_product_cat_dropdown_args','avdi_product_cat_dropdown_args');
function avdi_product_cat_dropdown_args($category_args){
	if(!isset($_GET['product_id']) && !isset($_GET['action'])){
		$get_terms_args = array(
	        'orderby' => 'term_id',
	        'order' => 'ASC'   ,
	        'hide_empty' => 0,
	        'taxonomy'  => 'product_cat',
	        'hide_if_empty' => false
	    );
	    $categories = get_terms( $get_terms_args );
	    $category_args =  array(
	        'show_option_none' => __( '- Select a category -', 'dokan-lite' ),
	        'hierarchical'     => 1,
	        'hide_empty'       => 0,
	        'name'             => 'product_cat',
	        'id'               => 'product_cat',
	        'taxonomy'         => 'product_cat',
	        'title_li'         => '',
	        'class'            => 'product_cat dokan-form-control dokan-select2',
	        'exclude'          => '',
	        'selected'         => count($categories)>0  ? $categories[0]->term_id : '',
	    );
	}
    return $category_args;
}
add_action('nbd_add_enable_check_spine','avdi_add_enable_check_spine');
function avdi_add_enable_check_spine($post_id){
    $enable = get_post_meta($post_id, '_nbd_enable_dokan' , true);
    ?>
    <p class="nbo-form-field">
        <label for="_nbd_enable_dokan"><?php _e('Enable Dokan Product', 'web-to-print-online-designer'); ?></label>
        <span class="nbo-option-val">
            <input type="hidden" value="0" name="_nbd_enable_dokan"/>
            <input type="checkbox" value="1" name="_nbd_enable_dokan" id="_nbd_enable_dokan" <?php checked($enable); ?> class="short" />
        </span>
    </p>
    <?php
}
add_action('nbo_save_options','avdi_save_options',10,2);
function avdi_save_options($post_id,$post){
    if(isset( $post['_nbd_enable_dokan'])){
        update_post_meta($post_id, '_nbd_enable_dokan', $post['_nbd_enable_dokan']);
    }
}
// add_filter('dokan_add_new_product_redirect','avdi_add_new_product_redirect',10,2);
// function avdi_add_new_product_redirect($redirect, $product_id){
//     $redirect = add_query_arg( array( 'addnew' => 'product' ), $redirect );
//     return $redirect;
// }
add_action('woocommerce_product_thumbnails','avdi_woocommerce_product_thumbnails');
function avdi_woocommerce_product_thumbnails(){
	global $product;
	$product_id = $product->get_id();
	$id = get_post_meta( $product_id, '_user_design', true);
	if($id){
		$user = get_user_by('id', $id);
		if($user){
			?>
			<p>Design by <?php echo $user->display_name ?></p>
			<?php
		}
	}
}

add_filter('nbo_product_options','avdi_product_options',10,2);
function avdi_product_options($options, $product_id){
	if(isset($_GET['cpi']) && $_GET['cpi'] != ''){
		$cpi = explode(',',$_GET['cpi']);
		if(count($cpi) > 0){
			$fields = $options['fields'];
			foreach ($fields as $key => $field) {
				if($field['nbd_type'] == 'color' && $field['appearance']['change_image_product'] == 'y'){
					$first = true;
					$arr_remove = array();
					foreach ($field['general']['attributes']['options'] as $k => $v) {
						if(!in_array($k,$cpi)){
							$arr_remove[] = $k;
						}
						else{
							if($first){
								$first = false;
								$options['fields'][$key]['general']['attributes']['options'][$k]['selected'] = 1;
							}
						}
					}
					foreach ($arr_remove as $krm => $rm) {
					    array_splice($options['fields'][$key]['general']['attributes']['options'],$rm,1);
					}
				}
			}
		}
	}
	return $options;
}
function avdi_create_preview_design( $path_src, $path_dst, $product_config, $width, $height, $limit = false ){
    if( !file_exists( $path_dst ) ){
        wp_mkdir_p( $path_dst );
    }
    $scale = $width / 500;
    $count = 0;
    foreach ( $product_config as $key => $val ){
        $p_img          = $path_src . '/frame_' . $key . '.png';
        $design_format  = 'png';
        if( file_exists( $path_src . '/frame_' . $key . '.jpeg' ) ){
            $p_img          = $path_src . '/frame_' . $key . '.jpeg';
            $design_format  = 'jpeg';
        }
        if( file_exists( $p_img ) ){
            $bg_width   = $val["img_src_width"] * $scale;
            $bg_height  = $val["img_src_height"] * $scale;
            $ds_width   = $val["area_design_width"] * $scale;
            $ds_height  = $val["area_design_height"] * $scale;
            if( $design_format == 'png' ){
                $image_design = NBD_Image::nbdesigner_resize_imagepng( $p_img, $ds_width, $ds_height );
            }else{
                $image_design = NBD_Image::nbdesigner_resize_imagejpg( $p_img, $ds_width, $ds_height );
            }
            $image_product_ext = pathinfo( $val["img_src"] );
            if( $val["bg_type"] == 'image' ){
                $path_img_src  = Nbdesigner_IO::convert_url_to_path( $val["img_src"] );
                if( $image_product_ext['extension'] == "png" ){
                    $image_product = NBD_Image::nbdesigner_resize_imagepng( $path_img_src, $bg_width, $bg_height );
                }else{
                    $image_product = NBD_Image::nbdesigner_resize_imagejpg( $path_img_src, $bg_width, $bg_height );
                }
            }
            if( $val["show_overlay"] == '1' ){
                $path_img_overlay   = Nbdesigner_IO::convert_url_to_path( $val["img_overlay"] );
                $overlay_ext        = pathinfo( $val["img_overlay"] );
                $over_ext           = strtolower( $overlay_ext['extension'] );
                if( $over_ext == "png" ){
                    $image_overlay = NBD_Image::nbdesigner_resize_imagepng( $path_img_overlay, $bg_width, $bg_height );
                }else if( $over_ext == "jpg" || $over_ext == "jpeg" ){
                    $image_overlay = NBD_Image::nbdesigner_resize_imagejpg( $path_img_overlay, $bg_width, $bg_height );
                }else{
                    $val["show_overlay"] = '0';
                }
            }
            if( $design_format == 'png' ){
                $image = imagecreatetruecolor( $bg_width, $bg_height );
                imagesavealpha( $image, true );
                $color = imagecolorallocatealpha( $image, 255, 255, 255, 127 );
                imagefill( $image, 0, 0, $color );
            }else{
                $image  = imagecreatetruecolor($bg_width, $bg_height);
                $bg     = imagecolorallocate( $image, 255, 255, 255 );
                imagefilledrectangle($image,0,0,$bg_width,$bg_height,$bg);
            }
            if( $val["bg_type"] == 'image' ){
                imagecopy( $image, $image_product, 0, 0, 0, 0, $bg_width, $bg_height );
            } else if( $val["bg_type"] == 'color' ){
                $show_bg_color = true;
                if( isset( $val["areaDesignShape"] ) && $val["areaDesignShape"] ){
                    $show_bg_color = false;
                }
                if( $val["show_overlay"] == '1' && $image_overlay ){
                    $show_bg_color = true;
                }
                if( $show_bg_color ){
                    $_color = hex_code_to_rgb( $val["bg_color_value"] );
                    $color  = imagecolorallocate( $image, $_color[0], $_color[1], $_color[2] );
                    imagefilledrectangle( $image, 0, 0, $bg_width, $bg_height, $color );
                }
            } else if( $design_format == 'jpeg' ) {
                $color = imagecolorallocate( $image, 255, 255, 255 );
                imagefilledrectangle( $image, 0, 0, $bg_width, $bg_height, $color );
            }
            imagecopy( $image, $image_design, ( $val["area_design_left"] - $val["img_src_left"] ) * $scale, ( $val["area_design_top"] - $val["img_src_top"] ) * $scale, 0, 0, $ds_width, $ds_height );
            if( $val["show_overlay"] == '1' && $image_overlay ){
                imagecopy( $image, $image_overlay, 0, 0, 0, 0, $bg_width, $bg_height );
            }
            if( $design_format == 'png' ){
                imagepng( $image, $path_dst . '/frame_' . $key . '.png' );
            }else{
                imagejpeg( $image, $path_dst . '/frame_' . $key . '.jpeg' );
            }
            imagedestroy( $image );
            imagedestroy( $image_design );
            $count++;
        }
        if( $limit && $count == $limit ) break;
    }
}
add_action('woocommerce_after_order_itemmeta','avdi_woocommerce_after_order_itemmeta',10,3);
function avdi_woocommerce_after_order_itemmeta($item_id, $item, $product){
	if($product){
		$url = '';
		$product_id = $product->get_id();
		$dokan_design = get_post_meta($product_id,'dokan_design',true);
		if($dokan_design){
			$nbo_options = wc_get_order_item_meta( $item_id, '_nbo_options', true );
			$nbo_field = wc_get_order_item_meta( $item_id, '_nbo_field', true );
			$fields = isset($nbo_options['fields']) ? base64_decode($nbo_options['fields']) : '';
			if($fields){
				$options = unserialize($fields);
				foreach ($options['fields'] as $key => $field) {
					if($field['nbd_type'] == 'color' && $field['appearance']['change_image_product'] == 'y'){
						$ok = $nbo_field[$field['id']];
						$_id = $field['general']['attributes']['options'][$ok]['product_image'];
						$full_src           = wp_get_attachment_image_src( $_id, 'large' );
						$url = $full_src[0];
					}
				}
			}
		}
		if($url){
			?>
			<a href="<?php echo esc_url($url) ?>" download>Download design</a>
			<?php
		}
	}
}
add_action('nbd_modern_extra_popup','avdi_nbd_modern_extra_popup',10,2);
function avdi_nbd_modern_extra_popup($task, $settings)
{
	?>
	<div class="nbd-popup popup-saved" data-animate="scale">
		<div class="main-popup">
		    <i class="icon-nbd icon-nbd-clear close-popup"></i>
		    <div class="head">
		        <h2><?php esc_html_e('Saved product','web-to-print-online-designer'); ?></h2>
		    </div>
		    <div class="body">
		        <div>
		            <div class="share-content share-design-link">
		                <b><?php esc_html_e('Product link','web-to-print-online-designer'); ?></b>
		            </div>
		            <div class="share-content share-design-link">
		                <input value="{{settings.product_url}}" /><i title="<?php esc_html_e('Click to copy','web-to-print-online-designer'); ?>" ng-click="copyShareLink($event)" class="icon-nbd icon-nbd-content-copy"></i>
		            </div>
		             <a href="{{settings.product_url}}" target="_blank" class="nbd-button nbd-hover-shadow"><?php esc_html_e('Share now','web-to-print-online-designer'); ?></a>
		        </div>
		    </div>
		    <div class="footer"></div>
		</div>
	</div>
	<?php
}
//add_action('dokan_after_add_product_btn','avdi_after_add_product_btn');
function avdi_after_add_product_btn(){
    if ( current_user_can( 'dokan_add_product' ) ): ?>
        <a href="" id="toggle-popup-tem" class="dokan-btn dokan-btn-theme">
            <i class="fa fa-briefcase">&nbsp;</i>
            <?php esc_html_e( 'Sell product', 'dokan-lite' ); ?>
        </a>
    <?php endif;
}
add_action('dokan_seller_meta_fields','avdi_seller_meta_fields');
function avdi_seller_meta_fields($user){
    $dokan_product_admin_com        = get_user_meta( $user->ID, 'dokan_product_admin_com', true );
    ?>
    <tr>
        <th><?php esc_html_e( 'Admin Product Dokan Commission ', 'dokan-lite' ); ?></th>
        <td>
            <input type="text" class="wc_input_price small-text" id="admin-product-commission" name="dokan_admin_product_percentage" value="<?php echo esc_attr( $dokan_product_admin_com ); ?>">
        </td>
    </tr>
    <?php
}

add_action('dokan_process_seller_meta_fields','avdi_process_seller_meta_fields');
function avdi_process_seller_meta_fields($user_id){
    update_user_meta( $user_id, 'dokan_product_admin_com', $_POST['dokan_admin_product_percentage'] );
}

add_filter('dokan_order_net_amount','avdi_order_net_amount',30,2);
function avdi_order_net_amount($net_amount, $order){
    
    
    
    $order_id = $order->get_id();
    $seller_id          = dokan_get_seller_id_by_order( $order_id );
    $dokan_admin_percentage_type = get_user_meta( $user_id, 'dokan_admin_percentage_type', true );
    foreach ( $order->get_items() as $item_id => $item ) {
       $product_id = $item->get_product_id();
       $total = $item->get_total();
       $total = $item->get_total();
       $check = get_post_meta($product_id , '_product_dokan_admin',true);
        
       if($check){
           if($dokan_admin_percentage_type == 'flat'){
               $net_amount = $net_amount + $total - $check;
           }
           else{
               $net_amount = $net_amount + $total * $check / 100;
           }
       }
    }

    return $net_amount;
}