<?php
$args = array(
     'taxonomy'     => 'product_cat',
     'orderby'      => 'name',
     'hierarchical' => 1,
     'title_li'     => '',
     'hide_empty'   => 1
);
$all_categories = get_categories( $args );
$i = 0;
$post_id = $_GET['product_id'];
?>
<div class="nbod_popup">
	<div class="popup-wrapper">
		<div class="popup-header"><h3 class="header__text"><?php esc_html_e( 'Create thumbnail', 'web-to-print-online-designer' ); ?></h2></div>
		<div class="popup-box">
			<div style="overflow: hidden;padding: 20px;height: 100%;">
				<ul class="nbod-tabs">
					<?php foreach($all_categories as $key => $cate) : ?>
					<li><a href="#nbd-category-<?php echo $cate->term_id ?>" class="<?php $key == 0 ? 'active' : '' ?>"><span class="dashicons dashicons-art"></span><?php echo $cate->name ?></a></li>
					<?php endforeach; ?>
				</ul>
				<?php foreach($all_categories as $key => $cate) : 
				    $i++;
					$posts = new WP_Query(array(
                        'post_type'         => 'product',
                        'tax_query' => array(
							array(
								'taxonomy' 	=> 'product_cat',
								'field' 	=> 'slug',
								'terms' 	=> $cate->slug
							)
						),
                        'post_status'       => 'publish',
                        'orderby'           => 'id',
                        'order'             => 'DESC',
                        'posts_per_page'    => -1,
                        'meta_query'        => array(
                            array(
                                'key'   => '_nbdesigner_enable',
                                'value' => 1,
                            ),
                            array(
                                'key'   => '_nbd_enable_dokan',
                                'value' => 1,
                            ),
                        )
                    ));
                    $products = $posts->posts;
					?>
					<div class="nbod_options_panel <?php echo $i == 1 ? '' : 'nbod-hidden'?>" key="<?php echo $key ?>" id="nbd-category-<?php echo $cate->term_id ?>">
						<?php foreach($products as $pro) :
						    $product = wc_get_product($pro->ID);
						    if($post_id){
						        $link_create_template = add_query_arg(array(
                                    'product_id'    => $post_id,
                                    'task'          => 'create',
                                    'aid'           => get_current_user_id(),
                                    'rd'            => is_admin() ? 'admin_templates' : 'designer',
                                    'create_thumb'  => $product->get_id(),
                                ), getUrlPageNBD('create'));
						    }
							else{
							    $link_create_template = add_query_arg(array(
                                    'product_id'    => $pro->ID,
                                    'task'          => 'create',
                                    'aid'           => get_current_user_id(),
                                    'rd'            => is_admin() ? 'admin_templates' : 'designer',
                                    'create_thumb'  => $product->get_id(),
                                ), getUrlPageNBD('create'));
							}
							?>
							<div class="box-product-wcfm">
    							<div class="box__product">
    								<div class="content__product">
    									<?php echo get_the_post_thumbnail($product->get_id()) ? get_the_post_thumbnail($product->get_id()) : wc_placeholder_img(); ?>
    									<span class="name__product"><?php echo $product->get_name(); ?></span>
    								</div>
    								<div class="btn-design">
    									<span data-url="<?php echo esc_url( $link_create_template ); ?>">Design</span>
    								</div>
    							</div>
							<?php 
							$option_id = NBD_FRONTEND_PRINTING_OPTIONS::get_product_option( $product->get_id() );
							if($option_id){
								$_options = NBD_FRONTEND_PRINTING_OPTIONS::get_option($option_id);
								$options = unserialize($_options['fields']);
			                    if( !isset($options['fields']) ){
			                        $options['fields'] = array();
			                    }
			                    $options['fields'] = NBD_FRONTEND_PRINTING_OPTIONS::recursive_stripslashes( $options['fields'] );
								foreach ($options['fields'] as $key => $field){
			                        if( !isset($field['general']['attributes']) ){
			                            $field['general']['attributes'] = array();
			                            $field['general']['attributes']['options'] = array();
			                            $options['fields'][$key]['general']['attributes'] = array();
			                            $options['fields'][$key]['general']['attributes']['options'] = array();
			                        }
			                        if($field['appearance']['change_image_product'] == 'y'){
			                            foreach ($field['general']['attributes']['options'] as $op_index => $option ){
			                                $option['product_image'] = isset($option['product_image']) ? $option['product_image'] : 0;
			                                $attachment_id = absint( $option['product_image'] );
			                                if( $attachment_id != 0 ){
			                                    $image_link         = wp_get_attachment_url( $attachment_id );
			                                    $attachment_object  = get_post( $attachment_id );
			                                    $full_src           = wp_get_attachment_image_src( $attachment_id, 'large' );
			                                    $image_title        = get_the_title( $attachment_id );
			                                    $image_alt          = trim( strip_tags( get_post_meta( $attachment_id, '_wp_attachment_image_alt', TRUE ) ) );
			                                    $image_srcset       = function_exists( 'wp_get_attachment_image_srcset' ) ? wp_get_attachment_image_srcset( $attachment_id, 'shop_single' ) : FALSE;
			                                    $image_sizes        = function_exists( 'wp_get_attachment_image_sizes' ) ? wp_get_attachment_image_sizes( $attachment_id, 'shop_single' ) : FALSE;
			                                    $image_caption      = $attachment_object->post_excerpt;
			                                    $options['fields'][$key]['general']['attributes']['options'][$op_index] = array_replace_recursive($options['fields'][$key]['general']['attributes']['options'][$op_index], array(
			                                        'imagep'        => 'y',
			                                        'image_link'    => $image_link,
			                                        'image_title'   => $image_title,
			                                        'image_alt'     => $image_alt,
			                                        'image_srcset'  => $image_srcset,
			                                        'image_sizes'   => $image_sizes,
			                                        'image_caption' => $image_caption,
			                                        'full_src'      => $full_src[0],
			                                        'full_src_w'    => $full_src[1],
			                                        'full_src_h'    => $full_src[2]
			                                    ));
			                                }else{
			                                    $options['fields'][$key]['general']['attributes']['options'][$op_index]['imagep'] = 'n';
			                                }
			                            }
			                        }
			                        if( isset($field['nbpb_type']) && $field['nbpb_type'] == 'nbpb_com' ){
			                            if( isset($field['general']['pb_config']) ){
			                                foreach( $field['general']['pb_config'] as $a_index => $attr ){
			                                    foreach( $attr as $s_index => $sattr ){
			                                        foreach( $sattr['views'] as $v_index => $view ){
			                                            $pb_image_obj = wp_get_attachment_url( absint($view['image']) );
			                                            $options['fields'][$key]['general']['pb_config'][$a_index][$s_index]['views'][$v_index]['image_url'] =  $pb_image_obj ? $pb_image_obj : NBDESIGNER_ASSETS_URL . 'images/placeholder.png';
			                                        }
			                                    }
			                                }
			                            }else{
			                                $field['general']['pb_config'] = array();
			                            }
			                            foreach ($field['general']['attributes']['options'] as $op_index => $option ){
			                                if( isset($option['enable_subattr']) && $option['enable_subattr'] == 'on' && isset($option['sub_attributes']) && count($option['sub_attributes']) > 0 ){
			                                    foreach( $option['sub_attributes'] as $sa_index => $sattr ){
			                                        $options['fields'][$key]['general']['attributes']['options'][$op_index]['sub_attributes'][$sa_index]['image_url'] = nbd_get_image_thumbnail( $sattr['image'] );
			                                    }
			                                }else{
			                                    $options['fields'][$key]['general']['attributes']['options'][$op_index]['image_url'] = nbd_get_image_thumbnail( $option['image'] );
			                                }
			                            };
			                            $options['fields'][$key]['general']['component_icon_url'] = nbd_get_image_thumbnail( $field['general']['component_icon'] );
			                        }
			                        if( isset($field['general']['attributes']['bg_type']) && $field['general']['attributes']['bg_type'] == 'i' ){
			                            foreach ($field['general']['attributes']['options'] as $op_index => $option ){
			                                foreach( $option['bg_image'] as $bg_index => $bg ){
			                                    $bg_obj = wp_get_attachment_url( absint($bg) );
			                                    $options['fields'][$key]['general']['attributes']['options'][$op_index]['bg_image_url'][$bg_index] = $bg_obj ? $bg_obj : NBDESIGNER_ASSETS_URL . 'images/placeholder.png';
			                                }
			                            };
			                        }
			                        if( isset($field['nbd_type']) && $field['nbd_type'] == 'overlay' ){
			                            foreach ($field['general']['attributes']['options'] as $op_index => $option ){
			                                foreach( $option['overlay_image'] as $ov_index => $ov ){
			                                    $ov_obj = wp_get_attachment_url( absint($ov) );
			                                    $options['fields'][$key]['general']['attributes']['options'][$op_index]['overlay_image_url'][$ov_index] = $ov_obj ? $ov_obj : '';
			                                }
			                            };
			                        }
			                        if( isset($field['nbe_type']) && $field['nbe_type'] == 'frame' ){
			                            foreach ($field['general']['attributes']['options'] as $op_index => $option ){
			                                $fr_obj = wp_get_attachment_url( absint($option['image']) );
			                                $options['fields'][$key]['general']['attributes']['options'][$op_index]['image_url'] = $fr_obj ? $fr_obj : '';
			                            };
			                        }
			                    }
			                    
							}
							$fields = isset($options['fields']) ? $options['fields'] : array();
							if(count($fields) > 0){
								?>
								<p class="title-select-color">Select your colors</p>
								<?php
								foreach ($fields as $k => $f) {
									if($f['nbd_type'] == 'color' && $f['appearance']['change_image_product'] == 'y'){
										$f_ops = $f['general']['attributes']['options'];
										?><?php
										foreach ($f_ops as $ok => $ov) {
											?>
												<input data-thumbnail="<?php echo $ov['image_link'] ?>" class="ip_wcfm_color" type="checkbox" data-id="<?php echo $ok; ?>" id="wcfm_side_<?php echo $ok.$product->get_id(); ?>" style="display: none" />
												<label title="<?php echo $ov['name'] ?>" style="<?php echo "background-color: " . $ov['color']; ?>" class="color_btn_wcfm" for="wcfm_side_<?php echo $ok.$product->get_id(); ?>"></label>

											<?php
										}
										
									}
								}
							}
							?>
						</div>
						<?php endforeach; ?>
					</div>
				<?php endforeach; ?>
				<div class="clear"></div>
			</div>
		</div>
	</div>
</div>