<?php if (!defined('ABSPATH')) exit; // Exit if accessed directly  ?>
<?php
class Nbdesigner_Compatibility_WCFM {
    public function __construct(){
    }
    public function init(){
        $this->compatibility_wcfm();
    }
    public function compatibility_wcfm(){
        add_action( 'after_wcfm_products_manage_pricing_fields', array(&$this, 'test'), 10, 1 );
        add_action( 'after_wcfm_products_manage_meta_save', array(&$this, 'processing'), 10, 2 );
        add_action( 'wp_enqueue_scripts', array($this, 'enqueue_scripts') , 20);
        add_action('nbod_after_create_template_in_manage_product',array($this , 'link_to_create_thumbnail'));
        add_filter('nbd_editor_process_action',array($this , 'vendor_editor_process_action'));
    }
    public function vendor_editor_process_action($process_action){
        if(isset($_GET['create_thumb']) && $_GET['create_thumb'] != ''){
            $process_action = 'saveData()';
        }
        return $process_action;
    }
    public function processing($new_product_id, $wcfm_products_manage_form_data ){
        $post_id                = $new_product_id;
        $enable                 = $wcfm_products_manage_form_data['_nbdesigner_enable'];
        $enable_upload          = $wcfm_products_manage_form_data['_nbdesigner_enable_upload']; 
        $upload_without_design  = $wcfm_products_manage_form_data['_nbdesigner_enable_upload_without_design']; 
        $option                 = serialize($wcfm_products_manage_form_data['_nbdesigner_option']); 
        $setting_design         = serialize($wcfm_products_manage_form_data['_designer_setting']);  
        $setting_upload         = serialize($wcfm_products_manage_form_data['_designer_upload']);  
        //todo check license here
        update_post_meta($post_id, '_designer_setting', $setting_design);
        update_post_meta($post_id, '_nbdesigner_option', $option);
        update_post_meta($post_id, '_nbdesigner_upload', $setting_upload);
        update_post_meta($post_id, '_nbdesigner_enable_upload_without_design', $upload_without_design);
        update_post_meta($post_id, '_nbdesigner_enable', $enable);
        update_post_meta($post_id, '_nbdesigner_enable_upload', $enable_upload); 
    }
    public function test($post_id){
        $enable                 = get_post_meta( $post_id, '_nbdesigner_enable', true );
        $_designer_setting      = unserialize( get_post_meta( $post_id, '_designer_setting', true ) );
        $enable_upload          = get_post_meta( $post_id, '_nbdesigner_enable_upload', true );
        $upload_without_design  = get_post_meta( $post_id, '_nbdesigner_enable_upload_without_design', true );
        $option                 = unserialize( get_post_meta( $post_id, '_nbdesigner_option', true ) );
        $unit                   = isset( $option['unit'] ) ? $option['unit'] : nbdesigner_get_option( 'nbdesigner_dimensions_unit', 'cm' );
        if ( isset( $_designer_setting[0] ) ){
            foreach ( $_designer_setting as $key => $set ){
                $_designer_setting[$key] = array_merge( nbd_default_product_setting(), $set );
            }
            $designer_setting = $_designer_setting;
            if(! isset($designer_setting[0]['version']) || $_designer_setting[0]['version'] < 160) {
                //$designer_setting = $this->update_config_product_160( $designer_setting );
            }
            if(! isset($designer_setting[0]['version']) || $_designer_setting[0]['version'] < 180) {
                $designer_setting = NBD_Update_Data::nbd_update_media_v180( $designer_setting );
            }
        }else {
            $designer_setting       = array();
            $designer_setting[0]    = nbd_default_product_setting();
        }
        $_option = nbd_get_default_product_option();
        if( !is_array( $option ) ){
            $option = array();
        }
        $option             = array_merge( $_option, $option );
        $upload_setting     = unserialize( get_post_meta( $post_id, '_nbdesigner_upload', true ) );
        $_upload_setting    = nbd_get_default_upload_setting();
        if( !is_array( $upload_setting ) ){
            $upload_setting = array();
        }
        $upload_setting     = array_merge( $_upload_setting, $upload_setting );
        $designer_setting   = nbd_update_config_default( $designer_setting );
        $atts = array(
            'post_id'               => $post_id,
            'enable'                => $enable,
            'enable_upload'         => $enable_upload,
            'upload_without_design' => $upload_without_design,
            'designer_setting'      => $designer_setting,
            'upload_setting'        => $upload_setting,
            'option'                => $option,
            'unit'                  => $unit,
        );
        ob_start();
        nbdesigner_get_template( 'compatibility/dokan/product_setting.php', $atts );
        $nbd_box = ob_get_clean();
        echo $nbd_box;
        ob_start();
        nbdesigner_get_template('popup.php',array('product_id' => $post_id),MV_PLUGIN_DIR,MV_PLUGIN_DIR);
        $nbd_popup = ob_get_clean();
        echo $nbd_popup;
    }
    public function enqueue_scripts(){

        global $wp;

        if( isset( $wp->query_vars['wcfm-products-manage'] ) ) {
            wp_register_script('nbd-dokan-product', NBDESIGNER_JS_URL . 'dokan.js', array( 'jquery-ui-resizable', 'jquery-ui-draggable' ));
            wp_register_script('nbd-wcfm-product', MV_PLUGIN_URL . 'wcfm.js', array( 'nbd-dokan-product' ));
            wp_enqueue_script( array( 'jquery-ui-core', 'nbd-dokan-product' , 'nbd-wcfm-product' ) );
            wp_enqueue_script(
                'iris',
                admin_url( 'js/iris.min.js' ),
                array( 'jquery-ui-draggable', 'jquery-ui-slider', 'jquery-touch-punch' ),
                false,
                1
            );
            wp_enqueue_script(
                'wp-color-picker',
                admin_url( 'js/color-picker.min.js' ),
                array( 'iris' ),
                false,
                1
            );
            $colorpicker_l10n = array(
                'clear' => __( 'Clear', 'web-to-print-online-designer' ),
                'defaultString' => __( 'Default', 'web-to-print-online-designer' ),
                'pick' => __( 'Select Color', 'web-to-print-online-designer' ),
                'current' => __( 'Current Color', 'web-to-print-online-designer' ),
            );
            wp_localize_script( 'wp-color-picker', 'wpColorPickerL10n', $colorpicker_l10n ); 
            $wp_scripts = wp_scripts();
            wp_enqueue_style(
                'jquery-ui-nbd-dokan', sprintf('https://ajax.googleapis.com/ajax/libs/jqueryui/%s/themes/smoothness/jquery-ui.css', $wp_scripts->registered['jquery-ui-core']->ver)
            );         
            wp_enqueue_style( 'wp-color-picker' );
            wp_enqueue_style('nbd-dokan-product', NBDESIGNER_CSS_URL . 'dokan.css');
            wp_enqueue_style('nba-wc-product', MV_PLUGIN_URL . 'style.css');
            wp_enqueue_style( 'dashicons' );
        }
    }
    public function link_to_create_thumbnail($link){
        global $wp;
        if( isset( $wp->query_vars['wcfm-products-manage'] ) && !empty( $wp->query_vars['wcfm-products-manage'] ) ) :
            $link .= "&create_thumb=1";
        ?>
        <a class="button nbd-admin-tem-link" id="toggle-popup-tem" href="<?php echo esc_url( $link ); ?>">
            <span class="dashicons dashicons-art"></span>
            <?php esc_html_e('Create Thumbnail', 'web-to-print-online-designer'); ?>
        </a>
        <?php
        endif;
    }
}