<?php
if (!defined('ABSPATH')) exit;
add_action('nbd_modern_extra_stages', 'bottom_process');
add_action('nbd_change_color_in_design_page', 'nbd_show_popup');
add_action('porto_after_tab_colors', 'add_custom_color');
function nbd_show_popup()
{
    $display_type       = nbdesigner_get_option('nbdesigner_option_display', '1');
    $arr = 1;
?>

<div class="nbd_tab_color_toggle">
    <span>></span>
</div>
<div class="nbd_tab_color" ng-class="close_tab_color ? 'nbd_translateY' : 'nbd_translateZ'">
<div class="close_tab_color">>
</div>
    <div class="tab_color">
        <div class="nbd_header-title">
            <h6>SUBIR UN DISEÑO TERMINADO ></h6>
        </div>
        <div class="tab-content-color">
            <div class="nbd_title">
                <h6 id="pt_product_name"></h6>
                <div class="nbd_desciption">
                    <p>¡Personaliza tu sticker en pocos pasos!</p>
                </div>
            </div>
            <div class="nbd_tab-porto-logo">
                <h5>Carga tu logotipo</h5>
                <p>JPG, PNG, PDF, SVG & EPS Tamaño máx. 10MB</p>
                <div class="nbd_tab-logo">
                    <div class="porto-tab-logo">
                        <img id="porto_logo_image" src="" height="35px" alt="">
                    </div>
                    <div class="form-upload nbd-dnd-file nbd_tab-logo" nbd-dnd-file="uploadFile(files);">
                        <input type="file" accept="image/*" id="cargatulogo" multiple style="display: none;"
                            <?php echo is_available_imagick() ? 'accept="image/*, .pdf"' : 'accept="image/*"'; ?>>
                        <label for="">Carga tu logo</label>
                    </div>
                </div>
            </div>
            <div class="nbd_form-porto" id="nbd_form-porto">

            </div>
        </div>
    </div>
</div>
<style>
    .nbd_tab_color_toggle {
        position: absolute;
        right: 0px;
        z-index: 99;
        background: #b7b7b7;
        width: 40px;
        height: 40px;
        line-height: 40px;
        text-align: center;
        cursor: pointer;
        top: 0px;
        display: none;
    }

    @media screen and (max-width: 1024px) {
        .nbd_tab_color_toggle {
            display: block;
        }

        .nbd_tab_color_toggle>span {
            display: block;
            font-size: 40px;
            letter-spacing: -10px;
            padding-right: 10px;
        }

        .nbd_tab_color {
            display: none;
        }


        div.stage>div.stage-main-wrap {
            transform: none;
        }
    }
    </style>
<?php
}


add_filter('nbd_hidien_discount', 'nbd_quantity', 10, 2);
function nbd_quantity($clean, $options)
{
?>
    <select name="nbo-quantity" convert-to-number class="nbo-dropdown" ng-change="change_quantity()" ng-model="quantity">
        <?php
        $discount_type = $options['quantity_discount_type'] == 'p' ? '%' : '/' . __('1 item', 'web-to-print-online-designer');
        foreach ($options['quantity_breaks'] as $break) :
            $discount = '';
            if ($break['dis'] != '') {
                $break['dis'] = $options['quantity_discount_type'] == 'p' ? $break['dis'] : wc_price($break['dis']);
                global $product;
                $pid = $product->get_id();
                $pro = wc_get_product($pid);
                $price_p = $pro->get_price();
                $total_discount = ($price_p - ($price_p * $break['dis']) / 100) * $break['val'];
                print_r($total_discount);
                $discount = ' (' . '$' . $total_discount . ' )';
            }
        ?>
            <option value="<?php echo $break['val']; ?>"><?php echo $break['val']; ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php echo $discount; ?></option>
        <?php endforeach; ?>
    </select>
<?php
}

function add_custom_color($field)
{if ($field['general']['attributes']['bg_type'] == 't') {
    ?>
        <div class="row">
            <div class="custom-color">
                <div class="color-picker">
                    <input type="text" name="" disabled ng-model="stages[currentStage].states.text.fill" style="min-width:100px;">
                    <input type="color" disabled ng-model="stages[currentStage].states.text.fill" id="choose_color" name="">
                </div>
                <div class="color-custom nbd-show-color-palette" ng-click="currentColor = stages[currentStage].states.text.fill">
                    <input type="text" name="" style="min-width:100px;" placeholder="Custom color">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
                        <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z" />
                    </svg>
                </div>
            </div>
        </div>
    <?php
    }
    if ($field['general']['attributes']['bg_type'] == 'c') {
    ?>
        <div class="row">
            <div class="custom-color">
                <div class="color-picker">
                    <input type="text" id="val_bg_color" value="#000000" disabled style="min-width:100px;">
                    <input type="color" class="dis_bg_color" value="" disabled id="choose_color">
                </div>
                <div class="color-custom nbd-show-color-palette" ng-click="currentColor = stages[currentStage].states.text.fill">
                    <input type="text" name="" style="min-width:100px;" placeholder="Custom color">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-search" viewBox="0 0 16 16">
                        <path d="M11.742 10.344a6.5 6.5 0 1 0-1.397 1.398h-.001c.03.04.062.078.098.115l3.85 3.85a1 1 0 0 0 1.415-1.414l-3.85-3.85a1.007 1.007 0 0 0-.115-.1zM12 6.5a5.5 5.5 0 1 1-11 0 5.5 5.5 0 0 1 11 0z" />
                    </svg>
                </div>
            </div>
        </div>
    <?php
    }
}

function bottom_process()
{
    function nbd_get_user_id()
    {
        global $current_user;
        $user_id = wp_get_current_user();
        return $user_id->ID;
    }
    function get_pid()
    {
        if (isset($_GET['product_id'])) {
            $pid = $_GET['product_id'];
            return $pid;
        }
    }
    function get_wpoi()
    {
        $p = wc_get_product(get_pid());
        $product_type   = $p->get_type();
        return $product_type;
    }
    function get_price_product()
    {
        if (isset($_GET['view']) && $_GET['view'] == 'm') {
            $percent = get_user_meta(nbd_get_user_id(), 'percent');
            $pro = wc_get_product(get_pid());
            $p_price = $pro->price;
            $sale_price = 0;
            $price = $pro->get_sale_price();
            if (!$percent[0]) {
                return $p_price;
            }
            if ($percent) {
                if ($percent[0] != '' && $percent[0] > 0) {
                    $sale_price = ($p_price * $percent[0]) / 100;
                    $price = $p_price - $sale_price;
                }
                return $price;
            }
        }
    }
?>
<div class="nbd_bottom_process">
    <input type="hidden" name="nbd_user_logged" id="nbd_user_logged"
        value="<?php echo nbd_get_user_id() . "===" . get_wpoi() ?> ">
    <div class="nbd_bottom">
        <div class="left-info">
            <p>Envíos a toda la república Mexicana.</p>
        </div>
        <div class="right-info">
            <div class="nbd_total-price">
                <div class="total-price">
                    <span>total</span>
                    <input type="hidden" id="product_pr" name="" value="<?php echo get_price_product(); ?>">
                    <span class="nbd_price"> </span>
                </div>

            </div>
            <div class="nbd_add-to-cart">
                <input type="hidden" name="" value="<?php echo get_pid(); ?>" id="porto_product_id">
                <button type="submit" name="btn_submit_add_to_cart" id="porto_add_to_cart"
                    ng-click="saveData('addtocart');">Añadir al carrito</button>
            </div>
        </div>
    </div>
</div>
<?php
}

add_action('wp_ajax_porto_add_to_carts', 'porto_add_to_carts');
add_action('wp_ajax_nopriv_porto_add_to_carts', 'porto_add_to_carts');
add_action('template_redirect', 'porto_add_to_carts');

function porto_add_to_carts()
{
    if (isset($_POST['fields']) && !empty($_POST['fields'])) {
        global $woocommerce, $wpdb;
        $data       = [];
        $pid        = $_POST['product_id'];
        $fields     = $_POST['fields'];
        foreach ($_POST['fields'] as $values) {
            $data[$values['name']] = $values['value'];
        }
        $quantity   = $data['nbo-quantity'];
        $cart = WC()->cart;
        $cart_page_url = $woocommerce->cart->get_cart_url();
        $product_cart_id = WC()->cart->generate_cart_id($pid);
        if (!WC()->cart->find_product_in_cart($product_cart_id)) {
            $cart->add_to_cart($pid, $quantity);
        }
        $log = array(
            'pid'       => $pid,
            'fields'    => $fields,
            'data'      => $data,
            'quantity'  => $quantity,
            'url_cart'  => $cart_page_url
        );
        echo wp_send_json($log);
        wp_redirect($cart_page_url);
    }
}
function action_woocommerce_after_cart_item_name($cart_item, $cart_item_key)
{
    // Price
    $price = $cart_item['data']->get_price();

    // Line subtotal
    $subtotal = $cart_item['line_subtotal'];

    // Quantity
    $quantity = $cart_item['quantity'];

    echo '<p class="cart-price">' . wc_price($price)  . '</p>';

    if ($quantity >= 2) {
        echo '<p class="cart-subtotal">' . wc_price($subtotal) . '</p>';
    }
}
// add_action('woocommerce_after_cart_item_name', 'action_woocommerce_after_cart_item_name', 10, 2);

add_action('porto_add_type_text', 'add_type_text_select');
function add_type_text_select()
{
?>
<option value="t"><?php _e('Text color', 'web-to-print-online-designer'); ?></option>
<?php
}
add_action('porto_choose_tab_text', 'add_tab_text_attr');
function add_tab_text_attr()
{
?>
<div class="nbd-field-info" ng-if="field.general.attributes.bg_type == 't'">
    <div class="nbd-field-info-1">
        <div><b><?php _e('Text sides', 'web-to-print-online-designer'); ?></b></div>
    </div>
    <div class="nbd-field-info-2">
        <div class="nbd-table-wrap">
            <table class="nbd-table" style="text-align: center;">
                <tbody>
                    <tr ng-repeat="(opIndex, op) in field.general.attributes.options">
                        <th>{{op.name}}</th>
                        <td>
                            <input type="text"
                                name="options[fields][{{fieldIndex}}][general][attributes][options][{{opIndex}}][bg_color]"
                                ng-model="op.bg_color" class="nbd-color-picker" nbd-color-picker="op.bg_color" />
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php
}

add_filter('nbd_porto_fill_color','porto_fill_color',10,8);
function porto_fill_color($html,$field,$attr,$image_url,$color,$style,$hide_swatch_label,$key){
    $color = "'" . $attr['color'] . "'";
    if ($field['general']['attributes']['bg_type'] == 'c') {
        $bgc = $attr['color'];
        $bgcolor = "ng-click=changeBgColor('$bgc')";
    }
    ?>
        <label id="1" <?php echo $bgcolor ? $bgcolor : ''  ?> <?php
                if ($attr['preview_type'] == 'c' && $field['general']['attributes']['bg_type'] == 't') {
                    echo 'ng-click="changeFill(' . $color . ')"';
                }
                ?> class="nbd-swatch" style="
            <?php
            if ($attr['preview_type'] == 'i') {
                echo 'background: url(' . $image_url . ') 0% 0% / cover';
            } else {
                if (isset($attr['color2'])) {
                    $style  = "background: -moz-linear-gradient(-35deg,  " . $attr['color'] . " 0%, " . $attr['color'] . " 50%, " . $attr['color2'] . " 51%, " . $attr['color2'] . " 100%);";
                    $style .= "background: -webkit-linear-gradient(-35deg,  " . $attr['color'] . " 0%, " . $attr['color'] . " 50%, " . $attr['color2'] . " 51%, " . $attr['color2'] . " 100%);";
                    $style .= "background: linear-gradient(150deg,  " . $attr['color'] . " 0%, " . $attr['color'] . " 50%, " . $attr['color2'] . " 51%, " . $attr['color2'] . " 100%);";
                    echo $style;
                } else {
                    echo 'background: ' . $attr['color'];
                }
            };
            ?>" title="<?php echo $attr['name']; ?>" for='nbd-field-<?php echo $field['id'] . '-' . $key; ?>' nbo-disabled="!status_fields['<?php echo $field['id']; ?>'][<?php echo $key; ?>].enable" nbo-disabled-type="class">
        <?php if ($hide_swatch_label == 'yes') : ?><span class="nbd-swatch-tooltip"><?php echo $attr['name']; ?></span><?php endif; ?>
    </label>
<?php
}
add_action('porto_add_fields', 'add_fields_extra');
function add_fields_extra()
{
?>
<option value="e"><?php _e('Extra Price', 'web-to-print-online-designer'); ?></option>
<?php
}
add_filter('change_select_value', 'porto_change_select');
function porto_change_select()
{
?>
{{options.quantity_discount_type == 'f' ? '-' : ''}}
{{options.quantity_discount_type == 'p' ? '-%' : ''}}
{{options.quantity_discount_type == 'e' ? '+$' : ''}} /
<?php
}

add_filter('nbdesigner_printing_options_settings', 'pop');
function pop($pop)
{
    array_push($pop['general'][14]['options'], 'The right');
    return $pop;
}

// add_filter('woocommerce_cart_item_price', 'bbloomer_change_cart_table_price_display', 30, 3);

function bbloomer_change_cart_table_price_display($price, $values, $cart_item_key)
{
    $slashed_price = $values['data']->get_price_html();
    $is_on_sale = $values['data']->is_on_sale();
    if ($is_on_sale) {
        $price = $slashed_price;
    }
    return $price;
}
?>