<?php

/**
 * Plugin Name:       Custom Porto for Nbdesigner
 * Plugin URI:        https://cmsmart.net
 * Description:       Checkout and AddtoCart from design page
 * Version:           1.0.1
 * Requires at least: 5.2
 * Requires PHP:      7.1
 * Author:            Thuan
 * Author URI:        https://cmsmart.net
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       checkout-and-cart-from-design-page
 * Domain Path:       /languages
 */
if (!defined('ABSPATH')) {
    exit;
}
define('NBDESIGNER_DIR_URL', plugin_dir_url(__FILE__));
define('NBDESIGNER_PATH_URL', plugin_dir_path(__FILE__));

require_once(NBDESIGNER_PATH_URL . 'tab-color.php');
add_action('nbd_extra_js', 'add_js_nb_color');
add_action('admin_enqueue_scripts', 'add_js_porto_');
add_action('nbd_extra_css', 'add_style_nbd_color');
add_action('admin_enqueue_scripts', 'add_style_admin_porto');
add_action('nbd_js_config', 'nbd_change_color_and_logo');

function add_js_porto_()
{
    echo
    '<script>
        var nonce_ = "' . wp_create_nonce('import_temp') . '";
    </script>';
    echo
    '<script>
        var ajaax_ = "' . admin_url('admin-ajax.php') . '";
    </script>';
    wp_enqueue_script('nbd_porto_script', NBDESIGNER_DIR_URL . 'assets/js/js.js');
}
function nbd_change_color_and_logo()
{
?>
var nbd_change_color_and_logo = true;

<?php
}

function add_style_admin_porto()
{
    wp_enqueue_style('porto-admin-css', NBDESIGNER_DIR_URL . 'assets/css/admin.css');
}
function add_js_nb_color()
{
?>
<script type="text/javascript" src="<?php echo NBDESIGNER_DIR_URL . 'assets/js/add-to-cart.js'; ?>"></script>
<?php

}
function add_style_nbd_color()
{
?>
<link rel="stylesheet" type='text/css' href="<?php echo NBDESIGNER_DIR_URL . 'assets/css/style.css'; ?>">
<link rel="stylesheet" type='text/css' href="<?php echo NBDESIGNER_DIR_URL . 'assets/css/reponsive.css'; ?>">
<?php
}


add_filter('change_icon_template_tab', 'change_icon_sidebar');
function change_icon_sidebar()
{
?>
<svg id="template-icon" width="20" height="17" xmlns="http://www.w3.org/2000/svg" fill="none">
    <path fill="#231d51" id="svg_1" stroke-linejoin="round" stroke-linecap="round" stroke-miterlimit="10"
        stroke-width="2.2" stroke="#ffffff"
        d="m12.80599,15.59184l0,-12.91528l5.5391,-1.08472l0,12.9153l-5.5391,1.0847z" />
    <path fill="#231d51" id="svg_2" stroke-linejoin="round" stroke-linecap="round" stroke-miterlimit="10"
        stroke-width="2.2" stroke="#ffffff"
        d="m1.72789,2.67656l5.53908,-1.08472l0,12.9153l-5.53908,1.0847l0,-12.91528z" />
    <path stroke="#ffffff" fill="#231d51" id="svg_3" stroke-linejoin="round" stroke-linecap="round"
        stroke-miterlimit="10" stroke-width="2.2" d="m8.21933,14.50714l4.1785,1.0847l0,-12.91528l-4.1785,-1.08472" />
</svg>
<?php
}

add_filter('nbd_change_icon_cliparts', 'change_icon_cliparts');
function change_icon_cliparts()
{
?>
<svg id="icon-nbd-text-fields" width="24" height="23" viewBox="0 0 24 23" fill="none"
    xmlns="http://www.w3.org/2000/svg">
    <path
        d="M12 17.7554L18.1784 21L17 14.1241L22 9.25725L15.0865 8.25273L12 2L8.90812 8.25273L2 9.25725L7 14.1241L5.81625 21L12 17.7554Z"
        stroke="#231D51" stroke-width="2.2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
</svg>

<?php
}


add_filter('nbd_change_icon_photos', 'change_icon_photos');
function change_icon_photos()
{
?>
<svg id="nbd_icon-photos" width="24" height="23" xmlns="http://www.w3.org/2000/svg" fill="none">
    <path stroke="white" id="svg_1" stroke-linejoin="round" stroke-linecap="round" stroke-miterlimit="10"
        stroke-width="2.2"
        d="m22.51927,15.38456l0,3.28968c0,0.96998 -0.78289,1.75301 -1.75287,1.75301l-16.94514,0c-1.29132,0 -2.33725,-1.0459 -2.33725,-2.33725l0,-13.33994c0,-1.29132 1.04593,-2.33725 2.33725,-2.33725l16.36076,0c1.29135,0 2.33725,1.04593 2.33725,2.33725l0,5.08938" />
    <path stroke="white" id="svg_2" stroke-linejoin="round" stroke-linecap="round" stroke-miterlimit="10"
        stroke-width="2.2" d="m22.51955,15.38456l-7.18714,-7.36234l-12.09523,12.0661" />
    <circle stroke="null" id="svg_3" fill="white" r="2.0451" cy="8.64155" cx="8.0521" />
</svg>
<?php
}

add_filter('nbd_change_icon_elementos', 'change_icon_elementos');
function change_icon_elementos()
{
?>
<svg width="29" height="21" viewBox="0 0 29 21" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M2.80385 16L8 7L13.1962 16H2.80385Z" stroke="white" stroke-width="2" stroke-linejoin="round" />
    <mask id="path-2-inside-1_243_49" fill="white">
        <path fill-rule="evenodd" clip-rule="evenodd"
            d="M23.8236 6.17647C23.8236 2.7653 21.0583 0 17.6472 0C14.236 0 11.4707 2.7653 11.4707 6.17647C11.4707 9.58764 14.236 12.3529 17.6472 12.3529C18.5256 12.3529 19.3612 12.1696 20.1178 11.839V6.17647H23.8236Z" />
    </mask>
    <path id="none-stroke"
        d="M23.8236 6.17647V8.17647C24.9282 8.17647 25.8236 7.28104 25.8236 6.17647H23.8236ZM20.1178 11.839L20.9185 13.6717C21.647 13.3534 22.1178 12.634 22.1178 11.839H20.1178ZM20.1178 6.17647V4.17647C19.0132 4.17647 18.1178 5.0719 18.1178 6.17647H20.1178ZM17.6472 2C19.9538 2 21.8236 3.86987 21.8236 6.17647H25.8236C25.8236 1.66073 22.1629 -2 17.6472 -2V2ZM13.4707 6.17647C13.4707 3.86987 15.3406 2 17.6472 2V-2C13.1314 -2 9.4707 1.66073 9.4707 6.17647H13.4707ZM17.6472 10.3529C15.3406 10.3529 13.4707 8.48307 13.4707 6.17647H9.4707C9.4707 10.6922 13.1314 14.3529 17.6472 14.3529V10.3529ZM19.317 10.0063C18.8082 10.2286 18.2448 10.3529 17.6472 10.3529V14.3529C18.8064 14.3529 19.9142 14.1105 20.9185 13.6717L19.317 10.0063ZM22.1178 11.839V6.17647H18.1178V11.839H22.1178ZM20.1178 8.17647H23.8236V4.17647H20.1178V8.17647Z"
        fill="white" mask="url(#path-2-inside-1_243_49)" />
    <rect x="19" y="5" width="9" height="9" stroke="white" stroke-width="2" stroke-linejoin="round" />
</svg>

<?php
}

add_filter('nbd_change_icon_layers', 'change_icon_layers');
function change_icon_layers()
{
?>
<svg id="nbd-icon-layers" width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path d="M14.9623 10.5095L10.5376 13.5128L6.05615 10.4906" stroke="white" stroke-width="2.2" stroke-miterlimit="10"
        stroke-linecap="round" stroke-linejoin="round" />
    <path d="M14.9625 10.5095L19.0189 7.75636L10.4811 2L2 7.75636L6.05637 10.4905" stroke="white" stroke-width="2.2"
        stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
    <path d="M14.9625 10.5094L19.0189 13.2436L10.5378 18.9999L2 13.2436L3.95028 11.9213" stroke="white"
        stroke-width="2.2" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
</svg>

<?php
}

/* User custom */
add_action('admin_menu', 'menu_user_info', 10);
function menu_user_info()
{
    add_submenu_page(
        'users.php',
        'User on Website',
        'User on Website',
        'manage_options',
        'user-on-website',
        'callback_porto'
    );
}
function callback_porto()
{
    require_once NBDESIGNER_PATH_URL . '/porto-manager-users.php';
}

function update_extra_profile_fields($user_id)
{
    if (current_user_can('edit_user', $user_id)) {
        update_user_meta($user_id, 'user_in_web', $_POST['user_in_web']);
        update_user_meta($user_id, 'percent', $_POST['percent']);
    }
}
add_action('edit_user_profile_update', 'update_extra_profile_fields');

add_action('edit_user_profile', 'acccc', 1);
add_action('show_user_profile', 'acccc', 2);
function acccc()
{
    $uid = $_GET['user_id'];
    $uow = get_user_meta($uid, 'user_in_web');
    $percent = get_user_meta($uid, 'percent');
    $get_role_1 = get_option('agency_user');
    $get_role_2 = get_option('industrial_users');
    $get_role_3 = get_option('ecommerce_user');
    $default_percent = $get_role_1;
    if ($uow == 2) {
        $default_percent = $get_role_2;
    }
    if ($uow == 3) {
        $default_percent = $get_role_3;
    }

?>
<h2>Porto setting role</h2>
<div class="nbd-section user-classification">
    <label for="porto_user_ow"><?php _e('Roles', 'web-to-print-online-designer'); ?></label>
    <select name="user_in_web" id="porto_user_ow" class="regular-text">
        <option value="1" <?php if ($uow[0] == 1) echo "selected=\"selected\""; ?>>Agency User</option>
        <option value="2" <?php if ($uow[0] == 2) echo "selected=\"selected\""; ?>>Industrial users</option>
        <option value="3" <?php if ($uow[0] == 3) echo "selected=\"selected\""; ?>>Ecommerce user</option>
    </select>
</div>
<div class="nbd-section user-percent-wrap">
    <label for="percent"><?php _e('Percent (%)'); ?></label>
    <input type="number" name="percent" id="percent" value="<?= isset($percent[0]) ? $percent[0] : $default_percent; ?>"
        class="regular-number" />
</div>
<?php
}

add_filter('manage_users_columns', 'custom_add_user_id_column');
add_filter('manage_users_custom_column',  'custom_show_user_id_column_content', 10, 3);

function custom_add_user_id_column($columns)
{
    $columns['role_ow'] = 'Role on website';
    return $columns;
}

function custom_show_user_id_column_content($value, $column_name, $user_id)
{
    $user = get_userdata($user_id);
    if ('role_ow' == $column_name) {
        $_uow = get_user_meta($user_id, 'user_in_web');
        $uow = $_uow[0];
        $role = get_role_user_logged($user_id);
        if ($role == "admintrator") {
            $default_percent = "";
            return $default_percent;
        }
        $default_percent = 'Agency User';
        if ($uow == 2) {
            $default_percent = 'Industrial users';
        }
        if ($uow == 3) {
            $default_percent = 'Ecommerce user';
        }
        return $default_percent;
    }
    return $value;
}
add_action('wp_ajax_ajaxs_import_file_vector', 'ajaxs_import_file_vector');
add_action('wp_ajax_nopriv_ajaxs_import_file_vector', 'ajaxs_import_file_vector');
function ajaxs_import_file_vector()
{
    $option_u1 = get_option('agency_user') ? get_option('agency_user') : 0;
    $option_u2 = get_option('industrial_users') ? get_option('industrial_users') : 0;
    $option_u3 = get_option('ecommerce_user') ? get_option('ecommerce_user') : 0;
    $agency_user = $_POST['agency_user'];
    $industrial_users = $_POST['industrial_users'];
    $ecommerce_user = $_POST['ecommerce_user'];
    if ($option_u1 && $option_u2 && $option_u3) {
        update_option('agency_user', $agency_user);
        update_option('industrial_users', $industrial_users);
        update_option('ecommerce_user', $ecommerce_user);
    } else {
        add_option('agency_user', $agency_user, '', 'yes');
        add_option('industrial_users', $industrial_users, '', 'yes');
        add_option('ecommerce_user', $ecommerce_user, '', 'yes');
    }
    wp_die();
}

function get_role_user_logged($user_id)
{
    $user = new WP_User($user_id);
    $role = $user->roles[0];
    return $role;
}


add_action('preview_mockup_live', 'abcd');
function abcd()
{
?>
    <div class="nbd-custom-porto-save">
        <div class="porto-save">
            <label class="save-design" for="" ng-click="prepareBeforeSaveForLater()">
                <svg width="24px" height="24px" viewBox="0 0 24 24" role="img" xmlns="http://www.w3.org/2000/svg" aria-labelledby="saveIconTitle" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" fill="none" color="#000000">
                    <path d="M17.2928932,3.29289322 L21,7 L21,20 C21,20.5522847 20.5522847,21 20,21 L4,21 C3.44771525,21 3,20.5522847 3,20 L3,4 C3,3.44771525 3.44771525,3 4,3 L16.5857864,3 C16.8510029,3 17.1053568,3.10535684 17.2928932,3.29289322 Z" />
                    <rect width="10" height="8" x="7" y="13" />
                    <rect width="8" height="5" x="8" y="3" />
                </svg>
                <span>Guardar</span>
            </label>
        </div>
        <div class="porto-download">
            <label class="download-design" for="" ng-click="saveData('download-pdf')">
                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M2.13999 8.27332L1.32001 9.21665C1.11334 9.45332 1 9.75665 1 10.07V11.9366C1 12.5233 1.47667 13 2.06333 13H11.6367C12.2233 13 12.7 12.5233 12.7 11.9366V10.07C12.7 9.75665 12.5867 9.45332 12.38 9.21665L11.56 8.27332" stroke="#231D51" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                    <path d="M3.74316 5.46667L6.85317 8.57668L9.96318 5.46667" stroke="#231D51" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                    <path d="M6.85303 1V8.42" stroke="#231D51" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                </svg>
                <span>Descargar</span>
            </label>
        </div>
    </div>
<?php
}

?>