<?php
/**
 * Plugin Name:       Customize the design web2print
 * Plugin URI:        https://cmsmart.net
 * Description:       Customize the design web2print
 * Version:           1.0.1
 * Requires at least: 5.2
 * Requires PHP:      7.1   
 * Author:            Huy
 * Author URI:        https://cmsmart.net
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       Customize the design web2print
 * Domain Path:       /languages
 nbd_extra_css
 */
// $path = plugin_dir_url(__FILE__) . 'assets/style.css';
add_action('nbd_js_config','tppl_add_js');
function tppl_add_js(){
    ?>
      var web2print_add_js = 1;
    <?php 
}

add_action('wp_enqueue_scripts','crs_logo_style');
function crs_logo_style(){
    wp_enqueue_script('quote_js', plugin_dir_url(__FILE__) . 'assets/quote.js', array('jquery'), 1.0, true);
    ?>
        <link rel="stylesheet" href="<?= plugin_dir_url(__FILE__) . 'assets/stylect.css'; ?>">
        <link rel="stylesheet" href="<?= plugin_dir_url(__FILE__) . 'assets/reponsive.css'; ?>">
    <?php
}

add_action('add_header_ed','addHeader');
function addHeader(){
    ?>
        <div class="homepage-hr"></div>
        <div class="homepage-title container-fluid">
            <div class="homepage-title-icon">
                <i class="fas fa-bars"></i>
                <span class="todo-los-productos">Todos los productos</span>
            </div>
            <div class="homepage-title-nav">
                <ul class="nav">
                    <li class="nav-item">
                        <a class="nav-link" href="#">Catálogo</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Tienda</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Inpsiración</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Centro de ayuda</a>
                    </li>
                </ul>
            </div>
            <div class="homepage-title-Offers">
                <div class="Offers-icon">
                    <img src="<?php echo plugin_dir_url(__FILE__) . 'image/Group2.svg' ?>" alt="">
                    <a href="#">Ofertas</a>
                </div>
                <?php 
                $uow =  get_user_meta(nbd_getuid(), 'user_in_web');
                $user = is_user_logged_in();
                $cl = '';
                $link = '#';
                if ($user >= 1) {
                        $cl = 'nbdq-add-a-quote-button';
                } else {
                    $link = get_permalink(get_option('woocommerce_myaccount_page_id'));
                }
                ?>
                <div class="pen-icon">
                    <img src="<?php echo plugin_dir_url(__FILE__) . 'image/Group.svg' ?>" alt="">
                    <a href="<?php echo $link ?>" class="<?php echo $cl; ?>" id="nbdq-quote-btn">Cotiza1</a>
                </div>
                <?php
                require_once('quotes.php');
                ?>
            </div>
        </div>
    <?php
}

add_filter('porto_minicart','priceCartHd');
function priceCartHd(){
    if ( class_exists( 'Woocommerce' ) || ( defined( 'PORTO_DEMO' ) && PORTO_DEMO ) ) :
        $icon_class = 'minicart-icon';
        if ( empty( $porto_settings['minicart-icon'] ) ) {
            if ( 'simple' == $minicart_type ) {
                $icon_class .= ' minicart-icon-default';
            } else {
                $icon_class .= ' porto-icon-bag-2';
            }
        } else {
            $icon_class .= ' ' . trim( $porto_settings['minicart-icon'] );
        }
        ?>
        <div id="mini-cart" class="mini-cart <?php echo esc_attr( $minicart_type ), isset( $porto_settings['minicart-content'] ) && $porto_settings['minicart-content'] ? ' minicart-offcanvas' : '', $el_class ? ' ' . esc_attr( $el_class ) : ''; ?>">
            <div class="cart-head">
            <?php
            if ( 'minicart-inline' == $minicart_type || 'minicart-text' == $minicart_type ) {
                $cart_text = empty( $porto_settings['minicart-text'] ) ? __( 'Cart', 'porto' ) : $porto_settings['minicart-text'];
                $format    = '<span class="cart-icon"><i class="' . esc_attr( $icon_class ) . '"></i><span class="cart-items">%s</span></span><span class="cart-subtotal">' . esc_html( $cart_text ) . ' %s</span>';
                if ( defined( 'WP_CACHE' ) && WP_CACHE ) {
                    $_cart_qty   = '<i class="fas fa-spinner fa-pulse"></i>';
                    $_cart_total = $_cart_qty;
                } else {
                    $_cart_qty   = $woocommerce->cart ? $woocommerce->cart->cart_contents_count : 0;
                    $_cart_total = $woocommerce->cart ? $woocommerce->cart->get_cart_subtotal() : 0;
                }
                printf( $format, $_cart_qty, '<span class="cart-price">' . $_cart_total . '</span>' );
            } else {
                $format = '
                    <svg width="44" height="39" viewBox="0 0 44 39" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M29.941 3.61803C30.5585 3.92677 31.3093 3.67649 31.618 3.05902C31.9268 2.44154 31.6765 1.6907 31.059 1.38197L29.941 
                        3.61803ZM28.5 1.5L29.059 0.381966C28.7161 0.21051 28.3135 0.2059 27.9667 0.36946L28.5 1.5ZM2 14L1.46673 12.8695C1.02793 13.0764 
                        0.748531 13.5186 0.750006 14.0038C0.751481 14.489 1.03356 14.9295 1.47361 15.1338L2 14ZM16 20.5L15.4736 21.6338C15.8065 21.7883 
                        16.1906 21.7888 16.5238 21.6349L16 20.5ZM42 8.5L42.5238 9.63495C42.9601 9.43359 43.2423 8.99997 43.2498 8.51952C43.2574 8.03908 
                        42.9888 7.59686 42.559 7.38197L42 8.5ZM34.559 3.38197C33.9415 3.07323 33.1907 3.32351 32.882 3.94098C32.5732 4.55846 32.8235 
                        5.3093 33.441 5.61803L34.559 3.38197ZM31.059 1.38197L29.059 0.381966L27.941 2.61803L29.941 3.61803L31.059 1.38197ZM27.9667 
                        0.36946L1.46673 12.8695L2.53327 15.1305L29.0333 2.63054L27.9667 0.36946ZM1.47361 15.1338L15.4736 21.6338L16.5264 19.3662L2.52639 
                        12.8662L1.47361 15.1338ZM16.5238 21.6349L42.5238 9.63495L41.4762 7.36505L15.4762 19.3651L16.5238 21.6349ZM42.559 7.38197L34.559 
                        3.38197L33.441 5.61803L41.441 9.61803L42.559 7.38197Z" fill="#2C3149"/>
                        <path d="M42.5 14L16 1.5L2 8.5L28 21L42.5 14Z" stroke="#2C3149" stroke-width="2.5" stroke-linejoin="round"/>
                        <path d="M7.5 16.5V27.5L22 34.5L36.5 27V17" stroke="#2C3149" stroke-width="2.5" stroke-linejoin="round"/>
                        <path d="M22 18V34.5" stroke="#2C3149" stroke-width="2.5"/>
                    </svg>
                    <span class="cart-items">%s</span></span>
                    <div class="price-cart-hd">
                        <span id="micarrito">Mi carrito</span>
                        <h5 id="micarrito-price">$' . WC()->cart->cart_contents_total . '.00</h5>
                    </div>';
                if ( ! class_exists( 'Woocommerce' ) && defined( 'PORTO_DEMO' ) && PORTO_DEMO ) {
                    $_cart_qty  = 1;
                    $_cart_qty1 = 1;
                } elseif ( defined( 'WP_CACHE' ) && WP_CACHE ) {
                    $_cart_qty  = '<i class="fas fa-spinner fa-pulse"></i>';
                    $_cart_qty1 = $_cart_qty;
                } else {
                    $_cart_qty = $woocommerce->cart ? $woocommerce->cart->cart_contents_count : 0;
                    /* translators: %s: Cart quantity */
                    $_cart_qty1 = sprintf( _n( '%d item', '%d items', $_cart_qty, 'porto' ), $_cart_qty );
                }

                printf( $format, $_cart_qty, $_cart_qty1 );
            }
            ?>
            </div>
            <div class="cart-popup widget_shopping_cart">
                <div class="widget_shopping_cart_content">
                <?php if ( class_exists( 'Woocommerce' ) ) : ?>
                    <div class="cart-loading"></div>
                <?php else : ?>
                    <ul class="cart_list py-3 px-0 mb-0"><li class="empty pt-0"><?php esc_html_e( 'WooCommerce is not installed.', 'porto' ); ?></li></ul>
                <?php endif; ?>
                </div>
            </div>
        <?php
        if ( ! empty( $porto_settings['minicart-content'] ) ) {
            echo '<div class="minicart-overlay"><svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><defs><style>.minicart-svg{fill:none;stroke:#fff;stroke-linecap:round;stroke-linejoin:round;stroke-width:2px;}</style></defs><title/><g id="cross"><line class="minicart-svg" x1="7" x2="25" y1="7" y2="25"/><line class="minicart-svg" x1="7" x2="25" y1="25" y2="7"/></g></svg></div>';
        }
        ?>
        </div>
        <?php
    endif;
}

add_action('woocommerce_after_shop_loop_item','buttonComprar');
function buttonComprar()
{
    ?>
        <button id="btcomprar">Comprar</button>
    <?php
}

add_action('add_footer_ed','addFooter');
function addFooter(){
    ?>
        <div class="containert container-fluid">
            <div class="bt-logo">
                <img src="<?php echo plugin_dir_url(__FILE__) . 'image/logot.png' ?>" alt="">
            </div>
            <div class="bt-title">
                <div class="porto-sicon-header">
                    <h4 class="porto-sicon-title">Suscríbete a nuestro newsletter</h4>
                    <p>Obtén la más reciente información sobre nuevos productos, descuentos y ofertas.</p>
                </div>
            </div>
            <div class="bt-form">
                <form action="" method="post" class="wpcf7-form init" novalidate="novalidate" data-status="init">
                    <div class="form-row d-flex justify-content-end widget-subscribe mb-0">
                        <span class="wpcf7-form-control-wrap email"><input type="email" name="email" value="" size="40" class="wpcf7-form-control wpcf7-text wpcf7-email wpcf7-validates-as-required wpcf7-validates-as-email form-control" id="email" aria-required="true" aria-invalid="false" placeholder="ejemplo@email.com"></span><br>
                        <input type="submit" value="Suscribirme" class="wpcf7-form-control has-spinner wpcf7-submit submit btn btn-secondary" id="submit"><span class="wpcf7-spinner"></span>
                    </div>
                </form>
            </div>
        </div>
    <?php
}

add_action('shop_title_filter','addTitle_filterShop');
function addTitle_filterShop() {
    ?>
        <div class="hr-filter" style="width: 100%;">
            <div class="shop-hr"></div>
            <p class="shop-hr-content">Navega entre nuestros productos con los filtros especializados.</p>
       </div>
        <div class="shop-filters">
            <div class="shop-filters-child">
                <i class="fas fa-filter"></i>
                <span>filters</span>
            </div>
        </div>
    <?php
}

function wooc_extra_register_fields() {?>
       <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
           <label class="custom-lable" for="reg_billing_first_name"><?php _e( 'Nombre*', 'woocommerce' ); ?><span class="required">*</span></label>
           <input type="text" class="input-text custom-input" name="billing_first_name" placeholder="Escribe aquí tu nombre" id="reg_billing_first_name" value="<?php if ( ! empty( $_POST['billing_first_name'] ) ) esc_attr_e( $_POST['billing_first_name'] ); ?>" />
       </p>
      <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
           <label class="custom-lable" for="reg_billing_last_name"><?php _e( 'Apellidos*', 'woocommerce' ); ?><span class="required">*</span></label>
           <input type="text" class="input-text custom-input" name="billing_last_name" placeholder="Escribe aquí tus apellidos" id="reg_billing_last_name" value="<?php if ( ! empty( $_POST['billing_last_name'] ) ) esc_attr_e( $_POST['billing_last_name'] ); ?>" />
       </p>

        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <label class="font-weight-medium mb-1 custom-lable" for="reg_email"><?php esc_html_e( 'Email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
            <input type="email" class="woocommerce-Input woocommerce-Input--text line-height-xl input-text custom-input" placeholder="Escribe aquí tu e-mail" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" />
        </p>

       <p class="form-row form-row-wide customH">
           <label for="reg_billing_phone" class="mb-1 custom-lable"><?php _e( 'Whatsapp o teléfono de contacto', 'woocommerce' ); ?><span class="required">*</span></label>
           <input type="text" class="input-text custom-input" placeholder="Escribe aquí tu Whatsapp" name="phone" id="" value="<?php esc_attr_e( $_POST['phone'] ); ?>" />
       </p>

        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <label class="font-weight-medium mb-1 custom-lable" for="reg_password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
            <input type="password" class="woocommerce-Input woocommerce-Input--text line-height-xl input-text custom-input" placeholder="Escribe aquí tu contraseña" name="password" id="reg_password" autocomplete="new-password" />
        </p>

       <div class="clear"></div>
       <?php
 }
 add_action( 'woocommerce_register_form_start', 'wooc_extra_register_fields' );

function my_account_my_order() {
    $items = array(
        'dashboard'       => __( 'Dashboard', 'woocommerce' ),
        'orders'          => __( 'Orders ', 'woocommerce' ),
        'downloads'       => __( 'Downloads', 'woocommerce' ),
        'edit-address'    => _n( 'Address', 'Address', (int) wc_shipping_enabled(), 'woocommerce' ),
        'edit-account'    => __( 'Account details', 'woocommerce' ),
        'my-designs' => __( 'My designs', 'woocommerce' ),
        'customer-logout' => __( 'Logout', 'woocommerce' ),
    );
    return $items;
}
add_filter('woocommerce_account_menu_items','my_account_my_order');

function nbd_getuid()
{
    global $current_user;
    $user_id = wp_get_current_user();
    return $user_id->ID;
}

add_action('w4_edit_adress','editAdress');
function editAdress()
{
    ?>
        <img src="<?php echo plugin_dir_url(__FILE__) . 'image/editad.svg' ?>" alt="" style="float: right;">
    <?php
}


function wooc_validate_extra_register_fields( $username, $email, $validation_errors ) {
      if ( isset( $_POST['billing_first_name'] ) && empty( $_POST['billing_first_name'] ) ) {
             $validation_errors->add( 'billing_first_name_error', __( '<strong>Error</strong>: First name is required!', 'woocommerce' ) );
      }
      if ( isset( $_POST['billing_last_name'] ) && empty( $_POST['billing_last_name'] ) ) {
             $validation_errors->add( 'billing_last_name_error', __( '<strong>Error</strong>: Last name is required!.', 'woocommerce' ) );
      }
         return $validation_errors;
}
add_action( 'woocommerce_register_post', 'wooc_validate_extra_register_fields', 10, 3 );

function wooc_save_extra_register_fields( $customer_id ) {
    if ( isset( $_POST['billing_phone'] ) ) {
                 update_user_meta( $customer_id, 'billing_phone', sanitize_text_field( $_POST['billing_phone'] ) );
          }
      if ( isset( $_POST['billing_first_name'] ) ) {
             update_user_meta( $customer_id, 'first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
             update_user_meta( $customer_id, 'billing_first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
      }
      if ( isset( $_POST['billing_last_name'] ) ) {
             update_user_meta( $customer_id, 'last_name', sanitize_text_field( $_POST['billing_last_name'] ) );
             update_user_meta( $customer_id, 'billing_last_name', sanitize_text_field( $_POST['billing_last_name'] ) );
      }
}
add_action( 'woocommerce_created_customer', 'wooc_save_extra_register_fieldsss' );



add_filter( 'woocommerce_get_order_item_totals', 'customize_order_item_totalss', 10, 3 );
function customize_order_item_totals( $total_rows, $order, $tax_display ){
    $total_rows['shipping']['label'] = __( 'Shipping:', 'woocommerce' ); 
    $total_rows['shipping']['value'] = $order->get_shipping_to_display( $tax_display ); 

    return $total_rows;
}

add_filter('nbd_edit_quote_w2','nbeditQuote');
function nbeditQuote() {
    ?>
        <h2 style="display: none;"><?php _e( 'Recent Quotes ', 'web-to-print-online-designer' ); ?></h2>
        <table class="shop_table shop_table_responsive my_account_quotes my_account_orders" style="display: none;">
            <thead>
                <tr>
                    <th class="order-status"><span class="nobr"><?php _e( 'Status', 'web-to-print-online-designer' ); ?></span></th>
                    <th class="order-number"><span class="nobr"><?php _e( 'Quote', 'web-to-print-online-designer' ); ?></span></th>
                    <th class="order-date"><span class="nobr"><?php _e( 'Date', 'web-to-print-online-designer' ); ?></span></th>
                    <th class="order-actions">&nbsp;</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    foreach ( $quote_orders as $quote_order ) {
                        $order_id   = $quote_order->ID;
                        $order      = wc_get_order( $order_id );
                        $order_date = $quote_order->post_date;
                        $email      = $order->get_meta('_raq_customer_email');
                        $raq_pay    = $order->get_meta('_raq_pay');
                        $quote_url  = wc_get_endpoint_url( 'view-quote', $order_id, wc_get_page_permalink( 'myaccount' ) );
                        $actions    = array();
                        if ( in_array( $order->get_status(), array( 'pending', 'nbdq-accepted' ) ) ) {
                            $actions['accept'] = array(
                                'url'  => nbd_is_true($raq_pay ) ? nbd_get_quote_action_url( 'accept', $order_id, $email, $order->get_checkout_payment_url( false ) ) : nbd_get_quote_action_url( 'accept', $order_id, $email ),
                                'name' => __( 'Checkout', 'web-to-print-online-designer' )
                            );
                        }
                        if ( in_array( $order->get_status(), array( 'nbdq-pending' ) ) ) {
                            $actions['accept'] = array(
                                'url'  => nbd_is_true($raq_pay ) ? nbd_get_quote_action_url( 'accept', $order_id, $email, $order->get_checkout_payment_url( false ) ) : nbd_get_quote_action_url( 'accept', $order_id, $email ),
                                'name' => __( 'Accept', 'web-to-print-online-designer' )
                            );
                            $actions['reject'] = array(
                                'url'  => nbd_get_quote_action_url( 'reject', $order_id, $email ),
                                'name' => __( 'Reject', 'web-to-print-online-designer' )
                            );
                        }
                        $actions['view'] = array(
                            'url'  => $quote_url,
                            'name' => __( 'View', 'web-to-print-online-designer' )
                        );
                ?>
                <tr class="quotes">
                    <td class="quotes-status" data-title="<?php _e( 'Status', 'web-to-print-online-designer' ); ?>" style="text-align:<?php echo $text_align ?>; white-space:nowrap;">
                <?php nbdq_get_order_status_tag( $order->get_status() ); ?>
                    </td>
                    <td class="quotes-number" data-title="<?php _e( 'Order Number', 'web-to-print-online-designer' ); ?>">
                        <a href="<?php echo $quote_url; ?>">
                            #<?php echo $order->get_order_number(); ?>
                        </a>
                    </td>
                    <td class="quotes-date" data-title="<?php _e( 'Date', 'web-to-print-online-designer' ); ?>">
                        <time datetime="<?php echo date( 'Y-m-d', strtotime( $order_date ) ); ?>" title="<?php echo esc_attr( strtotime( $order_date ) ); ?>"><?php echo date_i18n( get_option( 'date_format' ), strtotime( $order_date ) ); ?></time>
                    </td>
                    <td class="quotes-actions" data-order_id="<?php echo $order_id ?>">
                        <?php
                            if ( $actions ) {
                                foreach ( $actions as $key => $action ) {
                                    echo '<a href="' . esc_url( $action['url'] ) . '" class="button ' . sanitize_html_class( $key ) . '">' . esc_html( $action['name'] ) . '</a>';
                                }
                            }
                        ?>
                    </td>
                </tr>
                <?php }; ?>
            </tbody>
        </table>
    <?php
}

add_filter ( 'woocommerce_account_menu_items', 'my_quotes_link', 40 );
function my_quotes_link( $menu_links ){
    $used = nbd_getuid();
    $usd = get_user_meta($used, 'user_in_web');
    $menu_links = array_slice( $menu_links, 0, 2, true ) 
    + array( 'invoice' => 'Invoice' )
    + array_slice( $menu_links, 2, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 2, true ) 
    + array( 'quote' => 'My Quotes' )
    + array_slice( $menu_links, 2, NULL, true );
    return $menu_links;
}
 
add_action( 'init', 'quotes_add_endpointt' );
function quotes_add_endpointt() {    
    add_rewrite_endpoint( 'invoice', EP_PAGES ); 
}

add_action( 'woocommerce_account_invoice_endpoint', 'my_invoice_my_account_endpoint_content' );
function my_invoice_my_account_endpoint_content() {
    echo "<h3>No invoice</h3>";
} 
 
add_action( 'init', 'quotes_add_endpoint' );
function quotes_add_endpoint() {    
    add_rewrite_endpoint( 'quote', EP_PAGES ); 
}



require_once plugin_dir_path(__FILE__) . 'quote/quote.php';
add_filter('nbod_edit_quote_detail','editQuoteDetail',9,1);
function editQuoteDetail() {
    if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
    }
    $order_id = $_GET['qoute_id'] ? $_GET['qoute_id'] : '';
    $order              = wc_get_order( $order_id );
    if( !$order ) {
        _e( 'Order not exist', 'web-to-print-online-designer' );
        return;
    }
    $customer_note      = $order->get_meta('_raq_notes');
    $admin_message      = $order->get_meta('_raq_admin_message');
    $admin_custom_file  = $order->get_meta('_raq_admin_custom_file');
    $custom_files = json_decode($admin_custom_file);
    
    $order_date         = $order->get_date_created();
    $order_status       = $order->get_status();
    $customer_message   = $order->get_meta('_raq_customer_message');
    $customer_email     = $order->get_meta('_raq_customer_email');
    $admin_message      = $order->get_meta('_raq_admin_message');
    $expired            = $order->get_meta('_raq_expired');
    $raq_pay            = $order->get_meta('_raq_pay');
    $accept_button_text = $order_status != 'nbdq-pending' ? __( 'Checkout', 'web-to-print-online-designer' ) : __( 'Accept', 'web-to-print-online-designer' );
    $pdf_file           = false;
    $accept_url         = nbd_is_true( $raq_pay ) ? nbd_get_quote_action_url( 'accept', $order_id, $customer_email, $order->get_checkout_payment_url( false ) ) : nbd_get_quote_action_url( 'accept', $order_id, $customer_email );
    $reject_url         = nbd_get_quote_action_url( 'reject', $order_id, $customer_email );
    $pdf_url            = NBDESIGNER_DATA_URL .'/quotes/quote_'. $order_id .'.pdf';
    ?>
     <style>
        label[for="message_custom_user"] {
            display: flex;
            justify-content: space-between;
        }

        span.error_message {
            font-size: 14px;
            font-weight: lighter;
            color: #cd0000;
            /* display: flex; */
            position: relative;
            width: 400px;
            display: flex;
            justify-content: end;
        }

        input.nbdq_reject {
            background: #d43f5f;
            border: none;
            padding: 5px 10px 5px 10px;
            color: #fff;
        }

        input.nbdq_accept {
            background: #3fa1d4;
            color: #fff;
            border: none;
            float: right;
            padding: 5px;
        }

        tr.nbdq_bg_danger {
            background-color: #ffd5d5;
        }

        tr.nbdq_bg_success {
            background-color: #d5ffe5;
        }

        a.nbdq_admin_custom_file {
            font-weight: 500;
        }
    </style>
        <div class="woocommerce-MyAccount-content">
        <?php if ( $order->has_status( 'nbdq-rejected' ) && $order->get_customer_note() ): ?>
        <p>
            <strong><?php echo __( 'Customer reason:', 'web-to-print-online-designer' ) ?></strong> <?php echo $order->get_customer_note() ?>
        </p>
        <?php endif; ?>
        
        <?php if ( in_array( $order_status, array( 'nbdq-pending', 'nbdq-accepted', 'pending' ) ) ): ?>
        <p class="nbdq-buttons">
            <a class="button accept" href="<?php echo $accept_url; ?>"><?php echo $accept_button_text; ?></a>
            <?php if ( $order_status == 'nbdq-pending' ): ?>
            <a class="button reject" href="<?php echo $reject_url; ?>"><?php _e( 'Reject', 'web-to-print-online-designer' ); ?></a>
                <?php if( nbdesigner_get_option('nbdesigner_quote_allow_download_pdf', 'no') == 'yes' ): ?>
                <a class="button" href="<?php echo $pdf_url; ?>" target="_blank"><?php _e( 'Quote PDF', 'web-to-print-online-designer' ); ?></a>
                <?php endif; ?>
            <?php endif; ?>
        </p>
        <?php elseif( $order_status == 'nbdq-expired' ): ?>
        <p>
            <strong><?php echo __( 'Order Status:', 'web-to-print-online-designere' ) ?></strong> <?php _e( 'Expired Quote', 'web-to-print-online-designer' ); ?>
        </p>
        <?php endif; ?>
        
        <div class="pr-icon" style="">
            <div class="ct-icon <?php echo $order->get_status() == "pending" ? 'icon-active' : '' ?>">
                <i class="far fa-file"></i>
                <span class="ct-icon__line"></span>
                <span class="ct-icon__text">Recibida</span>
            </div>
            <div class="ct-icon <?php echo $order->get_status() == "processing" ? 'icon-active' : '' ?>">
                <i class="far fa-print"></i>
                <span class="ct-icon__line"></span>
                <span class="ct-icon__text">En Aprobación</span>
            </div>
            <div class="ct-icon <?php echo $order->get_status() == "on-hold" ? 'icon-active' : '' ?>">
                <i class="far fa-truck-moving"></i>
                <span class="ct-icon__text">Confirmar Pedido</span>
            </div>
        </div>

        <h2 style="color: #6E60EE;"><?php _e( 'Detalles de la cotización', 'web-to-print-online-designer' ); ?></h2>
        <?php if ( $expired != '' ): ?>
        <p>
            <strong><?php _e( 'Expiration date', 'web-to-print-online-designer' ) ?></strong>: <?php echo date_i18n( wc_date_format(), strtotime( $expired ) ) ?>
        </p>
        <?php endif ?>
        <table class="shop_table order_details">
            <thead style="background: #f8f8f8;">
                <tr>
                    <th class="product-name"><?php _e( 'Product', 'web-to-print-online-designer' ); ?></th>
                    <th class="product-total"><?php _e( 'Total', 'web-to-print-online-designer' ); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                // print_r($order);
                    if ( sizeof( $order->get_items() ) > 0 ) {
                        foreach ( $order->get_items() as $item_id => $item ) {
                            $product = $item->get_product();
                ?>
                <tr class="<?php echo esc_attr( apply_filters( 'woocommerce_order_item_class', 'woocommerce-table__line-item order_item', $item, $order ) ); ?>">
                    <td class="woocommerce-table__product-name product-name">
                        <?php
                            $is_visible        = $product && $product->is_visible();
                            $product_permalink = apply_filters( 'woocommerce_order_item_permalink', $is_visible ? $product->get_permalink( $item ) : '', $item, $order );
                            echo apply_filters( 'woocommerce_order_item_name', $product_permalink ? sprintf( '<a href="%s" class="product-quote">%s</a>', $product_permalink, $item->get_name() ) : $item->get_name(), $item, $is_visible );
                            echo apply_filters( 'woocommerce_order_item_quantity_html', ' <strong class="product-quantity">' . sprintf( '&times; %s', $item->get_quantity() ) . '</strong>', $item );
                            //do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $order, false );
                            wc_display_item_meta( $item );
                            do_action( 'woocommerce_order_item_meta_end', $item_id, $item, $order, false );
                        ?>
                    </td>
                    <td class="woocommerce-table__product-total product-total">
                        <?php echo $order->get_formatted_line_subtotal( $item ); ?>
                    </td>
                </tr>
                <?php }} ?>
            </tbody>
            <tfoot style="background: #f8f8f8;"> 
                <?php
                    foreach ( $order->get_order_item_totals() as $key => $total ) {
                        ?>
                        <tr>
                            <th scope="row"><?php echo $total['label']; ?></th>
                            <td><?php echo ( 'payment_method' === $key ) ? esc_html( $total['value'] ) : $total['value']; ?></td>
                        </tr>
                        <?php
                    }
                ?>
                <?php if ( $order->get_customer_note() ) : ?>
                    <tr>
                        <th><?php _e( 'Note:', 'woocommerce' ); ?></th>
                        <td><?php echo wptexturize( $order->get_customer_note() ); ?></td>
                    </tr>
                <?php endif; ?>
            </tfoot>
        </table>
        <?php 
            $show_shipping     = ! wc_ship_to_billing_address_only() && $order->needs_shipping_address(); 
            $billing_email     = $order->get_billing_email();
            $billing_email     = empty( $billing_email ) ? $customer_email : $billing_email;
        ?>
        <?php if ($custom_files != '') : ?>
        <h2><?php _e('Custom file', 'web-to-print-online-designer'); ?></h2>
        <table class="shop_table shop_table_responsive customer_details">
            <?php foreach ($custom_files as $key => $file) :
                $class = '';
                $status = '';
                if ($file->status == 0) {
                    $class = 'nbdq_bg_success';
                    $status = 'Accept';
                }
                if ($file->status == 2) {
                    $class = 'nbdq_bg_danger';
                    $status = 'Reject';
                }
                $url = $file->url;
                $filename = $file->filename;
            ?>
                <tr class="<?php echo $class; ?>">
                    <th scope="row"><a class="nbdq_admin_custom_file" href="<?php echo $url; ?>" download="<?php echo $filename; ?>"><?php echo $filename; ?></a></th>
                    <?php if ($file->status == 1) : ?>
                        <th scope="row"><input class="nbdq_accept" id="nbdq_accept_<?php echo $key ?> " type="button" value="Accept"></th>
                        <th scope="row"><input class="nbdq_reject" id="nbdq_reject_<?php echo $key ?>" type="button" value="Reject"></th>
                    <?php else : ?>
                        <th scope="row"></span></th>
                        <th scope="row"><span><?php echo $status; ?></span></th>
                    <?php endif; ?>
                </tr>
            <?php
            endforeach; ?>
        </table>
    <?php endif; ?>
    <?php if ($admin_message != '' || $customer_note != '') : ?>
        <h2><?php _e('Additional Information', 'web-to-print-online-designer'); ?></h2>
        <table class="shop_table shop_table_responsive customer_details">
            <?php if ('' != $customer_note) { ?>
                <tr>
                    <th scope="row"><?php _e('Customer\'s Notas:', 'web-to-print-online-designer'); ?></th>
                    <td data-title="<?php _e('Customer\'s Notas', 'web-to-print-online-designer'); ?>"><?php echo wptexturize($customer_note); ?></td>
                </tr>
            <?php } ?>
            <?php if ('' != $admin_message) { ?>
                <tr>
                    <th scope="row"><?php _e('Administrator\'s Message:', 'web-to-print-online-designer'); ?></th>
                    <td data-title="<?php _e('Administrator\'s Message', 'web-to-print-online-designer'); ?>"><?php echo wptexturize($admin_message); ?></td>
                </tr>
            <?php } ?>
        </table>
    <?php endif; ?>
    <div class="form-group">
        <?php $quote_id = $_GET['qoute_id']; ?>
        <input type="hidden" name="quote_id" id="quote_id" value="<?php echo $quote_id; ?>">
        <label for="message_custom_user">Message</label>
        <textarea name="message_custom_user" id="message_custom_user" cols="30" rows="5" class="form-control" placeholder="developing..."></textarea>
    </div>
    <input type="button" id="user_send_message" value="Send">
    <script type="text/javascript">
        jQuery("input[id^='nbdq_accept_']").on('click', function(e) {
            id = e.currentTarget.attributes.id.value.replace("nbdq_accept_", "");
            var formData = new FormData();
            formData.append('post_id', id);
            formData.append('quote_id', <?php echo $_GET['qoute_id']; ?>);
            formData.append('_ajax_nonce', "<?php echo wp_create_nonce('import_temp'); ?>");
            formData.append('action', 'nbdq_accept_file');
            jQuery.ajax({
                method: "POST",
                url: "<?php echo admin_url('admin-ajax.php') ?>",
                data: formData,
                processData: false,
                contentType: false,
                success: function(res) {
                    console.log(res);
                },
                error: function(t, c, e) {
                    console.log(t);
                }
            });
        });
        jQuery("input[id^='nbdq_reject_']").on('click', function(e) {
            id = e.currentTarget.attributes.id.value.replace("nbdq_reject_", "");
            var formData = new FormData();
            formData.append('post_id', id);
            formData.append('_ajax_nonce', "<?php echo wp_create_nonce('import_temp'); ?>");
            formData.append('action', 'nbdq_reject_file');
            formData.append('quote_id', <?php echo $_GET['qoute_id']; ?>);
            jQuery.ajax({
                method: "POST",
                url: "<?php echo admin_url('admin-ajax.php') ?>",
                data: formData,
                processData: false,
                contentType: false,
                success: function(res) {
                    console.log(res);
                },
                error: function(t, c, e) {
                    console.log(t);
                }
            });
        });
    </script>
    <?php
    return '';
}

add_filter('porto_form_quote', 'porto_popup_form_quote2', 10, 2);
function porto_popup_form_quote2()
{

?>
    <form action="" id="formQuote" method="post" enctype="multipart/form-data">
        <div class="form-group">
            <label for="description">Descripción general del producto a cotizar</label>
            <textarea class="form-control" name="description" id="description" cols="30" rows="5" placeholder="Escribe aquí las especificaciones generales de tu producto a cotizar."></textarea>
        </div>
        <div class="form-group">
            <input id="service" name="service" type="checkbox" value="1">
            <label for="service">Servicio de diseño</label>
        </div>
        <div class="form-group">
            <label for="medidas">Medidas</label>
            <input type="text" class="form-control" id="medidas" name="medidas" placeholder="Escribe aquí las especificaciones de medidas de tu diseño.">
        </div>
        <div class="form-group">
            <label for="color">Especificaciones de color</label>
            <input type="text" class="form-control" id="color" name="color" placeholder="CMYK, Pantone 151 C">
        </div>
        <div class="form-group">
            <label for="notes">Notas</label>
            <textarea class="form-control" name="notas" id="notes" cols="30" rows="5" placeholder="Escribe aquí cualquier indicación extra que necesitemos."></textarea>
        </div>
        <h3>Tiempo de espera</h3>
        <div class="form-check porto-urgente_estanda">
            <div class="form-check-inline">
                <input type="radio" name="urgente_estanda" value="1" id="estanda">
                <label class="form-check-label" for="estanda">Estándar</label>
            </div>
            <div class="form-check-inline">
                <input type="radio" name="urgente_estanda" value="2" id="urgente">
                <label class="form-check-label" for="urgente">Urgente</label>
                <br>
                <span>+Generará un cargo adicional del 5% sobre la orden</span>
            </div>

        </div>
        <h3>Carga tu archivo</h3>
        <div id="port_file_upload">

        </div>
        <div class="form-group">
            <input type="file" name="fileUpload[]" onchange="changeFileUpload()" id="uploadFile" style="display:none;" multiple>
            <label for="uploadFile">Cargar archivo
                <svg style="width: 23px;margin-left:10px;" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 490 490" style="enable-background:new 0 0 490 490;" xml:space="preserve">
                    <path d="M262.2,472.9V141.6l58.8,58.8c3.3,3.3,7.7,5,12.1,5c4.4,0,8.8-1.7,12.1-5c6.7-6.7,6.7-17.6,0-24.3L257.1,88
    c-6.4-6.4-17.8-6.4-24.3,0l-88.1,88.1c-6.7,6.7-6.7,17.6,0,24.3s17.6,6.7,24.3,0l58.8-58.8v331.2c0,9.5,7.7,17.2,17.1,17.2
    C254.6,490,262.2,482.4,262.2,472.9z" />
                    <path d="M28,17.1v99.7c0,9.5,7.7,17.2,17.1,17.2c9.5,0,17.2-7.7,17.2-17.2V34.3h365.5v82.6c0,9.5,7.7,17.2,17.1,17.2
    c9.4,0,17.1-7.7,17.1-17.2V17.1C462,7.6,454.3,0,444.9,0H45.2C35.7,0,28,7.6,28,17.1z" />
                </svg>
            </label>
        </div>
        <?php wp_nonce_field('#formQuote'); ?>
        <input type="submit" id="porto_submit_form_quote" name="porto_submit_form_quote" value="Cotizar Ahora">
    </form>

    <script type="text/javascript">
        jQuery(document).ready(function() {

            var start = 0;

            function changeFileUpload() {
                var file = document.getElementById('uploadFile').files[0];
                var filename = file.name;
                var name = filename.substring(filename.lastIndexOf('.') + 1);
                if (name == 'png' || name == 'svg' || name == '' || name == 'tiff' || name == 'pdf' || name == 'ai') {
                    var formData = new FormData();
                    formData.append('fileUpload', file);
                    formData.append('_ajax_nonce', "<?php echo wp_create_nonce('import_temp'); ?>");
                    formData.append('action', 'upload_file_for_porto');
                    var uploadhere = jQuery('#port_file_upload');
                    setTimeout(function() {
                        start++;
                        var _html = `
                    <div class="fileuploaded" id="fileuploaded_${start}">
                        <span class="filename">${file.name}</span>
                        <span id="portoDeleteFIle_${start}" class="deleteFile" title="Delete">+</span>
                    </div>`;
                        var arr = [];
                        arr.push(filename);
                        uploadhere.append(_html);
                        sessionStorage.setItem('fileuploaded_' + start, file.name);
                        sessionStorage.setItem('setFileUpload', JSON.stringify(arr));

                    }, 1000);

                    // setTimeout(function() {
                    jQuery("span[id^='portoDeleteFIle_']").click(function(e) {
                        id = e.currentTarget.attributes.id.value.replace("portoDeleteFIle_", "");
                        console.log(id);
                        setTimeout(function() {
                            jQuery("div[id^='fileuploaded_" + id + "']").remove();
                            sessionStorage.removeItem('fileuploaded_' + id);
                        }, 1000);
                    });
                    // }, 1000);

                    jQuery.ajax({
                        method: "POST",
                        data: formData,
                        url: "<?php echo admin_url('admin-ajax.php') ?>",
                        contentType: false,
                        processData: false,
                        success: function(data) {
                            var data = JSON.parse(data);
                            if (data) {
                                alert(data);
                                return;
                            } else {
                                console.log(data);
                            }
                        }
                    });
                } else {
                    alert('ngu');
                }

            };
            window.onload = function() {
                console.log(start);
                var getSS = sessionStorage.getItem('setFileUpload');
                if (getSS) {
                    sessionStorage.removeItem('setFileUpload');
                    sessionStorage.removeItem('fileuploaded_');
                }
            }
        });
    </script>

<?php

}

add_action('wp_ajax_ajax_get_form_quote', 'ajax_get_form_quote');
add_action('wp_ajax_user_send_message', 'user_send_message');
add_filter('nbd_add_raq_infor', 'nbd_add_raq_hook', 10, 2);
add_filter('raq_request_hook', 'nbd_add_request', 10, 2);
function nbd_add_raq_hook($attr, $raq)
{
    $attr['_raq_customer_message']  = $raq['user_message'];
    $attr['_raq_customer_email']    = $raq['user_email'];
    $attr['_raq_customer_name']     = $raq['user_name'];
    $attr['_raq_file_up_load']      = $raq['_raq_file_up_load'];
    $attr['_raq_description']       = $raq['_raq_description'];
    $attr['_raq_time_line']         = $raq['_raq_time_line'];
    $attr['_raq_service']           = $raq['_raq_service'];
    $attr['_raq_notes']             = $raq['_raq_notes'];
    $attr['_raq_color']             = $raq['_raq_color'];
    $attr['_raq_size']              = $raq['_raq_size'];
    return $attr;
}

function nbd_add_request($order)
{
}

add_filter('admin_raq', 'edit_admin_raq', 10, 1);
function edit_admin_raq()
{
    $post = isset($_REQUEST['post']) ? $_REQUEST['post'] : (isset($_REQUEST['post_ID']) ? $_REQUEST['post_ID'] : 0);
    $order = wc_get_order($post);

    $customer_email     = $order->get_meta('_raq_customer_email');
    $customer_name      = $order->get_meta('_raq_customer_name');
    $admin_message      = $order->get_meta('_raq_admin_message');
    $file_up_load       = $order->get_meta('_raq_file_up_load');
    $description        = $order->get_meta('_raq_description');
    $time_line          = $order->get_meta('_raq_time_line');
    $expired            = $order->get_meta('_raq_expired');
    $service            = $order->get_meta('_raq_service');
    $notes              = $order->get_meta('_raq_notes');
    $color              = $order->get_meta('_raq_color');
    $size               = $order->get_meta('_raq_size');
    $raq_pay            = $order->get_meta('_raq_pay');

?>
    <style>
        div.nbd-metabox-value>p {
            margin: 0px;
        }

        div.loading_file {
            width: 100%;
            min-height: 100vh;
            position: fixed;
            background: #d1d1d1;
            z-index: 10000;
            top: 0;
            opacity: 0.45;
            left: 0;
            visibility: hidden;
            border: 16px solid #f3f3f3;
        }

        div.loading_file::after {
            position: absolute;
            content: "";
            top: 50%;
            left: 50%;
            background: #000;
            border-radius: 50%;
            border-top: 16px solid #3498db;
            width: 120px;
            height: 120px;
            -webkit-animation: spin 1s linear infinite;
            /* Safari */
            animation: spin 1s linear infinite;
        }

        /* Safari */
        @-webkit-keyframes spin {
            0% {
                -webkit-transform: rotate(0deg);
            }

            100% {
                -webkit-transform: rotate(360deg);
            }
        }

        @keyframes spin {
            0% {
                transform: rotate(0deg);
            }

            100% {
                transform: rotate(360deg);
            }
        }
    </style>
    <input type="hidden" id="nbdq_action" name="nbdq[action]" value="" />
    <div class="nbd-metabox clearfix">
        <label for="nbdq_customer_name" class="nbd-metabox-label"><?php _e('Customer\'s name', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <input type="text" class="short" id="nbdq_customer_name" name="nbdq[_raq_customer_name]" value="<?php echo $customer_name; ?>" />
        </div>
    </div>
    <div class="nbd-metabox clearfix">
        <label for="nbdq_customer_email" class="nbd-metabox-label"><?php _e('Customer\'s email', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <input type="text" class="short" id="nbdq_customer_email" name="nbdq[_raq_customer_email]" value="<?php echo $customer_email; ?>" />
        </div>
    </div>
    <div class="nbd-metabox clearfix">
        <label for="nbdq_customer_message" class="nbd-metabox-label"><?php _e('Description', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <textarea cols="50" rows="5" type="text" id="nbdq_customer_message" name="nbdq[_raq_customer_message]"><?php echo $description ?></textarea>
        </div>
    </div>
    <div class="nbd-metabox clearfix">
        <label for="nbdq_customer_message" class="nbd-metabox-label"><?php _e('Notas', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <textarea cols="50" rows="5" type="text" id="nbdq_customer_message" name="nbdq[_raq_customer_message]"><?php echo $notes ?></textarea>
        </div>
    </div>
    <div class="nbd-metabox clearfix">
        <label for="nbdq_admin_message" class="nbd-metabox-label"><?php _e('Admin\'s message', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <textarea cols="50" rows="5" type="text" id="nbdq_admin_message" name="nbdq[_raq_admin_message]"><?php echo $admin_message; ?></textarea>
        </div>
    </div>
    <div class="nbd-metabox clearfix">
        <label for="nbdq_expired" class="nbd-metabox-label"><?php _e('Expire date (optional)', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <input type="text" class=" nbd-date-picker" id="nbdq_expired" name="nbdq[_raq_expired]" value="<?php echo $expired; ?>" />
        </div>
    </div>
    <div class="nbd-metabox clearfix">
        <label for="nbdq_raq_pay" class="nbd-metabox-label"><?php _e('Pay for Quote', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <input type="hidden" class="short" name="nbdq[_raq_pay]" value="0" />
            <input type="checkbox" class="short" id="nbdq_raq_pay" name="nbdq[_raq_pay]" value="1" <?php checked($raq_pay, 1); ?> />
            <span><?php _e('Send the customer to <b>"Pay for Quote"</b>', 'web-to-print-online-designer'); ?></span>
        </div>
    </div>
    <div class="loading_file"></div>
    <div class="nbd-metabox clearfix">
        <label for="nbdq_raq_pay" class="nbd-metabox-label"><?php _e('Custom file', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <input type="file" class="short" id="nbdq_raq_custom_file" name="nbdq_raq_custom_file[]" multiple />
        </div>
    </div>
    <div class="nbd-metabox clearfix">
        <input type="button" class="button button-secondary" id="nbdq_send_quote" value="<?php _e('Send Quote', 'web-to-print-online-designer'); ?>" />
    </div>
    <hr />
    <div class="nbd-metabox clearfix">
        <label class="nbd-metabox-label"><?php _e('Medidas', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <p><?php echo $size; ?></p>
            <div class="clear"></div>
        </div>
    </div>
    <div class="nbd-metabox clearfix">
        <label class="nbd-metabox-label"><?php _e('Servicio de diseño', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <p><?php echo $service; ?></p>
            <div class="clear"></div>
        </div>
    </div>
    <div class="nbd-metabox clearfix">
        <label class="nbd-metabox-label"><?php _e('Tiempo de espera', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <p><?php echo $time_line; ?></p>
            <div class="clear"></div>
        </div>
    </div>
    <div class="nbd-metabox clearfix">
        <label class="nbd-metabox-label"><?php _e('Color', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <p><?php echo $color; ?></p>
            <div class="clear"></div>
        </div>
    </div>
    <div class="nbd-metabox clearfix">
        <label class="nbd-metabox-label"><?php _e('File', 'web-to-print-online-designer'); ?></label>
        <div class="nbd-metabox-value">
            <?php
            if ($file_up_load) {
                foreach ($file_up_load as $key => $file) {
                    $filename = basename($file['date_path']);
                    $url = NBDESIGNER_TEMP_URL . $file['date_path'];
            ?>
                    <p><a href="<?php echo $url ?>" download="<?php echo $filename; ?>">file name</a></p>
                    <div class="clear"></div>
            <?php
                }
            }
            ?>
        </div>
    </div>
    <script type="text/javascript">
        jQuery('#nbdq_raq_custom_file').on('change', function(e) {
            jQuery('.loading_file').css('visibility', 'visible');
            var file = document.getElementById('nbdq_raq_custom_file').files;
            var filelength = file.length;
            for (i = 0; i < filelength; i++) {
                var formData = new FormData();
                formData.append('nbdq_raq_custom_file', file[i]);
                formData.append('post_id', <?php echo $_GET['post']; ?>);
                formData.append('_ajax_nonce', "<?php echo wp_create_nonce('import_temp'); ?>");
                formData.append('action', 'quote_add_form_file');
                jQuery.ajax({
                    method: "POST",
                    processData: false,
                    contentType: false,
                    url: "<?php echo admin_url('admin-ajax.php') ?>",
                    data: formData,
                    success: function(res) {
                        jQuery('.loading_file').css('visibility', 'hidden');
                        console.log(res);
                    },
                    error: function(e, t, c) {
                        console.log(e);
                    }
                });
            }
        });
    </script>
<?php
}

add_action('wp_ajax_quote_add_form_file', 'quote_add_form_file');
function quote_add_form_file()
{
    if (isset($_REQUEST)) {
        $id_post        = $_POST['post_id'];
        $order          =  wc_get_order($id_post);
        $posts          = array();
        $post           = $order->get_meta('_raq_admin_custom_file') ? $order->get_meta('_raq_admin_custom_file') : '';
        if ($post != '') {
            $post = json_decode($post);
            foreach ($post as $key => $value) {
                array_push($posts, $value);
            }
        }
        $file           = $_FILES['nbdq_raq_custom_file'];
        $filename       = $file['name'];
        $tmp_name       = $file['tmp_name'];
        $ext            = explode('.', $filename);
        $file_exten     = $ext[count($ext) - 1];
        $new_name       = strtotime("now") . substr(md5(rand(1111, 9999)), 0, 8) . '.' . $file_exten;
        $design_path =  Nbdesigner_IO::create_file_path(NBDESIGNER_TEMP_DIR, $new_name);
        $image_url = Nbdesigner_IO::create_file_path(NBDESIGNER_TEMP_URL, $new_name);
        move_uploaded_file($tmp_name, $design_path['full_path']);
        $fileArr = array();
        $fileArr['filename'] = $filename;
        $fileArr['url'] = $image_url['full_path'];
        $fileArr['status'] = 1;
        if (count($fileArr) > 0) {
            array_push($posts, $fileArr);
        }

        $order->update_meta_data('_raq_admin_custom_file', json_encode($posts));
        $order->save();
        wp_die();
    }
}


add_filter('message_custom_quote', 'change_message_custom_quote', 10, 1);
function change_message_custom_quote()
{
    global $wp;
    $order_id           = $wp->query_vars['view-quote'];
    $order              = wc_get_order($order_id);
    $customer_note      = $order->get_meta('_raq_notes');
    $admin_message      = $order->get_meta('_raq_admin_message');
    $admin_custom_file  = $order->get_meta('_raq_admin_custom_file');
    $custom_files = json_decode($admin_custom_file);
?>
    <style>
        label[for="message_custom_user"] {
            display: flex;
            justify-content: space-between;
        }

        span.error_message {
            font-size: 14px;
            font-weight: lighter;
            color: #cd0000;
            /* display: flex; */
            position: relative;
            width: 400px;
            display: flex;
            justify-content: end;
        }

        input.nbdq_reject {
            background: #d43f5f;
            border: none;
            padding: 5px 10px 5px 10px;
            color: #fff;
        }

        input.nbdq_accept {
            background: #3fa1d4;
            color: #fff;
            border: none;
            float: right;
            padding: 5px;
        }

        tr.nbdq_bg_danger {
            background-color: #ffd5d5;
        }

        tr.nbdq_bg_success {
            background-color: #d5ffe5;
        }

        a.nbdq_admin_custom_file {
            font-weight: 500;
        }
    </style>
    <?php if ($custom_files != '') : ?>
        <h2><?php _e('Custom file', 'web-to-print-online-designer'); ?></h2>
        <table class="shop_table shop_table_responsive customer_details">
            <?php foreach ($custom_files as $key => $file) :
                $class = '';
                $status = '';
                if ($file->status == 0) {
                    $class = 'nbdq_bg_success';
                    $status = 'Accept';
                }
                if ($file->status == 2) {
                    $class = 'nbdq_bg_danger';
                    $status = 'Reject';
                }
                $url = $file->url;
                $filename = $file->filename;
            ?>
                <tr class="<?php echo $class; ?>">
                    <th scope="row"><img src="<?php echo $url; ?>" width="30" alt=""></th>
                    <th scope="row"><a class="nbdq_admin_custom_file" href="<?php echo $url; ?>" download="<?php echo $filename; ?>"><?php echo $filename; ?></a></th>
                    <?php if ($file->status == 1) : ?>
                        <th scope="row"><input class="nbdq_accept" id="nbdq_accept_<?php echo $key ?> " type="button" value="Accept"></th>
                        <th scope="row"><input class="nbdq_reject" id="nbdq_reject_<?php echo $key ?>" type="button" value="Reject"></th>
                    <?php else : ?>
                        <th scope="row"></span></th>
                        <th scope="row"><span><?php echo $status; ?></span></th>
                    <?php endif; ?>
                </tr>
            <?php
            endforeach; ?>
        </table>
    <?php endif; ?>
    <?php if ($admin_message != '' || $customer_note != '') : ?>
        <h2><?php _e('Additional Information', 'web-to-print-online-designer'); ?></h2>
        <table class="shop_table shop_table_responsive customer_details">
            <?php if ('' != $customer_note) { ?>
                <tr>
                    <th scope="row"><?php _e('Customer\'s Notas:', 'web-to-print-online-designer'); ?></th>
                    <td data-title="<?php _e('Customer\'s Notas', 'web-to-print-online-designer'); ?>"><?php echo wptexturize($customer_note); ?></td>
                </tr>
            <?php } ?>
            <?php if ('' != $admin_message) { ?>
                <tr>
                    <th scope="row"><?php _e('Administrator\'s Message:', 'web-to-print-online-designer'); ?></th>
                    <td data-title="<?php _e('Administrator\'s Message', 'web-to-print-online-designer'); ?>"><?php echo wptexturize($admin_message); ?></td>
                </tr>
            <?php } ?>
        </table>
    <?php endif; ?>
    <div class="form-group">
        <?php $quote_id = $_GET['qoute_id']; ?>
        <input type="hidden" name="quote_id" id="quote_id" value="<?php echo $quote_id; ?>">
        <label for="message_custom_user">Message</label>
        <textarea name="message_custom_user" id="message_custom_user" cols="30" rows="5" class="form-control" placeholder="developing..."></textarea>
    </div>
    <input type="button" id="user_send_message" value="Send">
    <script type="text/javascript">
        jQuery("input[id^='nbdq_accept_']").on('click', function(e) {
            id = e.currentTarget.attributes.id.value.replace("nbdq_accept_", "");
            var formData = new FormData();
            formData.append('post_id', id);
            formData.append('quote_id', <?php echo $_GET['qoute_id']; ?>);
            formData.append('_ajax_nonce', "<?php echo wp_create_nonce('import_temp'); ?>");
            formData.append('action', 'nbdq_accept_file');
            jQuery.ajax({
                method: "POST",
                url: "<?php echo admin_url('admin-ajax.php') ?>",
                data: formData,
                processData: false,
                contentType: false,
                success: function(res) {
                    console.log(res);
                },
                error: function(t, c, e) {
                    console.log(t);
                }
            });
        });
        jQuery("input[id^='nbdq_reject_']").on('click', function(e) {
            id = e.currentTarget.attributes.id.value.replace("nbdq_reject_", "");
            var formData = new FormData();
            formData.append('post_id', id);
            formData.append('_ajax_nonce', "<?php echo wp_create_nonce('import_temp'); ?>");
            formData.append('action', 'nbdq_reject_file');
            formData.append('quote_id', <?php echo $_GET['qoute_id']; ?>);
            jQuery.ajax({
                method: "POST",
                url: "<?php echo admin_url('admin-ajax.php') ?>",
                data: formData,
                processData: false,
                contentType: false,
                success: function(res) {
                    console.log(res);
                },
                error: function(t, c, e) {
                    console.log(t);
                }
            });
        });
    </script>
<?php
}

add_action('wp_ajax_nbdq_accept_file', 'nbdq_accept_file');
add_action('wp_ajax_nbdq_reject_file', 'nbdq_reject_file');

function nbdq_reject_file()
{
    if (isset($_REQUEST)) {
        $post_id = $_POST['post_id'];
        $index = (int)$post_id;
        $quote_id = $_POST['quote_id'];
        $order = wc_get_order($quote_id);
        $files = json_decode($order->get_meta('_raq_admin_custom_file'));
        foreach ($files as $key => $value) {
            $files[$index]->status = 2;
        }
        $order->update_meta_data('_raq_admin_custom_file', json_encode($files));
        $order->save();
        print_r(json_encode($files));
        wp_die();
    }
}

function nbdq_accept_file()
{
    if (isset($_REQUEST)) {
        $post_id = $_POST['post_id'];
        $index = (int)$post_id;
        $quote_id = $_POST['quote_id'];
        $order = wc_get_order($quote_id);
        $files = json_decode($order->get_meta('_raq_admin_custom_file'));
        foreach ($files as $key => $value) {
            $files[$index]->status = 0;
        }
        $order->update_meta_data('_raq_admin_custom_file', json_encode($files));
        $order->save();
        print_r($files);
        wp_die();
    }
}

function ajax_get_form_quote()
{
    if (isset($_REQUEST)) {
        global $woocommerce, $current_user;
        $posted = $_POST;
        $filename = $_FILES['fileUpload']['name'];
        $upload_dir = wp_upload_dir();
        $basedir    = $upload_dir['basedir'];
        $baseurl    = $upload_dir['baseurl'];
        nbd_define('NBDESIGNER_DATA_DIR', $basedir . '/nbdesigner');
        nbd_define('NBDESIGNER_DATA_URL', $baseurl . '/nbdesigner');
        nbd_define('NBDESIGNER_TEMP_DIR', NBDESIGNER_DATA_DIR . '/temp');
        nbd_define('NBDESIGNER_TEMP_URL', NBDESIGNER_DATA_URL . '/temp');
        $dm_domain      = $_SERVER['HTTP_HOST'];
        $baseurl_arr    = explode('wp-content', $baseurl);
        if (isset($baseurl_arr[1])) {
            $protocol   = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off') ? 'https://' : 'http://';
            $baseurl    = $protocol . $dm_domain . '/wp-content' . $baseurl_arr[1];
        }
        $posted['file_up_load'] = array();
        foreach ($filename as $key => $name) {
            $file           = $_FILES['fileUpload'];
            $tmp_name       = $file['tmp_name'][$key];
            $ext            = explode('.', $filename[$key]);
            $file_exten     = $ext[count($ext) - 1];
            $new_name       = strtotime("now") . substr(md5(rand(1111, 9999)), 0, 8) . '.' . $file_exten;
            $design_path =  Nbdesigner_IO::create_file_path(NBDESIGNER_TEMP_DIR, $new_name);
            $image_url = Nbdesigner_IO::create_file_path(NBDESIGNER_TEMP_URL, $new_name);
            move_uploaded_file($tmp_name, $design_path['full_path']);
            $posted['file_up_load'][$key] = $design_path;
        }
        $posted['service'] = $posted['service'] ? $posted['service'] : 0;
        $current_user = wp_get_current_user();
        $email = $current_user->user_email;
        $posted['customer_email'] = $email;
        if (is_user_logged_in()) {
            $posted['customer_name'] = $current_user->user_login;
        }
        $raq = array();
        $raq['customer_id']             = get_current_user_id();
        $raq['user_message']            = $posted['customer_message'];
        $raq['_raq_time_line']          = $posted['urgente_estanda'];
        $raq['user_email']              = $posted['customer_email'];
        $raq['user_name']               = $posted['customer_name'];
        $raq['_raq_file_up_load']       = $posted['file_up_load'];
        $raq['_raq_description']        = $posted['description'];
        $raq['_raq_size']               = $posted['medidas'];
        $raq['_raq_service']            = $posted['service'];
        $raq['_raq_color']              = $posted['color'];
        $raq['_raq_notes']              = $posted['notas'];
        $nbd_quote = new NBD_Request_Quote();
        $nbd_quote->create_raq_order($raq, $posted);
        echo json_encode($posted);
        wp_die();
    }
}

function user_send_message()
{
    if (isset($_REQUEST)) {
        global $wp;
        $file = $_POST;
        $quote_id = $file['quote_id'];
        $order = wc_get_order($quote_id);
        update_post_meta($quote_id, '_raq_notes', $file['_mess']);
        echo json_encode($file['_mess']);
        wp_die();
    }
}

function user_autologout()
{
    if (is_user_logged_in()) {
        $current_user = wp_get_current_user();
        $user_id = $current_user->ID;
        $approved_status = get_user_meta($user_id, 'wp-approve-user', true);
        if ($approved_status == 1) {
            return $redirect_url;
        } else {
            wp_logout();
            return get_permalink(woocommerce_get_page_id('myaccount')) . "";
        }
    }
}
add_action('woocommerce_registration_redirect', 'user_autologout', 2);
function registration_message()
{
    $not_approved_message = '';
    if (isset($_REQUEST['approved'])) {
        $approved = $_REQUEST['approved'];
        if ($approved == 'false')  echo 'vlxx';
        else echo $not_approved_message;
    } else echo $not_approved_message;
}
add_action('woocommerce_before_customer_login_form', 'registration_message', 2);

add_action('wp_ajax_upload_file_for_porto', 'upload_file_for_porto');

function upload_file_for_porto()
{
    $res = [];
    $fileupload = $_FILES['fileUpload'];
    $name = $_FILES['fileUpload']['name'];
    $target_dir = $_FILES["fileUpload"]["tmp_name"];
    $ext =  explode('.', $name);
    $file_exten = $ext[count($ext) - 1];
    $new_name           = strtotime("now") . substr(md5(rand(1111, 9999)), 0, 8) . '.' . $file_exten;
    $path = Nbdesigner_IO::create_file_path(NBDESIGNER_TEMP_DIR, $name);
    foreach ($name as $key => $value) {
        move_uploaded_file($target_dir[$key], $path['full_path']);
        $res['file_upload'][$key] = $value;
    }
    if ($file_exten != 'ai' && $file_exten != 'png' && $file_exten != 'tiff' && $file_exten != 'svg' && $file_exten != 'eps' && $file_exten != 'pdf') {

        $res['mes'] = esc_html__('error convert!!');
        $res['flag'] = 0;
        echo json_encode($res);
        wp_die();
    }

    if (file_exists(NBDESIGNER_TEMP_DIR . $name) == true) {
        $res['src'] = NBDESIGNER_TEMP_URL . $name;
    } else {
        $res['mes'] = esc_html__('error convert!!');
        $res['flag'] = 2;
    }
    if (file_exists(NBDESIGNER_TEMP_DIR . $name) == true) {
        $res['src'] = NBDESIGNER_TEMP_URL . $name;
        $res['flag'] = 2;
    }
    echo json_encode($fileupload);
    wp_die();
}
