jQuery(document).ready(function($) {
    $('#porto_submit_form_quote').on('click', function(e) {
        e.preventDefault();
        var ajax_nonce = $('#_wpnonce').val();
        var ajax_url = '';
        if (window.nbdq_form_obj) {
            ajax_url = window.nbdq_form_obj.ajaxurl;
        } else {
            ajax_url = window.nbds_frontend.url;

        }
        var formData = new FormData($('#formQuote')[0]);
        formData.append('action', 'ajax_get_form_quote');
        formData.append('_ajax_nonce', ajax_nonce);
        $.ajax({
            url: ajax_url,
            method: "POST",
            processData: false,
            contentType: false,
            data: formData,
            success: function(res) {
                var data = JSON.parse(res);
                alert('sucessful');
                console.log(data);
                // window.location.reload();
            },
            error: function(t, e, c) {
                console.log(t);
            }
        });
    });
    $('#user_send_message').on('click', function(e) {
        var mess = $('#message_custom_user').val();
        var quote_id = $('#quote_id').val();
        ajax_url = window.nbds_frontend.url;
        var err = `
            <span class="error_message">Please enter in4</span>
        `;
        $('.error_message').remove();
        if (mess == "") {
            $('label[for="message_custom_user"]').append(err);
        } else {
            $.ajax({
                method: "POST",
                url: ajax_url,
                data: {
                    action: "user_send_message",
                    _mess: mess,
                    quote_id: quote_id
                },
                success: function(res) {
                    $('.error_message').remove();
                    var data = JSON.parse(res);
                    $('td[data-title="Customer\'s Notas"]').text(data);
                    console.log(data);
                },
                error: function(t, e, c) {
                    console.log(e);
                }
            });
        }
    });
    console.log('oke');
    $('.nbdq-add-a-quote-button').on('click', function(e) {
        console.log('object');
        e.preventDefault();
        if ($(this).hasClass('nbdesigner_disable') || $(this).hasClass('nbo-disabled')) {
            alert(nbds_frontend.check_invalid_fields);
            return;
        } else {
            $('#nbdq-form-popup').nbqShowPopup();
        }
    });
    var nbdq_form_init = function() {
        var select = $('.nbd-multiselect, .nbdq-popup select'),
            datepicker = $('.nbd-datepicker'),
            timepicker = $('.nbd-timepicker'),
            nbdq_form = $('form[name="nbdq-form"]'),
            submit_button = $('.raq-send-request'),
            error = '<span class="nbdq_error"></span>',
            is_email = function(val) {
                var re = /^([\w-]+(?:\.[\w-]+)*)@((?:[\w-]+\.)*\w[\w-]{0,66})\.([a-z]{2,6}(?:\.[a-z]{2})?)$/i;
                return re.test(val);
            },
            show_error = function(elem, msg) {
                if (!elem.next('.nbdq_error').length) {
                    elem.after(error);
                }
                elem.next('.nbdq_error').html(msg);
            },
            validate_field = function() {
                var t = $(this),
                    parent = t.closest('p.form-row'),
                    value = t.val();
                if (!value && parent.hasClass('validate-required')) {
                    show_error(t, nbdq_form_obj.err_msg);
                } else if (value && parent.hasClass('validate-email') && !is_email(value)) {
                    show_error(t, nbdq_form_obj.err_msg_mail);
                } else {
                    t.next('.nbdq_error').remove();
                }
                validate_form();
            },
            validate_form = function() {
                var check = true;
                $.each(nbdq_form.find('select, input:checkbox, .input-text'), function() {
                    var t = $(this);
                    var parent = t.closest('p.form-row'),
                        value = t.val();
                    if (!((t.attr('id') == 'account_password' || t.attr('id') == 'account_username') && $('#createaccount').length > 0 && !$('#createaccount').is(':checked'))) {
                        if (!value && parent.hasClass('validate-required')) {
                            check = false;
                        } else if (value && parent.hasClass('validate-email') && !is_email(value)) {
                            check = false;
                        }
                    }
                });
                if (check) {
                    $('.raq-send-request').removeClass('nbdq-disabled');
                } else {
                    $('.raq-send-request').addClass('nbdq-disabled');
                }
            },
            scroll_to_notices = function() {
                //            var scrollElement = $('.woocommerce-error, .woocommerce-message'),
                //                scrollElementWrap = nbdq_form_obj.show_popup == '1' ? nbdq_form : $('html, body');
                $('html, body').animate({
                    scrollTop: (jQuery('#nbdq-form-popup .main-popup').position().top - 100)
                }, 1000);
            },
            submit_form = function(e) {
                e.preventDefault();
                var formData = new FormData(),
                    cartForm = jQuery('form.cart, form.variations_form'),
                    cartFormData = cartForm.serializeArray(),
                    requestFormData = nbdq_form.serializeArray();
                $.each(cartFormData, function(i, val) {
                    if (val.name) {
                        var new_name = val.name == 'add-to-cart' ? 'nbd-add-to-cart' : val.name;
                        formData.append(new_name, val.value);
                    }
                });
                if (typeof cartFormData['nbd-add-to-cart'] == 'undefined' && typeof cartFormData['add-to-cart'] == 'undefined') {
                    if (cartForm.find('[name="add-to-cart"]').length) {
                        formData.append('nbd-add-to-cart', cartForm.find('[name="add-to-cart"]').val());
                    } else {
                        formData.append('nbd-add-to-cart', jQuery('#nbdq-quote-btn').attr('data-id'));
                    }
                }
                /*NBDesigner Advanced*/
                if (typeof adc_check_app_modern != "undefined") {
                    if (typeof cartFormData['nbd-add-to-cart'] == 'undefined' && typeof cartFormData['add-to-cart'] != 'undefined') {
                        if (cartForm.find('[name="add-to-cart"]').length) {
                            formData.append('nbd-add-to-cart', cartForm.find('[name="add-to-cart"]').val());
                        } else {
                            formData.append('nbd-add-to-cart', jQuery('#nbdq-quote-btn').attr('data-id'));
                        }
                    }
                }
                $.each(cartForm.find("input[type='file']"), function(i, tag) {
                    $.each($(tag)[0].files, function(i, file) {
                        formData.append(tag.name, file);
                    });
                });
                $.each(requestFormData, function(i, val) {
                    if (val.name) {
                        formData.append(val.name, val.value);
                    }
                });
                $.ajax({
                    url: nbdq_form_obj.ajaxurl + '?action=nbdq_submit_raq_form',
                    type: 'POST',
                    dataType: 'json',
                    data: formData,
                    contentType: false,
                    processData: false,
                    beforeSend: function() {
                        nbdq_form.addClass('processing').block({
                            message: null,
                            overlayCSS: {
                                background: '#fff',
                                opacity: 0.6
                            }
                        });
                    },
                    complete: function() {
                        submit_button.prop('disabled', false).next().remove();
                    },
                    success: function(response) {
                        nbdq_form.unblock();
                        if ('success' === response.result) {
                            $('.nbdq-popup').find('.close-popup').trigger('click');
                            if (response.redirect) {
                                //window.location.href = response.redirect;
                                $('#nbdq-alert-detail-link').show().attr('href', response.redirect);
                            } else {
                                $('#nbdq-alert-detail-link').hide();
                            }
                            $('#nbdq-alert-popup').showAlert();
                        }
                        if ('failure' === response.result) {
                            $('.woocommerce-error, .woocommerce-message').remove();
                            if (response.messages) {
                                nbdq_form.prepend('<div class="woocommerce-error woocommerce-message">' + response.messages + '</div>');
                            }
                            nbdq_form.find('.input-text, select, input:checkbox').trigger('validate').blur();
                            scroll_to_notices();
                            if (typeof grecaptcha != "undefined") {
                                grecaptcha.reset(rqa_captcha);
                            }
                        }
                        console.log(response);
                    }
                });
                return false;
            },
            toggle_create_account = function() {
                $('div.create-account').hide();
                if ($(this).is(':checked')) {
                    $('#account_password').val('').change();
                    $('div.create-account').slideDown();
                }
            };
        if (select && typeof $.fn.select2 != 'undefined') {
            $.each(select, function() {
                var s = $(this),
                    sid = s.attr('id');
                if ($('#s2id_' + sid).length) {
                    return;
                }
                s.select2({
                    placeholder: s.data('placeholder'),
                    dropdownCssClass: 'nbdq-select2'
                });
            });
        }
        if (typeof $.fn.datepicker != 'undefined' && datepicker) {
            $.each(datepicker, function() {
                var self = $(this);
                $(this).datepicker({
                    dateFormat: $(this).data('format') || "dd-mm-yy",
                    beforeShow: function() {
                        setTimeout(function() {
                            var dptop = self.parent('.form-row').position().top + $('#nbdq-form-popup .main-popup').position().top;
                            $('#ui-datepicker-div').wrap('<div class="nbdq_datepicker"></div>').css({
                                'z-index': 99999999999999,
                                'top': dptop
                            });
                            $('#ui-datepicker-div').show();
                        }, 0);
                    },
                    onClose: function() {
                        $('#ui-datepicker-div').hide();
                        $('#ui-datepicker-div').unwrap();
                    }
                });
            });
        }
        if (typeof $.fn.timepicki != 'undefined' && timepicker) {
            $.each(timepicker, function() {
                $(this).timepicki({
                    reset: true,
                    disable_keyboard_mobile: true,
                    show_meridian: nbdq_form_obj.time_format,
                    max_hour_value: nbdq_form_obj.time_format ? '12' : '23',
                    min_hour_value: nbdq_form_obj.time_format ? '1' : '0',
                    overflow_minutes: true,
                    increase_direction: 'up'
                });
            });
            $(document).on('click', '.reset_time', function(ev) {
                ev.preventDefault();
            });
        }
        nbdq_form.on('blur', '.input-text', validate_field);
        nbdq_form.on('change', 'select, input:checkbox', validate_field);
        nbdq_form.on('submit', function(e) {
            if (window.preventSubmitFormCart && !nbd_stored_design) {
                e.preventDefault();
                nbdq_form.addClass('processing').block({
                    message: null,
                    overlayCSS: {
                        background: '#fff',
                        opacity: 0.6
                    }
                });
                var scope = angular.element(document.getElementById("designer-controller")).scope();
                scope.saveData('quote');
                return false;
            }
            submit_form(e);
        });
        $(document).find('input#createaccount').on('change', toggle_create_account).change();
        validate_form();
    };
    nbdq_form_init(false);
    if (jQuery('form.cart input[name="variation_id"]').length > 0) {
        if (jQuery('form.cart input[name="variation_id"]').val() > 0) {
            jQuery('#nbdq-quote-btn').removeClass('nbdesigner_disable');
        } else {
            jQuery('#nbdq-quote-btn').addClass('nbdesigner_disable');
        }
        jQuery('form.cart input[name="variation_id"]').on('change', function() {
            if (jQuery('form.cart input[name="variation_id"]').val() > 0) {
                jQuery('#nbdq-quote-btn').removeClass('nbdesigner_disable');
            } else {
                jQuery('#nbdq-quote-btn').addClass('nbdesigner_disable');
            }
        });
    }
    jQuery(document).on('nbd_design_stored', function(e, data) {
        nbd_stored_design = true;
        if (data._type == 'quote') {
            $('form[name="nbdq-form"]').submit();
        }
    });
});
jQuery(document).on('nbo_valid_form', function() {
    jQuery('#nbdq-quote-btn').removeClass('nbo-disabled');
});
jQuery(document).on('nbo_invalid_form', function() {
    jQuery('#nbdq-quote-btn').addClass('nbo-disabled');
});
