<?php

/**
 * Schema object for: PurchaseOrderModRq
 * 
 * @author "Keith Palmer Jr." <Keith@ConsoliByte.com>
 * @license LICENSE.txt
 * 
 * @package QuickBooks
 * @subpackage QBXML
 */

/**
 * 
 */
require_once 'QuickBooks.php';

/**
 * 
 */
require_once 'QuickBooks/QBXML/Schema/Object.php';

/**
 * 
 */
class QuickBooks_QBXML_Schema_Object_PurchaseOrderModRq extends QuickBooks_QBXML_Schema_Object
{
	protected function &_qbxmlWrapper()
	{
		static $wrapper = 'PurchaseOrderMod';
		
		return $wrapper;
	}
	
	protected function &_dataTypePaths()
	{
		static $paths = array (
  'TxnID' => 'IDTYPE',
  'EditSequence' => 'STRTYPE',
  'VendorRef ListID' => 'IDTYPE',
  'VendorRef FullName' => 'STRTYPE',
  'ClassRef ListID' => 'IDTYPE',
  'ClassRef FullName' => 'STRTYPE',
  'ShipToEntityRef ListID' => 'IDTYPE',
  'ShipToEntityRef FullName' => 'STRTYPE',
  'TemplateRef ListID' => 'IDTYPE',
  'TemplateRef FullName' => 'STRTYPE',
  'TxnDate' => 'DATETYPE',
  'RefNumber' => 'STRTYPE',
  'VendorAddress Addr1' => 'STRTYPE',
  'VendorAddress Addr2' => 'STRTYPE',
  'VendorAddress Addr3' => 'STRTYPE',
  'VendorAddress Addr4' => 'STRTYPE',
  'VendorAddress Addr5' => 'STRTYPE',
  'VendorAddress City' => 'STRTYPE',
  'VendorAddress State' => 'STRTYPE',
  'VendorAddress PostalCode' => 'STRTYPE',
  'VendorAddress Country' => 'STRTYPE',
  'VendorAddress Note' => 'STRTYPE',
  'ShipAddress Addr1' => 'STRTYPE',
  'ShipAddress Addr2' => 'STRTYPE',
  'ShipAddress Addr3' => 'STRTYPE',
  'ShipAddress Addr4' => 'STRTYPE',
  'ShipAddress Addr5' => 'STRTYPE',
  'ShipAddress City' => 'STRTYPE',
  'ShipAddress State' => 'STRTYPE',
  'ShipAddress PostalCode' => 'STRTYPE',
  'ShipAddress Country' => 'STRTYPE',
  'ShipAddress Note' => 'STRTYPE',
  'TermsRef ListID' => 'IDTYPE',
  'TermsRef FullName' => 'STRTYPE',
  'DueDate' => 'DATETYPE',
  'ExpectedDate' => 'DATETYPE',
  'ShipMethodRef ListID' => 'IDTYPE',
  'ShipMethodRef FullName' => 'STRTYPE',
  'FOB' => 'STRTYPE',
  'IsManuallyClosed' => 'BOOLTYPE',
  'Memo' => 'STRTYPE',
  'VendorMsg' => 'STRTYPE',
  'IsToBePrinted' => 'BOOLTYPE',
  'IsToBeEmailed' => 'BOOLTYPE',
  'IsTaxIncluded' => 'BOOLTYPE',
  'SalesTaxCodeRef ListID' => 'IDTYPE',
  'SalesTaxCodeRef FullName' => 'STRTYPE',
  'Other1' => 'STRTYPE',
  'Other2' => 'STRTYPE',
  'PurchaseOrderLineMod TxnLineID' => 'IDTYPE',
  'PurchaseOrderLineMod ItemRef ListID' => 'IDTYPE',
  'PurchaseOrderLineMod ItemRef FullName' => 'STRTYPE',
  'PurchaseOrderLineMod ManufacturerPartNumber' => 'STRTYPE',
  'PurchaseOrderLineMod Desc' => 'STRTYPE',
  'PurchaseOrderLineMod Quantity' => 'QUANTYPE',
  'PurchaseOrderLineMod UnitOfMeasure' => 'STRTYPE',
  'PurchaseOrderLineMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'PurchaseOrderLineMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'PurchaseOrderLineMod Rate' => 'PRICETYPE',
  'PurchaseOrderLineMod ClassRef ListID' => 'IDTYPE',
  'PurchaseOrderLineMod ClassRef FullName' => 'STRTYPE',
  'PurchaseOrderLineMod Amount' => 'AMTTYPE',
  'PurchaseOrderLineMod CustomerRef ListID' => 'IDTYPE',
  'PurchaseOrderLineMod CustomerRef FullName' => 'STRTYPE',
  'PurchaseOrderLineMod ServiceDate' => 'DATETYPE',
  'PurchaseOrderLineMod SalesTaxCodeRef ListID' => 'IDTYPE',
  'PurchaseOrderLineMod SalesTaxCodeRef FullName' => 'STRTYPE',
  'PurchaseOrderLineMod IsManuallyClosed' => 'BOOLTYPE',
  'PurchaseOrderLineMod OverrideItemAccountRef ListID' => 'IDTYPE',
  'PurchaseOrderLineMod OverrideItemAccountRef FullName' => 'STRTYPE',
  'PurchaseOrderLineMod Other1' => 'STRTYPE',
  'PurchaseOrderLineMod Other2' => 'STRTYPE',
  'PurchaseOrderLineGroupMod TxnLineID' => 'IDTYPE',
  'PurchaseOrderLineGroupMod ItemGroupRef ListID' => 'IDTYPE',
  'PurchaseOrderLineGroupMod ItemGroupRef FullName' => 'STRTYPE',
  'PurchaseOrderLineGroupMod Quantity' => 'QUANTYPE',
  'PurchaseOrderLineGroupMod UnitOfMeasure' => 'STRTYPE',
  'PurchaseOrderLineGroupMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'PurchaseOrderLineGroupMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod TxnLineID' => 'IDTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef ListID' => 'IDTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef FullName' => 'STRTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ManufacturerPartNumber' => 'STRTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Desc' => 'STRTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Quantity' => 'QUANTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod UnitOfMeasure' => 'STRTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef ListID' => 'IDTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef FullName' => 'STRTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Rate' => 'PRICETYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef ListID' => 'IDTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef FullName' => 'STRTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Amount' => 'AMTTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef ListID' => 'IDTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef FullName' => 'STRTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ServiceDate' => 'DATETYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef ListID' => 'IDTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef FullName' => 'STRTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod IsManuallyClosed' => 'BOOLTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef ListID' => 'IDTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef FullName' => 'STRTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other1' => 'STRTYPE',
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other2' => 'STRTYPE',
  'IncludeRetElement' => 'STRTYPE',
);
		
		return $paths;
	}
	
	protected function &_maxLengthPaths()
	{
		static $paths = array (
  'TxnID' => 0,
  'EditSequence' => 16,
  'VendorRef ListID' => 0,
  'VendorRef FullName' => 41,
  'ClassRef ListID' => 0,
  'ClassRef FullName' => 41,
  'ShipToEntityRef ListID' => 0,
  'ShipToEntityRef FullName' => 41,
  'TemplateRef ListID' => 0,
  'TemplateRef FullName' => 41,
  'TxnDate' => 0,
  'RefNumber' => 11,
  'VendorAddress Addr1' => 41,
  'VendorAddress Addr2' => 41,
  'VendorAddress Addr3' => 41,
  'VendorAddress Addr4' => 41,
  'VendorAddress Addr5' => 41,
  'VendorAddress City' => 31,
  'VendorAddress State' => 21,
  'VendorAddress PostalCode' => 13,
  'VendorAddress Country' => 31,
  'VendorAddress Note' => 41,
  'ShipAddress Addr1' => 41,
  'ShipAddress Addr2' => 41,
  'ShipAddress Addr3' => 41,
  'ShipAddress Addr4' => 41,
  'ShipAddress Addr5' => 41,
  'ShipAddress City' => 31,
  'ShipAddress State' => 21,
  'ShipAddress PostalCode' => 13,
  'ShipAddress Country' => 31,
  'ShipAddress Note' => 41,
  'TermsRef ListID' => 0,
  'TermsRef FullName' => 41,
  'DueDate' => 0,
  'ExpectedDate' => 0,
  'ShipMethodRef ListID' => 0,
  'ShipMethodRef FullName' => 41,
  'FOB' => 13,
  'IsManuallyClosed' => 0,
  'Memo' => 4095,
  'VendorMsg' => 99,
  'IsToBePrinted' => 0,
  'IsToBeEmailed' => 0,
  'IsTaxIncluded' => 0,
  'SalesTaxCodeRef ListID' => 0,
  'SalesTaxCodeRef FullName' => 41,
  'Other1' => 25,
  'Other2' => 29,
  'PurchaseOrderLineMod TxnLineID' => 0,
  'PurchaseOrderLineMod ItemRef ListID' => 0,
  'PurchaseOrderLineMod ItemRef FullName' => 41,
  'PurchaseOrderLineMod ManufacturerPartNumber' => 31,
  'PurchaseOrderLineMod Desc' => 4095,
  'PurchaseOrderLineMod Quantity' => 0,
  'PurchaseOrderLineMod UnitOfMeasure' => 31,
  'PurchaseOrderLineMod OverrideUOMSetRef ListID' => 0,
  'PurchaseOrderLineMod OverrideUOMSetRef FullName' => 41,
  'PurchaseOrderLineMod Rate' => 0,
  'PurchaseOrderLineMod ClassRef ListID' => 0,
  'PurchaseOrderLineMod ClassRef FullName' => 41,
  'PurchaseOrderLineMod Amount' => 0,
  'PurchaseOrderLineMod CustomerRef ListID' => 0,
  'PurchaseOrderLineMod CustomerRef FullName' => 41,
  'PurchaseOrderLineMod ServiceDate' => 0,
  'PurchaseOrderLineMod SalesTaxCodeRef ListID' => 0,
  'PurchaseOrderLineMod SalesTaxCodeRef FullName' => 41,
  'PurchaseOrderLineMod IsManuallyClosed' => 0,
  'PurchaseOrderLineMod OverrideItemAccountRef ListID' => 0,
  'PurchaseOrderLineMod OverrideItemAccountRef FullName' => 41,
  'PurchaseOrderLineMod Other1' => 25,
  'PurchaseOrderLineMod Other2' => 29,
  'PurchaseOrderLineGroupMod TxnLineID' => 0,
  'PurchaseOrderLineGroupMod ItemGroupRef ListID' => 0,
  'PurchaseOrderLineGroupMod ItemGroupRef FullName' => 41,
  'PurchaseOrderLineGroupMod Quantity' => 0,
  'PurchaseOrderLineGroupMod UnitOfMeasure' => 31,
  'PurchaseOrderLineGroupMod OverrideUOMSetRef ListID' => 0,
  'PurchaseOrderLineGroupMod OverrideUOMSetRef FullName' => 41,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod TxnLineID' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef ListID' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef FullName' => 41,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ManufacturerPartNumber' => 31,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Desc' => 4095,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Quantity' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod UnitOfMeasure' => 31,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef ListID' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef FullName' => 41,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Rate' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef ListID' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef FullName' => 41,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Amount' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef ListID' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef FullName' => 41,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ServiceDate' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef ListID' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef FullName' => 41,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod IsManuallyClosed' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef ListID' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef FullName' => 41,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other1' => 25,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other2' => 29,
  'IncludeRetElement' => 50,
);
		
		return $paths;
	}
	
	protected function &_isOptionalPaths()
	{
		static $paths = array (
  'TxnID' => false,
  'EditSequence' => false,
  'VendorRef ListID' => true,
  'VendorRef FullName' => true,
  'ClassRef ListID' => true,
  'ClassRef FullName' => true,
  'ShipToEntityRef ListID' => true,
  'ShipToEntityRef FullName' => true,
  'TemplateRef ListID' => true,
  'TemplateRef FullName' => true,
  'TxnDate' => true,
  'RefNumber' => true,
  'VendorAddress Addr1' => true,
  'VendorAddress Addr2' => true,
  'VendorAddress Addr3' => true,
  'VendorAddress Addr4' => true,
  'VendorAddress Addr5' => true,
  'VendorAddress City' => true,
  'VendorAddress State' => true,
  'VendorAddress PostalCode' => true,
  'VendorAddress Country' => true,
  'VendorAddress Note' => true,
  'ShipAddress Addr1' => true,
  'ShipAddress Addr2' => true,
  'ShipAddress Addr3' => true,
  'ShipAddress Addr4' => true,
  'ShipAddress Addr5' => true,
  'ShipAddress City' => true,
  'ShipAddress State' => true,
  'ShipAddress PostalCode' => true,
  'ShipAddress Country' => true,
  'ShipAddress Note' => true,
  'TermsRef ListID' => true,
  'TermsRef FullName' => true,
  'DueDate' => true,
  'ExpectedDate' => true,
  'ShipMethodRef ListID' => true,
  'ShipMethodRef FullName' => true,
  'FOB' => true,
  'IsManuallyClosed' => true,
  'Memo' => true,
  'VendorMsg' => true,
  'IsToBePrinted' => true,
  'IsToBeEmailed' => true,
  'IsTaxIncluded' => true,
  'SalesTaxCodeRef ListID' => true,
  'SalesTaxCodeRef FullName' => true,
  'Other1' => true,
  'Other2' => true,
  'PurchaseOrderLineMod TxnLineID' => false,
  'PurchaseOrderLineMod ItemRef ListID' => true,
  'PurchaseOrderLineMod ItemRef FullName' => true,
  'PurchaseOrderLineMod ManufacturerPartNumber' => true,
  'PurchaseOrderLineMod Desc' => true,
  'PurchaseOrderLineMod Quantity' => true,
  'PurchaseOrderLineMod UnitOfMeasure' => true,
  'PurchaseOrderLineMod OverrideUOMSetRef ListID' => true,
  'PurchaseOrderLineMod OverrideUOMSetRef FullName' => true,
  'PurchaseOrderLineMod Rate' => true,
  'PurchaseOrderLineMod ClassRef ListID' => true,
  'PurchaseOrderLineMod ClassRef FullName' => true,
  'PurchaseOrderLineMod Amount' => true,
  'PurchaseOrderLineMod CustomerRef ListID' => true,
  'PurchaseOrderLineMod CustomerRef FullName' => true,
  'PurchaseOrderLineMod ServiceDate' => true,
  'PurchaseOrderLineMod SalesTaxCodeRef ListID' => true,
  'PurchaseOrderLineMod SalesTaxCodeRef FullName' => true,
  'PurchaseOrderLineMod IsManuallyClosed' => true,
  'PurchaseOrderLineMod OverrideItemAccountRef ListID' => true,
  'PurchaseOrderLineMod OverrideItemAccountRef FullName' => true,
  'PurchaseOrderLineMod Other1' => true,
  'PurchaseOrderLineMod Other2' => true,
  'PurchaseOrderLineGroupMod TxnLineID' => false,
  'PurchaseOrderLineGroupMod ItemGroupRef ListID' => true,
  'PurchaseOrderLineGroupMod ItemGroupRef FullName' => true,
  'PurchaseOrderLineGroupMod Quantity' => true,
  'PurchaseOrderLineGroupMod UnitOfMeasure' => true,
  'PurchaseOrderLineGroupMod OverrideUOMSetRef ListID' => true,
  'PurchaseOrderLineGroupMod OverrideUOMSetRef FullName' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod TxnLineID' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef ListID' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef FullName' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ManufacturerPartNumber' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Desc' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Quantity' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod UnitOfMeasure' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef ListID' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef FullName' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Rate' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef ListID' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef FullName' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Amount' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef ListID' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef FullName' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ServiceDate' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef ListID' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef FullName' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod IsManuallyClosed' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef ListID' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef FullName' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other1' => true,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other2' => true,
  'IncludeRetElement' => true,
);
	}
	
	protected function &_sinceVersionPaths()
	{
		static $paths = array (
  'TxnID' => 0,
  'EditSequence' => 999.99,
  'VendorRef ListID' => 999.99,
  'VendorRef FullName' => 999.99,
  'ClassRef ListID' => 999.99,
  'ClassRef FullName' => 999.99,
  'ShipToEntityRef ListID' => 999.99,
  'ShipToEntityRef FullName' => 999.99,
  'TemplateRef ListID' => 999.99,
  'TemplateRef FullName' => 999.99,
  'TxnDate' => 999.99,
  'RefNumber' => 999.99,
  'VendorAddress Addr1' => 999.99,
  'VendorAddress Addr2' => 999.99,
  'VendorAddress Addr3' => 999.99,
  'VendorAddress Addr4' => 2,
  'VendorAddress Addr5' => 6,
  'VendorAddress City' => 999.99,
  'VendorAddress State' => 999.99,
  'VendorAddress PostalCode' => 999.99,
  'VendorAddress Country' => 999.99,
  'VendorAddress Note' => 6,
  'ShipAddress Addr1' => 999.99,
  'ShipAddress Addr2' => 999.99,
  'ShipAddress Addr3' => 999.99,
  'ShipAddress Addr4' => 2,
  'ShipAddress Addr5' => 6,
  'ShipAddress City' => 999.99,
  'ShipAddress State' => 999.99,
  'ShipAddress PostalCode' => 999.99,
  'ShipAddress Country' => 999.99,
  'ShipAddress Note' => 6,
  'TermsRef ListID' => 999.99,
  'TermsRef FullName' => 999.99,
  'DueDate' => 999.99,
  'ExpectedDate' => 999.99,
  'ShipMethodRef ListID' => 999.99,
  'ShipMethodRef FullName' => 999.99,
  'FOB' => 999.99,
  'IsManuallyClosed' => 999.99,
  'Memo' => 999.99,
  'VendorMsg' => 999.99,
  'IsToBePrinted' => 999.99,
  'IsToBeEmailed' => 6,
  'IsTaxIncluded' => 6,
  'SalesTaxCodeRef ListID' => 999.99,
  'SalesTaxCodeRef FullName' => 999.99,
  'Other1' => 6,
  'Other2' => 6,
  'PurchaseOrderLineMod TxnLineID' => 0,
  'PurchaseOrderLineMod ItemRef ListID' => 999.99,
  'PurchaseOrderLineMod ItemRef FullName' => 999.99,
  'PurchaseOrderLineMod ManufacturerPartNumber' => 7,
  'PurchaseOrderLineMod Desc' => 999.99,
  'PurchaseOrderLineMod Quantity' => 999.99,
  'PurchaseOrderLineMod UnitOfMeasure' => 7,
  'PurchaseOrderLineMod OverrideUOMSetRef ListID' => 999.99,
  'PurchaseOrderLineMod OverrideUOMSetRef FullName' => 999.99,
  'PurchaseOrderLineMod Rate' => 999.99,
  'PurchaseOrderLineMod ClassRef ListID' => 999.99,
  'PurchaseOrderLineMod ClassRef FullName' => 999.99,
  'PurchaseOrderLineMod Amount' => 999.99,
  'PurchaseOrderLineMod CustomerRef ListID' => 999.99,
  'PurchaseOrderLineMod CustomerRef FullName' => 999.99,
  'PurchaseOrderLineMod ServiceDate' => 999.99,
  'PurchaseOrderLineMod SalesTaxCodeRef ListID' => 999.99,
  'PurchaseOrderLineMod SalesTaxCodeRef FullName' => 999.99,
  'PurchaseOrderLineMod IsManuallyClosed' => 999.99,
  'PurchaseOrderLineMod OverrideItemAccountRef ListID' => 999.99,
  'PurchaseOrderLineMod OverrideItemAccountRef FullName' => 999.99,
  'PurchaseOrderLineMod Other1' => 6,
  'PurchaseOrderLineMod Other2' => 6,
  'PurchaseOrderLineGroupMod TxnLineID' => 0,
  'PurchaseOrderLineGroupMod ItemGroupRef ListID' => 999.99,
  'PurchaseOrderLineGroupMod ItemGroupRef FullName' => 999.99,
  'PurchaseOrderLineGroupMod Quantity' => 999.99,
  'PurchaseOrderLineGroupMod UnitOfMeasure' => 7,
  'PurchaseOrderLineGroupMod OverrideUOMSetRef ListID' => 999.99,
  'PurchaseOrderLineGroupMod OverrideUOMSetRef FullName' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod TxnLineID' => 0,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef ListID' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef FullName' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ManufacturerPartNumber' => 7,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Desc' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Quantity' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod UnitOfMeasure' => 7,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef ListID' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef FullName' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Rate' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef ListID' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef FullName' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Amount' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef ListID' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef FullName' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ServiceDate' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef ListID' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef FullName' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod IsManuallyClosed' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef ListID' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef FullName' => 999.99,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other1' => 6,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other2' => 6,
  'IncludeRetElement' => 4,
);
		
		return $paths;
	}
	
	protected function &_isRepeatablePaths()
	{
		static $paths = array (
  'TxnID' => false,
  'EditSequence' => false,
  'VendorRef ListID' => false,
  'VendorRef FullName' => false,
  'ClassRef ListID' => false,
  'ClassRef FullName' => false,
  'ShipToEntityRef ListID' => false,
  'ShipToEntityRef FullName' => false,
  'TemplateRef ListID' => false,
  'TemplateRef FullName' => false,
  'TxnDate' => false,
  'RefNumber' => false,
  'VendorAddress Addr1' => false,
  'VendorAddress Addr2' => false,
  'VendorAddress Addr3' => false,
  'VendorAddress Addr4' => false,
  'VendorAddress Addr5' => false,
  'VendorAddress City' => false,
  'VendorAddress State' => false,
  'VendorAddress PostalCode' => false,
  'VendorAddress Country' => false,
  'VendorAddress Note' => false,
  'ShipAddress Addr1' => false,
  'ShipAddress Addr2' => false,
  'ShipAddress Addr3' => false,
  'ShipAddress Addr4' => false,
  'ShipAddress Addr5' => false,
  'ShipAddress City' => false,
  'ShipAddress State' => false,
  'ShipAddress PostalCode' => false,
  'ShipAddress Country' => false,
  'ShipAddress Note' => false,
  'TermsRef ListID' => false,
  'TermsRef FullName' => false,
  'DueDate' => false,
  'ExpectedDate' => false,
  'ShipMethodRef ListID' => false,
  'ShipMethodRef FullName' => false,
  'FOB' => false,
  'IsManuallyClosed' => false,
  'Memo' => false,
  'VendorMsg' => false,
  'IsToBePrinted' => false,
  'IsToBeEmailed' => false,
  'IsTaxIncluded' => false,
  'SalesTaxCodeRef ListID' => false,
  'SalesTaxCodeRef FullName' => false,
  'Other1' => false,
  'Other2' => false,
  'PurchaseOrderLineMod TxnLineID' => false,
  'PurchaseOrderLineMod ItemRef ListID' => false,
  'PurchaseOrderLineMod ItemRef FullName' => false,
  'PurchaseOrderLineMod ManufacturerPartNumber' => false,
  'PurchaseOrderLineMod Desc' => false,
  'PurchaseOrderLineMod Quantity' => false,
  'PurchaseOrderLineMod UnitOfMeasure' => false,
  'PurchaseOrderLineMod OverrideUOMSetRef ListID' => false,
  'PurchaseOrderLineMod OverrideUOMSetRef FullName' => false,
  'PurchaseOrderLineMod Rate' => false,
  'PurchaseOrderLineMod ClassRef ListID' => false,
  'PurchaseOrderLineMod ClassRef FullName' => false,
  'PurchaseOrderLineMod Amount' => false,
  'PurchaseOrderLineMod CustomerRef ListID' => false,
  'PurchaseOrderLineMod CustomerRef FullName' => false,
  'PurchaseOrderLineMod ServiceDate' => false,
  'PurchaseOrderLineMod SalesTaxCodeRef ListID' => false,
  'PurchaseOrderLineMod SalesTaxCodeRef FullName' => false,
  'PurchaseOrderLineMod IsManuallyClosed' => false,
  'PurchaseOrderLineMod OverrideItemAccountRef ListID' => false,
  'PurchaseOrderLineMod OverrideItemAccountRef FullName' => false,
  'PurchaseOrderLineMod Other1' => false,
  'PurchaseOrderLineMod Other2' => false,
  'PurchaseOrderLineGroupMod TxnLineID' => false,
  'PurchaseOrderLineGroupMod ItemGroupRef ListID' => false,
  'PurchaseOrderLineGroupMod ItemGroupRef FullName' => false,
  'PurchaseOrderLineGroupMod Quantity' => false,
  'PurchaseOrderLineGroupMod UnitOfMeasure' => false,
  'PurchaseOrderLineGroupMod OverrideUOMSetRef ListID' => false,
  'PurchaseOrderLineGroupMod OverrideUOMSetRef FullName' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod TxnLineID' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef ListID' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef FullName' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ManufacturerPartNumber' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Desc' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Quantity' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod UnitOfMeasure' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef ListID' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef FullName' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Rate' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef ListID' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef FullName' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Amount' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef ListID' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef FullName' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod ServiceDate' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef ListID' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef FullName' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod IsManuallyClosed' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef ListID' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef FullName' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other1' => false,
  'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other2' => false,
  'IncludeRetElement' => true,
);
			
		return $paths;
	}
	
	/*
	abstract protected function &_inLocalePaths()
	{
		static $paths = array(
			'FirstName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ), 
			'LastName' => array( 'QBD', 'QBCA', 'QBUK', 'QBAU' ),
			);
		
		return $paths;
	}
	*/
	
	protected function &_reorderPathsPaths()
	{
		static $paths = array (
  0 => 'TxnID',
  1 => 'EditSequence',
  2 => 'VendorRef ListID',
  3 => 'VendorRef FullName',
  4 => 'ClassRef ListID',
  5 => 'ClassRef FullName',
  6 => 'ShipToEntityRef ListID',
  7 => 'ShipToEntityRef FullName',
  8 => 'TemplateRef ListID',
  9 => 'TemplateRef FullName',
  10 => 'TxnDate',
  11 => 'RefNumber',
  12 => 'VendorAddress Addr1',
  13 => 'VendorAddress Addr2',
  14 => 'VendorAddress Addr3',
  15 => 'VendorAddress Addr4',
  16 => 'VendorAddress Addr5',
  17 => 'VendorAddress City',
  18 => 'VendorAddress State',
  19 => 'VendorAddress PostalCode',
  20 => 'VendorAddress Country',
  21 => 'VendorAddress Note',
  22 => 'ShipAddress Addr1',
  23 => 'ShipAddress Addr2',
  24 => 'ShipAddress Addr3',
  25 => 'ShipAddress Addr4',
  26 => 'ShipAddress Addr5',
  27 => 'ShipAddress City',
  28 => 'ShipAddress State',
  29 => 'ShipAddress PostalCode',
  30 => 'ShipAddress Country',
  31 => 'ShipAddress Note',
  32 => 'TermsRef ListID',
  33 => 'TermsRef FullName',
  34 => 'DueDate',
  35 => 'ExpectedDate',
  36 => 'ShipMethodRef ListID',
  37 => 'ShipMethodRef FullName',
  38 => 'FOB',
  39 => 'IsManuallyClosed',
  40 => 'Memo',
  41 => 'VendorMsg',
  42 => 'IsToBePrinted',
  43 => 'IsToBeEmailed',
  44 => 'IsTaxIncluded',
  45 => 'SalesTaxCodeRef ListID',
  46 => 'SalesTaxCodeRef FullName',
  47 => 'Other1',
  48 => 'Other2',
  49 => 'PurchaseOrderLineMod TxnLineID',
  50 => 'PurchaseOrderLineMod ItemRef ListID',
  51 => 'PurchaseOrderLineMod ItemRef FullName',
  52 => 'PurchaseOrderLineMod ManufacturerPartNumber',
  53 => 'PurchaseOrderLineMod Desc',
  54 => 'PurchaseOrderLineMod Quantity',
  55 => 'PurchaseOrderLineMod UnitOfMeasure',
  56 => 'PurchaseOrderLineMod OverrideUOMSetRef ListID',
  57 => 'PurchaseOrderLineMod OverrideUOMSetRef FullName',
  58 => 'PurchaseOrderLineMod Rate',
  59 => 'PurchaseOrderLineMod ClassRef ListID',
  60 => 'PurchaseOrderLineMod ClassRef FullName',
  61 => 'PurchaseOrderLineMod Amount',
  62 => 'PurchaseOrderLineMod CustomerRef ListID',
  63 => 'PurchaseOrderLineMod CustomerRef FullName',
  64 => 'PurchaseOrderLineMod ServiceDate',
  65 => 'PurchaseOrderLineMod SalesTaxCodeRef ListID',
  66 => 'PurchaseOrderLineMod SalesTaxCodeRef FullName',
  67 => 'PurchaseOrderLineMod IsManuallyClosed',
  68 => 'PurchaseOrderLineMod OverrideItemAccountRef ListID',
  69 => 'PurchaseOrderLineMod OverrideItemAccountRef FullName',
  70 => 'PurchaseOrderLineMod Other1',
  71 => 'PurchaseOrderLineMod Other2',
  72 => 'PurchaseOrderLineGroupMod TxnLineID',
  73 => 'PurchaseOrderLineGroupMod ItemGroupRef ListID',
  74 => 'PurchaseOrderLineGroupMod ItemGroupRef FullName',
  75 => 'PurchaseOrderLineGroupMod Quantity',
  76 => 'PurchaseOrderLineGroupMod UnitOfMeasure',
  77 => 'PurchaseOrderLineGroupMod OverrideUOMSetRef ListID',
  78 => 'PurchaseOrderLineGroupMod OverrideUOMSetRef FullName',
  79 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod TxnLineID',
  80 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef ListID',
  81 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod ItemRef FullName',
  82 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod ManufacturerPartNumber',
  83 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod Desc',
  84 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod Quantity',
  85 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod UnitOfMeasure',
  86 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef ListID',
  87 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideUOMSetRef FullName',
  88 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod Rate',
  89 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef ListID',
  90 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod ClassRef FullName',
  91 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod Amount',
  92 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef ListID',
  93 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod CustomerRef FullName',
  94 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod ServiceDate',
  95 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef ListID',
  96 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod SalesTaxCodeRef FullName',
  97 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod IsManuallyClosed',
  98 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef ListID',
  99 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod OverrideItemAccountRef FullName',
  100 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other1',
  101 => 'PurchaseOrderLineGroupMod PurchaseOrderLineMod Other2',
  102 => 'IncludeRetElement',
);
			
		return $paths;
	}
}

?>