dokanWebpack([1],[
/* 0 */,
/* 1 */
/***/ (function(module, exports) {

module.exports = jQuery;

/***/ }),
/* 2 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_jquery___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_jquery__);
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ __webpack_exports__["a"] = ({
  name: "AdminNotice",
  props: {
    endpoint: {
      type: String,
      default: 'admin'
    },
    interval: {
      type: Number,
      default: 5000
    }
  },
  data: function data() {
    return {
      timer: null,
      notices: [],
      loading: false,
      button_text: '',
      current_notice: 1,
      task_completed: false,
      transitionName: 'slide-next'
    };
  },
  created: function created() {
    this.fetch();
  },
  methods: {
    fetch: function fetch() {
      var _this = this;

      dokan.api.get("/admin/notices/".concat(this.endpoint)).done(function (response) {
        _this.notices = response.filter(function (notice) {
          return notice.description || notice.title;
        });

        _this.startAutoSlide();
      });
    },
    slideNotice: function slideNotice(n) {
      this.current_notice += n;
      n === 1 ? this.transitionName = "slide-next" : this.transitionName = "slide-prev";
      var len = this.notices.length;

      if (this.current_notice < 1) {
        this.current_notice = len;
      }

      if (this.current_notice > len) {
        this.current_notice = 1;
      }
    },
    nextNotice: function nextNotice() {
      this.stopAutoSlide();
      this.slideNotice(1);
    },
    prevNotice: function prevNotice() {
      this.stopAutoSlide();
      this.slideNotice(-1);
    },
    startAutoSlide: function startAutoSlide() {
      var _this2 = this;

      if (!this.loading && this.notices.length > 1) {
        this.timer = setInterval(function () {
          _this2.slideNotice(1);
        }, this.interval);
      }
    },
    stopAutoSlide: function stopAutoSlide() {
      if (!this.loading && this.notices.length > 1) {
        clearInterval(this.timer);
        this.timer = null;
      }
    },
    hideNotice: function hideNotice(notice, index) {
      var _this3 = this;

      __WEBPACK_IMPORTED_MODULE_0_jquery___default.a.ajax({
        url: dokan.ajaxurl,
        method: 'post',
        dataType: 'json',
        data: notice.ajax_data
      }).done(function () {
        _this3.notices.splice(index, 1);

        _this3.current_notice = 1;
      });
    },
    handleAction: function handleAction(action, index) {
      var _this4 = this;

      if (action.confirm_message) {
        this.$swal({
          title: this.__('Are you sure?', 'dokan-lite'),
          type: 'warning',
          html: action.confirm_message,
          showCancelButton: true,
          confirmButtonText: action.text,
          cancelButtonText: this.__('Cancel', 'dokan-lite')
        }).then(function (response) {
          if (response.value) {
            _this4.handleRequest(action, index);
          }
        });
      } else {
        this.handleRequest(action, index);
      }
    },
    handleRequest: function handleRequest(action, index) {
      var _this5 = this;

      this.loading = true;
      this.button_text = action.loading_text ? action.loading_text : this.__('Loading...', 'dokan-lite');
      __WEBPACK_IMPORTED_MODULE_0_jquery___default.a.ajax({
        url: dokan.ajaxurl,
        method: 'post',
        dataType: 'json',
        data: action.ajax_data
      }).always(function () {
        _this5.loading = false;
      }).done(function () {
        _this5.button_text = action.completed_text ? action.completed_text : action.text;
        _this5.task_completed = true;

        if (action.reload) {
          window.location.reload();
        } else {
          _this5.notices.splice(index, 1);

          _this5.current_notice = 1;
        }
      });
    }
  }
});

/***/ }),
/* 3 */,
/* 4 */,
/* 5 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Switches_vue__ = __webpack_require__(12);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_aa8ad7dc_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Switches_vue__ = __webpack_require__(32);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(31)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Switches_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_aa8ad7dc_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Switches_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/Switches.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-aa8ad7dc", Component.options)
  } else {
    hotAPI.reload("data-v-aa8ad7dc", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 6 */,
/* 7 */,
/* 8 */,
/* 9 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_vue_chartjs__ = __webpack_require__(21);

/* harmony default export */ __webpack_exports__["a"] = ({
  extends: __WEBPACK_IMPORTED_MODULE_0_vue_chartjs__["Line"],
  props: ['data'],
  data: function data() {
    return {
      options: {
        responsive: true,
        maintainAspectRatio: true,
        scales: {
          xAxes: [{
            type: 'time',
            scaleLabel: {
              display: false
            },
            gridLines: {
              display: false
            },
            ticks: {
              fontColor: '#aaa',
              fontSize: 11
            }
          }],
          yAxes: [{
            scaleLabel: {
              display: false
            },
            ticks: {
              fontColor: '#aaa'
            }
          }]
        },
        legend: {
          position: 'top',
          onClick: false
        },
        elements: {
          line: {
            tension: 0,
            borderWidth: 4
          },
          point: {
            radius: 5,
            borderWidth: 3,
            backgroundColor: '#fff',
            borderColor: '#fff'
          }
        },
        tooltips: {
          displayColors: false,
          callbacks: {
            label: function label(tooltipItems, data) {
              var label = data.datasets[tooltipItems.datasetIndex].label || '';
              var customLabel = data.datasets[tooltipItems.datasetIndex].tooltipLabel || '';
              var prefix = data.datasets[tooltipItems.datasetIndex].tooltipPrefix || '';
              var tooltipLabel = customLabel ? customLabel + ': ' : label + ': ';
              tooltipLabel += prefix + tooltipItems.yLabel;
              return tooltipLabel;
            }
          }
        }
      }
    };
  },
  mounted: function mounted() {
    this.renderChart(this.data, this.options);
  }
});

/***/ }),
/* 10 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_vue_color_src_components_Sketch_vue__ = __webpack_require__(58);
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ __webpack_exports__["a"] = ({
  components: {
    Sketch: __WEBPACK_IMPORTED_MODULE_0_vue_color_src_components_Sketch_vue__["a" /* default */]
  },
  props: {
    value: {
      type: String,
      required: true,
      default: ''
    },
    format: {
      type: String,
      required: false,
      default: 'hex',
      validator: function validator(type) {
        return ['hsl', 'hex', 'rgba', 'hsv'].indexOf(type) !== -1;
      }
    },
    presetColors: {
      type: Array,
      required: false,
      default: function _default() {
        return ['#000', '#fff', '#d33', '#d93', '#ee2', '#81d742', '#1e73be', '#8224e3'];
      }
    },
    disableAlpha: {
      type: Boolean,
      required: false,
      default: true
    },
    disableFields: {
      type: Boolean,
      required: false,
      default: true
    }
  },
  data: function data() {
    return {
      showColorPicker: false
    };
  },
  methods: {
    updateColor: function updateColor(colors) {
      var color = '';

      if (colors[this.format]) {
        color = colors[this.format];
      }

      this.$emit('input', color);
    },
    toggleColorPicker: function toggleColorPicker() {
      this.showColorPicker = !this.showColorPicker;
    },
    setHexColor: function setHexColor(color) {
      this.updateColor({
        hex: color
      });
    }
  }
});

/***/ }),
/* 11 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_debounce__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_debounce___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_debounce__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_admin_components_Switches_vue__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_admin_components_UploadImage_vue__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_admin_components_PasswordGenerator_vue__ = __webpack_require__(24);
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//




/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'VendorAccountFields',
  components: {
    Switches: __WEBPACK_IMPORTED_MODULE_1_admin_components_Switches_vue__["a" /* default */],
    UploadImage: __WEBPACK_IMPORTED_MODULE_2_admin_components_UploadImage_vue__["a" /* default */],
    PasswordGenerator: __WEBPACK_IMPORTED_MODULE_3_admin_components_PasswordGenerator_vue__["a" /* default */]
  },
  props: {
    vendorInfo: {
      type: Object
    },
    errors: {
      type: Array,
      required: false
    }
  },
  data: function data() {
    return {
      showStoreUrl: true,
      showPassword: false,
      otherStoreUrl: null,
      banner: '',
      defaultUrl: dokan.urls.siteUrl + dokan.urls.storePrefix + '/',
      showButton: true,
      placeholderData: '',
      delay: 500,
      storeAvailable: null,
      userNameAvailable: null,
      emailAvailable: null,
      storeAvailabilityText: '',
      userNameAvailabilityText: '',
      emailAvailabilityText: '',
      getAccountFields: dokan.hooks.applyFilters('getVendorAccountFields', [])
    };
  },
  watch: {
    'vendorInfo.store_name': function vendorInfoStore_name(value) {
      this.showStoreUrl = true;
    },
    'vendorInfo.user_nicename': function vendorInfoUser_nicename(newValue) {
      if (typeof newValue !== 'undefined') {
        this.showStoreUrl = false;
        this.otherStoreUrl = this.defaultUrl + newValue.trim().split(' ').join('-').toLowerCase().replace(/[^\w\s/-]/g, '').replace(/-+/g, '-');
        this.vendorInfo.user_nicename = newValue.split(' ').join('-').toLowerCase().replace(/[^\w\s/-]/g, '').replace(/-+/g, '-'); // check if the typed url is available

        this.checkStoreName();
      }
    },
    'vendorInfo.user_login': function vendorInfoUser_login(value) {
      this.checkUsername();
    },
    'vendorInfo.email': function vendorInfoEmail(value) {
      this.checkEmail();
    }
  },
  computed: {
    storeUrl: function storeUrl() {
      var storeUrl = this.vendorInfo.store_name.trim().split(' ').join('-').toLowerCase().replace(/[^\w\s/-]/g, '').replace(/-+/g, '-');
      this.vendorInfo.user_nicename = storeUrl;
      this.otherStoreUrl = this.defaultUrl + storeUrl;
      return this.defaultUrl + storeUrl;
    }
  },
  created: function created() {
    var _this = this;

    this.checkStoreName = Object(__WEBPACK_IMPORTED_MODULE_0_debounce__["debounce"])(this.checkStore, this.delay);
    this.checkUsername = Object(__WEBPACK_IMPORTED_MODULE_0_debounce__["debounce"])(this.searchUsername, this.delay);
    this.checkEmail = Object(__WEBPACK_IMPORTED_MODULE_0_debounce__["debounce"])(this.searchEmail, this.delay);
    this.$root.$on('passwordCancelled', function () {
      _this.showPassword = false;
    });
  },
  methods: {
    uploadBanner: function uploadBanner(image) {
      this.vendorInfo.banner_id = image.id; // hide button and footer text after uploading banner

      this.showButton = false;
    },
    uploadGravatar: function uploadGravatar(image) {
      this.vendorInfo.gravatar_id = image.id;
    },
    // getId function has been used to identify whether is it vendor edit page or not
    getId: function getId() {
      return this.$route.params.id;
    },
    onSelectBanner: function onSelectBanner(image) {
      this.banner = image.url;
      this.vendorInfo.banner_id = image.id;
    },
    getError: function getError(key) {
      var errors = this.errors;

      if (!errors || typeof errors === 'undefined') {
        return false;
      }

      if (errors.length < 1) {
        return false;
      }

      if (errors.includes(key)) {
        return key;
      }
    },
    checkStore: function checkStore() {
      var _this2 = this;

      var storeName = this.vendorInfo.user_nicename;

      if (!storeName) {
        return;
      }

      this.storeAvailabilityText = this.__('Searching...', 'dokan-lite');
      dokan.api.get("/stores/check", {
        store_slug: storeName
      }).then(function (response) {
        if (response.available) {
          _this2.storeAvailable = true;

          _this2.$root.$emit('vendorInfoChecked', {
            userNameAvailable: _this2.userNameAvailable,
            storeAvailable: _this2.storeAvailable,
            emailAvailable: _this2.emailAvailable
          });

          _this2.storeAvailabilityText = _this2.__('Available', 'dokan-lite');
        } else {
          _this2.storeAvailable = false;

          _this2.$root.$emit('vendorInfoChecked', {
            userNameAvailable: _this2.userNameAvailable,
            storeAvailable: _this2.storeAvailable,
            emailAvailable: _this2.emailAvailable
          });

          _this2.storeAvailabilityText = _this2.__('Not Available', 'dokan-lite');
        }
      });
    },
    searchUsername: function searchUsername() {
      var _this3 = this;

      var userName = this.vendorInfo.user_login;

      if (!userName) {
        return;
      }

      this.userNameAvailabilityText = this.__('Searching...', 'dokan-lite');
      dokan.api.get("/stores/check", {
        username: userName
      }).then(function (response) {
        if (response.available) {
          _this3.userNameAvailable = true;

          _this3.$root.$emit('vendorInfoChecked', {
            userNameAvailable: _this3.userNameAvailable,
            storeAvailable: _this3.storeAvailable,
            emailAvailable: _this3.emailAvailable
          });

          _this3.userNameAvailabilityText = _this3.__('Available', 'dokan-lite');
        } else {
          _this3.userNameAvailable = false;

          _this3.$root.$emit('vendorInfoChecked', {
            userNameAvailable: _this3.userNameAvailable,
            storeAvailable: _this3.storeAvailable,
            emailAvailable: _this3.emailAvailable
          });

          _this3.userNameAvailabilityText = _this3.__('Not Available', 'dokan-lite');
        }
      });
    },
    searchEmail: function searchEmail() {
      var _this4 = this;

      var userEmail = this.vendorInfo.email;

      if (!userEmail) {
        return;
      }

      this.emailAvailabilityText = this.__('Searching...', 'dokan-lite');
      dokan.api.get("/stores/check", {
        email: userEmail
      }).then(function (response) {
        if (response.available) {
          _this4.emailAvailable = true;

          _this4.$root.$emit('vendorInfoChecked', {
            userNameAvailable: _this4.userNameAvailable,
            storeAvailable: _this4.storeAvailable,
            emailAvailable: _this4.emailAvailable
          });

          _this4.emailAvailabilityText = _this4.__('Available', 'dokan-lite');
        } else {
          _this4.emailAvailable = false;

          _this4.$root.$emit('vendorInfoChecked', {
            userNameAvailable: _this4.userNameAvailable,
            storeAvailable: _this4.storeAvailable,
            emailAvailable: _this4.emailAvailable
          });

          _this4.emailAvailabilityText = response.message ? response.message : _this4.__('This email is already registered, please choose another one.', 'dokan-lite');
        }
      });
    },
    setPassword: function setPassword(password) {
      this.showPassword = true;
      this.vendorInfo.user_pass = password;
    },
    sendEmail: function sendEmail(status, key) {
      if ('notify_vendor' !== key) {
        return;
      }

      this.vendorInfo.notify_vendor = status;
    },
    getUploadBannerText: function getUploadBannerText() {
      var width = dokan.store_banner_dimension.width;
      var height = dokan.store_banner_dimension.height;
      return this.__("Upload banner for your store. Banner size is (".concat(width, "x").concat(height, ") pixels."), 'dokan-lite');
    }
  }
});

/***/ }),
/* 12 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'Switches',
  props: {
    enabled: {
      type: Boolean,
      // String, Number, Boolean, Function, Object, Array
      required: true,
      default: false
    },
    value: {
      type: [String, Number]
    }
  },
  data: function data() {
    return {};
  },
  methods: {
    trigger: function trigger(e) {
      this.$emit('input', e.target.checked, e.target.value);
    }
  }
});

/***/ }),
/* 13 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'UploadImage',
  inheritAttrs: false,
  props: {
    src: {
      default: dokan.urls.assetsUrl + '/images/store-pic.png'
    },
    showButton: {
      type: Boolean,
      default: false
    },
    buttonLabel: {
      type: String,
      default: 'Upload Image'
    },
    croppingWidth: {
      type: Number
    },
    croppingHeight: {
      type: Number
    }
  },
  data: function data() {
    return {
      image: {
        src: '',
        id: ''
      }
    };
  },
  methods: {
    uploadImage: function uploadImage() {
      this.openMediaManager(this.onSelectImage);
    },
    onSelectImage: function onSelectImage(image) {
      this.image.src = image.url;
      this.image.id = image.id;
      this.$emit('uploadedImage', this.image);
    },

    /**
     * Open Image Media Uploader
     *
     * @param  function callback
     *
     * @return callback
     */
    openMediaManager: function openMediaManager(callback) {
      var self = this;

      if (self.fileFrame) {
        self.fileFrame.open();
        return;
      }

      var fileStatesOptions = {
        library: wp.media.query(),
        multiple: false,
        // set it true for multiple image
        title: this.__('Select & Crop Image', 'dokan-lite'),
        priority: 20,
        filterable: 'uploaded',
        autoSelect: true,
        suggestedWidth: 500,
        suggestedHeight: 300
      };
      var cropControl = {
        id: "control-id",
        params: {
          width: this.croppingWidth ? parseInt(this.croppingWidth, 10) : parseInt(dokan.store_banner_dimension.width, 10),
          height: this.croppingHeight ? parseInt(this.croppingHeight, 10) : parseInt(dokan.store_banner_dimension.height, 10),
          flex_width: !!parseInt(dokan.store_banner_dimension['flex-width'], 10),
          flex_height: !!parseInt(dokan.store_banner_dimension['flex-height'], 10)
        }
      };

      cropControl.mustBeCropped = function (flexW, flexH, dstW, dstH, imgW, imgH) {
        // If the width and height are both flexible
        // then the user does not need to crop the image.
        if (true === flexW && true === flexH) {
          return false;
        } // If the width is flexible and the cropped image height matches the current image height,
        // then the user does not need to crop the image.


        if (true === flexW && dstH === imgH) {
          return false;
        } // If the height is flexible and the cropped image width matches the current image width,
        // then the user does not need to crop the image.


        if (true === flexH && dstW === imgW) {
          return false;
        } // If the cropped image width matches the current image width,
        // and the cropped image height matches the current image height
        // then the user does not need to crop the image.


        if (dstW === imgW && dstH === imgH) {
          return false;
        } // If the destination width is equal to or greater than the cropped image width
        // then the user does not need to crop the image...


        if (imgW <= dstW) {
          return false;
        }

        return true;
      };

      var fileStates = [new wp.media.controller.Library(fileStatesOptions), new wp.media.controller.CustomizeImageCropper({
        imgSelectOptions: self.calculateImageSelectOptions,
        control: cropControl
      })];
      var mediaOptions = {
        title: this.__('Select Image', 'dokan-lite'),
        button: {
          text: this.__('Select Image', 'dokan-lite'),
          close: false
        },
        multiple: false
      };
      mediaOptions.states = fileStates;
      self.fileFrame = wp.media(mediaOptions);
      self.fileFrame.on('select', function () {
        self.fileFrame.setState('cropper');
      });
      self.fileFrame.on('cropped', function (croppedImage) {
        callback(croppedImage);
        self.fileFrame = null;
      });
      self.fileFrame.on('skippedcrop', function () {
        var selection = self.fileFrame.state().get('selection');
        var files = selection.map(function (attachment) {
          return attachment.toJSON();
        });
        var file = files.pop();
        callback(file);
        self.fileFrame = null;
      });
      self.fileFrame.on('close', function () {
        self.fileFrame = null;
      });
      self.fileFrame.on('ready', function () {
        self.fileFrame.uploader.options.uploader.params = {
          type: 'dokan-vendor-option-media'
        };
      });
      self.fileFrame.open();
    },

    /**
     * Calculate image section options
     *
     * @param  object attachment
     * @param  object controller
     *
     * @return object
     */
    calculateImageSelectOptions: function calculateImageSelectOptions(attachment, controller) {
      var xInit = this.croppingWidth ? parseInt(this.croppingWidth, 10) : parseInt(dokan.store_banner_dimension.width, 10);
      var yInit = this.croppingHeight ? parseInt(this.croppingHeight, 10) : parseInt(dokan.store_banner_dimension.height, 10);
      var flexWidth = !!parseInt(dokan.store_banner_dimension['flex-width'], 10);
      var flexHeight = !!parseInt(dokan.store_banner_dimension['flex-height'], 10);
      var ratio, xImg, yImg, realHeight, realWidth, imgSelectOptions;
      realWidth = attachment.get('width');
      realHeight = attachment.get('height');
      var control = controller.get('control');
      controller.set('canSkipCrop', !control.mustBeCropped(flexWidth, flexHeight, xInit, yInit, realWidth, realHeight));
      ratio = xInit / yInit;
      xImg = realWidth;
      yImg = realHeight;

      if (xImg / yImg > ratio) {
        yInit = yImg;
        xInit = yInit * ratio;
      } else {
        xInit = xImg;
        yInit = xInit / ratio;
      }

      imgSelectOptions = {
        handles: true,
        keys: true,
        instance: true,
        persistent: true,
        imageWidth: realWidth,
        imageHeight: realHeight,
        x1: 0,
        y1: 0,
        x2: xInit,
        y2: yInit
      };

      if (flexHeight === false && flexWidth === false) {
        imgSelectOptions.aspectRatio = xInit + ':' + yInit;
      }

      if (flexHeight === false) {
        imgSelectOptions.maxHeight = yInit;
      }

      if (flexWidth === false) {
        imgSelectOptions.maxWidth = xInit;
      }

      return imgSelectOptions;
    }
  }
});

/***/ }),
/* 14 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'PasswordGenerator',
  props: {
    title: {
      type: String,
      default: 'Generate Password'
    },
    cancelTitle: {
      type: String,
      default: 'Cancel'
    },
    regenrateTitle: {
      type: String,
      default: 'Regenrate'
    },
    length: {
      type: Number,
      default: 25
    }
  },
  data: function data() {
    return {
      password: '',
      hideGenerateButton: false,
      showCancelButton: false
    };
  },
  methods: {
    generatePassword: function generatePassword() {
      this.password = this.makePassword(this.length);
      this.$emit('passwordGenerated', this.password);
      this.hideGenerateButton = true;
      this.showCancelButton = true;
    },
    makePassword: function makePassword() {
      var len = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 25;
      var lowerCaseChars = 'abcdefghijklmnopqurstuvwxyz';
      var upperCaseChars = 'ABCDEFGHIJKLMNOPQURSTUVWXYZ';
      var specialChars = '!@#$%^&*()';
      var randomChars = '';

      for (var i = 0; i <= len; i++) {
        var mixUp = lowerCaseChars[Math.floor(Math.random() * len)] + upperCaseChars[Math.floor(Math.random() * 10)] + specialChars[Math.floor(Math.random() * specialChars.length)];
        randomChars += mixUp;
      }

      return randomChars.slice(-len);
    },
    cancelButton: function cancelButton() {
      this.hideGenerateButton = false;
      this.showCancelButton = false;
      this.$root.$emit('passwordCancelled');
    },
    regenratePassword: function regenratePassword() {
      this.password = this.makePassword(this.length);
      this.$emit('passwordGenerated', this.password);
    }
  }
});

/***/ }),
/* 15 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_vue_multiselect__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_vue_multiselect___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_vue_multiselect__);
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'VendorAddressFields',
  components: {
    Multiselect: __WEBPACK_IMPORTED_MODULE_0_vue_multiselect__["Multiselect"]
  },
  props: {
    vendorInfo: {
      type: Object
    }
  },
  data: function data() {
    return {
      countries: [],
      states: [],
      selectedCountry: {},
      selectedState: {},
      getAddressFields: dokan.hooks.applyFilters('getVendorAddressFields', [])
    };
  },
  computed: {
    selectedCode: function selectedCode() {
      // let selected = this.selectedCountry;
      var selected = this.vendorInfo.address.country;

      if ('' !== selected) {
        return selected;
      }

      return [];
    }
  },
  created: function created() {
    this.countries = this.transformCountries(dokan.countries);
    this.states = dokan.states;
    var savedCountry = this.vendorInfo.address.country;
    var savedState = this.vendorInfo.address.state;

    if ('' !== savedCountry) {
      this.selectedCountry = {
        name: this.getCountryFromCountryCode(savedCountry),
        code: savedCountry
      };
      this.selectedState = {
        name: this.getStateFromStateCode(savedState, savedCountry),
        code: savedState
      };
    }
  },
  methods: {
    transformCountries: function transformCountries(countryObject) {
      var countries = [];

      for (var key in countryObject) {
        countries.push({
          name: countryObject[key],
          code: key
        });
      }

      return countries;
    },
    getCountryFromCountryCode: function getCountryFromCountryCode(countryCode) {
      if ('' === countryCode) {
        return;
      }

      return dokan.countries[countryCode];
    },
    getStateFromStateCode: function getStateFromStateCode(stateCode, countryCode) {
      if ('' === stateCode) {
        return;
      }

      var states = dokan.states[countryCode];
      var state = states && states[stateCode];
      return typeof state !== 'undefined' ? state : [];
    },
    getStatesFromCountryCode: function getStatesFromCountryCode(countryCode) {
      if ('' === countryCode) {
        return;
      }

      var states = [];
      var statesObject = this.states;

      for (var state in statesObject) {
        if (state !== countryCode) {
          continue;
        }

        if (statesObject[state] && statesObject[state].length < 1) {
          continue;
        }

        for (var name in statesObject[state]) {
          states.push({
            name: statesObject[state][name],
            code: name
          });
        }
      }

      return states;
    },
    saveCountry: function saveCountry(value) {
      if (!value) return; // if reset default state values

      this.vendorInfo.address.state = null;
      this.selectedState = {};
      this.vendorInfo.address.country = value.code;
    },
    saveState: function saveState(value) {
      if (!value) return;
      this.vendorInfo.address.state = value.code;
    }
  }
});

/***/ }),
/* 16 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_admin_components_Switches_vue__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_vue_multiselect__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_vue_multiselect___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_vue_multiselect__);
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//


/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'VendorPaymentFields',
  components: {
    Switches: __WEBPACK_IMPORTED_MODULE_0_admin_components_Switches_vue__["a" /* default */],
    Multiselect: __WEBPACK_IMPORTED_MODULE_1_vue_multiselect__["Multiselect"]
  },
  props: {
    vendorInfo: {
      type: Object
    }
  },
  data: function data() {
    return {
      enabled: false,
      trusted: false,
      featured: false,
      commissionTypes: [{
        name: 'flat',
        label: this.__('Flat', 'dokan-lite')
      }, {
        name: 'percentage',
        label: this.__('Percentage', 'dokan-lite')
      }, {
        name: 'combine',
        label: this.__('Combine', 'dokan-lite')
      }],
      selectedCommissionType: {
        name: 'flat',
        label: this.__('Flat', 'dokan-lite')
      },
      getBankFields: dokan.hooks.applyFilters('getVendorBankFields', []),
      getPyamentFields: dokan.hooks.applyFilters('AfterPyamentFields', [])
    };
  },
  created: function created() {
    if (this.vendorInfo.enabled) {
      this.enabled = true;
      this.vendorInfo.enabled = true;
    }

    if (this.vendorInfo.trusted) {
      this.trusted = true;
      this.vendorInfo.trusted = true;
    }

    if (this.vendorInfo.featured) {
      this.featured = true;
      this.vendorInfo.featured = true;
    }

    var commissionType = this.vendorInfo.admin_commission_type;

    if (commissionType) {
      var _$findWhere = _.findWhere(this.commissionTypes, {
        name: commissionType
      }),
          name = _$findWhere.name,
          label = _$findWhere.label;

      this.selectedCommissionType.name = name;
      this.selectedCommissionType.label = label;
    }
  },
  methods: {
    setValue: function setValue(status, key) {
      if ('enabled' === key) {
        if (status) {
          this.vendorInfo.enabled = true;
        } else {
          this.vendorInfo.enabled = false;
        }
      }

      if ('trusted' === key) {
        if (status) {
          this.vendorInfo.trusted = true;
        } else {
          this.vendorInfo.trusted = false;
        }
      }

      if ('featured' === key) {
        if (status) {
          this.vendorInfo.featured = true;
        } else {
          this.vendorInfo.featured = false;
        }
      }
    },
    getId: function getId() {
      return this.$route.params.id;
    },
    saveCommissionType: function saveCommissionType(_ref) {
      var name = _ref.name;

      if (!name) {
        this.vendorInfo.admin_commission_type = 'flat';
      }

      this.vendorInfo.admin_commission_type = name;
    }
  }
});

/***/ }),
/* 17 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_AdminNotice_vue__ = __webpack_require__(2);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_0f724387_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_AdminNotice_vue__ = __webpack_require__(18);
var disposed = false
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = null
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_AdminNotice_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_0f724387_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_AdminNotice_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/AdminNotice.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-0f724387", Component.options)
  } else {
    hotAPI.reload("data-v-0f724387", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 18 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("div", { staticClass: "notice dokan-admin-notices-wrap" }, [
    _vm.notices && _vm.notices.length
      ? _c(
          "div",
          { staticClass: "dokan-admin-notices" },
          [
            _c(
              "transition-group",
              {
                staticClass: "dokan-notice-slides",
                attrs: { name: _vm.transitionName, tag: "div" }
              },
              [
                _vm._l(_vm.notices, function(notice, index) {
                  return [
                    _c(
                      "div",
                      {
                        directives: [
                          {
                            name: "show",
                            rawName: "v-show",
                            value: index + 1 === _vm.current_notice,
                            expression: "(index + 1) === current_notice"
                          }
                        ],
                        key: index,
                        staticClass: "dokan-admin-notice",
                        class: "dokan-" + notice.type,
                        on: {
                          mouseenter: _vm.stopAutoSlide,
                          mouseleave: _vm.startAutoSlide
                        }
                      },
                      [
                        _c(
                          "div",
                          {
                            staticClass: "notice-content",
                            style:
                              !notice.title ||
                              !notice.actions ||
                              !notice.description
                                ? "align-items: center"
                                : ""
                          },
                          [
                            _c("div", { staticClass: "logo-wrap" }, [
                              _c("div", { staticClass: "dokan-logo" }),
                              _vm._v(" "),
                              _c("span", {
                                staticClass: "dokan-icon",
                                class: "dokan-icon-" + notice.type
                              })
                            ]),
                            _vm._v(" "),
                            _c(
                              "div",
                              { staticClass: "dokan-message" },
                              [
                                notice.title
                                  ? _c("h3", [_vm._v(_vm._s(notice.title))])
                                  : _vm._e(),
                                _vm._v(" "),
                                notice.description
                                  ? _c("div", {
                                      domProps: {
                                        innerHTML: _vm._s(notice.description)
                                      }
                                    })
                                  : _vm._e(),
                                _vm._v(" "),
                                notice.actions && notice.actions.length
                                  ? [
                                      _vm._l(notice.actions, function(action) {
                                        return [
                                          action.action
                                            ? _c(
                                                "a",
                                                {
                                                  staticClass: "dokan-btn",
                                                  class: [
                                                    "dokan-btn-" + action.type,
                                                    action.class
                                                  ],
                                                  attrs: {
                                                    target: action.target
                                                      ? action.target
                                                      : "_self",
                                                    href: action.action
                                                  }
                                                },
                                                [_vm._v(_vm._s(action.text))]
                                              )
                                            : _c(
                                                "button",
                                                {
                                                  staticClass:
                                                    "dokan-btn btn-dokan",
                                                  class: [
                                                    "dokan-btn-" + action.type,
                                                    action.class
                                                  ],
                                                  attrs: {
                                                    disabled: _vm.loading
                                                  },
                                                  on: {
                                                    click: function($event) {
                                                      return _vm.handleAction(
                                                        action,
                                                        index
                                                      )
                                                    }
                                                  }
                                                },
                                                [
                                                  _vm._v(
                                                    _vm._s(
                                                      _vm.loading ||
                                                        _vm.task_completed
                                                        ? _vm.button_text
                                                        : action.text
                                                    )
                                                  )
                                                ]
                                              )
                                        ]
                                      })
                                    ]
                                  : _vm._e()
                              ],
                              2
                            ),
                            _vm._v(" "),
                            notice.show_close_button && notice.close_url
                              ? _c(
                                  "a",
                                  {
                                    staticClass: "close-notice",
                                    attrs: { href: notice.close_url }
                                  },
                                  [
                                    _c("span", {
                                      staticClass: "dashicons dashicons-no-alt"
                                    })
                                  ]
                                )
                              : _vm._e(),
                            _vm._v(" "),
                            notice.show_close_button && notice.ajax_data
                              ? _c(
                                  "button",
                                  {
                                    staticClass: "close-notice",
                                    attrs: { disabled: _vm.loading },
                                    on: {
                                      click: function($event) {
                                        return _vm.hideNotice(notice, index)
                                      }
                                    }
                                  },
                                  [
                                    _c("span", {
                                      staticClass: "dashicons dashicons-no-alt"
                                    })
                                  ]
                                )
                              : _vm._e()
                          ]
                        )
                      ]
                    )
                  ]
                })
              ],
              2
            ),
            _vm._v(" "),
            _c(
              "div",
              {
                directives: [
                  {
                    name: "show",
                    rawName: "v-show",
                    value: _vm.notices.length > 1,
                    expression: "notices.length > 1"
                  }
                ],
                staticClass: "slide-notice"
              },
              [
                _c(
                  "span",
                  {
                    staticClass: "prev",
                    class: { active: _vm.current_notice > 1 },
                    on: {
                      click: function($event) {
                        return _vm.prevNotice()
                      }
                    }
                  },
                  [
                    _c(
                      "svg",
                      {
                        attrs: {
                          width: "8",
                          height: "13",
                          viewBox: "0 0 8 13",
                          fill: "none",
                          xmlns: "http://www.w3.org/2000/svg"
                        }
                      },
                      [
                        _c("path", {
                          attrs: {
                            d:
                              "M0.791129 6.10203L6.4798 0.415254C6.72942 0.166269 7.13383 0.166269 7.38408 0.415254C7.63369 0.664239 7.63369 1.06866 7.38408 1.31764L2.14663 6.5532L7.38345 11.7888C7.63306 12.0377 7.63306 12.4422 7.38345 12.6918C7.13383 12.9408 6.72879 12.9408 6.47917 12.6918L0.790498 7.005C0.544665 6.75859 0.544666 6.34781 0.791129 6.10203Z",
                            fill: "#DADFE4"
                          }
                        })
                      ]
                    )
                  ]
                ),
                _vm._v(" "),
                _c("span", { staticClass: "notice-count" }, [
                  _c(
                    "span",
                    {
                      staticClass: "current-notice",
                      class: { active: _vm.current_notice > 1 }
                    },
                    [_vm._v(_vm._s(_vm.current_notice))]
                  ),
                  _vm._v(" of "),
                  _c(
                    "span",
                    {
                      staticClass: "total-notice",
                      class: { active: _vm.current_notice < _vm.notices.length }
                    },
                    [_vm._v(_vm._s(_vm.notices.length))]
                  )
                ]),
                _vm._v(" "),
                _c(
                  "span",
                  {
                    staticClass: "next",
                    class: { active: _vm.current_notice < _vm.notices.length },
                    on: {
                      click: function($event) {
                        return _vm.nextNotice()
                      }
                    }
                  },
                  [
                    _c(
                      "svg",
                      {
                        attrs: {
                          width: "8",
                          height: "13",
                          viewBox: "0 0 8 13",
                          fill: "none",
                          xmlns: "http://www.w3.org/2000/svg"
                        }
                      },
                      [
                        _c("path", {
                          attrs: {
                            d:
                              "M7.43934 6.10203L1.75067 0.415254C1.50105 0.166269 1.09664 0.166269 0.846391 0.415254C0.596776 0.664239 0.596776 1.06866 0.846391 1.31764L6.08384 6.5532L0.847021 11.7888C0.597406 12.0377 0.597406 12.4422 0.847021 12.6918C1.09664 12.9408 1.50168 12.9408 1.7513 12.6918L7.43997 7.005C7.6858 6.75859 7.6858 6.34781 7.43934 6.10203Z",
                            fill: "#DADFE4"
                          }
                        })
                      ]
                    )
                  ]
                )
              ]
            )
          ],
          1
        )
      : _vm._e()
  ])
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-0f724387", esExports)
  }
}

/***/ }),
/* 19 */,
/* 20 */,
/* 21 */,
/* 22 */,
/* 23 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_UploadImage_vue__ = __webpack_require__(13);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_40b3524c_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_UploadImage_vue__ = __webpack_require__(34);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(33)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_UploadImage_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_40b3524c_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_UploadImage_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/UploadImage.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-40b3524c", Component.options)
  } else {
    hotAPI.reload("data-v-40b3524c", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 24 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_PasswordGenerator_vue__ = __webpack_require__(14);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_4084a478_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_PasswordGenerator_vue__ = __webpack_require__(35);
var disposed = false
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = null
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_PasswordGenerator_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_4084a478_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_PasswordGenerator_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/PasswordGenerator.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-4084a478", Component.options)
  } else {
    hotAPI.reload("data-v-4084a478", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 25 */,
/* 26 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Chart_vue__ = __webpack_require__(9);
/* unused harmony namespace reexport */
var disposed = false
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */
var __vue_template__ = null
/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = null
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Chart_vue__["a" /* default */],
  __vue_template__,
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/Chart.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-28c376de", Component.options)
  } else {
    hotAPI.reload("data-v-28c376de", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 27 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_ColorPicker_vue__ = __webpack_require__(10);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_01dc0d51_hasScoped_true_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_ColorPicker_vue__ = __webpack_require__(29);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(28)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-01dc0d51"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_ColorPicker_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_01dc0d51_hasScoped_true_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_ColorPicker_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/ColorPicker.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-01dc0d51", Component.options)
  } else {
    hotAPI.reload("data-v-01dc0d51", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 28 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 29 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    { staticClass: "color-picker-container" },
    [
      _c(
        "button",
        {
          staticClass: "button color-picker-button",
          style: { backgroundColor: _vm.value },
          attrs: { type: "button" },
          on: { click: _vm.toggleColorPicker }
        },
        [_c("span", [_vm._v(_vm._s(_vm.__("Select Color", "dokan-lite")))])]
      ),
      _vm._v(" "),
      _vm.showColorPicker && _vm.format === "hex"
        ? _c("input", {
            staticClass: "hex-input",
            attrs: { type: "text" },
            domProps: { value: _vm.value },
            on: {
              input: function($event) {
                return _vm.setHexColor($event.target.value)
              }
            }
          })
        : _vm._e(),
      _vm._v(" "),
      _vm.showColorPicker
        ? _c("div", { staticClass: "button-group" }, [
            _c(
              "button",
              {
                staticClass: "button button-small",
                attrs: { type: "button" },
                on: {
                  click: function($event) {
                    return _vm.updateColor({})
                  }
                }
              },
              [_vm._v(_vm._s(_vm.__("Clear", "dokan-lite")))]
            ),
            _vm._v(" "),
            _c(
              "button",
              {
                staticClass: "button button-small",
                attrs: { type: "button" },
                on: { click: _vm.toggleColorPicker }
              },
              [_vm._v(_vm._s(_vm.__("Close", "dokan-lite")))]
            )
          ])
        : _vm._e(),
      _vm._v(" "),
      _vm.showColorPicker
        ? _c("sketch", {
            attrs: {
              value: _vm.value,
              "preset-colors": _vm.presetColors,
              "disable-alpha": _vm.disableAlpha,
              "disable-fields": _vm.disableFields
            },
            on: { input: _vm.updateColor }
          })
        : _vm._e()
    ],
    1
  )
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-01dc0d51", esExports)
  }
}

/***/ }),
/* 30 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_VendorAccountFields_vue__ = __webpack_require__(11);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_2b13daea_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_VendorAccountFields_vue__ = __webpack_require__(36);
var disposed = false
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = null
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_VendorAccountFields_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_2b13daea_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_VendorAccountFields_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/pages/VendorAccountFields.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-2b13daea", Component.options)
  } else {
    hotAPI.reload("data-v-2b13daea", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 31 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 32 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("label", { staticClass: "switch tips" }, [
    _c("input", {
      staticClass: "toogle-checkbox",
      attrs: { type: "checkbox" },
      domProps: { checked: _vm.enabled, value: _vm.value },
      on: { change: _vm.trigger }
    }),
    _vm._v(" "),
    _c("span", { staticClass: "slider round" })
  ])
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-aa8ad7dc", esExports)
  }
}

/***/ }),
/* 33 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 34 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    { staticClass: "dokan-upload-image", on: { click: _vm.uploadImage } },
    [
      !_vm.showButton
        ? _c("img", { attrs: { src: _vm.image.src ? _vm.image.src : _vm.src } })
        : _vm._e(),
      _vm._v(" "),
      _vm.showButton
        ? _c(
            "button",
            {
              on: {
                click: function($event) {
                  $event.preventDefault()
                  return _vm.uploadImage.apply(null, arguments)
                }
              }
            },
            [_vm._v("\n        " + _vm._s(_vm.buttonLabel) + "\n    ")]
          )
        : _vm._e()
    ]
  )
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-40b3524c", esExports)
  }
}

/***/ }),
/* 35 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("div", { staticClass: "password-generator" }, [
    !_vm.hideGenerateButton
      ? _c(
          "button",
          {
            staticClass: "button button-secondary",
            on: {
              click: function($event) {
                $event.preventDefault()
                return _vm.generatePassword.apply(null, arguments)
              }
            }
          },
          [_vm._v("\n        " + _vm._s(_vm.title) + "\n    ")]
        )
      : _vm._e(),
    _vm._v(" "),
    _vm.showCancelButton
      ? _c(
          "button",
          {
            staticClass: "button regen-button",
            on: {
              click: function($event) {
                $event.preventDefault()
                return _vm.regenratePassword.apply(null, arguments)
              }
            }
          },
          [
            _c("span", { staticClass: "dashicons dashicons-controls-repeat" }),
            _vm._v("\n        " + _vm._s(_vm.regenrateTitle) + "\n    ")
          ]
        )
      : _vm._e(),
    _vm._v(" "),
    _vm.showCancelButton
      ? _c(
          "button",
          {
            staticClass: "button cancel-button",
            on: {
              click: function($event) {
                $event.preventDefault()
                return _vm.cancelButton.apply(null, arguments)
              }
            }
          },
          [_vm._v("\n        " + _vm._s(_vm.cancelTitle) + "\n    ")]
        )
      : _vm._e()
  ])
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-4084a478", esExports)
  }
}

/***/ }),
/* 36 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("form", { staticClass: "account-info" }, [
    _c("div", { staticClass: "content-header" }, [
      _vm._v(
        "\n        " + _vm._s(_vm.__("Account Info", "dokan-lite")) + "\n    "
      )
    ]),
    _vm._v(" "),
    _c("div", { staticClass: "content-body" }, [
      !_vm.getId()
        ? _c("div", { staticClass: "vendor-image" }, [
            _c("div", { staticClass: "picture" }, [
              _c("p", { staticClass: "picture-header" }, [
                _vm._v(_vm._s(_vm.__("Vendor Picture", "dokan-lite")))
              ]),
              _vm._v(" "),
              _c(
                "div",
                { staticClass: "profile-image" },
                [
                  _c("upload-image", {
                    attrs: { croppingWidth: 150, croppingHeight: 150 },
                    on: { uploadedImage: _vm.uploadGravatar }
                  })
                ],
                1
              ),
              _vm._v(" "),
              _c("p", {
                staticClass: "picture-footer",
                domProps: {
                  innerHTML: _vm._s(
                    _vm.sprintf(
                      _vm.__(
                        "You can change your profile picture on %s",
                        "dokan-lite"
                      ),
                      "<a href='https://gravatar.com/' target='_blank'>Gravatar</a>"
                    )
                  )
                }
              })
            ]),
            _vm._v(" "),
            _c(
              "div",
              {
                class: [
                  "picture banner",
                  { "has-banner": _vm.vendorInfo.banner_id }
                ]
              },
              [
                _c(
                  "div",
                  { staticClass: "banner-image" },
                  [
                    _c("upload-image", {
                      attrs: {
                        showButton: _vm.showButton,
                        buttonLabel: _vm.__("Upload Banner", "dokan-lite")
                      },
                      on: { uploadedImage: _vm.uploadBanner }
                    })
                  ],
                  1
                ),
                _vm._v(" "),
                _vm.showButton
                  ? _c("p", { staticClass: "picture-footer" }, [
                      _vm._v(_vm._s(_vm.getUploadBannerText()))
                    ])
                  : _vm._e()
              ]
            )
          ])
        : _vm._e(),
      _vm._v(" "),
      _c(
        "div",
        { staticClass: "dokan-form-group" },
        [
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "first-name" } }, [
              _vm._v(_vm._s(_vm.__("First Name", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.first_name,
                  expression: "vendorInfo.first_name"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                type: "email",
                id: "first-name",
                placeholder: _vm.__("First Name", "dokan-lite")
              },
              domProps: { value: _vm.vendorInfo.first_name },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(_vm.vendorInfo, "first_name", $event.target.value)
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "last-name" } }, [
              _vm._v(_vm._s(_vm.__("Last Name", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.last_name,
                  expression: "vendorInfo.last_name"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                type: "email",
                id: "last-name",
                placeholder: _vm.__("Last Name", "dokan-lite")
              },
              domProps: { value: _vm.vendorInfo.last_name },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(_vm.vendorInfo, "last_name", $event.target.value)
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "store-name" } }, [
              _vm._v(_vm._s(_vm.__("Store Name", "dokan-lite")))
            ]),
            _vm._v(" "),
            !_vm.getId()
              ? _c("span", { staticClass: "required-field" }, [_vm._v("*")])
              : _vm._e(),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.store_name,
                  expression: "vendorInfo.store_name"
                }
              ],
              class: {
                "dokan-form-input": true,
                "has-error": _vm.getError("store_name")
              },
              attrs: {
                type: "text",
                id: "store-name",
                placeholder: _vm.getError("store_name")
                  ? _vm.__("Store Name is required", "dokan-lite")
                  : _vm.__("Store Name", "dokan-lite")
              },
              domProps: { value: _vm.vendorInfo.store_name },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(_vm.vendorInfo, "store_name", $event.target.value)
                }
              }
            })
          ]),
          _vm._v(" "),
          !_vm.getId()
            ? _c("div", { staticClass: "column" }, [
                _c("label", { attrs: { for: "user-nicename" } }, [
                  _vm._v(_vm._s(_vm.__("Store URL", "dokan-lite")))
                ]),
                _vm._v(" "),
                _c("input", {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.vendorInfo.user_nicename,
                      expression: "vendorInfo.user_nicename"
                    }
                  ],
                  staticClass: "dokan-form-input",
                  attrs: {
                    type: "text",
                    id: "user-nicename",
                    placeholder: _vm.__("Store Url", "dokan-lite")
                  },
                  domProps: { value: _vm.vendorInfo.user_nicename },
                  on: {
                    input: function($event) {
                      if ($event.target.composing) {
                        return
                      }
                      _vm.$set(
                        _vm.vendorInfo,
                        "user_nicename",
                        $event.target.value
                      )
                    }
                  }
                }),
                _vm._v(" "),
                _c("div", { staticClass: "store-avaibility-info" }, [
                  _vm.showStoreUrl
                    ? _c("p", { staticClass: "store-url" }, [
                        _vm._v(_vm._s(_vm.storeUrl))
                      ])
                    : _c("p", { staticClass: "store-url" }, [
                        _vm._v(_vm._s(_vm.otherStoreUrl))
                      ]),
                  _vm._v(" "),
                  _c(
                    "span",
                    {
                      class: {
                        "is-available": _vm.storeAvailable,
                        "not-available": !_vm.storeAvailable
                      }
                    },
                    [_vm._v(_vm._s(_vm.storeAvailabilityText))]
                  )
                ])
              ])
            : _vm._e(),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "store-phone" } }, [
              _vm._v(_vm._s(_vm.__("Phone Number", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.phone,
                  expression: "vendorInfo.phone"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                type: "number",
                id: "store-phone",
                placeholder: _vm.__("123456789", "dokan-lite")
              },
              domProps: { value: _vm.vendorInfo.phone },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(_vm.vendorInfo, "phone", $event.target.value)
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "store-email" } }, [
              _vm._v(_vm._s(_vm.__("Email", "dokan-lite")))
            ]),
            _vm._v(" "),
            !_vm.getId()
              ? _c("span", { staticClass: "required-field" }, [_vm._v("*")])
              : _vm._e(),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.email,
                  expression: "vendorInfo.email"
                }
              ],
              class: {
                "dokan-form-input": true,
                "has-error": _vm.getError("email")
              },
              attrs: {
                type: "email",
                id: "store-email",
                placeholder: _vm.getError("email")
                  ? _vm.__("Email is required", "dokan-lite")
                  : _vm.__("store@email.com", "dokan-lite")
              },
              domProps: { value: _vm.vendorInfo.email },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(_vm.vendorInfo, "email", $event.target.value)
                }
              }
            }),
            _vm._v(" "),
            _c("div", { staticClass: "store-avaibility-info" }, [
              _c(
                "span",
                {
                  class: {
                    "is-available": _vm.emailAvailable,
                    "not-available": !_vm.emailAvailable
                  }
                },
                [_vm._v(_vm._s(_vm.emailAvailabilityText))]
              )
            ])
          ]),
          _vm._v(" "),
          !_vm.getId()
            ? [
                _c("div", { staticClass: "column" }, [
                  _c("label", { attrs: { for: "user-login" } }, [
                    _vm._v(_vm._s(_vm.__("Username", "dokan-lite")))
                  ]),
                  _c("span", { staticClass: "required-field" }, [_vm._v("*")]),
                  _vm._v(" "),
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.vendorInfo.user_login,
                        expression: "vendorInfo.user_login"
                      }
                    ],
                    staticClass: "dokan-form-input",
                    class: {
                      "dokan-form-input": true,
                      "has-error": _vm.getError("user_login")
                    },
                    attrs: {
                      type: "text",
                      id: "user-login",
                      placeholder: _vm.getError("user_login")
                        ? _vm.__("Username is required", "dokan-lite")
                        : _vm.__("Username", "dokan-lite")
                    },
                    domProps: { value: _vm.vendorInfo.user_login },
                    on: {
                      input: function($event) {
                        if ($event.target.composing) {
                          return
                        }
                        _vm.$set(
                          _vm.vendorInfo,
                          "user_login",
                          $event.target.value
                        )
                      }
                    }
                  }),
                  _vm._v(" "),
                  _c("div", { staticClass: "store-avaibility-info" }, [
                    _c(
                      "span",
                      {
                        class: {
                          "is-available": _vm.userNameAvailable,
                          "not-available": !_vm.userNameAvailable
                        }
                      },
                      [_vm._v(_vm._s(_vm.userNameAvailabilityText))]
                    )
                  ]),
                  _vm._v(" "),
                  _c(
                    "div",
                    { staticClass: "checkbox-left notify-vendor" },
                    [
                      _c("switches", {
                        attrs: { enabled: true, value: "notify_vendor" },
                        on: { input: _vm.sendEmail }
                      }),
                      _vm._v(" "),
                      _c("span", { staticClass: "desc" }, [
                        _vm._v(
                          _vm._s(
                            _vm.__(
                              "Send the vendor an email about their account.",
                              "dokan-lite"
                            )
                          )
                        )
                      ])
                    ],
                    1
                  )
                ]),
                _vm._v(" "),
                _c(
                  "div",
                  { staticClass: "column" },
                  [
                    _c("label", { attrs: { for: "store-password" } }, [
                      _vm._v(_vm._s(_vm.__("Password", "dokan-lite")))
                    ]),
                    _vm._v(" "),
                    _vm.showPassword
                      ? _c("input", {
                          directives: [
                            {
                              name: "model",
                              rawName: "v-model",
                              value: _vm.vendorInfo.user_pass,
                              expression: "vendorInfo.user_pass"
                            }
                          ],
                          staticClass: "dokan-form-input",
                          attrs: {
                            id: "store-password",
                            type: "text",
                            placeholder: "********"
                          },
                          domProps: { value: _vm.vendorInfo.user_pass },
                          on: {
                            input: function($event) {
                              if ($event.target.composing) {
                                return
                              }
                              _vm.$set(
                                _vm.vendorInfo,
                                "user_pass",
                                $event.target.value
                              )
                            }
                          }
                        })
                      : _vm._e(),
                    _vm._v(" "),
                    _c("password-generator", {
                      attrs: {
                        title: _vm.__("Generate Password", "dokan-lite")
                      },
                      on: { passwordGenerated: _vm.setPassword }
                    })
                  ],
                  1
                )
              ]
            : _vm._e(),
          _vm._v(" "),
          _vm._l(_vm.getAccountFields, function(component, index) {
            return _c(component, {
              key: index,
              tag: "component",
              attrs: { vendorInfo: _vm.vendorInfo }
            })
          })
        ],
        2
      )
    ])
  ])
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-2b13daea", esExports)
  }
}

/***/ }),
/* 37 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_VendorAddressFields_vue__ = __webpack_require__(15);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_9504c01e_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_VendorAddressFields_vue__ = __webpack_require__(39);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(38)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_VendorAddressFields_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_9504c01e_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_VendorAddressFields_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/pages/VendorAddressFields.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-9504c01e", Component.options)
  } else {
    hotAPI.reload("data-v-9504c01e", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 38 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 39 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("div", { staticClass: "account-info" }, [
    _c("div", { staticClass: "content-header" }, [
      _vm._v("\n        " + _vm._s(_vm.__("Address", "dokan-lite")) + "\n    ")
    ]),
    _vm._v(" "),
    _c("div", { staticClass: "content-body" }, [
      _c(
        "div",
        { staticClass: "dokan-form-group" },
        [
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "street-1" } }, [
              _vm._v(_vm._s(_vm.__("Street 1", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.address.street_1,
                  expression: "vendorInfo.address.street_1"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                type: "text",
                id: "street-1",
                placeholder: _vm.__("Street 1", "dokan-lite")
              },
              domProps: { value: _vm.vendorInfo.address.street_1 },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(
                    _vm.vendorInfo.address,
                    "street_1",
                    $event.target.value
                  )
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "street-2" } }, [
              _vm._v(_vm._s(_vm.__("Street 2", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.address.street_2,
                  expression: "vendorInfo.address.street_2"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                type: "text",
                id: "street-2",
                placeholder: _vm.__("Street 2", "dokan-lite")
              },
              domProps: { value: _vm.vendorInfo.address.street_2 },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(
                    _vm.vendorInfo.address,
                    "street_2",
                    $event.target.value
                  )
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "city" } }, [
              _vm._v(_vm._s(_vm.__("City", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.address.city,
                  expression: "vendorInfo.address.city"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                type: "text",
                id: "city",
                placeholder: _vm.__("City", "dokan-lite")
              },
              domProps: { value: _vm.vendorInfo.address.city },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(_vm.vendorInfo.address, "city", $event.target.value)
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "zip" } }, [
              _vm._v(_vm._s(_vm.__("Zip", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.address.zip,
                  expression: "vendorInfo.address.zip"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                type: "text",
                id: "zip",
                placeholder: _vm.__("Zip", "dokan-lite")
              },
              domProps: { value: _vm.vendorInfo.address.zip },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(_vm.vendorInfo.address, "zip", $event.target.value)
                }
              }
            })
          ]),
          _vm._v(" "),
          _c(
            "div",
            { staticClass: "address-multiselect" },
            [
              _c("label", { attrs: { for: "country" } }, [
                _vm._v(_vm._s(_vm.__("Country", "dokan-lite")))
              ]),
              _vm._v(" "),
              _c("Multiselect", {
                attrs: {
                  id: "country",
                  options: _vm.countries,
                  multiselect: false,
                  label: "name",
                  "track-by": "name",
                  showLabels: false,
                  placeholder: _vm.__("Select Country", "dokan-lite")
                },
                on: { input: _vm.saveCountry },
                model: {
                  value: _vm.selectedCountry,
                  callback: function($$v) {
                    _vm.selectedCountry = $$v
                  },
                  expression: "selectedCountry"
                }
              })
            ],
            1
          ),
          _vm._v(" "),
          _c(
            "div",
            { staticClass: "address-multiselect" },
            [
              _c("label", { attrs: { for: "state" } }, [
                _vm._v(_vm._s(_vm.__("State", "dokan-lite")))
              ]),
              _vm._v(" "),
              _vm.getStatesFromCountryCode(_vm.selectedCode).length < 1
                ? [
                    _c("input", {
                      directives: [
                        {
                          name: "model",
                          rawName: "v-model",
                          value: _vm.vendorInfo.address.state,
                          expression: "vendorInfo.address.state"
                        }
                      ],
                      staticClass: "dokan-form-input",
                      attrs: {
                        id: "state",
                        type: "text",
                        placeholder: _vm.__("State", "dokan-lite")
                      },
                      domProps: { value: _vm.vendorInfo.address.state },
                      on: {
                        input: function($event) {
                          if ($event.target.composing) {
                            return
                          }
                          _vm.$set(
                            _vm.vendorInfo.address,
                            "state",
                            $event.target.value
                          )
                        }
                      }
                    })
                  ]
                : [
                    _c("Multiselect", {
                      attrs: {
                        id: "state",
                        options: _vm.getStatesFromCountryCode(_vm.selectedCode),
                        multiselect: false,
                        showLabels: false,
                        label: "name",
                        "track-by": "name",
                        placeholder: _vm.__("Select State", "dokan-lite")
                      },
                      on: { input: _vm.saveState },
                      model: {
                        value: _vm.selectedState,
                        callback: function($$v) {
                          _vm.selectedState = $$v
                        },
                        expression: "selectedState"
                      }
                    })
                  ]
            ],
            2
          ),
          _vm._v(" "),
          _vm._l(_vm.getAddressFields, function(component, index) {
            return _c(component, {
              key: index,
              tag: "component",
              attrs: { vendorInfo: _vm.vendorInfo }
            })
          })
        ],
        2
      )
    ])
  ])
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-9504c01e", esExports)
  }
}

/***/ }),
/* 40 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_VendorPaymentFields_vue__ = __webpack_require__(16);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_2ed34783_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_VendorPaymentFields_vue__ = __webpack_require__(42);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(41)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_VendorPaymentFields_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_2ed34783_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_VendorPaymentFields_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/pages/VendorPaymentFields.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-2ed34783", Component.options)
  } else {
    hotAPI.reload("data-v-2ed34783", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 41 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 42 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    { class: { "payment-info": true, "edit-mode": _vm.getId() } },
    [
      _c("div", { staticClass: "content-header" }, [
        _vm._v(
          "\n        " +
            _vm._s(_vm.__("Payment Options", "dokan-lite")) +
            "\n    "
        )
      ]),
      _vm._v(" "),
      _c(
        "div",
        { staticClass: "content-body" },
        [
          _c(
            "div",
            { staticClass: "dokan-form-group" },
            [
              _c("div", { staticClass: "column" }, [
                _c("label", { attrs: { for: "account-name" } }, [
                  _vm._v(_vm._s(_vm.__("Account Name", "dokan-lite")))
                ]),
                _vm._v(" "),
                _c("input", {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.vendorInfo.payment.bank.ac_name,
                      expression: "vendorInfo.payment.bank.ac_name"
                    }
                  ],
                  staticClass: "dokan-form-input",
                  attrs: {
                    type: "text",
                    id: "account-name",
                    placeholder: _vm.__("Account Name", "dokan-lite")
                  },
                  domProps: { value: _vm.vendorInfo.payment.bank.ac_name },
                  on: {
                    input: function($event) {
                      if ($event.target.composing) {
                        return
                      }
                      _vm.$set(
                        _vm.vendorInfo.payment.bank,
                        "ac_name",
                        $event.target.value
                      )
                    }
                  }
                })
              ]),
              _vm._v(" "),
              _c("div", { staticClass: "column" }, [
                _c("label", { attrs: { for: "account-number" } }, [
                  _vm._v(_vm._s(_vm.__("Account Number", "dokan-lite")))
                ]),
                _vm._v(" "),
                _c("input", {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.vendorInfo.payment.bank.ac_number,
                      expression: "vendorInfo.payment.bank.ac_number"
                    }
                  ],
                  staticClass: "dokan-form-input",
                  attrs: {
                    type: "text",
                    id: "account-number",
                    placeholder: _vm.__("1233456789", "dokan-lite")
                  },
                  domProps: { value: _vm.vendorInfo.payment.bank.ac_number },
                  on: {
                    input: function($event) {
                      if ($event.target.composing) {
                        return
                      }
                      _vm.$set(
                        _vm.vendorInfo.payment.bank,
                        "ac_number",
                        $event.target.value
                      )
                    }
                  }
                })
              ]),
              _vm._v(" "),
              _c("div", { staticClass: "column" }, [
                _c("label", { attrs: { for: "bank-name" } }, [
                  _vm._v(_vm._s(_vm.__("Bank Name", "dokan-lite")))
                ]),
                _vm._v(" "),
                _c("input", {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.vendorInfo.payment.bank.bank_name,
                      expression: "vendorInfo.payment.bank.bank_name"
                    }
                  ],
                  staticClass: "dokan-form-input",
                  attrs: {
                    type: "text",
                    id: "bank-name",
                    placeholder: _vm.__("Bank Name", "dokan-lite")
                  },
                  domProps: { value: _vm.vendorInfo.payment.bank.bank_name },
                  on: {
                    input: function($event) {
                      if ($event.target.composing) {
                        return
                      }
                      _vm.$set(
                        _vm.vendorInfo.payment.bank,
                        "bank_name",
                        $event.target.value
                      )
                    }
                  }
                })
              ]),
              _vm._v(" "),
              _c("div", { staticClass: "column" }, [
                _c("label", { attrs: { for: "bank-address" } }, [
                  _vm._v(_vm._s(_vm.__("Bank Address", "dokan-lite")))
                ]),
                _vm._v(" "),
                _c("input", {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.vendorInfo.payment.bank.bank_addr,
                      expression: "vendorInfo.payment.bank.bank_addr"
                    }
                  ],
                  staticClass: "dokan-form-input",
                  attrs: {
                    type: "text",
                    id: "bank-address",
                    placeholder: _vm.__("Bank Address", "dokan-lite")
                  },
                  domProps: { value: _vm.vendorInfo.payment.bank.bank_addr },
                  on: {
                    input: function($event) {
                      if ($event.target.composing) {
                        return
                      }
                      _vm.$set(
                        _vm.vendorInfo.payment.bank,
                        "bank_addr",
                        $event.target.value
                      )
                    }
                  }
                })
              ]),
              _vm._v(" "),
              _c("div", { staticClass: "column" }, [
                _c("label", { attrs: { for: "routing-number" } }, [
                  _vm._v(_vm._s(_vm.__("Routing Number", "dokan-lite")))
                ]),
                _vm._v(" "),
                _c("input", {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.vendorInfo.payment.bank.routing_number,
                      expression: "vendorInfo.payment.bank.routing_number"
                    }
                  ],
                  staticClass: "dokan-form-input",
                  attrs: {
                    type: "text",
                    id: "routing-number",
                    placeholder: _vm.__("123456789", "dokan-lite")
                  },
                  domProps: {
                    value: _vm.vendorInfo.payment.bank.routing_number
                  },
                  on: {
                    input: function($event) {
                      if ($event.target.composing) {
                        return
                      }
                      _vm.$set(
                        _vm.vendorInfo.payment.bank,
                        "routing_number",
                        $event.target.value
                      )
                    }
                  }
                })
              ]),
              _vm._v(" "),
              _c("div", { staticClass: "column" }, [
                _c("label", { attrs: { for: "iban" } }, [
                  _vm._v(_vm._s(_vm.__("IBAN", "dokan-lite")))
                ]),
                _vm._v(" "),
                _c("input", {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.vendorInfo.payment.bank.iban,
                      expression: "vendorInfo.payment.bank.iban"
                    }
                  ],
                  staticClass: "dokan-form-input",
                  attrs: {
                    type: "text",
                    id: "iban",
                    placeholder: _vm.__("123456789", "dokan-lite")
                  },
                  domProps: { value: _vm.vendorInfo.payment.bank.iban },
                  on: {
                    input: function($event) {
                      if ($event.target.composing) {
                        return
                      }
                      _vm.$set(
                        _vm.vendorInfo.payment.bank,
                        "iban",
                        $event.target.value
                      )
                    }
                  }
                })
              ]),
              _vm._v(" "),
              _c("div", { staticClass: "column" }, [
                _c("label", { attrs: { for: "swift" } }, [
                  _vm._v(_vm._s(_vm.__("Swift", "dokan-lite")))
                ]),
                _vm._v(" "),
                _c("input", {
                  directives: [
                    {
                      name: "model",
                      rawName: "v-model",
                      value: _vm.vendorInfo.payment.bank.swift,
                      expression: "vendorInfo.payment.bank.swift"
                    }
                  ],
                  staticClass: "dokan-form-input",
                  attrs: {
                    type: "text",
                    id: "swift",
                    placeholder: _vm.__("123456789", "dokan-lite")
                  },
                  domProps: { value: _vm.vendorInfo.payment.bank.swift },
                  on: {
                    input: function($event) {
                      if ($event.target.composing) {
                        return
                      }
                      _vm.$set(
                        _vm.vendorInfo.payment.bank,
                        "swift",
                        $event.target.value
                      )
                    }
                  }
                })
              ]),
              _vm._v(" "),
              _vm._l(_vm.getBankFields, function(component, index) {
                return _c(component, {
                  key: index,
                  tag: "component",
                  attrs: { vendorInfo: _vm.vendorInfo }
                })
              })
            ],
            2
          ),
          _vm._v(" "),
          _c(
            "div",
            { staticClass: "dokan-form-group" },
            [
              _c(
                "div",
                {
                  class: { column: _vm.getId(), "checkbox-group": !_vm.getId() }
                },
                [
                  _c("label", { attrs: { for: "paypal-email" } }, [
                    _vm._v(_vm._s(_vm.__("PayPal Email", "dokan-lite")))
                  ]),
                  _vm._v(" "),
                  _c("input", {
                    directives: [
                      {
                        name: "model",
                        rawName: "v-model",
                        value: _vm.vendorInfo.payment.paypal.email,
                        expression: "vendorInfo.payment.paypal.email"
                      }
                    ],
                    staticClass: "dokan-form-input",
                    attrs: {
                      type: "email",
                      id: "paypal-email",
                      placeholder: _vm.__("store@email.com", "dokan-lite")
                    },
                    domProps: { value: _vm.vendorInfo.payment.paypal.email },
                    on: {
                      input: function($event) {
                        if ($event.target.composing) {
                          return
                        }
                        _vm.$set(
                          _vm.vendorInfo.payment.paypal,
                          "email",
                          $event.target.value
                        )
                      }
                    }
                  })
                ]
              ),
              _vm._v(" "),
              _vm.getId()
                ? [
                    _c("div", { staticClass: "column" }, [
                      _c(
                        "div",
                        { staticClass: "column" },
                        [
                          _c("label", { attrs: { for: "commission-type" } }, [
                            _vm._v(
                              _vm._s(
                                _vm.__("Admin Commission Type", "dokan-lite")
                              )
                            )
                          ]),
                          _vm._v(" "),
                          _c("Multiselect", {
                            attrs: {
                              id: "commission-type",
                              options: _vm.commissionTypes,
                              "track-by": "name",
                              label: "label",
                              "allow-empty": false,
                              multiselect: false,
                              searchable: false,
                              showLabels: false
                            },
                            on: { input: _vm.saveCommissionType },
                            model: {
                              value: _vm.selectedCommissionType,
                              callback: function($$v) {
                                _vm.selectedCommissionType = $$v
                              },
                              expression: "selectedCommissionType"
                            }
                          })
                        ],
                        1
                      )
                    ]),
                    _vm._v(" "),
                    "combine" === _vm.selectedCommissionType.name
                      ? _c(
                          "div",
                          { staticClass: "column combine-commission" },
                          [
                            _c("label", [
                              _vm._v(
                                _vm._s(_vm.__("Admin Commission", "dokan-lite"))
                              )
                            ]),
                            _vm._v(" "),
                            _c(
                              "div",
                              { staticClass: "combine-commission-field" },
                              [
                                _c("input", {
                                  directives: [
                                    {
                                      name: "model",
                                      rawName: "v-model",
                                      value: _vm.vendorInfo.admin_commission,
                                      expression: "vendorInfo.admin_commission"
                                    }
                                  ],
                                  staticClass:
                                    "wc_input_decimal dokan-form-input percent_fee",
                                  attrs: { type: "text" },
                                  domProps: {
                                    value: _vm.vendorInfo.admin_commission
                                  },
                                  on: {
                                    input: function($event) {
                                      if ($event.target.composing) {
                                        return
                                      }
                                      _vm.$set(
                                        _vm.vendorInfo,
                                        "admin_commission",
                                        $event.target.value
                                      )
                                    }
                                  }
                                }),
                                _vm._v(
                                  "\n                        " +
                                    _vm._s("%    +") +
                                    "\n                        "
                                ),
                                _c("input", {
                                  directives: [
                                    {
                                      name: "model",
                                      rawName: "v-model",
                                      value:
                                        _vm.vendorInfo.admin_additional_fee,
                                      expression:
                                        "vendorInfo.admin_additional_fee"
                                    }
                                  ],
                                  staticClass:
                                    "wc_input_price dokan-form-input fixed_fee",
                                  attrs: { type: "text" },
                                  domProps: {
                                    value: _vm.vendorInfo.admin_additional_fee
                                  },
                                  on: {
                                    input: function($event) {
                                      if ($event.target.composing) {
                                        return
                                      }
                                      _vm.$set(
                                        _vm.vendorInfo,
                                        "admin_additional_fee",
                                        $event.target.value
                                      )
                                    }
                                  }
                                })
                              ]
                            )
                          ]
                        )
                      : _c("div", { staticClass: "column" }, [
                          _c("label", [
                            _vm._v(
                              _vm._s(_vm.__("Admin Commission", "dokan-lite"))
                            )
                          ]),
                          _vm._v(" "),
                          _c("input", {
                            directives: [
                              {
                                name: "model",
                                rawName: "v-model",
                                value: _vm.vendorInfo.admin_commission,
                                expression: "vendorInfo.admin_commission"
                              }
                            ],
                            staticClass: "dokan-form-input",
                            class: {
                              wc_input_price:
                                _vm.selectedCommissionType.name == "flat",
                              wc_input_decimal:
                                _vm.selectedCommissionType.name != "flat"
                            },
                            attrs: { type: "text" },
                            domProps: {
                              value: _vm.vendorInfo.admin_commission
                            },
                            on: {
                              input: function($event) {
                                if ($event.target.composing) {
                                  return
                                }
                                _vm.$set(
                                  _vm.vendorInfo,
                                  "admin_commission",
                                  $event.target.value
                                )
                              }
                            }
                          })
                        ])
                  ]
                : _vm._e(),
              _vm._v(" "),
              _c("div", { staticClass: "checkbox-group" }, [
                _c(
                  "div",
                  { staticClass: "checkbox-left" },
                  [
                    _c("switches", {
                      attrs: { enabled: _vm.enabled, value: "enabled" },
                      on: { input: _vm.setValue }
                    }),
                    _vm._v(" "),
                    _c("span", { staticClass: "desc" }, [
                      _vm._v(_vm._s(_vm.__("Enable Selling", "dokan-lite")))
                    ])
                  ],
                  1
                )
              ]),
              _vm._v(" "),
              _c("div", { staticClass: "checkbox-group" }, [
                _c(
                  "div",
                  { staticClass: "checkbox-left" },
                  [
                    _c("switches", {
                      attrs: { enabled: _vm.trusted, value: "trusted" },
                      on: { input: _vm.setValue }
                    }),
                    _vm._v(" "),
                    _c("span", { staticClass: "desc" }, [
                      _vm._v(
                        _vm._s(_vm.__("Publish Product Directly", "dokan-lite"))
                      )
                    ])
                  ],
                  1
                )
              ]),
              _vm._v(" "),
              _c("div", { staticClass: "checkbox-group" }, [
                _c(
                  "div",
                  { staticClass: "checkbox-left" },
                  [
                    _c("switches", {
                      attrs: { enabled: _vm.featured, value: "featured" },
                      on: { input: _vm.setValue }
                    }),
                    _vm._v(" "),
                    _c("span", { staticClass: "desc" }, [
                      _vm._v(
                        _vm._s(_vm.__("Make Vendor Featured", "dokan-lite"))
                      )
                    ])
                  ],
                  1
                )
              ])
            ],
            2
          ),
          _vm._v(" "),
          _vm._l(_vm.getPyamentFields, function(component, index) {
            return _c(component, {
              key: index,
              tag: "component",
              attrs: { vendorInfo: _vm.vendorInfo }
            })
          })
        ],
        2
      )
    ]
  )
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-2ed34783", esExports)
  }
}

/***/ }),
/* 43 */,
/* 44 */,
/* 45 */,
/* 46 */,
/* 47 */,
/* 48 */,
/* 49 */,
/* 50 */,
/* 51 */,
/* 52 */,
/* 53 */,
/* 54 */,
/* 55 */,
/* 56 */,
/* 57 */,
/* 58 */,
/* 59 */,
/* 60 */,
/* 61 */,
/* 62 */,
/* 63 */,
/* 64 */,
/* 65 */,
/* 66 */,
/* 67 */,
/* 68 */,
/* 69 */,
/* 70 */,
/* 71 */,
/* 72 */,
/* 73 */,
/* 74 */,
/* 75 */,
/* 76 */,
/* 77 */,
/* 78 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'Postbox',
  props: {
    title: {
      type: String,
      required: true,
      default: ''
    },
    extraClass: {
      type: String,
      default: null
    }
  },
  data: function data() {
    return {
      showing: true
    };
  }
});

/***/ }),
/* 79 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'Loading',
  data: function data() {
    return {};
  }
});

/***/ }),
/* 80 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'Modal',
  props: {
    footer: {
      type: Boolean,
      required: false,
      default: true
    },
    width: {
      type: String,
      required: false,
      default: '500px'
    },
    height: {
      type: String,
      required: false,
      default: 'auto'
    },
    title: {
      type: String,
      required: true,
      default: ''
    }
  },
  data: function data() {
    return {};
  }
});

/***/ }),
/* 81 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  props: {
    value: {
      type: String,
      required: true
    },
    shortcodes: {
      type: Object,
      required: false
    }
  },
  data: function data() {
    return {
      editorId: this._uid,
      fileFrame: null
    };
  },
  mounted: function mounted() {
    var vm = this;
    window.tinymce.init({
      selector: "#dokan-tinymce-".concat(this.editorId),
      branding: false,
      height: 200,
      menubar: false,
      convert_urls: false,
      theme: 'modern',
      skin: 'lightgray',
      fontsize_formats: '10px 11px 13px 14px 16px 18px 22px 25px 30px 36px 40px 45px 50px 60px 65px 70px 75px 80px',
      font_formats: 'Arial=arial,helvetica,sans-serif;' + 'Comic Sans MS=comic sans ms,sans-serif;' + 'Courier New=courier new,courier;' + 'Georgia=georgia,palatino;' + 'Lucida=Lucida Sans Unicode, Lucida Grande, sans-serif;' + 'Tahoma=tahoma,arial,helvetica,sans-serif;' + 'Times New Roman=times new roman,times;' + 'Trebuchet MS=trebuchet ms,geneva;' + 'Verdana=verdana,geneva;',
      plugins: 'textcolor colorpicker wplink wordpress code hr wpeditimage',
      toolbar: ['shortcodes bold italic underline bullist numlist alignleft aligncenter alignjustify alignright link image wp_adv', 'formatselect forecolor backcolor blockquote hr code fontselect fontsizeselect removeformat undo redo'],
      setup: function setup(editor) {
        var shortcodeMenuItems = [];

        _.forEach(vm.shortcodes, function (shortcodeObj, shortcodeType) {
          shortcodeMenuItems.push({
            text: shortcodeObj.title,
            classes: 'menu-section-title'
          });

          _.forEach(shortcodeObj.codes, function (codeObj, shortcode) {
            shortcodeMenuItems.push({
              text: codeObj.title,
              onclick: function onclick() {
                var code = "[".concat(shortcodeType, ":").concat(shortcode, "]");

                if (codeObj.default) {
                  code = "[".concat(shortcodeType, ":").concat(shortcode, " default=\"").concat(codeObj.default, "\"]");
                }

                if (codeObj.text) {
                  code = "[".concat(shortcodeType, ":").concat(shortcode, " text=\"").concat(codeObj.text, "\"]");
                }

                if (codeObj.plainText) {
                  code = codeObj.text;
                }

                editor.insertContent(code);
              }
            });
          });
        }); // editor.addButton('shortcodes', {
        //     type: 'menubutton',
        //     icon: 'shortcode',
        //     tooltip: 'Shortcodes',
        //     menu: shortcodeMenuItems
        // });


        editor.addButton('image', {
          icon: 'image',
          onclick: function onclick() {
            vm.browseImage(editor);
          }
        }); // editor change triggers

        editor.on('change keyup NodeChange', function () {
          vm.$emit('input', editor.getContent());
        });
      }
    });
  },
  methods: {
    browseImage: function browseImage(editor) {
      var vm = this;
      var selectedFile = {
        id: 0,
        url: '',
        type: ''
      };

      if (vm.fileFrame) {
        vm.fileFrame.open();
        return;
      }

      var fileStates = [new wp.media.controller.Library({
        library: wp.media.query(),
        multiple: false,
        title: this.__('Select an image', 'dokan-lite'),
        priority: 20,
        filterable: 'uploaded'
      })];
      vm.fileFrame = wp.media({
        title: this.__('Select an image', 'dokan-lite'),
        library: {
          type: ''
        },
        button: {
          text: this.__('Select an image', 'dokan-lite')
        },
        multiple: false,
        states: fileStates
      });
      vm.fileFrame.on('select', function () {
        var selection = vm.fileFrame.state().get('selection');
        selection.map(function (image) {
          image = image.toJSON();

          if (image.id) {
            selectedFile.id = image.id;
          }

          if (image.url) {
            selectedFile.url = image.url;
          }

          if (image.type) {
            selectedFile.type = image.type;
          }

          vm.insertImage(editor, selectedFile);
          return null;
        });
      });
      vm.fileFrame.on('ready', function () {
        vm.fileFrame.uploader.options.uploader.params = {
          type: 'dokan-image-uploader'
        };
      });
      vm.fileFrame.open();
    },
    insertImage: function insertImage(editor, image) {
      if (!image.id || image.type !== 'image') {
        this.alert({
          type: 'error',
          text: this.__('Please select an image,', 'dokan-lite')
        });
        return;
      }

      var img = "<img src=\"".concat(image.url, "\" alt=\"").concat(image.alt, "\" title=\"").concat(image.title, "\" style=\"max-width: 100%; height: auto;\">");
      editor.insertContent(img);
    }
  }
});

/***/ }),
/* 82 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  props: ['amount'],
  methods: {
    formattedPrice: function formattedPrice(value) {
      return accounting.formatMoney(value, dokan.currency);
    }
  }
});

/***/ }),
/* 83 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_debounce__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_debounce___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_debounce__);
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'LazyInput',
  props: {
    value: {
      type: String,
      required: true,
      default: ''
    },
    type: {
      type: String,
      required: false,
      default: 'text'
    },
    placeholder: {
      type: String,
      required: false,
      default: ''
    }
  },
  data: function data() {
    return {
      delay: 500,
      debouncer: null
    };
  },
  methods: {
    updateValue: function updateValue(value) {
      var vm = this;

      if (vm.debouncer) {
        vm.debouncer.clear();
      }

      vm.debouncer = Object(__WEBPACK_IMPORTED_MODULE_0_debounce__["debounce"])(function () {
        vm.triggerInput(value);
      }, vm.delay);
      vm.debouncer();
    },
    focus: function focus() {
      this.$emit('focus');
    },
    blur: function blur() {
      this.$emit('blur');
    },
    triggerInput: function triggerInput(value) {
      this.$emit('input', value);
    }
  }
});

/***/ }),
/* 84 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  props: {
    value: {
      type: Number,
      default: 0
    },
    hidden: {
      type: Boolean,
      default: false
    },
    bgColor: {
      type: String,
      default: 'defaultBg'
    },
    fgColor: {
      type: String,
      default: 'defaultFg'
    }
  }
});

/***/ }),
/* 85 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_debounce__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_debounce___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_debounce__);
//
//
//
//
//
//

/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'Search',
  props: {
    title: {
      type: String,
      default: 'Search'
    }
  },
  data: function data() {
    return {
      delay: 500,
      searchItems: ''
    };
  },
  watch: {
    searchItems: function searchItems() {
      this.makeDelay();
    }
  },
  created: function created() {
    this.makeDelay = Object(__WEBPACK_IMPORTED_MODULE_0_debounce__["debounce"])(this.doSearch, this.delay);
  },
  methods: {
    doSearch: function doSearch() {
      this.$emit('searched', this.searchItems);
    }
  }
});

/***/ }),
/* 86 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
//
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  props: {
    value: {
      type: String,
      required: true,
      default: ''
    },
    format: {
      type: String,
      required: false,
      default: ''
    },
    placeholder: {
      type: String,
      required: false,
      default: ''
    },
    changeMonthYear: {
      type: Boolean,
      required: false,
      default: false
    }
  },
  mounted: function mounted() {
    var vm = this;
    jQuery(vm.$el).datepicker({
      dateFormat: vm.format,
      changeMonth: vm.changeMonthYear,
      changeYear: vm.changeMonthYear,
      beforeShow: function beforeShow() {
        jQuery(this).datepicker('widget').addClass('dokan-datepicker');
      },
      onSelect: function onSelect(date) {
        vm.updateValue(date);
      }
    });
  },
  methods: {
    updateValue: function updateValue(value) {
      if (!value) {
        value = moment().format('YYYY-MM-DD');
      }

      this.$emit('input', value);
    }
  }
});

/***/ }),
/* 87 */,
/* 88 */,
/* 89 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'GoogleMaps',
  props: {
    apiKey: {
      type: String,
      default: null
    },
    location: {
      type: Object,
      default: function _default() {
        return {
          latitude: 23.709921,
          longitude: 90.40714300000002,
          address: 'dhaka',
          zoom: 10
        };
      }
    }
  },
  data: function data() {
    return {
      dokanGoogleMap: null,
      marker: null,
      loadMap: this.apiKey.length > 1
    };
  },
  mounted: function mounted() {
    if (!(this.apiKey && window.google && this.renderMap())) {
      this.$emit('hideMap', true);
    }
  },
  beforeDestroy: function beforeDestroy() {
    if (this.dokanGoogleMap) {
      this.dokanGoogleMap = null;
    }

    if (this.marker) {
      this.marker = null;
    }
  },
  methods: {
    setMap: function setMap() {
      this.dokanGoogleMap = new google.maps.Map(this.getMapArea(), {
        center: this.getCenter(),
        zoom: this.location.zoom,
        mapTypeId: google.maps.MapTypeId.ROADMAP
      });
    },
    setMarker: function setMarker() {
      this.marker = new google.maps.Marker({
        position: this.getCenter(),
        map: this.dokanGoogleMap
      });
    },
    GetGeocoder: function GetGeocoder() {
      return new google.maps.Geocoder();
    },
    getSearchAddress: function getSearchAddress() {
      if (this.location.address) {
        this.$refs['searchAddress'].value = this.location.address;
      }

      return this.$refs['searchAddress'];
    },
    setAutoComplete: function setAutoComplete() {
      var _this = this;

      var autocomplete = new google.maps.places.Autocomplete(this.getSearchAddress());
      autocomplete.addListener('place_changed', function () {
        var place = autocomplete.getPlace();
        var location = place.geometry.location;

        _this.updateMap(location.lat(), location.lng(), place.formatted_address);
      });
    },
    updateMap: function updateMap(latitude, longitude, formatted_address) {
      var curpoint = new google.maps.LatLng(latitude, longitude);
      this.$emit('updateMap', {
        latitude: curpoint.lat(),
        longitude: curpoint.lng(),
        address: formatted_address
      });
      this.dokanGoogleMap.setCenter(curpoint);
      this.marker.setPosition(curpoint);

      if (!formatted_address) {
        this.GetGeocoder.geocode({
          location: {
            lat: latitude,
            lng: longitude
          }
        }, function (results, status) {
          if ('OK' === status) {
            address.val(results[0].formatted_address);
          }
        });
      }
    },
    renderMap: function renderMap() {
      this.setMap();
      this.setMarker();
      this.setAutoComplete();
      return true;
    },
    getCenter: function getCenter() {
      return new google.maps.LatLng(this.location.latitude, this.location.longitude);
    },
    getMapArea: function getMapArea() {
      return this.$refs['gmapArea'];
    }
  }
});

/***/ }),
/* 90 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_runtime_helpers_classCallCheck__ = __webpack_require__(75);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0__babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__babel_runtime_helpers_createClass__ = __webpack_require__(76);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1__babel_runtime_helpers_createClass__);



//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
var SearchButtonControl = /*#__PURE__*/function () {
  function SearchButtonControl(mapId) {
    __WEBPACK_IMPORTED_MODULE_0__babel_runtime_helpers_classCallCheck___default()(this, SearchButtonControl);

    this._mapId = mapId;
  }

  __WEBPACK_IMPORTED_MODULE_1__babel_runtime_helpers_createClass___default()(SearchButtonControl, [{
    key: "onAdd",
    value: function onAdd(map) {
      var _this = this;

      this._map = map;
      var icon = document.createElement('span');
      icon.className = 'dashicons dashicons-search';
      var label = document.createTextNode('Search Map');
      var button = document.createElement('button');
      button.type = 'button';
      button.className = 'button';
      button.appendChild(icon);
      button.appendChild(label);
      button.addEventListener('click', function (e) {
        e.preventDefault();
        var control = document.getElementById(_this._mapId).getElementsByClassName('mapboxgl-ctrl-top-left')[0];
        control.className = control.className + ' ' + 'show-geocoder';
      });
      var container = document.createElement('div');
      container.className = 'mapboxgl-ctrl dokan-mapboxgl-ctrl';
      container.appendChild(button);
      this._container = container;
      return this._container;
    }
  }, {
    key: "onRemove",
    value: function onRemove() {
      this._container.parentNode.removeChild(this._container);

      this._map = undefined;
    }
  }]);

  return SearchButtonControl;
}();

/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'Mapbox',
  props: {
    accessToken: {
      type: String,
      default: null
    },
    location: {
      type: Object,
      required: true
    },
    width: {
      type: String,
      required: false,
      default: '100%'
    },
    height: {
      type: String,
      required: false,
      default: '300px'
    }
  },
  data: function data() {
    return {
      dokanMapbox: null,
      dokanGeocoder: null,
      dokanMarker: null
    };
  },
  computed: {
    mapboxId: function mapboxId() {
      return "dokan-mapbox-".concat(this._uid);
    },
    address: function address() {
      return this.location.address;
    }
  },
  mounted: function mounted() {
    if (!(this.accessToken && window.mapboxgl && this.initializeMapbox())) {
      this.$emit('hideMap', true);
    }

    window.mapboxgl = mapboxgl;
  },
  beforeDestroy: function beforeDestroy() {
    if (this.dokanMapbox) {
      this.dokanMarker.remove();
      this.dokanMapbox.remove();
    }
  },
  methods: {
    initializeMapbox: function initializeMapbox() {
      var _this2 = this;

      mapboxgl.accessToken = this.accessToken;
      this.dokanMapbox = new mapboxgl.Map({
        container: this.mapboxId,
        style: 'mapbox://styles/mapbox/streets-v10',
        center: [this.location.longitude, this.location.latitude],
        zoom: this.location.zoom
      });
      this.dokanMapbox.addControl(new mapboxgl.NavigationControl());
      this.dokanMapbox.addControl(new SearchButtonControl(this.mapboxId), 'top-left');
      this.dokanMapbox.on('zoomend', function (e) {
        _this2.setLocation({
          zoom: e.target.getZoom()
        });
      });
      this.dokanMapbox.on('load', function () {
        _this2.dokanGeocoder = new MapboxGeocoder({
          accessToken: mapboxgl.accessToken,
          mapboxgl: mapboxgl,
          zoom: _this2.dokanMapbox.getZoom(),
          placeholder: _this2.__('Search Address', 'dokan-lite'),
          marker: false,
          reverseGeocode: true
        });

        _this2.dokanMapbox.addControl(_this2.dokanGeocoder, 'top-left');

        _this2.dokanGeocoder.setInput(_this2.location.address);

        _this2.dokanGeocoder.on('result', function (_ref) {
          var result = _ref.result;
          var lngLat = result.center;
          var address = result.place_name;

          _this2.dokanMarker.setLngLat(lngLat);

          _this2.dokanMapbox.setCenter([lngLat[0], lngLat[1]]);

          _this2.setLocation({
            address: result.place_name,
            latitude: lngLat[1],
            longitude: lngLat[0],
            zoom: _this2.dokanMapbox.getZoom()
          });
        });
      });
      this.dokanMarker = new mapboxgl.Marker({
        draggable: true
      }).setLngLat([this.location.longitude, this.location.latitude]).addTo(this.dokanMapbox).on('dragend', this.onMarkerDragEnd);
      return true;
    },
    onMarkerDragEnd: function onMarkerDragEnd() {
      var _this3 = this;

      var urlOrigin = this.dokanGeocoder.geocoderService.client.origin;
      var accessToken = this.dokanGeocoder.geocoderService.client.accessToken;

      var _this$dokanMarker$get = this.dokanMarker.getLngLat().wrap(),
          lng = _this$dokanMarker$get.lng,
          lat = _this$dokanMarker$get.lat;

      this.dokanMapbox.setCenter([lng, lat]);
      this.setLocation({
        latitude: lat,
        longitude: lng
      });
      var url = "".concat(urlOrigin, "/geocoding/v5/mapbox.places/").concat(lng, "%2C").concat(lat, ".json?access_token=").concat(accessToken, "&cachebuster=").concat(+new Date(), "&autocomplete=true");
      this.dokanGeocoder._inputEl.disabled = true;
      this.dokanGeocoder._loadingEl.style.display = 'block';
      jQuery.ajax({
        url: url,
        method: 'get'
      }).done(function (response) {
        _this3.dokanGeocoder._typeahead.update(response.features);
      }).fail(function () {//
      }).always(function () {
        _this3.dokanGeocoder._inputEl.disabled = false;
        _this3.dokanGeocoder._loadingEl.style.display = '';
      });
    },
    setLocation: function setLocation(location) {
      this.$emit('updateMap', location);
    },
    onChangeAddress: function onChangeAddress(e) {
      this.setLocation({
        address: e.target.value
      });
    }
  }
});

/***/ }),
/* 91 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  props: {
    section: {
      type: String,
      required: true
    },
    field: {
      type: Object,
      required: true
    },
    toggleLoadingState: {
      type: Function,
      required: true
    }
  },
  data: function data() {
    return {
      isRefreshing: false,
      showRefreshedMsg: false
    };
  },
  computed: {
    messages: function messages() {
      var _this$field$refresh_o, _this$field$refresh_o2, _this$field$refresh_o3, _this$field$refresh_o4;

      return {
        refreshing: ((_this$field$refresh_o = this.field.refresh_options) === null || _this$field$refresh_o === void 0 ? void 0 : (_this$field$refresh_o2 = _this$field$refresh_o.messages) === null || _this$field$refresh_o2 === void 0 ? void 0 : _this$field$refresh_o2.refreshing) || this.__('Refreshing options', 'dokan-lite'),
        refreshed: ((_this$field$refresh_o3 = this.field.refresh_options) === null || _this$field$refresh_o3 === void 0 ? void 0 : (_this$field$refresh_o4 = _this$field$refresh_o3.messages) === null || _this$field$refresh_o4 === void 0 ? void 0 : _this$field$refresh_o4.refreshed) || this.__('Option refreshed!', 'dokan-lite')
      };
    }
  },
  methods: {
    refreshSettings: function refreshSettings() {
      var _this = this;

      this.toggleLoadingState();
      this.isRefreshing = true;
      jQuery.ajax({
        url: dokan.ajaxurl,
        method: 'post',
        dataType: 'json',
        data: {
          action: 'dokan_refresh_admin_settings_field_options',
          _wpnonce: dokan.admin_settings_nonce,
          section: this.section,
          field: this.field.name
        }
      }).done(function (response) {
        var _response$data;

        (response === null || response === void 0 ? void 0 : (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data[0]) && _this.setSettingOptions(response.data);
      }).always(function () {
        _this.toggleLoadingState();

        _this.isRefreshing = false;
      }).fail(function (jqXHR) {
        var _jqXHR$responseJSON;

        (jqXHR === null || jqXHR === void 0 ? void 0 : (_jqXHR$responseJSON = jqXHR.responseJSON) === null || _jqXHR$responseJSON === void 0 ? void 0 : _jqXHR$responseJSON.data) && alert(jqXHR.responseJSON.data);
      });
    },
    setSettingOptions: function setSettingOptions(options) {
      var _this2 = this;

      this.field.options = options;
      this.showRefreshedMsg = true;
      setTimeout(function () {
        return _this2.showRefreshedMsg = false;
      }, 3000);
    }
  }
});

/***/ }),
/* 92 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ __webpack_exports__["a"] = ({
  name: 'VendorSocialFields',
  props: {
    vendorInfo: {
      type: Object
    }
  },
  data: function data() {
    return {
      getSocialFields: dokan.hooks.applyFilters('getVendorSocialFields', [])
    };
  }
});

/***/ }),
/* 93 */,
/* 94 */,
/* 95 */,
/* 96 */,
/* 97 */,
/* 98 */,
/* 99 */,
/* 100 */,
/* 101 */,
/* 102 */,
/* 103 */,
/* 104 */,
/* 105 */,
/* 106 */,
/* 107 */,
/* 108 */,
/* 109 */,
/* 110 */,
/* 111 */,
/* 112 */,
/* 113 */,
/* 114 */,
/* 115 */,
/* 116 */,
/* 117 */,
/* 118 */,
/* 119 */,
/* 120 */,
/* 121 */,
/* 122 */,
/* 123 */,
/* 124 */,
/* 125 */,
/* 126 */,
/* 127 */,
/* 128 */,
/* 129 */,
/* 130 */,
/* 131 */,
/* 132 */,
/* 133 */,
/* 134 */,
/* 135 */,
/* 136 */,
/* 137 */,
/* 138 */,
/* 139 */,
/* 140 */,
/* 141 */,
/* 142 */,
/* 143 */,
/* 144 */,
/* 145 */,
/* 146 */,
/* 147 */,
/* 148 */,
/* 149 */,
/* 150 */,
/* 151 */,
/* 152 */,
/* 153 */,
/* 154 */,
/* 155 */,
/* 156 */,
/* 157 */,
/* 158 */,
/* 159 */,
/* 160 */,
/* 161 */,
/* 162 */,
/* 163 */,
/* 164 */,
/* 165 */,
/* 166 */,
/* 167 */,
/* 168 */,
/* 169 */,
/* 170 */,
/* 171 */,
/* 172 */,
/* 173 */,
/* 174 */,
/* 175 */,
/* 176 */,
/* 177 */,
/* 178 */,
/* 179 */,
/* 180 */,
/* 181 */,
/* 182 */,
/* 183 */,
/* 184 */,
/* 185 */,
/* 186 */,
/* 187 */,
/* 188 */,
/* 189 */,
/* 190 */,
/* 191 */,
/* 192 */,
/* 193 */,
/* 194 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_vue__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_vue_router__ = __webpack_require__(25);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_moment__ = __webpack_require__(195);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2_moment___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2_moment__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_vue_notification__ = __webpack_require__(72);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_vue_notification___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_vue_notification__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_vue_wp_list_table__ = __webpack_require__(73);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_vue_multiselect__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_vue_multiselect___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_5_vue_multiselect__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__utils_Api__ = __webpack_require__(199);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7_vue_chartjs__ = __webpack_require__(21);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__Mixin__ = __webpack_require__(200);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_debounce__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9_debounce___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_9_debounce__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__utils_VersionCompare__ = __webpack_require__(202);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__utils_VersionCompare___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_10__utils_VersionCompare__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__admin_components_AdminNotice_vue__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_vue_content_loading__ = __webpack_require__(77);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12_vue_content_loading___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_12_vue_content_loading__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13_admin_components_Postbox_vue__ = __webpack_require__(203);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14_admin_components_Loading_vue__ = __webpack_require__(206);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15_admin_components_Chart_vue__ = __webpack_require__(26);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16_admin_components_Modal_vue__ = __webpack_require__(209);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17_admin_components_Switches_vue__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18_admin_components_TextEditor_vue__ = __webpack_require__(212);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19_admin_components_Currency_vue__ = __webpack_require__(214);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20_admin_components_LazyInput_vue__ = __webpack_require__(216);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21_admin_components_Progressbar_vue__ = __webpack_require__(218);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22_admin_components_Search_vue__ = __webpack_require__(221);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_23_admin_components_Datepicker_vue__ = __webpack_require__(223);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_24_vue2_daterange_picker__ = __webpack_require__(87);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_24_vue2_daterange_picker___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_24_vue2_daterange_picker__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_25_vue2_daterange_picker_dist_vue2_daterange_picker_css__ = __webpack_require__(225);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_25_vue2_daterange_picker_dist_vue2_daterange_picker_css___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_25_vue2_daterange_picker_dist_vue2_daterange_picker_css__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_26_vue_sweetalert2__ = __webpack_require__(88);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_27_admin_components_ColorPicker_vue__ = __webpack_require__(27);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_28_admin_components_GoogleMaps_vue__ = __webpack_require__(230);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_29_admin_components_Mapbox_vue__ = __webpack_require__(233);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_30_admin_components_UploadImage_vue__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_31_admin_components_PasswordGenerator_vue__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_32_admin_components_RefreshSettingOptions_vue__ = __webpack_require__(236);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_33_admin_pages_VendorAccountFields_vue__ = __webpack_require__(30);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_34_admin_pages_VendorAddressFields_vue__ = __webpack_require__(37);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_35_admin_pages_VendorSocialFields_vue__ = __webpack_require__(239);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_36_admin_pages_VendorPaymentFields_vue__ = __webpack_require__(40);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_37_vue_multiselect_dist_vue_multiselect_min_css__ = __webpack_require__(241);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_37_vue_multiselect_dist_vue_multiselect_min_css___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_37_vue_multiselect_dist_vue_multiselect_min_css__);













window.__ = function (text, domain) {
  return __(text, domain);
};

 // core components


























__WEBPACK_IMPORTED_MODULE_0_vue__["default"].use(__WEBPACK_IMPORTED_MODULE_3_vue_notification___default.a);
__WEBPACK_IMPORTED_MODULE_0_vue__["default"].use(__WEBPACK_IMPORTED_MODULE_26_vue_sweetalert2__["default"]);
__WEBPACK_IMPORTED_MODULE_0_vue__["default"].mixin(__WEBPACK_IMPORTED_MODULE_8__Mixin__["a" /* default */]);
__WEBPACK_IMPORTED_MODULE_0_vue__["default"].filter('currency', function (value) {
  return accounting.formatMoney(value, dokan.currency);
});
__WEBPACK_IMPORTED_MODULE_0_vue__["default"].filter('capitalize', function (value) {
  if (!value) return '';
  value = value.toString();
  return value.charAt(0).toUpperCase() + value.slice(1);
}); // Tooltip directive

__WEBPACK_IMPORTED_MODULE_0_vue__["default"].directive('tooltip', {
  bind: function bind(el, binding, vnode) {
    jQuery(el).tooltip('show');
  },
  unbind: function unbind(el, binding, vnode) {
    jQuery(el).tooltip('destroy');
  }
});

window.dokan_get_lib = function (lib) {
  return window.dokan.libs[lib];
};

window.dokan_add_route = function (component) {
  window.dokan.routeComponents[component.name] = component;
}; // setup global Dokan libraries


window.dokan.api = new __WEBPACK_IMPORTED_MODULE_6__utils_Api__["a" /* default */]();
window.dokan.libs['Vue'] = __WEBPACK_IMPORTED_MODULE_0_vue__["default"];
window.dokan.libs['Router'] = __WEBPACK_IMPORTED_MODULE_1_vue_router__["default"];
window.dokan.libs['moment'] = __WEBPACK_IMPORTED_MODULE_2_moment___default.a;
window.dokan.libs['ListTable'] = __WEBPACK_IMPORTED_MODULE_4_vue_wp_list_table__["default"];
window.dokan.libs['Currency'] = __WEBPACK_IMPORTED_MODULE_19_admin_components_Currency_vue__["a" /* default */];
window.dokan.libs['Postbox'] = __WEBPACK_IMPORTED_MODULE_13_admin_components_Postbox_vue__["a" /* default */];
window.dokan.libs['Loading'] = __WEBPACK_IMPORTED_MODULE_14_admin_components_Loading_vue__["a" /* default */];
window.dokan.libs['ChartJS'] = __WEBPACK_IMPORTED_MODULE_7_vue_chartjs__["default"];
window.dokan.libs['Chart'] = __WEBPACK_IMPORTED_MODULE_15_admin_components_Chart_vue__["a" /* default */];
window.dokan.libs['Modal'] = __WEBPACK_IMPORTED_MODULE_16_admin_components_Modal_vue__["a" /* default */];
window.dokan.libs['Switches'] = __WEBPACK_IMPORTED_MODULE_17_admin_components_Switches_vue__["a" /* default */];
window.dokan.libs['TextEditor'] = __WEBPACK_IMPORTED_MODULE_18_admin_components_TextEditor_vue__["a" /* default */];
window.dokan.libs['LazyInput'] = __WEBPACK_IMPORTED_MODULE_20_admin_components_LazyInput_vue__["a" /* default */];
window.dokan.libs['Progressbar'] = __WEBPACK_IMPORTED_MODULE_21_admin_components_Progressbar_vue__["a" /* default */];
window.dokan.libs['Search'] = __WEBPACK_IMPORTED_MODULE_22_admin_components_Search_vue__["a" /* default */];
window.dokan.libs['Datepicker'] = __WEBPACK_IMPORTED_MODULE_23_admin_components_Datepicker_vue__["a" /* default */];
window.dokan.libs['DateRangePicker'] = __WEBPACK_IMPORTED_MODULE_24_vue2_daterange_picker___default.a;
window.dokan.libs['Multiselect'] = __WEBPACK_IMPORTED_MODULE_5_vue_multiselect___default.a;
window.dokan.libs['ColorPicker'] = __WEBPACK_IMPORTED_MODULE_27_admin_components_ColorPicker_vue__["a" /* default */];
window.dokan.libs['debounce'] = __WEBPACK_IMPORTED_MODULE_9_debounce___default.a;
window.dokan.libs['VersionCompare'] = __WEBPACK_IMPORTED_MODULE_10__utils_VersionCompare___default.a;
window.dokan.libs['GoogleMaps'] = __WEBPACK_IMPORTED_MODULE_28_admin_components_GoogleMaps_vue__["a" /* default */];
window.dokan.libs['Mapbox'] = __WEBPACK_IMPORTED_MODULE_29_admin_components_Mapbox_vue__["a" /* default */];
window.dokan.libs['UploadImage'] = __WEBPACK_IMPORTED_MODULE_30_admin_components_UploadImage_vue__["a" /* default */];
window.dokan.libs['PasswordGenerator'] = __WEBPACK_IMPORTED_MODULE_31_admin_components_PasswordGenerator_vue__["a" /* default */];
window.dokan.libs['VendorAccountFields'] = __WEBPACK_IMPORTED_MODULE_33_admin_pages_VendorAccountFields_vue__["a" /* default */];
window.dokan.libs['VendorAddressFields'] = __WEBPACK_IMPORTED_MODULE_34_admin_pages_VendorAddressFields_vue__["a" /* default */];
window.dokan.libs['VendorSocialFields'] = __WEBPACK_IMPORTED_MODULE_35_admin_pages_VendorSocialFields_vue__["a" /* default */];
window.dokan.libs['VendorPaymentFields'] = __WEBPACK_IMPORTED_MODULE_36_admin_pages_VendorPaymentFields_vue__["a" /* default */];
window.dokan.libs['RefreshSettingOptions'] = __WEBPACK_IMPORTED_MODULE_32_admin_components_RefreshSettingOptions_vue__["a" /* default */];
window.dokan.libs['AdminNotice'] = __WEBPACK_IMPORTED_MODULE_11__admin_components_AdminNotice_vue__["a" /* default */];
window.dokan.libs['ContentLoading'] = {
  VclCode: __WEBPACK_IMPORTED_MODULE_12_vue_content_loading__["VclCode"],
  VclList: __WEBPACK_IMPORTED_MODULE_12_vue_content_loading__["VclList"],
  VclTwitch: __WEBPACK_IMPORTED_MODULE_12_vue_content_loading__["VclTwitch"],
  VclFacebook: __WEBPACK_IMPORTED_MODULE_12_vue_content_loading__["VclFacebook"],
  VclInstagram: __WEBPACK_IMPORTED_MODULE_12_vue_content_loading__["VclInstagram"],
  VclBulletList: __WEBPACK_IMPORTED_MODULE_12_vue_content_loading__["VclBulletList"],
  VueContentLoading: __WEBPACK_IMPORTED_MODULE_12_vue_content_loading__["VueContentLoading"]
}; // wp npm packages with backward compatibility

dokan.hooks = wp && wp.hooks ? wp.hooks : dokan.wpPackages.hooks;

if (dokan.hooks) {
  dokan.addFilterComponent = function (hookName, namespace, component) {
    var priority = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 10;
    dokan.hooks.addFilter(hookName, namespace, function (components) {
      components.push(component);
      return components;
    }, priority);
  };
}

/***/ }),
/* 195 */
/***/ (function(module, exports) {

module.exports = moment;

/***/ }),
/* 196 */,
/* 197 */,
/* 198 */,
/* 199 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_runtime_helpers_classCallCheck__ = __webpack_require__(75);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_runtime_helpers_classCallCheck___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0__babel_runtime_helpers_classCallCheck__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__babel_runtime_helpers_createClass__ = __webpack_require__(76);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__babel_runtime_helpers_createClass___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1__babel_runtime_helpers_createClass__);



var Dokan_API = /*#__PURE__*/function () {
  function Dokan_API() {
    __WEBPACK_IMPORTED_MODULE_0__babel_runtime_helpers_classCallCheck___default()(this, Dokan_API);
  }

  __WEBPACK_IMPORTED_MODULE_1__babel_runtime_helpers_createClass___default()(Dokan_API, [{
    key: "endpoint",
    value: function endpoint() {
      return window.dokan.rest.root + window.dokan.rest.version;
    }
  }, {
    key: "headers",
    value: function headers() {
      return {};
    }
  }, {
    key: "get",
    value: function get(path) {
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return this.ajax(path, 'GET', this.headers(), data);
    }
  }, {
    key: "post",
    value: function post(path) {
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return this.ajax(path, 'POST', this.headers(), data);
    }
  }, {
    key: "put",
    value: function put(path) {
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return this.ajax(path, 'PUT', this.headers(), data);
    }
  }, {
    key: "delete",
    value: function _delete(path) {
      var data = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      return this.ajax(path, 'DELETE', this.headers(), data);
    } // jQuery ajax wrapper

  }, {
    key: "ajax",
    value: function ajax(path, method, headers, data) {
      var override = null;

      if ('PUT' === method || 'DELETE' === method) {
        override = method;
        method = 'POST';
      }

      return jQuery.ajax({
        url: this.endpoint() + path,
        beforeSend: function beforeSend(xhr) {
          xhr.setRequestHeader('X-WP-Nonce', window.dokan.rest.nonce);

          if (override) {
            xhr.setRequestHeader('X-HTTP-Method-Override', override);
          }
        },
        type: method,
        data: data
      });
    }
  }]);

  return Dokan_API;
}();

/* harmony default export */ __webpack_exports__["a"] = (Dokan_API);

/***/ }),
/* 200 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__utils_i18n__ = __webpack_require__(201);

/* harmony default export */ __webpack_exports__["a"] = ({
  methods: {
    setLocaleData: function setLocaleData(data) {
      return Object(__WEBPACK_IMPORTED_MODULE_0__utils_i18n__["c" /* setLocaleData */])(data);
    },
    __: function __(text, domain) {
      return Object(__WEBPACK_IMPORTED_MODULE_0__utils_i18n__["a" /* __ */])(text, domain);
    },
    _nx: function _nx(single, plural, number, context, domain) {
      return Object(__WEBPACK_IMPORTED_MODULE_0__utils_i18n__["b" /* _nx */])(single, plural, number, context, domain);
    },
    __n: function __n(single, plural, number, domain) {
      return _n(single, plural, number, domain);
    },
    sprintf: function sprintf(fmt) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      return __WEBPACK_IMPORTED_MODULE_0__utils_i18n__["d" /* sprintf */].apply(void 0, [fmt].concat(args));
    }
  }
});

/***/ }),
/* 201 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["c"] = setLocaleData;
/* unused harmony export getI18n */
/* harmony export (immutable) */ __webpack_exports__["a"] = __;
/* unused harmony export _x */
/* unused harmony export _n */
/* harmony export (immutable) */ __webpack_exports__["b"] = _nx;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return sprintf; });
/**
 * External dependencies
 */
var i18n = {};
/**
 * Creates a new Jed instance with specified locale data configuration.
 *
 * @see http://messageformat.github.io/Jed/
 *
 * @param {Object} data Locale data configuration.
 */

function setLocaleData(data) {
  var jed = new Jed(data);
  i18n[jed._textdomain] = jed;
}
/**
 * Returns the current Jed instance, initializing with a default configuration
 * if not already assigned.
 *
 * @return {Jed} Jed instance.
 */

function getI18n() {
  var domain = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';

  if (!i18n[domain]) {
    setLocaleData({
      '': {}
    });
  }

  return i18n[domain];
}
/**
 * Retrieve the translation of text.
 *
 * @see https://developer.wordpress.org/reference/functions/__/
 *
 * @param {string} text Text to translate.
 * @param {string} domain Domain to retrieve the translated text.
 *
 * @return {string} Translated text.
 */

function __(text, domain) {
  return getI18n(domain) ? getI18n(domain).dgettext(domain, text) : text;
}
/**
 * Retrieve translated string with gettext context.
 *
 * @see https://developer.wordpress.org/reference/functions/_x/
 *
 * @param {string} text    Text to translate.
 * @param {string} context Context information for the translators.
 * @param {string} domain Domain to retrieve the translated text.
 *
 * @return {string} Translated context string without pipe.
 */

function _x(text, context, domain) {
  return getI18n(domain).dpgettext(domain, context, text);
}
/**
 * Translates and retrieves the singular or plural form based on the supplied
 * number.
 *
 * @see https://developer.wordpress.org/reference/functions/_n/
 *
 * @param {string} single The text to be used if the number is singular.
 * @param {string} plural The text to be used if the number is plural.
 * @param {number} number The number to compare against to use either the
 *                         singular or plural form.
 * @param {string} domain Domain to retrieve the translated text.
 *
 * @return {string} The translated singular or plural form.
 */

function _n(single, plural, number, domain) {
  return getI18n(domain).dngettext(domain, single, plural, number);
}
/**
 * Translates and retrieves the singular or plural form based on the supplied
 * number, with gettext context.
 *
 * @see https://developer.wordpress.org/reference/functions/_nx/
 *
 * @param {string} single  The text to be used if the number is singular.
 * @param {string} plural  The text to be used if the number is plural.
 * @param {number} number  The number to compare against to use either the
 *                          singular or plural form.
 * @param {string} context Context information for the translators.
 * @param {string} domain Domain to retrieve the translated text.
 *
 * @return {string} The translated singular or plural form.
 */

function _nx(single, plural, number, context, domain) {
  return getI18n(domain).dnpgettext(domain, context, single, plural, number);
}
/**
 * Returns a formatted string.
 *
 * @see http://www.diveintojavascript.com/projects/javascript-sprintf
 *
 * @type {string}
 */

var sprintf = Jed.sprintf;

/***/ }),
/* 202 */
/***/ (function(module, exports) {

module.exports = function versionCompare(v1, v2, operator) {
  // eslint-disable-line camelcase
  //       discuss at: https://locutus.io/php/version_compare/
  //      original by: Philippe Jausions (https://pear.php.net/user/jausions)
  //      original by: Aidan Lister (https://aidanlister.com/)
  // reimplemented by: Kankrelune (https://www.webfaktory.info/)
  //      improved by: Brett Zamir (https://brett-zamir.me)
  //      improved by: Scott Baker
  //      improved by: Theriault (https://github.com/Theriault)
  //        example 1: versionCompare('8.2.5rc', '8.2.5a')
  //        returns 1: 1
  //        example 2: versionCompare('8.2.50', '8.2.52', '<')
  //        returns 2: true
  //        example 3: versionCompare('5.3.0-dev', '5.3.0')
  //        returns 3: -1
  //        example 4: versionCompare('4.1.0.52','4.01.0.51')
  //        returns 4: 1
  // Important: compare must be initialized at 0.
  var i;
  var x;
  var compare = 0; // vm maps textual PHP versions to negatives so they're less than 0.
  // PHP currently defines these as CASE-SENSITIVE. It is important to
  // leave these as negatives so that they can come before numerical versions
  // and as if no letters were there to begin with.
  // (1alpha is < 1 and < 1.1 but > 1dev1)
  // If a non-numerical value can't be mapped to this table, it receives
  // -7 as its value.

  var vm = {
    'dev': -6,
    'alpha': -5,
    'a': -5,
    'beta': -4,
    'b': -4,
    'RC': -3,
    'rc': -3,
    '#': -2,
    'p': 1,
    'pl': 1
  }; // This function will be called to prepare each version argument.
  // It replaces every _, -, and + with a dot.
  // It surrounds any nonsequence of numbers/dots with dots.
  // It replaces sequences of dots with a single dot.
  //    version_compare('4..0', '4.0') === 0
  // Important: A string of 0 length needs to be converted into a value
  // even less than an unexisting value in vm (-7), hence [-8].
  // It's also important to not strip spaces because of this.
  //   version_compare('', ' ') === 1

  var _prepVersion = function _prepVersion(v) {
    v = ('' + v).replace(/[_\-+]/g, '.');
    v = v.replace(/([^.\d]+)/g, '.$1.').replace(/\.{2,}/g, '.');
    return !v.length ? [-8] : v.split('.');
  }; // This converts a version component to a number.
  // Empty component becomes 0.
  // Non-numerical component becomes a negative number.
  // Numerical component becomes itself as an integer.


  var _numVersion = function _numVersion(v) {
    return !v ? 0 : isNaN(v) ? vm[v] || -7 : parseInt(v, 10);
  };

  v1 = _prepVersion(v1);
  v2 = _prepVersion(v2);
  x = Math.max(v1.length, v2.length);

  for (i = 0; i < x; i++) {
    if (v1[i] === v2[i]) {
      continue;
    }

    v1[i] = _numVersion(v1[i]);
    v2[i] = _numVersion(v2[i]);

    if (v1[i] < v2[i]) {
      compare = -1;
      break;
    } else if (v1[i] > v2[i]) {
      compare = 1;
      break;
    }
  }

  if (!operator) {
    return compare;
  } // Important: operator is CASE-SENSITIVE.
  // "No operator" seems to be treated as "<."
  // Any other values seem to make the function return null.


  switch (operator) {
    case '>':
    case 'gt':
      return compare > 0;

    case '>=':
    case 'ge':
      return compare >= 0;

    case '<=':
    case 'le':
      return compare <= 0;

    case '===':
    case '=':
    case 'eq':
      return compare === 0;

    case '<>':
    case '!==':
    case 'ne':
      return compare !== 0;

    case '':
    case '<':
    case 'lt':
      return compare < 0;

    default:
      return null;
  }
};

/***/ }),
/* 203 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Postbox_vue__ = __webpack_require__(78);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_36a997ab_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Postbox_vue__ = __webpack_require__(205);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(204)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Postbox_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_36a997ab_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Postbox_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/Postbox.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-36a997ab", Component.options)
  } else {
    hotAPI.reload("data-v-36a997ab", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 204 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 205 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "div",
    {
      class: [
        "postbox",
        "dokan-postbox",
        { closed: !_vm.showing },
        _vm.extraClass
      ]
    },
    [
      _c("div", { staticClass: "postbox-header" }, [
        _c("h2", { staticClass: "hndle" }, [
          _c("span", [_vm._v(_vm._s(_vm.title))])
        ]),
        _vm._v(" "),
        _c("div", { staticClass: "handle-actions hide-if-no-js" }, [
          _c(
            "button",
            {
              staticClass: "handlediv",
              attrs: { type: "button", "aria-expanded": "false" },
              on: {
                click: function($event) {
                  _vm.showing = !_vm.showing
                }
              }
            },
            [
              _c("span", {
                staticClass: "toggle-indicator",
                attrs: { "aria-hidden": "true" }
              })
            ]
          )
        ])
      ]),
      _vm._v(" "),
      _c("div", { staticClass: "inside" }, [
        _c("div", { staticClass: "main" }, [_vm._t("default")], 2)
      ])
    ]
  )
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-36a997ab", esExports)
  }
}

/***/ }),
/* 206 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Loading_vue__ = __webpack_require__(79);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_67db673c_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Loading_vue__ = __webpack_require__(208);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(207)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Loading_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_67db673c_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Loading_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/Loading.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-67db673c", Component.options)
  } else {
    hotAPI.reload("data-v-67db673c", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 207 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 208 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _vm._m(0)
}
var staticRenderFns = [
  function() {
    var _vm = this
    var _h = _vm.$createElement
    var _c = _vm._self._c || _h
    return _c("div", { staticClass: "dokan-loader" }, [_c("div"), _c("div")])
  }
]
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-67db673c", esExports)
  }
}

/***/ }),
/* 209 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Modal_vue__ = __webpack_require__(80);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_4bd79a2d_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Modal_vue__ = __webpack_require__(211);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(210)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Modal_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_4bd79a2d_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Modal_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/Modal.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-4bd79a2d", Component.options)
  } else {
    hotAPI.reload("data-v-4bd79a2d", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 210 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 211 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("div", { staticClass: "dokan-modal-dialog" }, [
    _c("div", { staticClass: "dokan-modal" }, [
      _c(
        "div",
        {
          staticClass: "dokan-modal-content",
          style: { width: _vm.width, height: _vm.height }
        },
        [
          _c(
            "section",
            { class: ["dokan-modal-main", { "has-footer": _vm.footer }] },
            [
              _c(
                "header",
                { staticClass: "modal-header" },
                [
                  _vm._t("header", function() {
                    return [_c("h1", [_vm._v(_vm._s(_vm.title))])]
                  }),
                  _vm._v(" "),
                  _c(
                    "button",
                    {
                      staticClass:
                        "modal-close modal-close-link dashicons dashicons-no-alt",
                      on: {
                        click: function($event) {
                          return _vm.$emit("close")
                        }
                      }
                    },
                    [
                      _c("span", { staticClass: "screen-reader-text" }, [
                        _vm._v(
                          _vm._s(_vm.__("Close modal panel", "dokan-lite"))
                        )
                      ])
                    ]
                  )
                ],
                2
              ),
              _vm._v(" "),
              _c("div", { staticClass: "modal-body" }, [_vm._t("body")], 2),
              _vm._v(" "),
              _vm.footer
                ? _c("footer", { staticClass: "modal-footer" }, [
                    _c("div", { staticClass: "inner" }, [_vm._t("footer")], 2)
                  ])
                : _vm._e()
            ]
          )
        ]
      )
    ]),
    _vm._v(" "),
    _c("div", { staticClass: "dokan-modal-backdrop" })
  ])
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-4bd79a2d", esExports)
  }
}

/***/ }),
/* 212 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_TextEditor_vue__ = __webpack_require__(81);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_70730fac_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_TextEditor_vue__ = __webpack_require__(213);
var disposed = false
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = null
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_TextEditor_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_70730fac_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_TextEditor_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/TextEditor.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-70730fac", Component.options)
  } else {
    hotAPI.reload("data-v-70730fac", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 213 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("textarea", {
    attrs: { id: "dokan-tinymce-" + _vm.editorId },
    domProps: { value: _vm.value }
  })
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-70730fac", esExports)
  }
}

/***/ }),
/* 214 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Currency_vue__ = __webpack_require__(82);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_7df58dc1_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Currency_vue__ = __webpack_require__(215);
var disposed = false
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = null
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Currency_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_7df58dc1_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Currency_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/Currency.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-7df58dc1", Component.options)
  } else {
    hotAPI.reload("data-v-7df58dc1", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 215 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("div", {
    domProps: { innerHTML: _vm._s(_vm.formattedPrice(_vm.amount)) }
  })
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-7df58dc1", esExports)
  }
}

/***/ }),
/* 216 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_LazyInput_vue__ = __webpack_require__(83);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_588d4894_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_LazyInput_vue__ = __webpack_require__(217);
var disposed = false
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = null
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_LazyInput_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_588d4894_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_LazyInput_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/LazyInput.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-588d4894", Component.options)
  } else {
    hotAPI.reload("data-v-588d4894", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 217 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("input", {
    attrs: { type: _vm.type, placeholder: _vm.placeholder },
    domProps: { value: _vm.value },
    on: {
      input: function($event) {
        return _vm.updateValue($event.target.value)
      },
      focus: _vm.focus,
      blur: _vm.blur
    }
  })
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-588d4894", esExports)
  }
}

/***/ }),
/* 218 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Progressbar_vue__ = __webpack_require__(84);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_356fabc6_hasScoped_true_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Progressbar_vue__ = __webpack_require__(220);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(219)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-356fabc6"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Progressbar_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_356fabc6_hasScoped_true_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Progressbar_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/Progressbar.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-356fabc6", Component.options)
  } else {
    hotAPI.reload("data-v-356fabc6", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 219 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 220 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("div", { class: _vm.bgColor, attrs: { id: "progressbar" } }, [
    _c(
      "div",
      {
        class: _vm.fgColor,
        style: { width: _vm.value + "%" },
        attrs: { id: "value" }
      },
      [!_vm.hidden ? [_vm._v(_vm._s(_vm.value + "%"))] : _vm._e()],
      2
    )
  ])
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-356fabc6", esExports)
  }
}

/***/ }),
/* 221 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Search_vue__ = __webpack_require__(85);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_5d8365d8_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Search_vue__ = __webpack_require__(222);
var disposed = false
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = null
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Search_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_5d8365d8_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Search_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/Search.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-5d8365d8", Component.options)
  } else {
    hotAPI.reload("data-v-5d8365d8", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 222 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("p", { staticClass: "search-box" }, [
    _c("input", {
      directives: [
        {
          name: "model",
          rawName: "v-model",
          value: _vm.searchItems,
          expression: "searchItems"
        }
      ],
      attrs: {
        type: "search",
        id: "post-search-input",
        name: "s",
        placeholder: _vm.title
      },
      domProps: { value: _vm.searchItems },
      on: {
        input: function($event) {
          if ($event.target.composing) {
            return
          }
          _vm.searchItems = $event.target.value
        }
      }
    })
  ])
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-5d8365d8", esExports)
  }
}

/***/ }),
/* 223 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Datepicker_vue__ = __webpack_require__(86);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_ae257028_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Datepicker_vue__ = __webpack_require__(224);
var disposed = false
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = null
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Datepicker_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_ae257028_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Datepicker_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/Datepicker.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-ae257028", Component.options)
  } else {
    hotAPI.reload("data-v-ae257028", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 224 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("input", {
    attrs: { type: "text", placeholder: _vm.placeholder },
    domProps: { value: _vm.value },
    on: {
      input: function($event) {
        return _vm.updateValue($event.target.value)
      }
    }
  })
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-ae257028", esExports)
  }
}

/***/ }),
/* 225 */,
/* 226 */,
/* 227 */,
/* 228 */,
/* 229 */,
/* 230 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_GoogleMaps_vue__ = __webpack_require__(89);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_4f45e4a0_hasScoped_true_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_GoogleMaps_vue__ = __webpack_require__(232);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(231)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-4f45e4a0"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_GoogleMaps_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_4f45e4a0_hasScoped_true_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_GoogleMaps_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/GoogleMaps.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-4f45e4a0", Component.options)
  } else {
    hotAPI.reload("data-v-4f45e4a0", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 231 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 232 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _vm.apiKey
    ? _c("div", { staticClass: "gmap-wrap regular-text" }, [
        _c("input", {
          ref: "searchAddress",
          staticClass: "search-address regular-text",
          attrs: {
            type: "text",
            placeholder: _vm.__("Search Address", "dokan-lite")
          }
        }),
        _vm._v(" "),
        _c("div", { ref: "gmapArea", attrs: { id: "gmap" } })
      ])
    : _c("p", [
        _vm._v(
          "\n    " +
            _vm._s(_vm.__("Please enter google map API key", "dokan-lite")) +
            "\n"
        )
      ])
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-4f45e4a0", esExports)
  }
}

/***/ }),
/* 233 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Mapbox_vue__ = __webpack_require__(90);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_2fe28f9f_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Mapbox_vue__ = __webpack_require__(235);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(234)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_Mapbox_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_2fe28f9f_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_Mapbox_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/Mapbox.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-2fe28f9f", Component.options)
  } else {
    hotAPI.reload("data-v-2fe28f9f", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 234 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 235 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return !_vm.accessToken
    ? _c("p", [
        _vm._v(
          "\n    " +
            _vm._s(
              _vm.__(
                "Please enter Mapbox access token in `Appearance > Mapbox Access Token` settings.",
                "dokan-lite"
              )
            ) +
            "\n"
        )
      ])
    : _c("div", { staticClass: "mapbox-wrapper" }, [
        _c("div", { staticClass: "address-input" }, [
          _c("label", [
            _vm._v(
              "\n            " +
                _vm._s(_vm.__("Address", "dokan-lite")) +
                "\n            "
            ),
            _c("input", {
              attrs: { type: "text" },
              domProps: { value: _vm.address },
              on: { input: _vm.onChangeAddress }
            })
          ])
        ]),
        _vm._v(" "),
        _c("div", {
          style: { width: _vm.width, height: _vm.height },
          attrs: { id: _vm.mapboxId }
        })
      ])
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-2fe28f9f", esExports)
  }
}

/***/ }),
/* 236 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_RefreshSettingOptions_vue__ = __webpack_require__(91);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_e724292e_hasScoped_true_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_RefreshSettingOptions_vue__ = __webpack_require__(238);
var disposed = false
function injectStyle (ssrContext) {
  if (disposed) return
  __webpack_require__(237)
}
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = injectStyle
/* scopeId */
var __vue_scopeId__ = "data-v-e724292e"
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_RefreshSettingOptions_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_e724292e_hasScoped_true_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_RefreshSettingOptions_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/components/RefreshSettingOptions.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-e724292e", Component.options)
  } else {
    hotAPI.reload("data-v-e724292e", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 237 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),
/* 238 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c(
    "button",
    {
      staticClass: "button button-link",
      attrs: {
        type: "button",
        disabled: _vm.isRefreshing || _vm.showRefreshedMsg
      },
      on: {
        click: function($event) {
          $event.preventDefault()
          return _vm.refreshSettings.apply(null, arguments)
        }
      }
    },
    [
      !_vm.isRefreshing && !_vm.showRefreshedMsg
        ? _c("span", { staticClass: "dashicons dashicons-image-rotate" })
        : _vm._e(),
      _vm._v(" "),
      _vm.isRefreshing
        ? _c("span", { staticClass: "refreshing-message" }, [
            _vm._v(_vm._s(_vm.messages.refreshing) + "...")
          ])
        : _vm._e(),
      _vm._v(" "),
      _vm.showRefreshedMsg
        ? _c("span", { staticClass: "refresh-message-success" }, [
            _vm._v("✓ " + _vm._s(_vm.messages.refreshed))
          ])
        : _vm._e()
    ]
  )
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-e724292e", esExports)
  }
}

/***/ }),
/* 239 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_VendorSocialFields_vue__ = __webpack_require__(92);
/* unused harmony namespace reexport */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_21406e92_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_VendorSocialFields_vue__ = __webpack_require__(240);
var disposed = false
var normalizeComponent = __webpack_require__(0)
/* script */


/* template */

/* template functional */
var __vue_template_functional__ = false
/* styles */
var __vue_styles__ = null
/* scopeId */
var __vue_scopeId__ = null
/* moduleIdentifier (server only) */
var __vue_module_identifier__ = null
var Component = normalizeComponent(
  __WEBPACK_IMPORTED_MODULE_0__babel_loader_node_modules_vue_loader_lib_selector_type_script_index_0_VendorSocialFields_vue__["a" /* default */],
  __WEBPACK_IMPORTED_MODULE_1__node_modules_vue_loader_lib_template_compiler_index_id_data_v_21406e92_hasScoped_false_buble_transforms_node_modules_vue_loader_lib_selector_type_template_index_0_VendorSocialFields_vue__["a" /* default */],
  __vue_template_functional__,
  __vue_styles__,
  __vue_scopeId__,
  __vue_module_identifier__
)
Component.options.__file = "src/admin/pages/VendorSocialFields.vue"

/* hot reload */
if (false) {(function () {
  var hotAPI = require("vue-hot-reload-api")
  hotAPI.install(require("vue"), false)
  if (!hotAPI.compatible) return
  module.hot.accept()
  if (!module.hot.data) {
    hotAPI.createRecord("data-v-21406e92", Component.options)
  } else {
    hotAPI.reload("data-v-21406e92", Component.options)
  }
  module.hot.dispose(function (data) {
    disposed = true
  })
})()}

/* harmony default export */ __webpack_exports__["a"] = (Component.exports);


/***/ }),
/* 240 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
var render = function() {
  var _vm = this
  var _h = _vm.$createElement
  var _c = _vm._self._c || _h
  return _c("div", { staticClass: "social-info" }, [
    _c("div", { staticClass: "content-header" }, [
      _vm._v(
        "\n        " + _vm._s(_vm.__("Social Options", "dokan-lite")) + "\n    "
      )
    ]),
    _vm._v(" "),
    _c("div", { staticClass: "content-body" }, [
      _c(
        "div",
        { staticClass: "dokan-form-group" },
        [
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "facebook" } }, [
              _vm._v(_vm._s(_vm.__("Facebook", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.social.fb,
                  expression: "vendorInfo.social.fb"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                id: "facebook",
                type: "text",
                placeholder: _vm.__("https://example.com")
              },
              domProps: { value: _vm.vendorInfo.social.fb },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(_vm.vendorInfo.social, "fb", $event.target.value)
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "flickr" } }, [
              _vm._v(_vm._s(_vm.__("Flickr", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.social.flickr,
                  expression: "vendorInfo.social.flickr"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                id: "flickr",
                type: "text",
                placeholder: _vm.__("https://example.com")
              },
              domProps: { value: _vm.vendorInfo.social.flickr },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(_vm.vendorInfo.social, "flickr", $event.target.value)
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "twitter" } }, [
              _vm._v(_vm._s(_vm.__("Twitter", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.social.twitter,
                  expression: "vendorInfo.social.twitter"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                id: "twitter",
                type: "text",
                placeholder: _vm.__("https://example.com")
              },
              domProps: { value: _vm.vendorInfo.social.twitter },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(
                    _vm.vendorInfo.social,
                    "twitter",
                    $event.target.value
                  )
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "youtube" } }, [
              _vm._v(_vm._s(_vm.__("Youtube", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.social.youtube,
                  expression: "vendorInfo.social.youtube"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                id: "youtube",
                type: "text",
                placeholder: _vm.__("https://example.com")
              },
              domProps: { value: _vm.vendorInfo.social.youtube },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(
                    _vm.vendorInfo.social,
                    "youtube",
                    $event.target.value
                  )
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "linkedin" } }, [
              _vm._v(_vm._s(_vm.__("Linkedin", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.social.linkedin,
                  expression: "vendorInfo.social.linkedin"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                id: "linkedin",
                type: "text",
                placeholder: _vm.__("https://example.com")
              },
              domProps: { value: _vm.vendorInfo.social.linkedin },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(
                    _vm.vendorInfo.social,
                    "linkedin",
                    $event.target.value
                  )
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { id: "pinterest", for: "pinterest" } }, [
              _vm._v(_vm._s(_vm.__("Pinterest", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.social.pinterest,
                  expression: "vendorInfo.social.pinterest"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                type: "text",
                placeholder: _vm.__("https://example.com")
              },
              domProps: { value: _vm.vendorInfo.social.pinterest },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(
                    _vm.vendorInfo.social,
                    "pinterest",
                    $event.target.value
                  )
                }
              }
            })
          ]),
          _vm._v(" "),
          _c("div", { staticClass: "column" }, [
            _c("label", { attrs: { for: "instagram" } }, [
              _vm._v(_vm._s(_vm.__("Instagram", "dokan-lite")))
            ]),
            _vm._v(" "),
            _c("input", {
              directives: [
                {
                  name: "model",
                  rawName: "v-model",
                  value: _vm.vendorInfo.social.instagram,
                  expression: "vendorInfo.social.instagram"
                }
              ],
              staticClass: "dokan-form-input",
              attrs: {
                id: "instagram",
                type: "text",
                placeholder: _vm.__("https://example.com")
              },
              domProps: { value: _vm.vendorInfo.social.instagram },
              on: {
                input: function($event) {
                  if ($event.target.composing) {
                    return
                  }
                  _vm.$set(
                    _vm.vendorInfo.social,
                    "instagram",
                    $event.target.value
                  )
                }
              }
            })
          ]),
          _vm._v(" "),
          _vm._l(_vm.getSocialFields, function(component, index) {
            return _c(component, {
              key: index,
              tag: "component",
              attrs: { vendorInfo: _vm.vendorInfo }
            })
          })
        ],
        2
      )
    ])
  ])
}
var staticRenderFns = []
render._withStripped = true
var esExports = { render: render, staticRenderFns: staticRenderFns }
/* harmony default export */ __webpack_exports__["a"] = (esExports);
if (false) {
  module.hot.accept()
  if (module.hot.data) {
    require("vue-hot-reload-api")      .rerender("data-v-21406e92", esExports)
  }
}

/***/ })
],[194]);