<?php
/**
* Plugin Name:       Cmsmart Toolkit
* Plugin URI:        https://cmsmart.net
* Version:           1.0.0
* Description:       Include File manager and adminer
* Requires at least: 5.2
* Requires PHP:      7.1
* Author:            thanhbinh87
* Author URI:        https://cmsmart.net
* License:           GPL v2 or later
* License URI:       https://www.gnu.org/licenses/gpl-2.0.html
* Text Domain:       cmsmart-toolkit
* Domain Path:       /languages
*/

add_action( 'admin_menu', 'cmtk_options_page' );
function cmtk_options_page() {
    $hookname = add_menu_page(
        'Cmsmart Toolkit',
        'Cmsmart Toolkit',
        'install_plugins',
        'cmsmart-toolkit',
        'cmtk_options_page_html',
        plugin_dir_url(__FILE__) . 'images/settings.svg',
        20
    );
 
    add_action( 'load-' . $hookname, 'wporg_options_page_submit' );
}

function cmtk_options_page_html(){
    ?>
    <div class="wrap">
        <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
        <table class="form-table">
            <tbody>
                <tr valign="top">
                    <th>TinyFileManager:</th>
                    <td><a target="_blank" href="<?= plugin_dir_url(__FILE__) ?>tinyfilemanager.php"><?= plugin_dir_url(__FILE__) ?>tinyfilemanager.php</a></td>
                </tr>
                <tr valign="top">
                    <th>Adminer:</th>
                    <td><a target="_blank" href="<?= plugin_dir_url(__FILE__) ?>adminer.php"><?= plugin_dir_url(__FILE__) ?>adminer.php</a></td>
                </tr>
            </tbody>
        </table>
    </div>
    <?php
}