        <?php
/**
 * Plugin Name:       Customize the design web2print
 * Plugin URI:        https://cmsmart.net
 * Description:       Customize the design web2print
 * Version:           1.0.1
 * Requires at least: 5.2
 * Requires PHP:      7.1   
 * Author:            Huy
 * Author URI:        https://cmsmart.net
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       Customize the design web2print
 * Domain Path:       /languages
 nbd_extra_css
 */
// $path = plugin_dir_url(__FILE__) . 'assets/style.css';
add_action('nbd_js_config','tppl_add_js');
function tppl_add_js(){
    ?>
      var web2print_add_js = 1;
    <?php 
}

add_action('wp_enqueue_scripts','crs_logo_style');
function crs_logo_style(){
    ?>
        <link rel="stylesheet" href="<?= plugin_dir_url(__FILE__) . 'assets/stylect.css'; ?>">
    <?php
}

add_action('add_header_ed','addHeader');
function addHeader(){
    ?>
        <div class="homepage-hr"></div>
        <div class="homepage-title container-fluid">
            <div class="homepage-title-icon">
                <i class="fas fa-bars"></i>
                <span>Todos los productos</span>
            </div>
            <div class="homepage-title-nav">
                <ul class="nav">
                    <li class="nav-item">
                        <a class="nav-link" href="#">Catálogo</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Tienda</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Inpsiración</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#">Centro de ayuda</a>
                    </li>
                </ul>
            </div>
            <div class="homepage-title-Offers">
                <div class="Offers-icon">
                    <img src="<?php echo plugin_dir_url(__FILE__) . 'image/Group2.svg' ?>" alt="">
                    <a href="#">Ofertas</a>
                </div>
                <div class="pen-icon">
                    <img src="<?php echo plugin_dir_url(__FILE__) . 'image/Group.svg' ?>" alt="">
                    <a href="#">Cotiza</a>
                </div>
            </div>
        </div>
    <?php
}

add_filter('porto_minicart','priceCartHd');
function priceCartHd(){
    if ( class_exists( 'Woocommerce' ) || ( defined( 'PORTO_DEMO' ) && PORTO_DEMO ) ) :
        $icon_class = 'minicart-icon';
        if ( empty( $porto_settings['minicart-icon'] ) ) {
            if ( 'simple' == $minicart_type ) {
                $icon_class .= ' minicart-icon-default';
            } else {
                $icon_class .= ' porto-icon-bag-2';
            }
        } else {
            $icon_class .= ' ' . trim( $porto_settings['minicart-icon'] );
        }
        ?>
        <div id="mini-cart" class="mini-cart <?php echo esc_attr( $minicart_type ), isset( $porto_settings['minicart-content'] ) && $porto_settings['minicart-content'] ? ' minicart-offcanvas' : '', $el_class ? ' ' . esc_attr( $el_class ) : ''; ?>">
            <div class="cart-head">
            <?php
            if ( 'minicart-inline' == $minicart_type || 'minicart-text' == $minicart_type ) {
                $cart_text = empty( $porto_settings['minicart-text'] ) ? __( 'Cart', 'porto' ) : $porto_settings['minicart-text'];
                $format    = '<span class="cart-icon"><i class="' . esc_attr( $icon_class ) . '"></i><span class="cart-items">%s</span></span><span class="cart-subtotal">' . esc_html( $cart_text ) . ' %s</span>';
                if ( defined( 'WP_CACHE' ) && WP_CACHE ) {
                    $_cart_qty   = '<i class="fas fa-spinner fa-pulse"></i>';
                    $_cart_total = $_cart_qty;
                } else {
                    $_cart_qty   = $woocommerce->cart ? $woocommerce->cart->cart_contents_count : 0;
                    $_cart_total = $woocommerce->cart ? $woocommerce->cart->get_cart_subtotal() : 0;
                }
                printf( $format, $_cart_qty, '<span class="cart-price">' . $_cart_total . '</span>' );
            } else {
                $format = '
                    <svg width="40" height="40" xmlns="http://www.w3.org/2000/svg" xml:space="preserve" version="1.1">
                        <path stroke="null" id="svg_1" d="m39.28264,17.36757l-5.42092,-2.94303l4.32956,-2.9554c0.24553,-0.1675 0.38462,-0.4545 0.36552,
                        -0.75363c-0.01909,-0.29914 -0.19358,-0.56556 -0.45843,-0.69967l-12.21058,-6.18476c-0.25808,-0.13074 -0.56488,-0.1168 -0.81075,
                        0.03732l-4.96593,3.11526l-4.96593,-3.11526c-0.24564,-0.15412 -0.55256,-0.16806 -0.81075,-0.03732l-12.21069,6.18487c-0.26485,
                        0.13411 -0.43934,0.40054 -0.45843,0.69967c-0.01909,0.29914 0.11999,0.58602 0.36552,0.75363l4.32956,2.9554l-5.42092,
                        2.94303c-0.26485,0.14378 -0.43257,0.42088 -0.43901,0.72508c-0.00655,0.3042 0.14952,0.58827 0.40793,0.7434l12.09403,
                        7.25787c0.13065,0.07847 0.27739,0.11781 0.42435,0.11781c0.13509,0 0.2704,-0.03327 0.39338,-0.10005l5.45843,-2.96338l0,
                        12.57816l-10.51616,-5.33748l0,-4.86399c0,-0.46562 -0.37263,-0.84312 -0.8325,-0.84312s-0.8325,0.37749 -0.8325,0.84312l0,
                        5.38447c0,0.31903 0.17793,0.61087 0.45954,0.75375l12.18105,6.1824c0.00788,0.00393 0.0161,0.00674 0.02398,0.01045c0.01299,
                        0.00607 0.02597,0.01169 0.03918,0.01709c0.02065,0.00843 0.0414,0.01574 0.06238,0.02237c0.01277,0.00405 0.02542,0.00821 0.03841,
                        0.01158c0.02287,0.00607 0.04595,0.01057 0.06915,0.0145c0.01177,0.00202 0.02331,0.00472 0.03519,0.00618c0.03119,0.00405 0.0626,
                        0.00618 0.09402,0.00652c0.00377,0 0.00744,0.00079 0.01121,0.00079c0.03541,0 0.07093,-0.00292 0.10645,-0.00764c0.00877,
                        -0.00112 0.01743,-0.00315 0.02631,-0.00461c0.02597,-0.00427 0.05184,-0.00956 0.07759,-0.01641c0.01199,-0.00315 0.02364,
                        -0.00697 0.03552,-0.01068c0.02209,-0.00697 0.04396,-0.01484 0.06571,-0.02383c0.01299,-0.00528 0.02575,-0.01079 0.03852,
                        -0.01675c0.00744,-0.00348 0.01499,-0.00596 0.02231,-0.00967l12.18105,-6.1824c0.28161,-0.14288 0.45954,-0.43471 0.45954,
                        -0.75375l0,-5.38447c0,-0.46562 -0.37263,-0.84312 -0.8325,-0.84312s-0.8325,0.37749 -0.8325,0.84312l0,4.86399l-10.51605,
                        5.33726l0,-12.57805l5.45843,2.96338c0.12299,0.06677 0.2583,0.10005 0.39338,0.10005c0.14696,0 0.29371,-0.03935 0.42435,
                        -0.11781l12.09403,-7.25787c0.25841,-0.15502 0.41436,-0.43921 0.40793,-0.7434c-0.00633,-0.3042 -0.17416,-0.58119 -0.43901,
                        -0.72497zm-19.17151,3.39202l-10.43269,-6.26075l10.43269,-5.5703l10.43269,5.5703l-10.43269,6.26075zm5.44756,-15.2098l10.5196,
                        5.32826l-3.8385,2.62007l-10.454,-5.58165l3.7729,-2.36668zm-10.89522,0l3.77279,2.36679l-10.454,5.58165l-3.83839,-2.62018l10.5196,
                        -5.32826zm-1.21623,18.85094l-10.42014,-6.25333l4.96948,-2.69797l10.42014,6.25322l-4.96948,2.69808zm13.32768,0l-4.96948,
                        -2.69797l10.42014,-6.25322l4.96948,2.69797l-10.42014,6.25322z" />
                    </svg>
                    <span class="cart-items">%s</span></span>
                    <div class="price-cart-hd">
                        <span id="micarrito">Mi carrito</span>
                        <h5 id="micarrito-price">$' . WC()->cart->cart_contents_total . '.00</h5>
                    </div>';
                if ( ! class_exists( 'Woocommerce' ) && defined( 'PORTO_DEMO' ) && PORTO_DEMO ) {
                    $_cart_qty  = 1;
                    $_cart_qty1 = 1;
                } elseif ( defined( 'WP_CACHE' ) && WP_CACHE ) {
                    $_cart_qty  = '<i class="fas fa-spinner fa-pulse"></i>';
                    $_cart_qty1 = $_cart_qty;
                } else {
                    $_cart_qty = $woocommerce->cart ? $woocommerce->cart->cart_contents_count : 0;
                    /* translators: %s: Cart quantity */
                    $_cart_qty1 = sprintf( _n( '%d item', '%d items', $_cart_qty, 'porto' ), $_cart_qty );
                }

                printf( $format, $_cart_qty, $_cart_qty1 );
            }
            ?>
            </div>
            <div class="cart-popup widget_shopping_cart">
                <div class="widget_shopping_cart_content">
                <?php if ( class_exists( 'Woocommerce' ) ) : ?>
                    <div class="cart-loading"></div>
                <?php else : ?>
                    <ul class="cart_list py-3 px-0 mb-0"><li class="empty pt-0"><?php esc_html_e( 'WooCommerce is not installed.', 'porto' ); ?></li></ul>
                <?php endif; ?>
                </div>
            </div>
        <?php
        if ( ! empty( $porto_settings['minicart-content'] ) ) {
            echo '<div class="minicart-overlay"><svg viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"><defs><style>.minicart-svg{fill:none;stroke:#fff;stroke-linecap:round;stroke-linejoin:round;stroke-width:2px;}</style></defs><title/><g id="cross"><line class="minicart-svg" x1="7" x2="25" y1="7" y2="25"/><line class="minicart-svg" x1="7" x2="25" y1="25" y2="7"/></g></svg></div>';
        }
        ?>
        </div>
        <?php
    endif;
}

add_action('woocommerce_after_shop_loop_item','buttonComprar');
function buttonComprar()
{
    ?>
        <button id="btcomprar">Comprar</button>
    <?php
}

add_action('add_footer_ed','addFooter');
function addFooter(){
    ?>
        <div class="containert container-fluid">
            <div class="bt-logo">
                <img src="<?php echo plugin_dir_url(__FILE__) . 'image/logot.png' ?>" alt="">
            </div>
            <div class="bt-title">
                <div class="porto-sicon-header">
                    <h4 class="porto-sicon-title">Suscríbete a nuestro newsletter</h4>
                    <p>Obtén la más reciente información sobre nuevos productos, descuentos y ofertas.</p>
                </div>
            </div>
            <div class="bt-form">
                <form action="" method="post" class="wpcf7-form init" novalidate="novalidate" data-status="init">
                    <div class="form-row d-flex justify-content-end widget-subscribe mb-0">
                        <span class="wpcf7-form-control-wrap email"><input type="email" name="email" value="" size="40" class="wpcf7-form-control wpcf7-text wpcf7-email wpcf7-validates-as-required wpcf7-validates-as-email form-control" id="email" aria-required="true" aria-invalid="false" placeholder="ejemplo@email.com"></span><br>
                        <input type="submit" value="Suscribirme" class="wpcf7-form-control has-spinner wpcf7-submit submit btn btn-secondary" id="submit"><span class="wpcf7-spinner"></span>
                    </div>
                </form>
            </div>
        </div>
    <?php
}

add_action('shop_title_filter','addTitle_filterShop');
function addTitle_filterShop() {
    ?>
        <div class="hr-filter" style="width: 100%;">
            <div class="shop-hr"></div>
            <p class="shop-hr-content">Navega entre nuestros productos con los filtros especializados.</p>
       </div>
        <div class="shop-filters">
            <div class="shop-filters-child">
                <i class="fas fa-filter"></i>
                <span>filters</span>
            </div>
        </div>
    <?php
}

// 404

add_action('w4_content_error','contentEr');
function contentEr(){
    ?>
        <img src="<?php echo plugin_dir_url(__FILE__) . 'image/loi404.png' ?>" alt="">
    <?php
}

function wooc_extra_register_fields() {?>
       <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
           <label class="custom-lable" for="reg_billing_first_name"><?php _e( 'Nombre*', 'woocommerce' ); ?><span class="required">*</span></label>
           <input type="text" class="input-text custom-input" name="billing_first_name" placeholder="Escribe aquí tu nombre" id="reg_billing_first_name" value="<?php if ( ! empty( $_POST['billing_first_name'] ) ) esc_attr_e( $_POST['billing_first_name'] ); ?>" />
       </p>
      <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
           <label class="custom-lable" for="reg_billing_last_name"><?php _e( 'Apellidos*', 'woocommerce' ); ?><span class="required">*</span></label>
           <input type="text" class="input-text custom-input" name="billing_last_name" placeholder="Escribe aquí tus apellidos" id="reg_billing_last_name" value="<?php if ( ! empty( $_POST['billing_last_name'] ) ) esc_attr_e( $_POST['billing_last_name'] ); ?>" />
       </p>

        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <label class="font-weight-medium mb-1 custom-lable" for="reg_email"><?php esc_html_e( 'Email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
            <input type="email" class="woocommerce-Input woocommerce-Input--text line-height-xl input-text custom-input" placeholder="Escribe aquí tu e-mail" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" />
        </p>

       <p class="form-row form-row-wide">
           <label for="reg_billing_phone" class="mb-1 custom-lable"><?php _e( 'Whatsapp o teléfono de contacto', 'woocommerce' ); ?><span class="required">*</span></label>
           <input type="text" class="input-text custom-input" placeholder="Escribe aquí tu Whatsapp" name="phone" id="" value="<?php esc_attr_e( $_POST['phone'] ); ?>" />
       </p>

        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <label class="font-weight-medium mb-1 custom-lable" for="reg_password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
            <input type="password" class="woocommerce-Input woocommerce-Input--text line-height-xl input-text custom-input" placeholder="Escribe aquí tu contraseña" name="password" id="reg_password" autocomplete="new-password" />
        </p>

       <div class="clear"></div>
       <?php
 }
 add_action( 'woocommerce_register_form_start', 'wooc_extra_register_fields' );


function my_account_my_order() {
    $items = array(
        'dashboard'       => __( 'Dashboard', 'woocommerce' ),
        'orders'          => __( 'Orders ', 'woocommerce' ),
        'downloads'       => __( 'Downloads', 'woocommerce' ),
        'edit-address'    => _n( 'Address', 'Address', (int) wc_shipping_enabled(), 'woocommerce' ),
        'edit-account'    => __( 'Account details', 'woocommerce' ),
        'my-designs' => __( 'My designs', 'woocommerce' ),
        'customer-logout' => __( 'Logout', 'woocommerce' ),
    );
    return $items;
}
add_filter('woocommerce_account_menu_items','my_account_my_order');

add_action('w4_edit_adress','editAdress');
function editAdress()
{
    ?>
        <img src="<?php echo plugin_dir_url(__FILE__) . 'image/editad.svg' ?>" alt="" style="float: right;">
    <?php
}


function wooc_validate_extra_register_fields( $username, $email, $validation_errors ) {
      if ( isset( $_POST['billing_first_name'] ) && empty( $_POST['billing_first_name'] ) ) {
             $validation_errors->add( 'billing_first_name_error', __( '<strong>Error</strong>: First name is required!', 'woocommerce' ) );
      }
      if ( isset( $_POST['billing_last_name'] ) && empty( $_POST['billing_last_name'] ) ) {
             $validation_errors->add( 'billing_last_name_error', __( '<strong>Error</strong>: Last name is required!.', 'woocommerce' ) );
      }
         return $validation_errors;
}
add_action( 'woocommerce_register_post', 'wooc_validate_extra_register_fields', 10, 3 );

function wooc_save_extra_register_fields( $customer_id ) {
    if ( isset( $_POST['billing_phone'] ) ) {
                 update_user_meta( $customer_id, 'billing_phone', sanitize_text_field( $_POST['billing_phone'] ) );
          }
      if ( isset( $_POST['billing_first_name'] ) ) {
             update_user_meta( $customer_id, 'first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
             update_user_meta( $customer_id, 'billing_first_name', sanitize_text_field( $_POST['billing_first_name'] ) );
      }
      if ( isset( $_POST['billing_last_name'] ) ) {
             update_user_meta( $customer_id, 'last_name', sanitize_text_field( $_POST['billing_last_name'] ) );
             update_user_meta( $customer_id, 'billing_last_name', sanitize_text_field( $_POST['billing_last_name'] ) );
      }
}
add_action( 'woocommerce_created_customer', 'wooc_save_extra_register_fields' );