<?php
  /*
   * Template name: Registration Form
   */
?>
<?php if(is_user_logged_in()){
  wp_redirect(get_permalink(get_option('woocommerce_myaccount_page_id')));
} ?>
<?php get_header();?>
<?php do_action( 'woocommerce_before_customer_login_form' ); ?>

<div class="title-login">
	<h3 class="micuenta">Mi cuenta</h3>
	<p class="micuenta-title">¡Regístrate! Gestiona tus pedidos, facturas y detalles de tu cuenta en un mismo lugar</p>
</div>

<div class="custom-registration" style="margin-top:46px;">

	<div class="" style="width: 523px;margin: auto;">
					<form method="post" novalidate class="woocommerce-form woocommerce-form-register register pl-lg-4 pe-0" <?php do_action( 'woocommerce_register_form_tag' ); ?> >
						<h3 class="micuenta" style="text-align: center;margin-bottom: 26px"><?php esc_html_e( 'Registro', 'woocommerce' ); ?></h3>
						<?php do_action( 'woocommerce_register_form_start' ); ?>

						<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

							<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
								<label class="font-weight-medium mb-1" for="reg_username"><?php esc_html_e( 'Username', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
								<input type="text" class="woocommerce-Input woocommerce-Input--text line-height-xl input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
							</p>

						<?php endif; ?>

						<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

							<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
								<label class="font-weight-medium mb-1" for="reg_password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
								<input type="password" class="woocommerce-Input woocommerce-Input--text line-height-xl input-text" name="password" id="reg_password" autocomplete="new-password" />
							</p>

						<?php else : ?>

						<?php endif; ?>

						<?php do_action( 'woocommerce_register_form' ); ?>

						<p class="status" style="display: none;"></p>

						<p class="woocommerce-form-row form-row mb-0" style="text-align: center;">
							<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
							<button type="submit" class="custom-btn" name="register" value="<?php esc_attr_e( 'Registrarme', 'woocommerce' ); ?>"><?php esc_html_e( 'Registrarme', 'woocommerce' ); ?></button>
						</p>

						<p class="unacuenta">Ya cuento con una cuenta, <a href="<?php echo get_site_url(null, '/my-account/', ''); ?>">¡Iniciar Sesión!</a></p>

						<?php do_action( 'woocommerce_register_form_end' ); ?>

					</form>

				</div>
	
</div>

<?php do_action( 'woocommerce_after_customer_login_form' ); ?>
<?php get_footer();?>