<?php
/**
 * Edit account form
 *
 * @version     3.5.0
 */

defined( 'ABSPATH' ) || exit;

$porto_woo_version = porto_get_woo_version_number();
if ( version_compare( $porto_woo_version, '2.6', '<' ) ) :
	wc_print_notices();
	?>
	<div class="featured-box align-left">
		<div class="box-content">
<?php endif; ?>

<?php do_action( 'woocommerce_before_edit_account_form' ); ?>
<form action="" method="post" class="woocommerce-EditAccountForm edit-account" <?php do_action( 'woocommerce_edit_account_form_tag' ); ?> >

	<?php do_action( 'woocommerce_edit_account_form_start' ); ?>

	<p class="woocommerce-FormRow woocommerce-FormRow--first form-row form-row-first">
		<label class="mb-1 custom-lable" for="account_first_name"><?php esc_html_e( 'Nombre', 'porto' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="woocommerce-Input woocommerce-Input--text line-height-xl input-text custom-input" name="account_first_name" placeholder="Escribe aquí tu nombre" id="account_first_name" autocomplete="given-name" value="<?php echo esc_attr( $user->first_name ); ?>" />
	</p>
	<p class="woocommerce-FormRow woocommerce-FormRow--last form-row form-row-last">
		<label class="mb-1 custom-lable" for="account_last_name"><?php esc_html_e( 'Apellidos', 'porto' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="woocommerce-Input woocommerce-Input--text line-height-xl input-text custom-input" name="account_last_name" placeholder="Escribe aquí tu apellido" id="account_last_name" autocomplete="family-name" value="<?php echo esc_attr( $user->last_name ); ?>" />
	</p>
	<div class="clear"></div>

	<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
		<label class="mb-1 custom-lable" for="account_display_name"><?php esc_html_e( 'Nombre de usuario', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="text" class="woocommerce-Input woocommerce-Input--text line-height-xl input-text custom-input" name="account_display_name" placeholder="Escribe aquí tu nombre de usuarios" id="account_display_name" value="<?php echo esc_attr( $user->display_name ); ?>" /> <span class="text-sm"><?php esc_html_e( 'Este es el nombre que se  mostrará en tu cuenta.', 'woocommerce' ); ?></span>
	</p>
	<div class="clear"></div>

	<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
		<label class="mb-1 custom-lable" for="account_email"><?php esc_html_e( 'Dirección de e-mail', 'porto' ); ?>&nbsp;<span class="required">*</span></label>
		<input type="email" class="woocommerce-Input woocommerce-Input--email line-height-xl input-text custom-input" name="account_email" placeholder="Escribe aquí tu e-mail" id="account_email" autocomplete="email" value="<?php echo esc_attr( $user->user_email ); ?>" />
	</p>
	<div class="">
		<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
			<label class="mb-1 custom-lable" for="account_display_name"><?php esc_html_e( 'Cambiar contraseña', 'woocommerce' ); ?></label>
			<span><?php esc_html_e( 'Si deseas cambiar tu contraseña completa los siguientes campos.', 'woocommerce' ); ?></span>
		</p>
		<fieldset class="mt-4">
			<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
				<label class="mb-1 font-weight-medium custom-lable" for="password_current"><?php esc_html_e( 'Contraseña actual', 'porto' ); ?></label>
				<input type="password" class="woocommerce-Input woocommerce-Input--password line-height-xl input-text custom-input" placeholder="Escribe aquí tu contraseña actual" name="password_current" id="password_current" autocomplete="off" />
			</p>

			<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
				<label class="mb-1 font-weight-medium custom-lable" for="password_1"><?php esc_html_e( 'Nueva contraseña', 'porto' ); ?></label>
				<input type="password" class="woocommerce-Input woocommerce-Input--password line-height-xl input-text custom-input" placeholder="Escribe aquí tu nueva contraseña" name="password_1" id="password_1" autocomplete="off" />
			</p>

			<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
				<label class="mb-1 font-weight-medium custom-lable" for="password_2"><?php esc_html_e( 'Confirma tu nueva contraseña', 'porto' ); ?></label>
				<input type="password" class="woocommerce-Input woocommerce-Input--password line-height-xl input-text custom-input" placeholder="Confirma aquí tu nueva contraseña" name="password_2" id="password_2" autocomplete="off" />
			</p>
		</fieldset>
	</div>
	<div class="clear"></div>

	<?php do_action( 'woocommerce_edit_account_form' ); ?>

	<p class="clearfix">
		<?php wp_nonce_field( 'save_account_details', 'save-account-details-nonce' ); ?>
		<button type="submit" class="woocommerce-Button button btn-v-dark btn-go-shop pt-left custom-btn" name="save_account_details" value="<?php esc_attr_e( 'Guardar cambios', 'porto' ); ?>"><?php esc_html_e( 'Guardar cambios', 'porto' ); ?></button>
		<input type="hidden" name="action" value="save_account_details" />
	</p>

	<?php do_action( 'woocommerce_edit_account_form_end' ); ?>

</form>

<?php do_action( 'woocommerce_after_edit_account_form' ); ?>

<?php if ( version_compare( $porto_woo_version, '2.6', '<' ) ) : ?>
		</div>
	</div>
<?php endif; ?>
