<?php
/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_account_navigation' );
$woo         = defined( 'WOOCOMMERCE_VERSION' );
$wishlist    = defined( 'YITH_WCWL' );
if ( $wishlist & $woo ) {
	$account_arr = array();
	foreach ( wc_get_account_menu_items() as $endpoint => $label ) {
		if ( 'customer-logout' == $endpoint ) {
			//$account_arr['wishlist'] = __( 'Wishlist', 'porto' );
		}
		$account_arr[ $endpoint ] = $label;
	}
} else {
	$account_arr = wc_get_account_menu_items();
}
?>

<!-- 	$args = array(
			'delimiter' => '>'
	);

    woocommerce_breadcrumb( $args );  -->


<nav class="woocommerce-MyAccount-navigation" style="border-right: 1px solid #D1D6E0;padding-bottom: 0;">
	<ul style="margin-bottom: 0;">
		<?php foreach ( $account_arr as $endpoint => $label ) : ?>
			<li class="<?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
				<?php
					if ( 'wishlist' == $endpoint ) {
						$url = YITH_WCWL()->get_wishlist_url();
					} else {
						$url = wc_get_account_endpoint_url( $endpoint );
					}
				?>
				<a href="<?php echo esc_url( $url ); ?>"><?php echo esc_html( $label ); ?></a>
			</li>
		<?php endforeach; ?>
	</ul>
</nav>

<?php do_action( 'woocommerce_after_account_navigation' ); ?>
