'use strict';

var node_child_process = require('node:child_process');
var node_util = require('node:util');
var treeKill = require('tree-kill');
var signalExit = require('signal-exit');

const pTreeKill = node_util.promisify(treeKill);
const spawnd = (command, options)=>{
    const proc = node_child_process.spawn(command, options);
    const cleanExit = (code = 1)=>{
        if (proc && proc.pid) {
            treeKill(proc.pid, ()=>process.exit(code));
        } else {
            process.exit(code);
        }
    };
    const cleanExit1 = ()=>cleanExit(1);
    proc.stderr.pipe(process.stderr);
    proc.on("exit", cleanExit);
    proc.on("error", cleanExit1);
    const offExit = signalExit.onExit((code)=>{
        cleanExit(typeof code === "number" ? code : 1);
    });
    proc.destroy = async ()=>{
        offExit();
        proc.removeListener("exit", cleanExit);
        proc.removeListener("error", cleanExit1);
        if (typeof proc.pid === "number") {
            await pTreeKill(proc.pid).catch(()=>{
            /* ignore error */ });
        }
    };
    return proc;
};

exports.spawnd = spawnd;
