import { PackageJson } from 'type-fest';
export interface AuditDependenciesWithRestrictedVersionResponse {
    hasDependencyWithRestrictedVersion: boolean;
    dependenciesWithRestrictedVersion: string[];
    dependenciesWithoutRestrictedVersion: string[];
}
/**
 * Determines whether or not the package has a given dependency
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param depsToCheckFor An array of packages to check for
 * @return True if the package has a dependency. False if it is not or the node is missing.
 */
export declare const auditDependenciesWithRestrictedVersion: (packageJsonData: PackageJson | any, nodeName: string, depsToCheckFor: string[]) => AuditDependenciesWithRestrictedVersionResponse;
export interface AuditDependenciesWithRestrictedPrereleaseVersionResponse {
    hasDependencyWithRestrictedPrereleaseVersion: boolean;
    dependenciesWithRestrictedPrereleaseVersion: string[];
    dependenciesWithoutRestrictedPrereleaseVersion: string[];
}
/**
 * Determines whether or not the package has a pre-release version of a given dependency
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param depsToCheckFor An array of packages to check for
 * @return True if the package has a pre-release version of a dependency. False if it is not or the node is missing.
 */
export declare const auditDependenciesWithRestrictedPrereleaseVersion: (packageJsonData: PackageJson | any, nodeName: string, depsToCheckFor: string[]) => AuditDependenciesWithRestrictedPrereleaseVersionResponse;
export interface AuditDependenciesWithMajorVersionOfZeroResponse {
    hasDependencyWithMajorVersionOfZero: boolean;
    dependenciesWithMajorVersionOfZero: string[];
    dependenciesWithoutMajorVersionOfZero: string[];
}
/**
 * Determines whether or not the package has a dependency with a major version of 0
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param config Rule configuration
 * @return True if the package has a dependency with version 0. False if it does not or the node is missing.
 */
export declare const auditDependenciesWithMajorVersionOfZero: (packageJsonData: PackageJson | any, nodeName: string, config: any) => AuditDependenciesWithMajorVersionOfZeroResponse;
/**
 * Determines if the dependencies version string starts with the specified range
 * @param  {String}   dependencyVersion   Dependency's version range
 * @param  {String}   rangeSpecifier      A version range specifier
 * @return {Boolean}                      True if the version starts with the range, false if it doesn't.
 */
export declare const doesVersionStartWithRange: (dependencyVersion: string, rangeSpecifier: string) => boolean;
export interface AuditDependenciesForValidRangeResponse {
    onlyValidVersionsDetected: boolean;
    dependenciesWithValidVersionRange: string[];
    dependenciesWithoutValidVersionRange: string[];
}
/**
 * Determines whether or not all dependency version ranges match expected range
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param rangeSpecifier A version range specifier
 * @param config Rule configuration
 * @return False if the package has an invalid range. True if it is not or the node is missing.
 */
export declare const auditDependenciesForValidRangeVersions: (packageJsonData: PackageJson | any, nodeName: string, rangeSpecifier: string, config: any) => AuditDependenciesForValidRangeResponse;
export interface AuditDependenciesForInvalidRangeResponse {
    hasInvalidRangeVersions: boolean;
    dependenciesWithInvalidVersionRange: string[];
    dependenciesWithoutInvalidVersionRange: string[];
}
/**
 * Determines if any dependencies have a version string that starts with the specified invalid range
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param rangeSpecifier A version range specifier
 * @param config Rule configuration
 * @return True if any dependencies versions start with the invalid range, false if they don't.
 */
export declare const auditDependenciesForInvalidRange: (packageJsonData: PackageJson | any, nodeName: string, rangeSpecifier: string, config: any) => AuditDependenciesForInvalidRangeResponse;
export interface AbsoluteVersionCheckerResult {
    onlyAbsoluteVersionDetected: boolean;
    dependenciesChecked: number;
    dependenciesWithAbsoluteVersion: string[];
    dependenciesWithoutAbsoluteVersion: string[];
}
export interface AuditDependenciesForAbsoluteVersionResponse {
    onlyAbsoluteVersionsDetected: boolean;
    dependenciesWithAbsoluteVersion: string[];
    dependenciesWithoutAbsoluteVersion: string[];
}
/**
 * Determines whether or not all dependency versions are absolut
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param config Rule configuration
 * @return False if the package has an non-absolute version. True if it is not or the node is missing.
 */
export declare const auditDependenciesForAbsoluteVersion: (packageJsonData: PackageJson | any, nodeName: string, config: any) => AuditDependenciesForAbsoluteVersionResponse;
export interface AuditDependenciesForNonAbsoluteVersionResponse {
    onlyNonAbsoluteVersionsDetected: boolean;
    dependenciesWithAbsoluteVersion: string[];
    dependenciesWithoutAbsoluteVersion: string[];
}
/**
 * Determines whether or not all dependency versions are absolut
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param config Rule configuration
 * @return False if the package has an non-absolute version. True if it is not or the node is missing.
 */
export declare const auditDependenciesForNonAbsoluteVersion: (packageJsonData: PackageJson | any, nodeName: string, config: any) => AuditDependenciesForNonAbsoluteVersionResponse;
export interface AuditDependenciesForGitRepositoryVersionResponse {
    hasGitRepositoryVersions: boolean;
    dependenciesWithGitRepositoryVersion: string[];
    dependenciesWithoutGitRepositoryVersion: string[];
}
/**
 * Determines whether or not dependency versions are git repository
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param config Rule configuration
 * @return True if the package has an git repo.
 */
export declare const auditDependenciesForGitRepositoryVersion: (packageJsonData: PackageJson | any, nodeName: string, config: any) => AuditDependenciesForGitRepositoryVersionResponse;
export interface AuditDependenciesForArchiveUrlVersionResponse {
    hasArchiveUrlVersions: boolean;
    dependenciesWithArchiveUrlVersion: string[];
    dependenciesWithoutArchiveUrlVersion: string[];
}
/**
 * Determines whether or not dependency versions contains archive url
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param config Rule configuration
 * @return True if the package contain archive url.
 */
export declare const auditDependenciesForArchiveUrlVersion: (packageJsonData: PackageJson | any, nodeName: string, config: any) => AuditDependenciesForArchiveUrlVersionResponse;
export interface AuditDependenciesForFileUrlVersionResponse {
    hasFileUrlVersions: boolean;
    dependenciesWithFileUrlVersion: string[];
    dependenciesWithoutFileUrlVersion: string[];
}
/**
 * Determines whether or not dependency versions contains file url
 * @param packageJsonData Valid JSON
 * @param nodeName Name of a node in the package.json file
 * @param config Rule configuration
 * @return True if the package contain file url.
 */
export declare const auditDependenciesForFileUrlVersion: (packageJsonData: PackageJson | any, nodeName: string, config: any) => AuditDependenciesForFileUrlVersionResponse;
