import { PackageJson } from 'type-fest';
import { LintResult } from './lint-result';
import { Severity } from './severity';
export interface StandardLintFunction {
    (packageJsonData: PackageJson | any, severity: Severity): LintResult;
}
export interface ArrayLintFunction {
    <T>(packageJsonData: PackageJson | any, severity: Severity, ruleConfig: T[]): LintResult;
}
export interface ObjectLintFunction {
    (packageJsonData: PackageJson | any, severity: Severity, ruleConfig: Record<string, boolean>): LintResult;
}
export interface OptionalObjectRuleConfig {
    exceptions?: string[];
}
export interface OptionalObjectLintFunction {
    (packageJsonData: PackageJson | any, severity: Severity, ruleConfig: OptionalObjectRuleConfig): LintResult;
}
export type LintFunction = StandardLintFunction | ArrayLintFunction | ObjectLintFunction | OptionalObjectLintFunction;
