import { Config } from './configuration';
import { Rules } from './native-rules';
import { OverallLintingResult } from './linter/linter';
export interface NpmPackageJsonLintOptions {
    cwd?: string;
    packageJsonObject?: any;
    packageJsonFilePath?: string;
    config?: any;
    configFile?: any;
    configBaseDirectory?: any;
    patterns?: any;
    quiet?: boolean;
    ignorePath?: string;
    fix?: boolean;
}
export declare class NpmPackageJsonLint {
    cwd: string;
    packageJsonObject: any;
    packageJsonFilePath: string;
    patterns: any;
    quiet: boolean;
    ignorePath: string;
    fix: boolean;
    version: string;
    rules: Rules;
    configHelper: Config;
    /**
     * constructor
     * @param options An instance of the {@link NpmPackageJsonLintOptions} options object.
     * @constructor
     */
    constructor(options: NpmPackageJsonLintOptions);
    /**
     * Runs the linter using the config specified in the constructor
     *
     * @returns The results {@link OverallLintingResult} from linting a collection of package.json files.
     */
    lint(): OverallLintingResult;
}
