import { LintFunction } from './types/lint-function';
import { RuleType } from './types/rule-type';
export interface Rule {
    lint: LintFunction;
    ruleType: RuleType;
    minItems?: number;
}
export declare class Rules {
    rules: Record<string, string>;
    constructor();
    /**
     * Loads rules
     *
     * @return Set of rules
     */
    load(): Record<string, string>;
    /**
     * Loads a rule module
     *
     * @param ruleId Name of the rule
     * @return Rule module
     */
    get(ruleId: string): Rule;
    /**
     * Gets entire rule set
     *
     * @returns Rule set
     */
    getRules(): Record<string, string>;
    /**
     * Registers a rule in the rules object
     *
     * @param ruleId Name of the rule
     * @param filePathToRuleModule File path to rule
     */
    registerRule(ruleId: string, filePathToRuleModule: string): void;
}
