/**
 * Validates only the rules of a config object
 *
 * @param {Object} rulesConfig The rules config object to validate.
 * @param {String} source The name of the configuration source to report in any errors.
 * @param {Object} rules  Rules object
 * @returns {undefined} No return
 * @static
 */
export declare const validateRules: (rulesConfig: any, source: any, rules: any) => any;
/**
 * Validates entire config object, including top-level properties.
 *
 * @param {Object} config The config object to validate.
 * @param {String} source The name of the configuration source to report in any errors.
 * @param {Object} rules  Rules object
 * @returns {undefined} No return
 * @static
 */
export declare const validate: (config: any, source: any, rules: any) => any;
