export { TBTImpactTasksComputed as TBTImpactTasks };
export type TBTImpactTask = LH.Artifacts.TaskNode & {
    tbtImpact: number;
    selfTbtImpact: number;
};
declare const TBTImpactTasksComputed: typeof TBTImpactTasks & {
    request: (dependencies: import("../index.js").Artifacts.MetricComputationDataInput, context: import("../../types/utility-types.js").default.ImmutableObject<{
        computedCache: Map<string, import("../lib/arbitrary-equality-map.js").ArbitraryEqualityMap>;
    }>) => Promise<TBTImpactTask[]>;
};
/** @typedef {LH.Artifacts.TaskNode & {tbtImpact: number, selfTbtImpact: number}} TBTImpactTask */
declare class TBTImpactTasks {
    /**
     * @param {LH.Artifacts.TaskNode} task
     * @return {LH.Artifacts.TaskNode}
     */
    static getTopLevelTask(task: LH.Artifacts.TaskNode): LH.Artifacts.TaskNode;
    /**
     * @param {LH.Artifacts.MetricComputationDataInput} metricComputationData
     * @param {LH.Artifacts.ComputedContext} context
     * @return {Promise<{startTimeMs: number, endTimeMs: number}>}
     */
    static getTbtBounds(metricComputationData: LH.Artifacts.MetricComputationDataInput, context: LH.Artifacts.ComputedContext): Promise<{
        startTimeMs: number;
        endTimeMs: number;
    }>;
    /**
     * @param {LH.Artifacts.TaskNode[]} tasks
     * @param {Map<LH.Artifacts.TaskNode, number>} taskToImpact
     */
    static createImpactTasks(tasks: LH.Artifacts.TaskNode[], taskToImpact: Map<LH.Artifacts.TaskNode, number>): TBTImpactTask[];
    /**
     * @param {LH.Artifacts.TaskNode[]} tasks
     * @param {number} startTimeMs
     * @param {number} endTimeMs
     * @return {TBTImpactTask[]}
     */
    static computeImpactsFromObservedTasks(tasks: LH.Artifacts.TaskNode[], startTimeMs: number, endTimeMs: number): TBTImpactTask[];
    /**
     * @param {LH.Artifacts.TaskNode[]} tasks
     * @param {LH.Gatherer.Simulation.Result['nodeTimings']} tbtNodeTimings
     * @param {number} startTimeMs
     * @param {number} endTimeMs
     * @return {TBTImpactTask[]}
     */
    static computeImpactsFromLantern(tasks: LH.Artifacts.TaskNode[], tbtNodeTimings: LH.Gatherer.Simulation.Result['nodeTimings'], startTimeMs: number, endTimeMs: number): TBTImpactTask[];
    /**
     * @param {LH.Artifacts.MetricComputationDataInput} metricComputationData
     * @param {LH.Artifacts.ComputedContext} context
     * @return {Promise<TBTImpactTask[]>}
     */
    static compute_(metricComputationData: LH.Artifacts.MetricComputationDataInput, context: LH.Artifacts.ComputedContext): Promise<TBTImpactTask[]>;
}
//# sourceMappingURL=tbt-impact-tasks.d.ts.map