"use strict";

exports.__esModule = true;
exports.default = void 0;

var _utils = require("../utils");

var _options = require("../options");

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

async function notToMatchElement(instance, selector, _ref = {}) {
  let {
    text
  } = _ref,
      options = _objectWithoutPropertiesLoose(_ref, ["text"]);

  options = (0, _options.defaultOptions)(options);
  const {
    page,
    handle
  } = await (0, _utils.getContext)(instance, () => document);

  try {
    await page.waitForFunction((handle, selector, text) => {
      const elements = handle.querySelectorAll(selector);

      if (text !== undefined) {
        return [...elements].every(({
          textContent
        }) => !textContent.match(text));
      }

      return elements.length === 0;
    }, options, handle, selector, text);
  } catch (error) {
    throw (0, _utils.enhanceError)(error, `Element ${selector}${text !== undefined ? ` (text: "${text}") ` : ' '}found`);
  }
}

var _default = notToMatchElement;
exports.default = _default;