"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ast_1 = require("../utils/ast");
exports.default = {
    create(context) {
        const unchecked = [];
        function checkExpressions(nodes) {
            for (const node of nodes) {
                const index = node.type === 'CallExpression' ? unchecked.indexOf(node) : -1;
                if (index !== -1) {
                    unchecked.splice(index, 1);
                    break;
                }
            }
        }
        return {
            CallExpression(node) {
                if ((0, ast_1.isTest)(node, ['fixme', 'only', 'skip'])) {
                    unchecked.push(node);
                }
                else if ((0, ast_1.isExpectCall)(node)) {
                    checkExpressions(context.getAncestors());
                }
            },
            'Program:exit'() {
                unchecked.forEach((node) => {
                    context.report({ messageId: 'noAssertions', node });
                });
            },
        };
    },
    meta: {
        docs: {
            category: 'Best Practices',
            description: 'Enforce assertion to be made in a test body',
            recommended: true,
            url: 'https://github.com/playwright-community/eslint-plugin-playwright/tree/main/docs/rules/expect-expect.md',
        },
        messages: {
            noAssertions: 'Test has no assertions',
        },
        type: 'problem',
    },
};
