"use strict";
const expect_expect_1 = require("./rules/expect-expect");
const max_nested_describe_1 = require("./rules/max-nested-describe");
const missing_playwright_await_1 = require("./rules/missing-playwright-await");
const no_conditional_in_test_1 = require("./rules/no-conditional-in-test");
const no_element_handle_1 = require("./rules/no-element-handle");
const no_eval_1 = require("./rules/no-eval");
const no_focused_test_1 = require("./rules/no-focused-test");
const no_force_option_1 = require("./rules/no-force-option");
const no_nested_step_1 = require("./rules/no-nested-step");
const no_networkidle_1 = require("./rules/no-networkidle");
const no_nth_methods_1 = require("./rules/no-nth-methods");
const no_page_pause_1 = require("./rules/no-page-pause");
const no_restricted_matchers_1 = require("./rules/no-restricted-matchers");
const no_skipped_test_1 = require("./rules/no-skipped-test");
const no_useless_await_1 = require("./rules/no-useless-await");
const no_useless_not_1 = require("./rules/no-useless-not");
const no_wait_for_timeout_1 = require("./rules/no-wait-for-timeout");
const prefer_lowercase_title_1 = require("./rules/prefer-lowercase-title");
const prefer_strict_equal_1 = require("./rules/prefer-strict-equal");
const prefer_to_be_1 = require("./rules/prefer-to-be");
const prefer_to_contain_1 = require("./rules/prefer-to-contain");
const prefer_to_have_length_1 = require("./rules/prefer-to-have-length");
const prefer_web_first_assertions_1 = require("./rules/prefer-web-first-assertions");
const require_soft_assertions_1 = require("./rules/require-soft-assertions");
const require_top_level_describe_1 = require("./rules/require-top-level-describe");
const valid_expect_1 = require("./rules/valid-expect");
const recommended = {
    env: {
        'shared-node-browser': true,
    },
    plugins: ['playwright'],
    rules: {
        'no-empty-pattern': 'off',
        'playwright/expect-expect': 'warn',
        'playwright/max-nested-describe': 'warn',
        'playwright/missing-playwright-await': 'error',
        'playwright/no-conditional-in-test': 'warn',
        'playwright/no-element-handle': 'warn',
        'playwright/no-eval': 'warn',
        'playwright/no-focused-test': 'error',
        'playwright/no-force-option': 'warn',
        'playwright/no-nested-step': 'warn',
        'playwright/no-networkidle': 'error',
        'playwright/no-page-pause': 'warn',
        'playwright/no-skipped-test': 'warn',
        'playwright/no-useless-await': 'warn',
        'playwright/no-useless-not': 'warn',
        'playwright/no-wait-for-timeout': 'warn',
        'playwright/prefer-web-first-assertions': 'error',
        'playwright/valid-expect': 'error',
    },
};
module.exports = {
    configs: {
        'jest-playwright': {
            env: {
                jest: true,
                'shared-node-browser': true,
            },
            globals: {
                browser: true,
                browserName: true,
                context: true,
                deviceName: true,
                jestPlaywright: true,
                page: true,
            },
            plugins: ['jest', 'playwright'],
            rules: {
                'jest/no-standalone-expect': [
                    'error',
                    {
                        additionalTestBlockFunctions: [
                            'test.jestPlaywrightDebug',
                            'it.jestPlaywrightDebug',
                            'test.jestPlaywrightSkip',
                            'it.jestPlaywrightSkip',
                            'test.jestPlaywrightConfig',
                            'it.jestPlaywrightConfig',
                        ],
                    },
                ],
                'playwright/missing-playwright-await': 'error',
                'playwright/no-page-pause': 'warn',
            },
        },
        'playwright-test': recommended,
        recommended,
    },
    rules: {
        'expect-expect': expect_expect_1.default,
        'max-nested-describe': max_nested_describe_1.default,
        'missing-playwright-await': missing_playwright_await_1.default,
        'no-conditional-in-test': no_conditional_in_test_1.default,
        'no-element-handle': no_element_handle_1.default,
        'no-eval': no_eval_1.default,
        'no-focused-test': no_focused_test_1.default,
        'no-force-option': no_force_option_1.default,
        'no-nested-step': no_nested_step_1.default,
        'no-networkidle': no_networkidle_1.default,
        'no-nth-methods': no_nth_methods_1.default,
        'no-page-pause': no_page_pause_1.default,
        'no-restricted-matchers': no_restricted_matchers_1.default,
        'no-skipped-test': no_skipped_test_1.default,
        'no-useless-await': no_useless_await_1.default,
        'no-useless-not': no_useless_not_1.default,
        'no-wait-for-timeout': no_wait_for_timeout_1.default,
        'prefer-lowercase-title': prefer_lowercase_title_1.default,
        'prefer-strict-equal': prefer_strict_equal_1.default,
        'prefer-to-be': prefer_to_be_1.default,
        'prefer-to-contain': prefer_to_contain_1.default,
        'prefer-to-have-length': prefer_to_have_length_1.default,
        'prefer-web-first-assertions': prefer_web_first_assertions_1.default,
        'require-soft-assertions': require_soft_assertions_1.default,
        'require-top-level-describe': require_top_level_describe_1.default,
        'valid-expect': valid_expect_1.default,
    },
};
