"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HorizontalRule = void 0;
var _react = require("react");
var _reactNative = require("react-native");
var _compose = require("@wordpress/compose");
var _styles = _interopRequireDefault(require("./styles.scss"));
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */

const HR = ({
  getStylesFromColorScheme,
  lineStyle,
  marginLeft,
  marginRight,
  style,
  textStyle,
  text,
  ...props
}) => {
  const renderLine = key => (0, _react.createElement)(_reactNative.View, {
    key: key,
    style: [getStylesFromColorScheme(_styles.default.line, _styles.default.lineDark), lineStyle]
  });
  const renderText = key => (0, _react.createElement)(_reactNative.View, {
    key: key,
    style: _styles.default.textContainer
  }, (0, _react.createElement)(_reactNative.Text, {
    style: [_styles.default.text, textStyle]
  }, text));
  const renderInner = () => {
    if (!text) {
      return renderLine();
    }
    return [renderLine(1), renderText(2), renderLine(3)];
  };
  return (0, _react.createElement)(_reactNative.View, {
    style: [_styles.default.container, {
      marginLeft,
      marginRight
    }, style],
    ...props
  }, renderInner());
};
const HorizontalRule = exports.HorizontalRule = (0, _compose.withPreferredColorScheme)(HR);
//# sourceMappingURL=index.native.js.map