"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlockQuotation = void 0;
var _react = require("react");
var _reactNative = require("react-native");
var _element = require("@wordpress/element");
var _compose = require("@wordpress/compose");
var _style = _interopRequireDefault(require("./style.scss"));
/**
 * External dependencies
 */

/**
 * WordPress dependencies
 */

/**
 * Internal dependencies
 */

const BlockQuotation = exports.BlockQuotation = (0, _element.forwardRef)(({
  ...props
}, ref) => {
  const {
    style
  } = props;
  const blockQuoteStyle = [(0, _compose.usePreferredColorSchemeStyle)(_style.default.wpBlockQuoteLight, _style.default.wpBlockQuoteDark), style?.baseColors?.color?.text && {
    borderLeftColor: style.baseColors.color.text
  }, style?.color && {
    borderLeftColor: style.color
  }, style, style?.backgroundColor && _style.default.paddingWithBackground];
  const colorStyle = style?.color ? {
    color: style.color
  } : {};
  const newChildren = _element.Children.map(props.children, child => {
    if (child && child.props.identifier === 'citation') {
      return (0, _element.cloneElement)(child, {
        style: {
          ..._style.default.wpBlockQuoteCitation,
          ...colorStyle
        }
      });
    }
    if (child && child.props.identifier === 'value') {
      return (0, _element.cloneElement)(child, {
        tagsToEliminate: ['div'],
        style: colorStyle
      });
    }
    return child;
  });
  return (0, _react.createElement)(_reactNative.View, {
    ref: ref,
    style: blockQuoteStyle
  }, newChildren);
});
//# sourceMappingURL=index.native.js.map