/** @typedef {(...args: any[])=>any} Callback */
/**
 * @typedef Handler
 * @property {Callback} callback  The callback
 * @property {string}   namespace The namespace
 * @property {number}   priority  The namespace
 */
/**
 * @typedef Hook
 * @property {Handler[]} handlers Array of handlers
 * @property {number}    runs     Run counter
 */
/**
 * @typedef Current
 * @property {string} name         Hook name
 * @property {number} currentIndex The index
 */
/**
 * @typedef {Record<string, Hook> & {__current: Current[]}} Store
 */
/**
 * @typedef {'actions' | 'filters'} StoreKey
 */
/**
 * @typedef {import('./createHooks').Hooks} Hooks
 */
export const defaultHooks: import("./createHooks")._Hooks;
export type Callback = (...args: any[]) => any;
export type Handler = {
    /**
     * The callback
     */
    callback: Callback;
    /**
     * The namespace
     */
    namespace: string;
    /**
     * The namespace
     */
    priority: number;
};
export type Hook = {
    /**
     * Array of handlers
     */
    handlers: Handler[];
    /**
     * Run counter
     */
    runs: number;
};
export type Current = {
    /**
     * Hook name
     */
    name: string;
    /**
     * The index
     */
    currentIndex: number;
};
export type Store = Record<string, Hook> & {
    __current: Current[];
};
export type StoreKey = 'actions' | 'filters';
export type Hooks = import('./createHooks').Hooks;
import createHooks from './createHooks';
export const addAction: import("./createAddHook").AddHook;
export const addFilter: import("./createAddHook").AddHook;
export const removeAction: import("./createRemoveHook").RemoveHook;
export const removeFilter: import("./createRemoveHook").RemoveHook;
export const hasAction: import("./createHasHook").HasHook;
export const hasFilter: import("./createHasHook").HasHook;
export const removeAllActions: import("./createRemoveHook").RemoveHook;
export const removeAllFilters: import("./createRemoveHook").RemoveHook;
export const doAction: (hookName: string, ...args: unknown[]) => unknown;
export const applyFilters: (hookName: string, ...args: unknown[]) => unknown;
export const currentAction: () => string | null;
export const currentFilter: () => string | null;
export const doingAction: import("./createDoingHook").DoingHook;
export const doingFilter: import("./createDoingHook").DoingHook;
export const didAction: import("./createDidHook").DidHook;
export const didFilter: import("./createDidHook").DidHook;
export const actions: Store;
export const filters: Store;
export { createHooks };
//# sourceMappingURL=index.d.ts.map