"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createPage = exports.deleteAllPages = exports.deletePage = void 0;
const PAGE_STATUS = [
    'publish',
    'future',
    'draft',
    'pending',
    'private',
    'trash',
];
async function deletePage(id) {
    // https://developer.wordpress.org/rest-api/reference/pages/#delete-a-page
    return await this.rest({
        method: 'DELETE',
        path: `/wp/v2/pages/${id}`,
        params: {
            force: true,
        },
    });
}
exports.deletePage = deletePage;
/**
 * Delete all pages using REST API.
 *
 * @param this
 */
async function deleteAllPages() {
    // List all pages.
    // https://developer.wordpress.org/rest-api/reference/pages/#list-pages
    const pages = await this.rest({
        path: '/wp/v2/pages',
        params: {
            per_page: 100,
            status: PAGE_STATUS.join(','),
        },
    });
    // Delete all pages one by one.
    // "/wp/v2/pages" not yet supports batch requests.
    await Promise.all(pages.map((page) => deletePage.call(this, page.id)));
}
exports.deleteAllPages = deleteAllPages;
/**
 * Create a new page.
 *
 * @param this
 * @param payload The page payload.
 */
async function createPage(payload) {
    // https://developer.wordpress.org/rest-api/reference/pages/#create-a-page
    const page = await this.rest({
        method: 'POST',
        path: `/wp/v2/pages`,
        params: payload,
    });
    return page;
}
exports.createPage = createPage;
//# sourceMappingURL=pages.js.map