"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.setIsFixedToolbar = void 0;
/**
 * Toggles the fixed toolbar option.
 *
 * @param this
 * @param isFixed Boolean value true/false for on/off.
 */
async function setIsFixedToolbar(isFixed) {
    await this.page.waitForFunction(() => window?.wp?.data);
    await this.page.evaluate((_isFixed) => {
        window.wp.data
            .dispatch('core/preferences')
            .set('core/edit-post', 'fixedToolbar', _isFixed);
    }, isFixed);
}
exports.setIsFixedToolbar = setIsFixedToolbar;
//# sourceMappingURL=set-is-fixed-toolbar.js.map