"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.openDocumentSettingsSidebar = void 0;
/**
 * Clicks on the button in the header which opens Document Settings sidebar when
 * it is closed.
 *
 * @param this
 */
async function openDocumentSettingsSidebar() {
    const toggleButton = this.page
        .getByRole('region', { name: 'Editor top bar' })
        .getByRole('button', {
        name: 'Settings',
        disabled: false,
    });
    const isClosed = (await toggleButton.getAttribute('aria-expanded')) === 'false';
    if (isClosed) {
        await toggleButton.click();
        await this.page
            .getByRole('region', { name: 'Editor settings' })
            .getByRole('button', { name: 'Close Settings' })
            .waitFor();
    }
}
exports.openDocumentSettingsSidebar = openDocumentSettingsSidebar;
//# sourceMappingURL=open-document-settings-sidebar.js.map