"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.insertBlock = void 0;
/**
 * Insert a block.
 *
 * @param this
 * @param blockRepresentation Inserted block representation.
 */
async function insertBlock(blockRepresentation) {
    await this.page.waitForFunction(() => window?.wp?.blocks && window?.wp?.data);
    await this.page.evaluate((_blockRepresentation) => {
        function recursiveCreateBlock({ name, attributes = {}, innerBlocks = [], }) {
            return window.wp.blocks.createBlock(name, attributes, innerBlocks.map((innerBlock) => recursiveCreateBlock(innerBlock)));
        }
        const block = recursiveCreateBlock(_blockRepresentation);
        window.wp.data.dispatch('core/block-editor').insertBlock(block);
    }, blockRepresentation);
}
exports.insertBlock = insertBlock;
//# sourceMappingURL=insert-block.js.map