<?php

namespace WpBookingPro\Wordpress;
use Exception;
use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingPro\Mvc\Model\Model;
use WpBookingPro\Mvc\View\View;
use WpBookingPro\Registry\Registry;
use Endroid\QrCode\ErrorCorrectionLevel;
use Endroid\QrCode\LabelAlignment;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Response\QrCodeResponse;


/**
 * Class PDF_Invoice
 * @package WpBookingPro\Wordpress
 */
class PDF_Invoice
{
    /**
     * @var null
     */
    public static $instance=null;

    /**
     * @return PDF_Invoice|null
     */
    public static function getInstance(){
        if (!isset(self::$instance))
        {
            self::$instance=  new PDF_Invoice();
        }
        return self::$instance;
    }

    /**
     * PDF_Invoice constructor.
     */
    public function __construct()
    {

    }

    /**
     *
     */
    public function init()
    {
        add_action('add_short_code_print_invoice_pdf',array($this,'add_short_code_print_invoice_pdf'));
        add_filter('add_option_metadata_product',array($this,'add_option_metadata_product'),10,1);
        add_filter('render_short_code_print_invoice_pdf',array($this,'render_short_code_print_invoice_pdf'), 10, 2);
        add_filter('add_option_element_pdf_invoice',array($this,'add_option_element_pdf_invoice'),10, 1);
        add_filter('add_case_column_type_to_pdf_invoice',array($this,'add_case_column_type_to_pdf_invoice'),10, 4);

    }

    public function add_case_column_type_to_pdf_invoice($column_type,$html='', $order,$j) {
        switch ($column_type) {
            case 'expert':
                $html.='<td class="product_tax_name product_list_content product_list_content_'.($j+1)
                    .' product_list_col_'.($j+1).'">';
                $html .= $order->get_meta('_expert');
                $html.='</td>';
                break;
        }
        return $html;
    }
    public function add_option_element_pdf_invoice($html="") {
        ob_start();
        ?>
        <option value="expert"><?php echo esc_html__(" Expert ",'wpbookingpro'); ?></option>;
        <?php
        $content = ob_get_clean();
        return trim($content);
    }
    public function add_option_metadata_product($data=array()) {
        $data['expert'] = esc_html__("Expert",'netbase-smart-invoice');
        return $data;
    }
    public function add_short_code_print_invoice_pdf() {
        ob_start();
        ?>
        <span class=" btn-short-code" data-toggle="tooltip" data-placement="left" title="<?php echo esc_html__("the date for create Invoice",'netbase-smart-invoice');?>">
                                [qr_code]
                            </span>
        <?php
        $content=ob_get_clean();
        echo $content;
    }
    public function render_short_code_print_invoice_pdf($html,$order) {
        $link_active = Factory::getRootUrlPlugin().'wpbookingpro_frontend/?task=booking.active_order&order_id='.(int)$order->get_id();
        // Create a basic QR code
        $qrCode = new QrCode($link_active);
        $qrCode->setSize(300);

        // Set advanced options
        $qrCode->setWriterByName('png');
        $qrCode->setEncoding('UTF-8');
        $qrCode->setErrorCorrectionLevel(ErrorCorrectionLevel::HIGH());
        $qrCode->setForegroundColor(['r' => 0, 'g' => 0, 'b' => 0, 'a' => 0]);
        $qrCode->setBackgroundColor(['r' => 255, 'g' => 255, 'b' => 255, 'a' => 0]);
        $qrCode->setLogoSize(150, 200);
        $qrCode->setValidateResult(false);

        // Apply a margin and round block sizes to improve readability
        // Please note that rounding block sizes can result in additional margin
        $qrCode->setRoundBlockSize(true);
        $qrCode->setMargin(10);

        // Set additional writer options (SvgWriter example)
        $qrCode->setWriterOptions(['exclude_xml_declaration' => true]);

        // Save it to a file
        $qrCode->writeFile(WPBOOKINGPRO_PATH_ROOT.'/qr_code/qrcode-'.$order->get_id().'.png');

        $html = str_replace("[qr_code]", '<img  src="'.Factory::getRootUrlPlugin().'/qr_code/qrcode-'.$order->get_id().'.png'.'">', $html);
        return $html;
    }

}