<?php
/**

 *
 * @copyright  Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */

namespace WpBookingPro\Router;





use WpBookingPro\Application\Application;
use WpBookingPro\Factory;
use WpBookingPro\Uri\NBUri;
use WpBookingPro\Uri\Uri;
use WpBookingProFrontend\app\router as approuter;

/**
 * Class to create and parse routes for the site application
 *
 * @since  1.5
 */
class SiteRouter extends Router
{
    /**
     * Component-router objects
     *
     * @var    array
     * @since  3.3
     */
    protected $componentRouters = array();

    /**
     * Current Application-Object
     *
     * @since  3.4
     */
    protected $app;

    /**
     *
     * @since  3.4
     */
    protected $menu;

    public function __construct($options = array(), Application $app = null)
    {
        parent::__construct($options);
    }



    public function build($url)
    {
        $uri = parent::build($url);
        // Get the path data
        $route = $uri->getPath();
        $config = Factory::getConfig();
        // Add the suffix to the uri
        if ($this->_mode == ROUTER_MODE_SEF && $route)
        {
            if ($config->get('sef_suffix'))
            {
                if ($format = $uri->getVar('format', 'html'))
                {
                    $route .= '.' . $format;
                    $uri->delVar('format');
                }
            }
        }

        // Add frontend basepath to the uri
        //$uri->setPath(NBUri::root(true) . '/' . $route);
        return $uri;
    }

    /**
     * Function to convert a raw route to an internal URI
     *
     * @param   \NBUri  &$uri  The raw route
     *
     * @return  array
     *
     * @since   3.2
     * @deprecated  4.0  Attach your logic as rule to the main parse stage
     */
    protected function parseRawRoute(&$uri)
    {
        return array();
    }

    /**
     * Function to convert a sef route to an internal URI
     *
     * @param   \NBUri  &$uri  The sef URI
     *
     * @return array
     *
     * @since   3.2
     * @deprecated  4.0  Attach your logic as rule to the main parse stage
     */
    protected function parseSefRoute(&$uri)
    {
        $config=Factory::getConfig();
        $live_site=$config->get('live_site');
        $route = $uri->getPath();
        if($live_site!=""){
            $uri_live_site = Factory::getUri($live_site);
            $path_live_site=$uri_live_site->getPath();
            $route=str_replace($path_live_site,"",$route);
        }
        // Remove the suffix

        if ($config->get('sef_suffix'))
        {
            if ($suffix = pathinfo($route, PATHINFO_EXTENSION))
            {
                $route = str_replace('.' . $suffix, '', $route);
            }
        }
        // Get the variables from the uri
        $vars = $uri->getQuery(true);

        // Handle an empty URL (special case)
        if (empty($route))
        {
            return array();
        }
        // Parse the application route
        $segments = explode('/', $route);
        $segments=array_filter($segments);
        $segments=array_values($segments);

        if(count($segments)==2 && $segments[0]== 'service-detail') {
            $service_id = $segments[1];
            $service_id = explode("-", $service_id);
            $service_id = end($service_id);
            $vars["service_id"] = $service_id;
        }

        $this->setVars($vars);

        return $vars;
    }

    /**
     * Function to build a raw route
     *
     * @param   \NBUri  &$uri  The internal URL
     *
     * @return  string  Raw Route
     *
     * @since   3.2
     * @deprecated  4.0  Attach your logic as rule to the main build stage
     */
    protected function buildRawRoute(&$uri)
    {

    }

    /**
     * Function to build a sef route
     *
     * @param   \NBUri  &$uri  The internal URL
     *
     * @return  void
     *
     * @since   1.5
     * @deprecated  4.0  Attach your logic as rule to the main build stage
     * @codeCoverageIgnore
     */
    protected function _buildSefRoute(&$uri)
    {
        $this->buildSefRoute($uri);
    }

    /**
     * Function to build a sef route
     *
     * @param   \NBUri  &$uri  The uri
     *
     * @return  void
     *
     * @since   3.2
     * @deprecated  4.0  Attach your logic as rule to the main build stage
     */
    protected function buildSefRoute(&$uri)
    {
        $route=$uri->getPath();
        $query = $uri->getQuery(true);
        $crouter   = new approuter();
        $parts     = $crouter->build($query);
        $result    = implode('/', $parts);
        $tmp       = ($result !== '') ? $result : '';
        $route.="/$tmp";

        $uri->setQuery($query);
        $uri->setPath($route);


    }


}
