<?php
/**
 * @package     woobooking.Platform
 * @subpackage  Form
 *
 *  Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE
 */
namespace WpBookingPro\Form\fields;
defined('_WPBOOKINGPRO_EXEC') or die;
use WpBookingPro\Form\FormField;

/**
 * Form Field class for the woobooking Platform.
 * Supports a one line text field.
 *
 * @link   http://www.w3.org/TR/html-markup/input.text.html#input.text

 */
class WpBookingPro_FormFieldPaymentsImage extends FormField
{
    /**
     * The form field type.
     *
     * @var    string
     */
    protected $type = 'paymentsimage';
    /**
     * Name of the layout being used to render the field
     *
     * @var    string
     */
    protected $layout = 'WooBooking.form.field.paymentsimage.paymentsimage';
    public $disable_payment_online;

    public function setDisablePaymentOnline($disable_payment_online)
    {
        $this->disable_payment_online = $disable_payment_online;
    }
    protected function getLayoutData()
    {
        $data = parent::getLayoutData();

        $extraData = array(
            'disable_payment_online'   => $this->element['disable_payment_online']
        );

        return array_merge($data, $extraData);
    }
}
