<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;
use WpBookingProFrontend\app\helpers\FrontendHelper;

$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>
<div class="block_top_employee">
    <div class="contain">
        <div id="owl-carousel" class="owl-carousel owl-theme">
            <?php foreach ($list_employee as $item) { ?>
                <div class="wrapper-employee">
                    <div class="cover-image-service-trainer">
                        <div class="item">
                            <?php $check_image_size = FrontendHelper::checkImageData($uploads['baseurl'], $item->image)?>
                            <?php if($check_user_demo['is_demo']) {?>
                                <?php if($check_image_size) {?>
                                    <img class="image lazy" data-src="<?php echo (esc_url($uploads['baseurl']. '/'.$item->image)) ?>">
                                <?php } else {?>
                                    <img class="image lazy" data-src="<?php echo (esc_url(Factory::getRootUrlPlugin().'/'.$item->image)) ?>">
                                <?php } ?>
                            <?php } else {?>
                                <img class="image lazy" data-src="<?php echo (esc_url(Factory::getRootUrlPlugin().'/'.$item->image)) ?>">
                            <?php } ?>

                        </div>
                    </div>
                    <div class="content">
                        <h3 class="name"><?php esc_html_e($item->first_name); ?> <?php esc_html_e($item->last_name) ?></h3>
                        <p class="location"><?php esc_html_e($item->location_name) ?></p>
                    </div>
                    <div class="team-social">
                        <a href="https://twitter.com">
                            <i class="fas fa-phone-alt"></i>
                        </a>
                        <a href="https://www.facebook.com/">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="https://www.instagram.com/?hl=vi">
                            <i class="fab fa-instagram"></i>
                        </a>
                    </div>

                </div>
            <?php } ?>
        </div>
    </div>
</div>
<?php
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_top_employee/assets/less/block_top_employee.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.block_top_employee','block_top_employee',array(),'frontend/blocks/block_top_employee/assets/js/block_top_employee.js');
