<?php

use WpBookingPro\Factory;
use WpBookingPro\Language\Text;

?>

<div class="block-search-service">
    <form action="<?php echo($page_list_service)  ?>" class="form-search" method="get">
        <div class="block-select-location">
            <i class="icon-nb-pin"></i>
            <label><?php esc_attr_e('Location','wpbookingpro');?></label>
            <select name="location" class="select-location">
                <option value=""><?php esc_attr_e('Select place','wpbookingpro');?></option>
                <?php foreach ($list_country as $country) {?>
                    <optgroup label="<?php esc_attr_e($country->countryname);?>">
                        <?php foreach ($country->list_location as $location) {?>
                            <option value="<?php esc_attr_e($location->location_id);?>"><?php esc_html_e($location->location_name);?></option>
                        <?php }?>
                    </optgroup>
                <?php }?>
            </select>
        </div>
        <div class="block-sorting-dropdown category">
            <i class="icon-nb-search"></i>
            <div class="dropdown">
                <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:;">
                    <label><?php esc_attr_e('Selected','wpbookingpro');?></label>
                    <span>
                        <span><?php esc_attr_e('Categories','wpbookingpro');?></span>
                        <i class="fas fa-sort-down"></i>
                    </span>
                </a>
                <div class="dropdown-menu">
                    <div class="block-service-categories">
                        <h5><?php esc_attr_e('Categories','wpbookingpro');?></h5>
                        <div class="block-service-type-item">
                            <?php foreach ($list_categories as $categories) {?>
                                <label>
                                    <input type="checkbox" name="category[]" value="<?php esc_attr_e($categories->id);?>"/>
                                    <span><?php esc_attr_e($categories->name);?></span>
                                </label>
                            <?php }?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="block-sorting-dropdown price-employee">
            <i class="icon-nb-user-2"></i>
            <div class="dropdown">
                <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:;">
                    <label><?php esc_attr_e('Advance','wpbookingpro');?></label>
                    <span>
                        <span><?php esc_attr_e('More option','wpbookingpro');?></span>
                        <i class="fas fa-sort-down"></i>
                    </span>
                </a>
                <div class="dropdown-menu">
                    <div class="block-filter-price block-filter-price-more-option">
                        <h5><?php esc_attr_e('Filter price','wpbookingpro');?></h5>
                        <input type="text" id="amount_1" readonly/>
                        <div id="slider-container-1"></div>
                        <input type="hidden" name="price_search">
                    </div>
                    <div class="block-employee">
                        <h5><?php esc_attr_e('Employees','wpbookingpro');?></h5>
                        <div class="block-employee-item">
                            <?php foreach ($list_employees as $employees) {?>
                                <label>
                                    <input type="checkbox" name="employee[]" value="<?php esc_attr_e($employees->id);?>"/>
                                    <span><?php esc_attr_e($employees->first_name);?> <?php esc_attr_e($employees->last_name);?></span>
                                </label>
                            <?php }?>
                        </div>
                    </div>

                </div>
            </div>
        </div>
        <div class="wrapper-button">
            <button class="btn btn-primary" type="submit"><?php esc_attr_e('Search','wpbookingpro');?></button>
        </div>
    </form>
    <form action="<?php echo ($page_list_service)  ?>" method="get" class="form-search-service">
        <div class="block-select-location">
            <i class="icon-nb-pin"></i>
            <label><?php esc_attr_e('Location','wpbookingpro');?></label>
            <select name="location" class="select-location">
                <option value=""><?php esc_attr_e('Select place','wpbookingpro');?></option>
                <?php foreach ($list_country  as $country) {?>
                    <optgroup label="<?php echo ($country->countryname);?>">
                        <?php foreach ($country->list_location as $location) {?>
                            <option value="<?php echo ($location->location_id);?>"><?php echo ($location->location_name);?></option>
                        <?php }?>
                    </optgroup>
                <?php }?>
            </select>
        </div>
        <div class="block-more-option employee">
            <div class="title-more-option">
                <p class="more-option"><span><?php esc_attr_e('Select Employee','wpbookingpro');?></span><i class="fas fa-sort-down"></i></p>
                <div class="block-service-categories-2">
                    <h5><?php esc_attr_e('Employees','wpbookingpro');?></h5>
                    <div class="block-service-type-item">
                        <?php foreach ($list_employees as $employees) {?>
                            <label>
                                <input type="checkbox" name="employee[]" value="<?php echo ($employees->id);?>"/>
                                <span><?php esc_attr_e($employees->first_name);?> <?php esc_attr_e($employees->last_name);?></span>
                            </label>
                        <?php }?>
                    </div>
                </div>
            </div>
        </div>
        <div class="block-more-option">
            <div class="title-more-option">
                <p class="more-option"><span><?php esc_attr_e('More option','wpbookingpro');?></span><i class="fas fa-sort-down"></i></p>
                <div class="block-filter-price block-filter-price-more-option-2">
                    <h5><?php esc_attr_e('Filter price','wpbookingpro');?></h5>
                    <input type="text" id="amount_2" readonly/>
                    <div id="slider-container-2"></div>
                    <input type="hidden" name="price_search">
                </div>
                <div class="block-service-categories-2">
                    <h5><?php esc_attr_e('Categories','wpbookingpro');?></h5>
                    <div class="block-service-type-item">
                        <?php foreach ($list_categories as $categories) {?>
                            <label>
                                <input type="checkbox" name="category[]" value="<?php echo ($categories->id);?>"/>
                                <span><?php echo ($categories->name);?></span>
                            </label>
                        <?php }?>
                    </div>
                </div>
            </div>
        </div>
        <div class="block-button-search">
            <button type="submit" class="btn btn-primary"><?php esc_attr_e('Search','wpbookingpro');?></button>
        </div>
    </form>
</div>
<?php
$doc= Factory::getDocument();
$doc->addLessStyleSheet('frontend/blocks/block_search_service/assets/less/block_search_service.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$doc->addScriptApplySelector('.block-search-service','block_search_service',array(),'frontend/blocks/block_search_service/assets/js/block_search_service.js');



