<?php
use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingPro\Language\Text;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

$doc= FactoryAlias::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view-list-vendors.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
WpBookingProHtmlFrontend::load_jquery_library('datatables');
WpBookingProHtmlFrontend::load_jquery_library('moment');
WpBookingProHtmlFrontend::load_jquery_library('daterangepicker');
WpBookingProHtmlFrontend::load_jquery_library('fontawesome');
WpBookingProHtmlFrontend::load_jquery_library('ui');
WpBookingProHtmlFrontend::load_jquery_library('icheck');
WpBookingProHtmlFrontend::load_jquery_library('select2');
WpBookingProHtmlFrontend::load_jquery_library('loading_js');
WpBookingProHtmlFrontend::load_jquery_library('confirm');
WpBookingProHtmlFrontend::load_jquery_library('twbs_pagination');


$page_vendor_detail = ConfigHelperAlias::get_page_vendor_detail();
if($page_vendor_detail) {
    $this->page_vendor_detail = get_permalink($page_vendor_detail);
} else {
    $this->page_vendor_detail = '';
}

$limit = 8;

?>
    <div class="view-list-vendors">
        <form action="" method="post" name="form-list_vendor">
            <div class="row wrapper-list-vendor">
                <?php foreach ($this->list_vendor as $vendor) {?>
                    <div class="col-sm-6 col-md-4 col-lg-3">
                        <?php
                        $this->vendor = $vendor;
                        $this->loadTemplate('list_item')
                        ?>
                    </div>
                <?php }?>
            </div>
            <ul class="pagination-vendors"></ul>
            <input type="hidden" name="limit" value="<?php echo (esc_attr($limit)) ?>">
            <input type="hidden" name="start">
            <input type="hidden" name="total_result" value="<?php echo (esc_attr($this->total_vendor))?>">
            <input type="hidden" name="page_vendor_detail" value="<?php echo (esc_attr($this->page_vendor_detail))?>">
        </form>
    </div>
<?php
$input = FactoryAlias::getInput();
$doc->addScriptApplySelector('.view-list-vendors','view_list_vendors',array(
    "limit"=>$limit,
    "total_result"=>$this->total_vendor
),"frontend/app/assets/js/view_list_vendors.js");
?>