<?php
use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingPro\Language\Text;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingProFrontend\app\helpers\FrontendHelper;

$doc= FactoryAlias::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view-list-services.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
WpBookingProHtmlFrontend::load_jquery_library('fontawesome');
WpBookingProHtmlFrontend::load_jquery_library('ui');
WpBookingProHtmlFrontend::load_jquery_library('select2');
WpBookingProHtmlFrontend::load_jquery_library('loading_js');
WpBookingProHtmlFrontend::load_jquery_library('confirm');
WpBookingProHtmlFrontend::load_jquery_library('twbs_pagination');

$page_service_detail= ConfigHelperAlias::get_page_service_detail();
if($page_service_detail) {
    $this->page_service_detail = get_page_link($page_service_detail);
}else{
    $this->page_service_detail="";
}
$number_service=count($this->list);
$page_list_service= ConfigHelperAlias::get_page_list_service();
if($page_list_service) {
    $page_list_service = get_page_link($page_list_service);
}else{
    $page_list_service="";
}

$input=FactoryAlias::getInput();
$location_id=$input->getInt('location',0);
$near_me=$input->getInt('near_me',0);
$rating = $input->getString('rating','');
$sort = $input->getString('sort', "a.ordering");
$direction = $input->getString('direction', "ASC");

$list_vendor_id=[];
if(array_key_exists('vendor',(array)$input->getData())) {
    $list_vendor_id=(array)$input->getData()['vendor'];
}

$list_employee_id=[];
if(array_key_exists('employee',(array)$input->getData())) {
    $list_employee_id=(array)$input->getData()['employee'];
}
$list_category_id=[];
if(array_key_exists('category',(array)$input->getData())) {
    $list_category_id=(array)$input->getData()['category'];
}

$price_search = $input->getString('price_search','');
$price_search = json_decode($price_search);

if(is_array($price_search) && !empty($price_search) && count($price_search) == 2) {
    $min_price_search = min($price_search);
    $max_price_search = max($price_search);
} else {
    $min_price_search = 0;
    $max_price_search = 1099;
}

$one_star = array();
$two_star = array();
$three_star = array();
$four_star = array();
$five_star = array();
foreach ($this->list as $service_item) {
    if(isset($service_item->rating_avg)) {
        if($service_item->rating_avg >= 0 && $service_item->rating_avg <= 1) {
            array_push($one_star, $service_item);
        } elseif($service_item->rating_avg > 1 && $service_item->rating_avg <= 2) {
            array_push($two_star, $service_item);
        } elseif($service_item->rating_avg > 2 && $service_item->rating_avg <= 3) {
            array_push($three_star, $service_item);
        } elseif($service_item->rating_avg > 3 && $service_item->rating_avg <= 4) {
            array_push($four_star, $service_item);
        } elseif($service_item->rating_avg > 4 && $service_item->rating_avg <= 5) {
            array_push($five_star, $service_item);
        }
    }
}

$limit = 9;
$appConfig = FactoryAlias::getAppConfig();
$default_currency = $appConfig->get('default_currency','');
$current_currency = isset($_SESSION['currency'])?$_SESSION['currency']: $default_currency;


?>
    <div class="view-list-services">
        <form action="<?php echo ($page_list_service)  ?>" method="post" class="form-search-service" name="filter-form">
            <div class="row">
                <div class="col-md-3">
                    <div class="wrapper-change-currency">
                        <select  id="searchByCurrency" name="currency">
                            <option value='' disabled>-- <?php esc_html_e('Select currency','wpbookingpro');?>--</option>
                            <?php foreach ($this->list_currency as $currency_item) {?>
                                <option value="<?php echo (esc_attr($currency_item->unit_currency)) ?>" <?php echo (esc_attr($currency_item->unit_currency == $current_currency ? 'selected':''))?> >
                                    <?php echo (esc_html($currency_item->unit_currency))?>
                                </option>
                            <?php }?>
                        </select>
                    </div>
                    <div class="wrapper-search-service">
                        <div class="block-title-search-service">
                            <h4><?php esc_attr_e('Search services','wpbookingpro');?></h4>
                        </div>
                        <div class="block-select-location">
                            <i class="icon-nb-pin"></i>
                            <label><?php esc_attr_e('Destination','wpbookingpro');?></label>
                            <select name="location" class="select-location">
                                <option value=""><?php esc_attr_e('Select place','wpbookingpro');?></option>
                                <?php foreach ($this->list_countries as $country) {?>
                                    <optgroup label="<?php echo ($country->countryname);?>">
                                        <?php foreach ($country->list_location as $location) {?>
                                            <option value="<?php echo ($location->location_id);?>"><?php echo ($location->location_name);?></option>
                                        <?php }?>
                                    </optgroup>
                                <?php }?>
                            </select>
                        </div>
                        <div class="block-location-near-me">
                            <input type="checkbox" class="input-near-me" name="near_me" value="1" />
                            <label class="label-near-me"><?php esc_html_e('Near you','wpbookingpro');?></label>
                            <input type="hidden" name="latitude">
                            <input type="hidden" name="longitude">
                        </div>
                        <?php if(isset($this->list_vendor) && !empty($this->list_vendor)) {?>
                            <div class="block-select-vendors">
                                <h5><?php esc_html_e('Select vendor','wpbookingpro');?></h5>
                                <div class="block-service-vendor">
                                    <?php foreach ($this->list_vendor as $vendor) {?>
                                        <?php if (count((array)$list_vendor_id)) {?>
                                            <div class="block-input">
                                                <input  type="checkbox" id="vendor-<?php echo (esc_attr($vendor->id))?>" name="vendor[]" value="<?php echo (esc_attr($vendor->id));?>"  />
                                                <label for="vendor-<?php echo (esc_attr($vendor->id))?>"> <span><?php echo (esc_html($vendor->first_name.' '.$vendor->last_name));?></span></label>
                                            </div>
                                        <?php } else {?>
                                            <div class="block-input">
                                                <input type="checkbox" id="vendor-<?php echo (esc_attr($vendor->id))?>" name="vendor[]" value="<?php echo (esc_attr($vendor->id));?>"/>
                                                <label for="vendor-<?php echo (esc_attr($vendor->id))?>"><?php echo (esc_html($vendor->first_name.' '.$vendor->last_name));?></label>
                                            </div>
                                        <?php }?>
                                    <?php }?>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="block-select-employees">
                            <h5><?php esc_attr_e('Select employee','wpbookingpro');?></h5>
                            <div class="block-service-employee">
                                <?php foreach ($this->list_employees as $employee) {?>
                                    <?php if (count((array)$list_employee_id)) {?>
                                        <div class="block-input">
                                            <input type="checkbox" id="employee-<?php echo (esc_attr($employee->id))?>" name="employee[]" value="<?php echo (esc_attr($employee->id));?>" />
                                            <label for="employee-<?php echo (esc_attr($employee->id))?>"><?php echo (esc_html($employee->first_name.' '.$employee->last_name));?></label>
                                        </div>
                                    <?php } else {?>
                                        <div class="block-input">
                                            <input type="checkbox" id="employee-<?php echo (esc_attr($employee->id))?>" name="employee[]" value="<?php echo (esc_attr($employee->id));?>" />
                                            <label for="employee-<?php echo (esc_attr($employee->id))?>"><?php echo (esc_html($employee->first_name.' '.$employee->last_name));?></label>
                                        </div>
                                    <?php }?>
                                <?php }?>
                            </div>
                        </div>
                        <div class="block-more-option">
                            <div class="title-more-option">
                                <div class="wrapper-button">
                                    <button type="button" class="btn btn-primary more-option"><?php esc_attr_e('More option','wpbookingpro');?><i class="fas fa-sort-down"></i></button>
                                </div>
                                <div class="content-left srat-ratings">
                                    <h5 class="title-left"><?php esc_html_e('Star Ratings', 'wpbookingpro');?></h5>
                                    <div class="block-filter-star">
                                        <div class="item-star-filter">
                                            <input type="checkbox" name="rating[]" id="five-star" value="[4,5]">
                                            <label for="five-star">
                                                <ul class="list-rating-star">
                                                    <?php for($i = 1; $i <= 5; $i++) {?>
                                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                                    <?php }?>
                                                </ul>
                                                <span class="number-hotel">
                                                    <?php echo (esc_html(count($five_star)));?>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="item-star-filter">
                                            <input type="checkbox" name="rating[]" id="four-star" value="[3,4]" >
                                            <label for="four-star">
                                                <ul class="list-rating-star">
                                                    <?php for($i = 1; $i <= 4; $i++) {?>
                                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                                    <?php }?>
                                                    <li class="item-star"><i class="far fa-star"></i></li>
                                                </ul>
                                                <span class="number-hotel">
                                                    <?php echo (esc_html(count($four_star)));?>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="item-star-filter">
                                            <input type="checkbox" name="rating[]" id="three-star" value="[2,3]" >
                                            <label for="three-star">
                                                <ul class="list-rating-star">
                                                    <?php for($i = 1; $i <= 3; $i++) {?>
                                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                                    <?php }?>
                                                    <?php for($i = 1; $i <= 2; $i++) {?>
                                                        <li class="item-star"><i class="far fa-star"></i></li>
                                                    <?php }?>
                                                </ul>
                                                <span class="number-hotel">
                                                    <?php echo (esc_html(count($three_star)));?>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="item-star-filter">
                                            <input type="checkbox" name="rating[]" id="two-star" value="[1,2]" >
                                            <label for="two-star">
                                                <ul class="list-rating-star">
                                                    <?php for($i = 1; $i <= 2; $i++) {?>
                                                        <li class="item-star"><i class="fas fa-star"></i></li>
                                                    <?php }?>
                                                    <?php for($i = 1; $i <= 3; $i++) {?>
                                                        <li class="item-star"><i class="far fa-star"></i></li>
                                                    <?php }?>
                                                </ul>
                                                <span class="number-hotel">
                                                    <?php echo (esc_html(count($two_star)));?>
                                                </span>
                                            </label>
                                        </div>
                                        <div class="item-star-filter">
                                            <input type="checkbox" name="rating[]" id="one-star" value="[0,1]" >
                                            <label for="one-star">
                                                <ul class="list-rating-star">
                                                    <li class="item-star"><i class="fas fa-star"></i></li>
                                                    <?php for($i = 1; $i <= 4; $i++) {?>
                                                        <li class="item-star"><i class="far fa-star"></i></li>
                                                    <?php }?>
                                                </ul>
                                                <span class="number-hotel">
                                                    <?php echo (esc_html(count($one_star)));?>
                                                </span>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="block-filter-price block-filter-price-more-option">
                                    <h5><?php esc_attr_e('Filter price','wpbookingpro');?></h5>
                                    <input type="text" id="amount_1" readonly/>
                                    <div id="slider-container-1"></div>
                                    <input type="hidden" name="price_search">
                                </div>
                                <div class="block-service-categories">
                                    <h5><?php esc_attr_e('Select category','wpbookingpro');?></h5>
                                    <div class="block-service-category">
                                        <?php foreach ($this->list_categories as $category) {?>
                                            <?php if (count((array)$list_category_id)) {?>
                                                <div class="block-input">
                                                    <input type="checkbox" id="category-<?php echo (esc_attr($category->id))?>" name="category[]" value="<?php echo ($category->id);?>" />
                                                    <label for="category-<?php echo (esc_attr($category->id))?>"> <span><?php echo ($category->name);?></span></label>
                                                </div>
                                            <?php } else {?>
                                                <div class="block-input">
                                                    <input type="checkbox" id="category-<?php echo (esc_attr($category->id))?>" name="category[]" value="<?php echo (esc_attr($category->id));?>"/>
                                                    <label for="category-<?php echo (esc_attr($category->id))?>"><?php echo (esc_html($category->name));?></label>
                                                </div>
                                            <?php }?>
                                        <?php }?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-9">
                    <?php if($number_service > 0) {?>
                        <div class="wrapper-block-result">
                            <div class="block-top-result">
                                <div class="result-title">
                                    <h3><span class="total-service"><?php echo (esc_html($this->total_service)) ?></span> <?php esc_attr_e('services found','wpbookingpro');?></h3>
                                </div>
                                <div class="block-sorting-display">
                                    <div class="block-display-button">
                                        <ul class="nav nav-tabs">
                                            <li class="active"><a data-toggle="tab" href="#grid-display"><i class="fas fa-th"></i></a></li>
                                            <li><a data-toggle="tab" href="#list-display"><i class="fas fa-list"></i></a></li>
                                        </ul>
                                    </div>
                                </div>
                                <div class="sort-by-block">
                                    <div class="dropdown">
                                        <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:void(0)">
                                            <span class="select-by-default"><?php esc_attr_e('Sort by', 'wpbookingpro') ?></span>
                                            <i class="fas fa-chevron-down"></i>
                                        </a>
                                        <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            <ul class="sort-display">
                                                <li ><a class="select-sort-item" data-key_sort="a.name" data-direction="ASC"  href="javascript:void(0)"><?php esc_attr_e('Sort by name from A-Z', 'wpbookingpro') ?></i></a></li>
                                                <li ><a class="select-sort-item" data-key_sort="a.name" data-direction="DESC"   href="javascript:void(0)"><?php esc_attr_e('Sort by name from Z-A', 'wpbookingpro') ?></a></li>
                                                <li ><a class="select-sort-item" data-key_sort="a.price" data-direction="ASC"   href="javascript:void(0)"><?php esc_attr_e('Sort by ascending price', 'wpbookingpro') ?></a></li>
                                                <li ><a class="select-sort-item" data-key_sort="a.price" data-direction="DESC"   href="javascript:void(0)"><?php esc_attr_e('Sort by descending price', 'wpbookingpro') ?></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-content wrapper-result-body">
                                <div id="grid-display" class="tab-pane fade in active">
                                    <div class="row">

                                    </div>
                                </div>
                                <div id="list-display" class="tab-pane fade">

                                </div>
                            </div>
                            <ul class="pagination-services"></ul>
                        </div>
                    <?php } else {?>
                    <div class="wrapper-block-result">
                        <div class="block-top-result">
                            <div class="result-title">
                                <h3><?php echo ($number_service) ?> <?php esc_attr_e(' services found','wpbookingpro');?></h3>
                            </div>
                            <div class="block-sorting-display">
                                <div class="block-display-button">
                                    <ul class="nav nav-tabs">
                                        <li class="active"><a data-toggle="tab" href="#grid-display"><i class="fas fa-th"></i></a></li>
                                        <li><a data-toggle="tab" href="#list-display"><i class="fas fa-list"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                            <div class="sort-by-block">
                                <div class="dropdown">
                                    <a class="dropdown-toggle" data-toggle="dropdown" href="javascript:void(0)">
                                        <span class="select-by-default"><?php esc_attr_e('Sort by', 'wpbookingpro') ?></span>
                                        <i class="fas fa-chevron-down"></i>
                                    </a>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                        <ul class="sort-display">
                                            <li class="<?php echo ($sort=="a.name" && $direction=="ASC"?' active ':'') ?>"><a  class="select-sort-item <?php echo ($sort=="a.name" && $direction=="ASC"?' active ':'') ?>" data-key_sort="a.name" data-direction="ASC"  href="javascript:void(0)"><?php esc_attr_e('Sort by name from A-Z', 'wpbookingpro') ?></i></a></li>
                                            <li class="<?php echo ($sort=="a.name" && $direction=="DESC"?' active ':'') ?>"><a class="select-sort-item <?php echo ($sort=="a.name" && $direction=="DESC"?' active ':'') ?>" data-key_sort="a.name" data-direction="DESC"   href="javascript:void(0)"><?php esc_attr_e('Sort by name from Z-A', 'wpbookingpro') ?></a></li>
                                            <li class="<?php echo ($sort=="a.price" && $direction=="ASC"?' active ':'') ?>"><a class="select-sort-item <?php echo ($sort=="a.price" && $direction=="ASC"?' active ':'') ?>" data-key_sort="a.price" data-direction="ASC"   href="javascript:void(0)"><?php esc_attr_e('Sort by ascending price', 'wpbookingpro') ?></a></li>
                                            <li class="<?php echo ($sort=="a.price" && $direction=="DESC"?' active ':'') ?>"><a class="select-sort-item <?php echo ($sort=="a.price" && $direction=="DESC"?' active ':'') ?>" data-key_sort="a.price" data-direction="DESC"   href="javascript:void(0)"><?php esc_attr_e('Sort by descending price', 'wpbookingpro') ?></a></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-content wrapper-result-body">
                            <div id="grid-display" class="tab-pane fade in active">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="alert-block">
                                            <span><?php esc_attr_e('Could not find any services','wpbookingpro')?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="list-display" class="tab-pane fade">
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="alert-block">
                                            <span><?php esc_attr_e('Could not find any services','wpbookingpro')?></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php }?>
                </div>
            </div>
            <input type="hidden" name="sort" >
            <input type="hidden" name="direction" >
            <input type="hidden" name="limit" value="<?php echo (esc_attr($limit))?>">
            <input type="hidden" name="page_service_detail" value="<?php echo (esc_attr($this->page_service_detail))?>">
            <input type="hidden" name="start">
            <input type="hidden" name="total_result" value="<?php echo (esc_attr(count($this->list)))?>">
        </form>
    </div>
<?php

$doc->addScriptApplySelector('.view-list-services','view_list_services',array(
        "page_list_service"=>$page_list_service,
        "min_price"=>$min_price_search,
        "max_price"=>$max_price_search,
        "user_id"=> isset($_SESSION['user_id'])?$_SESSION['user_id']:'',
        "limit"=>$limit,
        "list_service"=>$this->list,
        "format_currency"=> FrontendHelper::getFormatCurrentCurrency()
),"frontend/app/assets/js/view_list_services.js");
?>