<?php

use WpBookingPro\Factory;
use WpBookingProFrontend\app\Html\HtmlFrontend;
use WooBooking\CMS\Utilities\Utility;
\WpBookingPro\Html\WpBookingProHtmlFrontend::load_jquery_library('awesome');
$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view_payment_cancel.less');
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
$total = 0;
?>
    <div class="view-payment-cancel">
        <div class="view-list-paynow">
            <?php if(!empty((array)($this->order->list_rate))) {?>
                <?php foreach ($this->order->list_rate as $item) { ?>
                    <?php $this->item = $item ?>
                    <?php
                    $total += $item->total;
                    ?>
                    <?php $this->loadTemplate('list_item') ?>
                <?php } ?>
            <?php }?>
            <div class="row">
                <div class="col-md-4"></div>
                <div class="col-sm-6 col-md-4"></div>
                <div class="col-sm-6 col-md-4">
                    <div class="cart-totals" >
                        <div class="detail-cart">
                            <?php if(!empty((array)($this->order->list_rate))) { ?>
                                <h3><?php esc_attr_e('Payment totals','wpbookingpro')?></h3>
                                <div class="block-payment-total">
                                    <span ><?php esc_attr_e('Payment subtotal','wpbookingpro')?></span>
                                    <span class="subtotal_price"><?php echo(HtmlFrontend::render_price($total)); ?></span>

                                </div>
                                <div class="block-shipping">
                                    <span><?php esc_attr_e('Shipping','wpbookingpro')?></span>
                                    <span class="shipping-price">0</span>
                                </div>
                                <div class="order_total_price">
                                    <div class="block-shipping">
                                        <span><?php esc_attr_e('Order total','wpbookingpro')?></span>
                                        <span class="total-price"><?php echo(HtmlFrontend::render_price($total)); ?></span>
                                    </div>
                                    <?php if($this->order->payment_schedule == 'pay-later') {?>
                                        <div class="block-shipping">
                                            <span><?php esc_attr_e('Deposit payment','wpbookingpro')?></span>
                                            <span class="deposit-payment"><?php echo (esc_html(HtmlFrontend::render_price($this->order->deposit_payment)))?></span>
                                        </div>
                                        <div class="block-shipping">
                                            <span><?php esc_attr_e('Balance payment','wpbookingpro')?></span>
                                            <span class="balance-payment"><?php echo (esc_html(HtmlFrontend::render_price($this->order->balance_payment)))?></span>
                                        </div>
                                    <?php }?>
                                </div>
                            <?php } else {?>
                                <h3><?php esc_attr_e('Payment totals','wpbookingpro')?></h3>
                                <div class="block-payment-total">
                                    <span ><?php esc_attr_e('Payment subtotal','wpbookingpro')?></span>
                                    <span class="subtotal_price"><?php echo(HtmlFrontend::render_price($this->order_package->total)); ?></span>

                                </div>
                                <div class="block-shipping">
                                    <span><?php esc_attr_e('Shipping','wpbookingpro')?></span>
                                    <span class="shipping-price">0</span>
                                </div>
                                <div class="order_total_price">
                                    <span><?php esc_attr_e('Order total','wpbookingpro')?></span>
                                    <span class="total-price"><?php echo(HtmlFrontend::render_price($this->order_package->total)); ?></span>
                                </div>
                            <?php }?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4"></div>
                <div class="col-md-4"></div>
                <div class="col-md-4">
                    <div class="checkout-cart">
                        <h3><?php esc_attr_e('If you wish to proceed with the payment','wpbookingpro')?></h3>
                        <?php if(!empty((array)($this->order->list_rate))) {?>
                            <?php echo($this->paymentPlugin->onAfterOrderConfirm($this->order)) ?>
                        <?php }?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$doc->addScriptApplySelector('.view-payment-cancel','view_payment_paynow',array(
    "list_rate"=>  $this->order->list_rate
),'frontend/app/assets/js/view_payment_paynow.js');
