<?php

use WpBookingPro\Factory;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;

WpBookingProHtmlFrontend::load_jquery_library('awesome');

$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view_login.less');

$page_signup= ConfigHelperAlias::get_page_signup();
if($page_signup) {
    $this->page_signup = get_page_link($page_signup);
}else{
    $this->page_signup="";
}

$page_login= ConfigHelperAlias::get_page_login();
if($page_login) {
    $this->page_login = get_page_link($page_login);
}else{
    $this->page_login="";
}

$page_user_account= ConfigHelperAlias::get_page_user_account();
if($page_user_account) {
    $this->page_user_account = get_page_link($page_user_account);
}else{
    $this->page_user_account="";
}
$uri = Factory::getUri();
$login_message = $uri->getVar('login_message','');
$logout_message = $uri->getVar('logout_message','');

?>
<div class="view-login">
    <?php if(is_user_logged_in()) { ?>
        <?php Utility::redirect($this->page_user_account);?>
    <?php } else {?>
    <form action="" method="post" class="login-form" name="login_form">
        <div class="row">
            <div class="col-md-12">
                <div class="wrapper-login-form">
                    <div class="block-content-left">
                        <h1><?php esc_html_e('Welcome Back!', 'wpbookingpro');?></h1>
                        <p><?php esc_html_e('To keep connect with us please login with your personal info', 'wpbookingpro');?></p>
                        <div class="have-account">
                            <span><?php esc_html_e('Not a member?','wpbookingpro');?></span>
                            <a href="<?php echo (esc_url($this->page_signup))?>"><?php esc_html_e('Sign up now','wpbookingpro');?></a>
                        </div>
                    </div>
                    <div class="block-content-right">
                        <h1><?php esc_html_e('Login', 'wpbookingpro');?></h1>
                        <?php if($login_message == 'error') {?>
                            <div class="alert alert-danger alert-dismissible error-alert" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <?php esc_html_e('Invalid username or password','wpbookingpro');?>
                            </div>
                        <?php }?>
                        <?php if($logout_message == 'success') {?>
                            <div class="alert alert-success alert-dismissible error-alert" role="alert">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                                <?php esc_html_e('You are logout','wpbookingpro');?>
                            </div>
                        <?php }?>
                        <div class="form-info-user">
                            <input type="text" name="email_or_username" placeholder="<?php esc_attr_e('Email or Username', 'wpbookingpro');?>" autocomplete="off" />
                            <input type="password" name="password" placeholder="<?php esc_attr_e('Password', 'wpbookingpro');?>" autocomplete="off" />
                            <div class="remember-remind">
                                <input type="checkbox" name="remember_login" value="1">
                                <span><?php esc_html_e('Remember me', 'wpbookingpro');?></span>
                            </div>
                            <button type="submit" class="login-button"><?php esc_html_e('Login','wpbookingpro');?></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" name="task" value="login.programmatic_login">
        <input type="hidden" name="link_redirect_error" value="<?php echo (esc_url($this->page_login))?>">
        <input type="hidden" name="link_redirect_success" value="<?php echo (esc_url($this->page_user_account))?>">
    </form>
    <?php }?>
</div>
<?php
$doc->addScriptApplySelector('.view-login','view_login',array(

),"frontend/app/assets/js/view_login.js");