<?php

use WpBookingPro\Factory;
use WpBookingProFrontend\app\helpers\ConfigHelper as ConfigHelperAlias;
use WpBookingProFrontend\app\helpers\FrontendHelper;

$doc = Factory::getDocument();
$doc->addLessStyleSheet('frontend/app/assets/less/view_list_category.less');
$page_list_service= ConfigHelperAlias::get_page_list_service();
if($page_list_service) {
    $page_list_service = get_page_link($page_list_service);
}else{
    $page_list_service="";
}

$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>
<div class="view-list-category">
    <div class="row">
        <div class="col-md-12">
            <div class="block-title">
                <h2 class="title"><?php esc_attr_e('Our category','wpbookingpro') ?></h2>
                <p class="des"><?php esc_attr_e('Exercise with the leading bodybuilding experts on the world, helping to improve the overall health','wpbookingpro'); ?></p>
            </div>
        </div>
    </div>
    <div class="row">
        <?php foreach ($this->list as $item) { ?>
            <?php
            $list_service = $item->list_service;
            $a_list_service = array_slice($list_service, 0, 3);
            ?>
            <div class="col-md-4 col-sm-6">
                <div class="wrapper-category-item">
                    <div class="img-block">
                        <div>
                            <?php $check_image_size = FrontendHelper::checkImageData($uploads['baseurl'], $item->image)?>
                            <?php if($check_user_demo['is_demo']) {?>
                                <?php if($check_image_size) {?>
                                    <img src="<?php echo (esc_url($uploads['baseurl'].'/'.$item->image)) ?>" alt="category-image" />
                                <?php } else {?>
                                    <img src="<?php echo (esc_url(Factory::getRootUrlPlugin().$item->image)) ?>" alt="category-image" />
                                <?php } ?>

                            <?php } else {?>
                                <img src="<?php echo (esc_url(Factory::getRootUrlPlugin().$item->image)) ?>" alt="category-image" />
                            <?php } ?>
                        </div>
                    </div>
                    <div class="layer-blur"></div>
                    <div class="layer-content">
                        <h3><a href="<?php echo($page_list_service.'?category='.$item->id); ?>"><?php esc_html_e($item->name) ?></a></h3>
                        <div class="training">
                            <ul class="list-service pull-left">
                                <?php foreach ($a_list_service as $service) { ?>
                                    <li>
                                        <img class="service-image" src="<?php esc_html_e(Factory::getRootUrlPlugin()) ?>/<?php esc_html_e($service->image) ?>" alt="image-service">
                                    </li>
                                <?php } ?>
                            </ul>
                            <p><?php esc_attr_e('Service','wpbookingpro') ?>: <?php echo (count($list_service)) ?></p>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
    </div>
</div>