<?php

use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\WpBookingProHtmlFrontend;

WpBookingProHtmlFrontend::load_jquery_library('slick');
WpBookingProHtmlFrontend::load_jquery_library('validate');
WpBookingProHtmlFrontend::load_jquery_library('confirm');
WpBookingProHtmlFrontend::load_jquery_library('twbs_pagination');
WpBookingProHtmlFrontend::load_jquery_library('awesome');
WpBookingProHtmlFrontend::load_jquery_library('datatables');
WpBookingProHtmlFrontend::load_jquery_library('loading_js');

$state_item = $this->state_item;

?>
<div class="wrapper-state-form">
    <div class="block-nav-setting">
        <h2><?php esc_html_e('State Form','wpbookingpro');?></h2>
        <ul class="room-tab nav nav-tabs" role="tablist">
            <li role="presentation" class="active">
                <a href="#home" aria-controls="home" role="tab" data-toggle="tab">
                    <?php esc_html_e('State details', 'wpbookingpro') ?>
                </a>
            </li>
        </ul>
    </div>
    <div class="block-content-setting">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="home">
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_state->setValue('name',null, isset($state_item->name)?$state_item->name:'');
                        echo ($this->form_state->renderField('name'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_state->setValue('country_id',null, isset($state_item->country_id)?$state_item->country_id:'');
                        echo ($this->form_state->renderField('country_id'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $field=$this->form_state->getField('published');
                        $field->setValue(isset($state_item->published)?$state_item->published:0);
                        ?>
                        <?php echo ($field->input) ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-button">
            <a href="<?php echo (esc_url($this->page_user_account.'?layout=my-state'))?>" class="btn-cancel">
                <i class="fas fa-undo-alt"></i>
                <?php esc_html_e('Cancel','wpbookingpro');?>
            </a>
            <button class="btn-save btn-save-state" type="button">
                <i class="icon-nb-save"></i>
                <?php esc_html_e('Save','wpbookingpro');?>
            </button>
        </div>
        <input type="hidden" name="page_my_state" value="<?php echo (esc_attr($this->page_user_account.'?layout=my-state'))?>">
        <input type="hidden" name="user_id" value="<?php echo (esc_attr($this->user->data->user_plugin->id))?>">
    </div>


</div>
