<?php

use WpBookingPro\Factory;
use WpBookingPro\Factory as FactoryAlias;
use WpBookingPro\Html\WpBookingProHtmlFrontend;
use WpBookingProAdmin\app\HtmlCustomField\HtmlCustomFieldFrontend;
use WpBookingProFrontend\app\helpers\ConfigHelper;

WpBookingProHtmlFrontend::load_jquery_library('slick');
WpBookingProHtmlFrontend::load_jquery_library('validate');
WpBookingProHtmlFrontend::load_jquery_library('confirm');
WpBookingProHtmlFrontend::load_jquery_library('twbs_pagination');
WpBookingProHtmlFrontend::load_jquery_library('awesome');
WpBookingProHtmlFrontend::load_jquery_library('datatables');
WpBookingProHtmlFrontend::load_jquery_library('loading_js');
WpBookingProHtmlFrontend::load_jquery_library('select2');

$service_item = $this->service_item;
?>

<div class="wrapper-service-form">
    <div class="block-nav-setting">
        <h2><?php esc_html_e('Service Form','wpbookingpro');?></h2>
        <ul class="state-tab nav nav-tabs" role="tablist">
            <li role="presentation" class="active">
                <a href="#home" aria-controls="home" role="tab" data-toggle="tab">
                    <?php esc_html_e('Service detail', 'wpbookingpro') ?>
                </a>
            </li>
            <li role="presentation">
                <a href="#profile" aria-controls="profile" role="tab" data-toggle="tab">
                    <?php esc_html_e('Gallery', 'wpbookingpro') ?>
                </a>
            </li>
            <li role="presentation">
                <a href="#settings" aria-controls="settings" role="tab" data-toggle="tab">
                    <?php esc_html_e('Settings', 'wpbookingpro') ?>
                </a>
            </li>
        </ul>
    </div>
    <div class="block-content-setting">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="home">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $field = $this->form_service->getField('image');
                        $field->setValue(isset($service_item->image)?$service_item->image:'');
                        echo($this->form_service->renderField('image'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('name',null, isset($service_item->name)?$service_item->name:'');
                        echo($this->form_service->renderField('name'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('alias',null, isset($service_item->alias)?$service_item->alias:'');
                        echo($this->form_service->renderField('alias'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('meta_keyword',null, isset($service_item->meta_keyword)?$service_item->meta_keyword:'');
                        echo($this->form_service->renderField('meta_keyword'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('meta_description',null, isset($service_item->meta_description)?$service_item->meta_description:'');
                        echo($this->form_service->renderField('meta_description'))
                        ?>
                    </div>
                </div>
                <div class="row">

                </div>
                <div class="row">
                    <div class="col-md-6">

                        <?php
                        $this->form_service->setValue('category_id',null, isset($service_item->category_id)?$service_item->category_id:'');
                        echo($this->form_service->renderField('category_id'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('location_id',null, isset($service_item->location_id)?$service_item->location_id:'');
                        echo($this->form_service->renderField('location_id'))
                        ?>
                    </div>
                </div>
                <div class="row">

                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('duration',null, isset($service_item->duration)?$service_item->duration:'');
                        echo($this->form_service->renderField('duration'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('price',null, isset($service_item->price)?$service_item->price:'');
                        echo($this->form_service->renderField('price'))
                        ?>
                    </div>
                </div>
                <div class="row">

                    <div class="col-md-6">
                        <?php
                        echo($this->form_service->renderField('mobile'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('deposit_percent',null, isset($service_item->deposit_percent)?$service_item->deposit_percent:'');
                        echo($this->form_service->renderField('deposit_percent'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('facebook','params', isset($this->service_item->params)?$this->service_item->params->get('facebook'):'');
                        echo($this->form_service->renderField('facebook', 'params'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('instagram','params', isset($this->service_item->params)?$this->service_item->params->get('instagram'):'');
                        echo($this->form_service->renderField('instagram', 'params'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_service->setValue('list_employee_id',null, isset($service_item->list_employee_id)?$service_item->list_employee_id:array());
                        echo($this->form_service->renderField('list_employee_id'))
                        ?>
                    </div>
                </div>
                <div class="row open-close-on">
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('open_time',null, isset($service_item->open_time)?$service_item->open_time:'');
                        echo($this->form_service->renderField('open_time'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('close_time',null, isset($service_item->close_time)?$service_item->close_time:'');
                        echo($this->form_service->renderField('close_time'))
                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_service->setValue('working_day',null, isset($service_item->working_day)?$service_item->working_day:'');
                        echo($this->form_service->renderField('working_day'))
                        ?>
                    </div>
                </div>



                <div class="row add-background">
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('buffer_time_before',null, isset($service_item->buffer_time_before)?$service_item->buffer_time_before:'');
                        echo($this->form_service->renderField('buffer_time_before'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('buffer_time_after',null, isset($service_item->buffer_time_after)?$service_item->buffer_time_after:'');
                        echo($this->form_service->renderField('buffer_time_after'))
                        ?>
                    </div>
                </div>
                <div class="row add-background">

                    <div class="col-md-6 ">
                        <?php
                        $this->form_service->setValue('minimum_capacity',null, isset($service_item->minimum_capacity)?$service_item->minimum_capacity:'');
                        echo($this->form_service->renderField('minimum_capacity'))
                        ?>
                    </div>
                    <div class="col-md-6">
                        <?php
                        $this->form_service->setValue('minimum_capacity',null, isset($service_item->maximum_capacity)?$service_item->maximum_capacity:'');
                        echo($this->form_service->renderField('maximum_capacity'))
                        ?>
                    </div>
                </div>

                <div class="row">
                    <?php
                    $this->form_service->setValue('bringing_anyone',null, isset($service_item->bringing_anyone)?$service_item->bringing_anyone:0);
                    $field = $this->form_service->getField('bringing_anyone');
                    ?>
                    <div class="col-md-12">
                        <?php echo($field->input) ?>
                    </div>
                </div>
                <div class="row">
                    <?php
                    $this->form_service->setValue('multiply_number',null, isset($service_item->multiply_number)?$service_item->multiply_number:0);
                    $field = $this->form_service->getField('multiply_number');
                    ?>
                    <div class="col-md-12">
                        <?php echo($field->input) ?>
                    </div>
                </div>
                <div class="row">
                    <?php
                    $this->form_service->setValue('published',null, isset($service_item->published)?$service_item->published:0);
                    $field = $this->form_service->getField('published');
                    ?>
                    <div class="col-md-12">
                        <?php echo($field->input) ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_service->setValue('description',null, isset($service_item->description)?$service_item->description:'');
                        echo($this->form_service->renderField('description'))
                        ?>
                    </div>
                </div>
            </div>
            <div role="tabpanel" class="tab-pane" id="profile">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_service->setValue('gallery',null, isset($service_item->gallery)?$service_item->gallery:array());
                        echo($this->form_service->renderField('gallery'))
                        ?>
                    </div>
                </div>
            </div>
            <div role="tabpanel" class="tab-pane" id="settings">
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_service->setValue('disable_payment_online',null, isset($service_item->disable_payment_online)?$service_item->disable_payment_online:0);
                        echo($this->form_service->renderField('disable_payment_online'))
                        ?>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <?php
                        $this->form_service->setValue('service_color',null, isset($service_item->service_color)?$service_item->service_color:'');
                        echo($this->form_service->renderField('service_color'))
                        ?>
                    </div>
                </div>
            </div>
            <div role="tabpanel" class="tab-pane" id="customize">
                <?php
                ?>
            </div>
        </div>
        <div class="wrapper-button">
            <a href="<?php echo (esc_url($this->page_user_account.'?layout=my-service'))?>" class="btn-cancel">
                <i class="fas fa-undo-alt"></i>
                <?php esc_html_e('Cancel','wpbookingpro');?>
            </a>
            <button class="btn-save btn-save-service" type="button">
                <i class="icon-nb-save"></i>
                <?php esc_html_e('Save','wpbookingpro');?>
            </button>
        </div>
    </div>
    <input type="hidden" name="user_id" value="<?php echo (esc_attr($this->user->data->user_plugin->id))?>">
    <input type="hidden" name="link_redirect" value="<?php echo (esc_url($this->page_user_account.'?layout=my-service'));?>">
</div>
