<?php

use WpBookingProFrontend\app\Html\HtmlFrontend;

$user = $this->user;
?>
<div class="wrapper-profile-user">
    <h2><?php esc_html_e('Profile','wpbookingpro');?></h2>
    <div class="main-infomation">
        <div class="main-info-item">
            <h3 class="name"><?php echo (esc_html(isset($user->data->display_name)?$user->data->display_name:''))?></h3>
            <div class="address">
                <i class="fas fa-map-marker-alt"></i>
                <span><?php echo (esc_html(isset($user->data->user_plugin->address)?$user->data->user_plugin->address:''))?></span>
            </div>
        </div>
        <div class="main-info-item">
            <p class="job"><?php echo (esc_html(isset($user->data->user_plugin->business)?$user->data->user_plugin->business:''))?></p>
        </div>
    </div>
    <div class="basic-information">
        <h4><?php esc_html_e('Basic Information','wpbookingpro');?></h4>
        <div class="wrapper-basic-info">
            <div class="basic-info-item">
                <span><?php esc_html_e('Birthday:','wpbookingpro');?></span>
                <span><?php echo (esc_html(isset($user->data->user_plugin->birthday)?date('M d, Y',strtotime($user->data->user_plugin->birthday)):''))?></span>
            </div>
            <div class="basic-info-item">
                <span><?php esc_html_e('Gender:','wpbookingpro');?></span>
                <span><?php echo (esc_html(isset($user->data->user_plugin->gender)?$user->data->user_plugin->gender:''))?></span>
            </div>
            <div class="basic-info-item">
                <span><?php esc_html_e('About me:','wpbookingpro');?></span>
                <span><?php echo (esc_html(isset($user->data->user_plugin->description)?$user->data->user_plugin->description:''))?></span>
            </div>
        </div>
    </div>
    <div class="contact-information">
        <h4><?php esc_html_e('Contact Information','wpbookingpro');?></h4>
        <div class="wrapper-contact-info">
            <div class="contact-info-item">
                <span><?php esc_html_e('Phone:','wpbookingpro');?></span>
                <span>
                    <?php
                    $mobile = isset($user->data->user_plugin->mobile)?$user->data->user_plugin->mobile:'';
                    if($mobile['0'] == 0) {
                        $mobile = substr($mobile,1);
                    }
                    $phonecode = isset($user->data->user_plugin->phonecode)?$user->data->user_plugin->phonecode:'';
                    echo (esc_html('+'.$phonecode .' '. $mobile));
                    ?>
                </span>
            </div>
            <div class="contact-info-item">
                <span><?php esc_html_e('Address:','wpbookingpro');?></span>
                <span><?php echo (esc_html(isset($user->data->user_plugin->address)?$user->data->user_plugin->address:''))?></span>
            </div>
            <div class="contact-info-item">
                <span><?php esc_html_e('Email:','wpbookingpro');?></span>
                <span><?php echo (esc_html(isset($user->data->user_email)?$user->data->user_email:''))?></span>
            </div>
            <div class="contact-info-item">
                <span><?php esc_html_e('Company:','wpbookingpro');?></span>
                <span><?php echo (esc_html(isset($user->data->user_plugin->company)?$user->data->user_plugin->company:''))?></span>
            </div>
            <div class="contact-info-item">
                <span><?php esc_html_e('Site:','wpbookingpro');?></span>
                <span><?php echo (esc_html(isset($user->data->user_url)?$user->data->user_url:''))?></span>
            </div>
        </div>
    </div>
</div>
