<?php

use WpBookingPro\Factory;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$doc = Factory::getDocument();
$page_user_account= ConfigHelper::get_page_user_account();
if($page_user_account) {
    $this->page_user_account = get_page_link($page_user_account);
}else{
    $this->page_user_account="";
}
$list_state = $this->list_state;
?>
<div class="wrapper-table-state">
    <h2><?php esc_html_e('My states','wpbookingpro');?></h2>
    <div class="btn-add">
        <a href="<?php echo (esc_url($this->page_user_account.'?layout=my-state&form=state_form')) ?>" class="btn btn-primary">
            <i class="icon-nb-plus"></i>
            <?php esc_html_e('Add New State','wpbookingpro');?>
        </a>
    </div>
    <table id="list-state">
        <thead>
        <tr>
            <th><?php esc_html_e('ID','wpbookingpro');?></th>
            <th><?php esc_html_e('State name','wpbookingpro');?></th>
            <th><?php esc_html_e('Country name','wpbookingpro');?></th>
            <th><?php esc_html_e('Published','wpbookingpro');?></th>
            <th><?php esc_html_e('Actions','wpbookingpro');?></th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($list_state as $state) {?>
            <tr data-state_id = "<?php echo (esc_html(isset($state->id)?$state->id:'')) ?>">
                <td>#<?php echo (esc_html(isset($state->id)?$state->id:'')) ?></td>
                <td><?php echo (esc_html(isset($state->name)?$state->name:'')) ?></td>
                <td><?php echo (esc_html(isset($state->country_name)?$state->country_name:'')) ?></td>
                <td>
                    <?php if ($state->published == 1) { ?>
                        <div class="published">
                            <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro');?>"></i>
                        </div>
                    <?php } else { ?>
                        <div class="unpublished">
                            <i class="far fa-times-circle" title="<?php esc_attr_e('Not published','wpbookingpro');?>"></i>
                        </div>
                    <?php } ?>
                </td>
                <td>
                    <div class="button-action">
                        <a class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro');?>" href="<?php echo (esc_url($this->page_user_account.'?layout=my-state&form=state_form&id='.$state->id)) ?>">
                            <i class="icon-nb-edit"></i>
                        </a>
                        <button  type="button" class="btn-delete btn-delete-state" title="<?php esc_attr_e('Delete','wpbookingpro');?>">
                            <i class="icon-nb-delete"></i>
                        </button>
                    </div>
                </td>
            </tr>
        <?php } ?>
        </tbody>
    </table>
    <input type="hidden" name="state_id">
    <input type="hidden" name="page_my_state" value="<?php echo (esc_attr($this->page_user_account.'?layout=my-state'))?>">

</div>
<?php
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
?>