<?php

use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$page_user_account= ConfigHelper::get_page_user_account();
if($page_user_account) {
    $this->page_user_account = get_page_link($page_user_account);
}else{
    $this->page_user_account="";
}
$list_order_by_user = $this->list_order_by_user;
$list_order_by_vendor = $this->list_order_by_vendor;

?>
<div class="wrapper-table-order">
    <div class="block-nav-setting">
        <h2><?php esc_html_e('List orders','wpbookingpro');?></h2>
        <ul class="nav nav-tabs" role="tablist">
            <li role="presentation" class="active">
                <a href="#user" aria-controls="user" role="tab" data-toggle="tab">
                    <?php esc_html_e('My order', 'wpbookingpro') ?>
                </a>
            </li>
            <?php if($this->user->data->user_plugin->group_user_alias == 'vendor') {?>
            <li role="presentation">
                <a href="#vendor" aria-controls="vendor" role="tab" data-toggle="tab">
                    <?php esc_html_e('Customer order', 'wpbookingpro') ?>
                </a>
            </li>
            <?php }?>
        </ul>
    </div>
    <div class="block-content-setting">
        <div class="tab-content">
            <div role="tabpanel" class="tab-pane active" id="user">
                <table id="list-order-user">
                    <thead>
                    <tr>
                        <th><?php esc_html_e('Order','wpbookingpro');?></th>
                        <th><?php esc_html_e('Date','wpbookingpro');?></th>
                        <th><?php esc_html_e('Status','wpbookingpro');?></th>
                        <th><?php esc_html_e('Total','wpbookingpro');?></th>
                        <th><?php esc_html_e('Actions','wpbookingpro');?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($list_order_by_user as $order) {?>
                        <tr>
                            <td>#<?php echo (esc_html($order->id))?></td>
                            <td><?php echo (esc_html(date('F d, Y',strtotime($order->created_date))))?></td>
                            <td><?php echo (esc_html($order->status_payment))?></td>
                            <td><?php echo (esc_html(HtmlFrontend::render_price(reset($order->list_rate)->total)." for 1 item"))?></td>
                            <td>
                                <a class="btn-view" href="<?php echo (esc_url($this->page_user_account.'?layout=my-order&order_id='.$order->id)) ?>">
                                    <?php esc_html_e('View','wpbookingpro');?>
                                </a>
                            </td>
                        </tr>
                    <?php }?>
                    </tbody>
                </table>
            </div>
            <?php if($this->user->data->user_plugin->group_user_alias == 'vendor') {?>
                <div role="tabpanel" class="tab-pane" id="vendor">
                    <table id="list-order-customer">
                        <thead>
                        <tr>
                            <th><?php esc_html_e('Order','wpbookingpro');?></th>
                            <th><?php esc_html_e('Date','wpbookingpro');?></th>
                            <th><?php esc_html_e('Status','wpbookingpro');?></th>
                            <th><?php esc_html_e('Total','wpbookingpro');?></th>
                            <th><?php esc_html_e('Actions','wpbookingpro');?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($list_order_by_vendor as $order) {?>
                            <tr>
                                <td>#<?php echo (esc_html($order->id))?></td>
                                <td><?php echo (esc_html(date('F d, Y',strtotime($order->created_date))))?></td>
                                <td><?php echo (esc_html($order->status_payment))?></td>
                                <td><?php echo (esc_html(HtmlFrontend::render_price(reset($order->list_rate)->total)." for 1 item"))?></td>
                                <td>
                                    <a class="btn-view" href="<?php echo (esc_url($this->page_user_account.'?layout=my-order&order_id='.$order->id)) ?>">
                                        <?php esc_html_e('View','wpbookingpro');?>
                                    </a>
                                </td>
                            </tr>
                        <?php }?>
                        </tbody>
                    </table>
                </div>
            <?php }?>
        </div>
    </div>

</div>
