<?php

use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\FrontendHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$doc = Factory::getDocument();
$page_user_account= ConfigHelper::get_page_user_account();
if($page_user_account) {
    $this->page_user_account = get_page_link($page_user_account);
}else{
    $this->page_user_account="";
}
$list_coupons = $this->list_coupons;
$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>
    <div class="wrapper-table-coupon">
        <h2><?php esc_html_e('My coupon', 'wpbookingpro'); ?></h2>
        <div class="btn-add">
            <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-coupon&form=coupon_form')) ?>"
                class="btn btn-primary">
                <i class="icon-nb-plus"></i>
                <?php esc_html_e('Add New Coupon','wpbookingpro');?>
            </a>
        </div>
        <table id="list-coupon">
            <thead>
            <tr>
                <th><?php esc_html_e('Code', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Service', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Amount', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Percent', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Published', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Action', 'wpbookingpro'); ?></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($list_coupons as $coupon) { ?>
                <tr data-coupon_id="<?php echo(esc_attr($coupon->id)) ?>">
                    <td><?php echo(esc_html($coupon->code)) ?></td>
                    <td>
                        <?php foreach ($coupon->list_service as $service){ ?>
                            <?php echo "$service->name <br/>" ?>
                        <?php } ?>
                    </td>
                    <td><?php echo(esc_html($coupon->amount)) ?></td>
                    <td><?php echo(esc_html($coupon->percent)) ?></td>
                    <td>
                        <?php if ($coupon->published == 1) { ?>
                            <div class="published">
                                <i class="fas fa-check-square" title="<?php esc_attr_e('Public','wpbookingpro');?>"></i>
                            </div>
                        <?php } else { ?>
                            <div class="unpublished">
                                <i class="far fa-times-circle" title="<?php esc_attr_e('Not published','wpbookingpro');?>"></i>
                            </div>
                        <?php } ?>
                    </td>
                    <td>
                        <div class="button-action">
                            <a class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro');?>" href="<?php echo(esc_url($this->page_user_account . '?layout=my-coupon&form=coupon_form&id=' . $coupon->id)) ?>">
                                <i class="icon-nb-edit"></i>
                            </a>
                            <button  type="button" class="btn-delete btn-delete-coupon" title="<?php esc_attr_e('Delete','wpbookingpro');?>">
                                <i class="icon-nb-delete"></i>
                            </button>
                        </div>
                    </td>
                </tr>
            <?php } ?>
            </tbody>
        </table>
        <input type="hidden" name="coupon_id">
        <input type="hidden" name="link_my_coupon" value="<?php echo(esc_attr($this->page_user_account . '?layout=my-coupon')) ?>">
    </div>
<?php
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
?>