<?php

use WpBookingPro\Factory;
use WpBookingPro\Utilities\Utility;
use WpBookingProFrontend\app\helpers\ConfigHelper;
use WpBookingProFrontend\app\helpers\FrontendHelper;
use WpBookingProFrontend\app\Html\HtmlFrontend;

$doc = Factory::getDocument();
$page_user_account= ConfigHelper::get_page_user_account();
if($page_user_account) {
    $this->page_user_account = get_page_link($page_user_account);
}else{
    $this->page_user_account="";
}
$list_category = $this->list_category;
$check_user_demo = FrontendHelper::checkUserDemo();
$uploads = wp_upload_dir();
?>
    <div class="wrapper-table-category">
        <h2><?php esc_html_e('My categorys', 'wpbookingpro'); ?></h2>
        <div class="btn-add">
            <a href="<?php echo(esc_url($this->page_user_account . '?layout=my-category&form=category_form')) ?>"
               type="submit" class="btn btn-primary">
                <i class="icon-nb-plus"></i>
                <?php esc_html_e('Add New Category','wpbookingpro');?>
            </a>
        </div>
        <table id="list-category">
            <thead>
            <tr>
                <th><?php esc_html_e('Category', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Image', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Description', 'wpbookingpro'); ?></th>
                <th><?php esc_html_e('Actions', 'wpbookingpro'); ?></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($list_category as $category) { ?>
                <tr data-category_id="<?php echo(esc_attr($category->id)) ?>">
                    <td>#<?php echo(esc_html($category->name)) ?></td>
                    <td class="category-image">
                        <div class="img-block">
                            <div>
                                <?php if($check_user_demo['is_demo']) {?>
                                    <img src="<?php echo(esc_url($uploads['baseurl'].'/' . $category->image)) ?>"
                                     alt="category_image">
                                <?php }else {?>
                                    <img src="<?php echo(esc_url(Factory::getRootUrlPlugin() . $category->image)) ?>"
                                         alt="category_image">
                                <?php }?>
                            </div>
                        </div>
                    </td>
                    <td><?php echo(esc_html($category->description)) ?></td>
                    <td>
                        <div class="button-action">
                            <a class="btn-edit" title="<?php esc_attr_e('Edit','wpbookingpro');?>" href="<?php echo(esc_url($this->page_user_account . '?layout=my-category&form=category_form&id=' . $category->id)) ?>">
                                <i class="icon-nb-edit"></i>
                            </a>
                            <button  type="button" class="btn-delete btn-delete-category" title="<?php esc_attr_e('Delete','wpbookingpro');?>">
                                <i class="icon-nb-delete"></i>
                            </button>
                        </div>
                    </td>
                </tr>
            <?php } ?>
            </tbody>
        </table>
        <input type="hidden" name="category_id">
        <input type="hidden" name="link_my_category" value="<?php echo(esc_attr($this->page_user_account . '?layout=my-category')) ?>">
    </div>
<?php
$doc->addStyleSheet('frontend/app/assets/nb-font-icon/nb-font-icon.css');
?>